/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.adaltis;

import jalis.comum.Conexao;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.interfaces.adaltis.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.util.MemoryList;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class InterfaceListener
extends InterfaceASTMListener {
    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
    }

    @Override
    public String getErroTraduzido(String erro) {
        return "erro";
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        String string;
        Statement st = null;
        try {
            String[] exms;
            st = Conexao.getStatement();
            for (String s : exms = pac_exames.split(" ", 0)) {
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, s, mco_codigo, int_codigo, null, acao.equals("N") ? 1 : 3);
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            string = "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception ex) {
            try {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return null;
        }
        Conexao.fecharStatement(st);
        return string;
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(1, message.length() - 2);
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                String[] msgs;
                message = message.substring(0, message.length() - 1);
                block7: for (String s : msgs = message.split(String.valueOf('\r'))) {
                    if (s.trim().length() <= 0) continue;
                    char c = s.charAt(0);
                    switch (c) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            if (this.rx_list.size() > 0) {
                                String msg = (String)this.rx_list.remove(this.rx_list.size() - 1);
                                msg = msg + s.trim().substring(1);
                                this.rx_list.add(msg);
                                continue block7;
                            }
                            this.rx_list.add(s);
                            continue block7;
                        }
                        default: {
                            this.rx_list.add(s);
                        }
                    }
                }
                if (termination.equals(this.getMiddleFrameEnd())) {
                    return "";
                }
                MemoryList rx_clonada = (MemoryList)this.rx_list.clone();
                ThreadRecebimento tr = new ThreadRecebimento(rx_clonada, this);
                tr.start();
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    class ThreadRecebimento
    extends Thread {
        private MemoryList rx_list;
        private AbstractInterfaceamentoListener equipamento;

        public ThreadRecebimento(MemoryList rx_list, AbstractInterfaceamentoListener equipamento) {
            this.rx_list = rx_list;
            this.equipamento = equipamento;
        }

        @Override
        public void run() {
            try {
                while (!this.rx_list.isEmpty()) {
                    InterfaceListener.this.recordParser.recordFound((String)this.rx_list.remove(0));
                    ThreadRecebimento.sleep(250L);
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this.equipamento, InterfaceListener.this.TIME_TO_REFRESH);
            }
            catch (InterruptedException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "InterfaceListener: 194");
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "InterfaceListener: 196");
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "InterfaceListener: 198");
            }
        }
    }
}

