/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.acltop300;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.InterfaceamentoConfiguracao;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketServer;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.acltop300.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends InterfaceASTMListener {
    protected int MAX_PATIENT_NAME_CHARS = 20;
    protected int MAX_EXAMES = 10;
    protected boolean hostQuery = false;
    private List<String> request = new ArrayList<String>();
    private InterfaceamentoConfiguracao configuracao;
    private ArrayList<InfoExameRequisicao> examesEnviados = new ArrayList();

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        this.INSTRUMENT_NAME = "top300";
        this.HOST_NAME = "top300";
        this.DELIMITERS = "@^\\";
        this.INSTRUMENT_SYSTEM_VERSION = "1394-97";
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceamentoConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        super.setPortaCOM(portaCOM);
        if (portaCOM instanceof PortaSocketServer) {
            ((PortaSocketServer)portaCOM).setEscreverEmBytes(true);
        }
    }

    private String enviarRequisicaoHostQuery(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, int sequence) {
        try {
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome);
            String sobrenome = "";
            if (short_name.contains(" ")) {
                String[] aux = short_name.trim().split(" ");
                if (aux != null && aux.length > 2) {
                    short_name = aux[0];
                    sobrenome = aux[1].length() > aux[2].length() ? aux[1] : aux[2];
                } else if (aux != null && aux.length == 2) {
                    short_name = aux[0];
                    sobrenome = aux[1];
                }
            }
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            if (sobrenome.length() > this.MAX_PATIENT_NAME_CHARS) {
                sobrenome = sobrenome.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            String nome = short_name;
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            if (Funcoes.textoVazio(tipo_amostra)) {
                tipo_amostra = "P";
            }
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            Date dataNasc = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            StringBuilder msg = new StringBuilder();
            String patient_id = req_codigo;
            String laboratory_pid = null;
            msg.append(this.getPatientRecord(sequence, codigo.toString(), laboratory_pid, nome, sobrenome, pac_sexo, dataNasc));
            for (int i = 0; i < alternativos.length; ++i) {
                msg.append(this.getOrderRecord(i + 1, codigo.toString(), alternativos[i], null, null, "R", null, tipo_amostra, "Q"));
            }
            return msg.toString();
        }
        catch (Exception e) {
            final String filial = fil_codigo;
            final String requisicao = req_codigo;
            final String recipiente = rec_codigo;
            final String exames = pac_exames;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, String.format("%s\nErro ao montar dados para enviar %s %s %s %s ", e.getMessage(), filial, requisicao, recipiente, exames), e.getStackTrace());
                }
            });
            return "";
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            Funcoes.mensagem(null, "Equipamento desenvolvido exclusivamente para funcionamento em modo host query n\u00e3o \u00e9 poss\u00edvel enviar exames manualmente", 2);
            return "";
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(2, message.length() - 2);
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size()) {
                    String last = (String)this.rx_list.get(this.rx_list.getUltimoInserido());
                    message = last.substring(0, last.length() - 1) + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                if (message.contains(String.valueOf('\r'))) {
                    String[] tmp;
                    for (String s : tmp = message.split(String.format("[%s]", Character.valueOf('\r')))) {
                        if (s.length() <= 1) continue;
                        this.rx_list.add(s);
                    }
                } else {
                    this.rx_list.add(message);
                }
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                while (!this.rx_list.isEmpty()) {
                    this.recordParser.recordFound((String)this.rx_list.remove(0));
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            if (!Funcoes.textoVazio(starting_range) && starting_range.length() > 1) {
                String sampleId = starting_range.substring(1).trim();
                this.hostQuery = true;
                if (!Funcoes.textoVazio(sampleId)) {
                    ArrayList<Object> amostras = new ArrayList<String>();
                    if (sampleId.contains("@^")) {
                        amostras = StringUtil.explode(sampleId, "@^");
                    } else {
                        amostras.add(sampleId);
                    }
                    for (String string : amostras) {
                        if (Funcoes.textoVazio(string)) {
                            this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                            continue;
                        }
                        if (string.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                            this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                            continue;
                        }
                        if (this.request.contains(string)) continue;
                        this.request.add(string);
                    }
                    if (!this.request.isEmpty()) {
                        this.hostQuery = true;
                    } else {
                        this.fireExcecaoEncontrada(String.format("Pedido de amostra do aparelho sem nenhum Sample ID: %s", starting_range));
                    }
                } else {
                    this.fireExcecaoEncontrada("Pedido de amostra do aparelho sem nenhum Sample ID");
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0005': {
                    if (this.isTX() || this.tx_list.size() > 0 && this.rx_counter < this.MAX_TENTATIVAS_RX && !this.request.isEmpty()) {
                        this.getPortaCOM().write(String.valueOf('\u0015'));
                        ++this.rx_counter;
                        break;
                    }
                    this.rx_counter = 0;
                    this.tratarEnquiry();
                    break;
                }
                case '\u0006': {
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0015': {
                    this.tratarNegativeAck();
                    break;
                }
                case '\u0004': {
                    this.tratarEndOfTX();
                    break;
                }
                default: {
                    this.caracterNaoEsperado();
                    break;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de caracter de handshake recebido");
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento: " + ex.getMessage(), 1, 5000);
            if (this.tx_list.size() > 0) {
                this.limpaDadosRequisicao();
            }
            this.setIdle();
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery && !this.request.isEmpty()) {
            this.responseHostQuery();
        }
    }

    public void responseHostQuery() {
        try {
            if (this.request.isEmpty()) {
                return;
            }
            StringBuilder msg = new StringBuilder();
            msg.append(this.getHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            int sequence = 1;
            while (!this.request.isEmpty()) {
                String sampleId = this.request.remove(0);
                String fil_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                sampleId = sampleId.substring(ParametrosGerais.getDigitosTuboFilial());
                String req_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                String rec_codigo = sampleId.substring(ParametrosGerais.getDigitosTuboRequisicao());
                String pac_nome = null;
                String pac_sexo = null;
                String pac_idade = null;
                String data = null;
                String hora = null;
                String rack = null;
                String prioridade = null;
                String int_codigo = null;
                String mco_codigo = null;
                String pac_exames = "";
                String acao = "A";
                Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
                PanelAbaAbstrata aba = this.equipamento.getTab(0);
                if (req != null) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (req == null) {
                    req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    aba = this.equipamento.getTab(1);
                    if (req != null) {
                        pac_exames = pac_exames + " ";
                        List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                        for (Object[] r : reqs) {
                            pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                        }
                        pac_exames = pac_exames.trim();
                    }
                }
                if (req != null) {
                    pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                    pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                    data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                    hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                    rack = aba.getColIndice("Rack") >= 0 ? (String)req[aba.getColIndice("Rack")] : null;
                    int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                    mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                    msg.append(this.enviarRequisicaoHostQuery(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames.trim(), acao, sequence++));
                    InfoExameRequisicao infoExameRequisicao = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, pac_exames.trim());
                    infoExameRequisicao.setInterface(int_codigo);
                    this.examesEnviados.add(infoExameRequisicao);
                    continue;
                }
                this.fireExcecaoEncontrada(String.format("Nenhuma requisi\u00e7\u00e3o encontrada para a amostra %s %s %s", fil_codigo, req_codigo, rec_codigo));
            }
            msg.append(ASTMStandard.getDefaultTerminationRecord("F"));
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.clear();
            this.tx_list.add(msg.toString());
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            this.hostQuery = false;
            this.fil_codigo = null;
            this.int_codigo = null;
            this.req_codigo = null;
            this.pac_nome = null;
            this.pac_sexo = null;
            this.req_idade = null;
            this.req_data = null;
            this.req_hora = null;
            this.mco_codigo = null;
            this.rec_codigo = null;
            this.pac_exames = null;
            this.exames = null;
            this.ultima_acao = null;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    public void limparWorklistEnvio() {
        this.request.clear();
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        if (this.exames == null && this.configuracao.getModoHostQuery() && this.examesEnviados.size() > 0) {
            final ArrayList<InfoExameRequisicao> examesEnviadosAux = new ArrayList<InfoExameRequisicao>();
            for (InfoExameRequisicao infoExameRequisicao : this.examesEnviados) {
                examesEnviadosAux.add(infoExameRequisicao);
            }
            Thread th = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Statement st = Conexao.getStatement();
                        for (int i = 0; i < examesEnviadosAux.size(); ++i) {
                            String fil_codigo = ((InfoExameRequisicao)examesEnviadosAux.get(i)).getFilial();
                            String int_codigo = ((InfoExameRequisicao)examesEnviadosAux.get(i)).getInterface();
                            String req_codigo = ((InfoExameRequisicao)examesEnviadosAux.get(i)).getCodigo();
                            String mco_codigo = ((InfoExameRequisicao)examesEnviadosAux.get(i)).getMaterial();
                            String rec_codigo = ((InfoExameRequisicao)examesEnviadosAux.get(i)).getRecipiente();
                            String pac_nome = ((InfoExameRequisicao)examesEnviadosAux.get(i)).getNome();
                            String[] exames = ((InfoExameRequisicao)examesEnviadosAux.get(i)).getExames().split(" ");
                            if (exames == null || exames.length <= 0) continue;
                            for (int j = 0; j < exames.length; ++j) {
                                int situacao = InterfaceListener.this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[j], mco_codigo, rec_codigo);
                                InterfaceListener.this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exames[j], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                                System.out.println(String.format("Atualizando %s %s %s %s %s %s %s  ", fil_codigo, req_codigo, rec_codigo, exames[j], mco_codigo, int_codigo, situacao));
                            }
                            Conexao.arquivaSQL();
                            InterfaceListener.this.fireMensagemEnviada("Exame(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
                            InterfaceListener.this.firePacienteEnviado(req_codigo, pac_nome, ((InfoExameRequisicao)examesEnviadosAux.get(i)).getSexo(), ((InfoExameRequisicao)examesEnviadosAux.get(i)).getIdade(), ((InfoExameRequisicao)examesEnviadosAux.get(i)).getData(), ((InfoExameRequisicao)examesEnviadosAux.get(i)).getHora(), ((InfoExameRequisicao)examesEnviadosAux.get(i)).getExames());
                        }
                        InterfaceListener.this.fireAtualizarTabela();
                        InterfaceListener.this.fireAtualizarTabela(0);
                    }
                    catch (SQLException e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                            }
                        });
                    }
                }
            });
            th.start();
            this.examesEnviados.clear();
            this.interromperTimer();
            this.getPortaCOM().write(String.valueOf('\u0004'));
            this.setIdle();
        } else {
            super.encerrarTransmissao();
        }
    }

    @Override
    public String getErroTraduzido(String erro) {
        return erro;
    }

    private String getHeaderRecord(String delimiters, String password, String host, String receiver_id_name, String version_number) {
        String number2Aux;
        String number1Aux;
        int number2;
        Random r = new Random();
        long number1 = r.nextLong();
        if (number1 < 0L) {
            number1 *= -1L;
        }
        if ((number2 = r.nextInt(99999)) < 0) {
            number2 *= -1;
        }
        if ((number1Aux = String.valueOf(number1)).length() > 10) {
            number1Aux = number1Aux.substring(0, 10);
        }
        if ((number2Aux = String.valueOf(number2)).length() > 5) {
            number2Aux = number1Aux.substring(0, 5);
        }
        StringBuilder record = new StringBuilder("H|");
        record.append(delimiters == null ? "" : delimiters);
        record.append("|");
        record.append("<").append(number1Aux).append("_").append(number2).append(">");
        record.append("<").append(number1Aux).append("_").append(number2 + 1).append(">");
        record.append("|");
        record.append(password == null ? "" : password);
        record.append("|");
        record.append(host == null ? "" : host);
        record.append("||||");
        record.append("|");
        record.append(receiver_id_name == null ? "" : receiver_id_name);
        record.append("||P|");
        record.append(version_number);
        record.append("|");
        record.append(ASTMStandard.getCurrentMoment());
        record.append("|");
        record.append('\r');
        return record.toString();
    }

    private String getOrderRecord(int order_sequence, String sample_id, ExameMaterial test_item_numbers, ExameMaterial test_item_names, String dilution, String priority, String action_code, String sample_type, String report_type) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("||");
        if (test_item_numbers != null) {
            record.append("^^^");
            record.append(test_item_numbers.getNomeExame());
            record.append(test_item_names == null ? "" : "^" + test_item_names.getNomeExame());
            record.append(dilution == null ? "" : "^" + dilution);
        }
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("||||||");
        record.append(action_code == null ? "" : action_code);
        record.append("||||");
        record.append(sample_type == null ? "" : sample_type);
        record.append("||||||||||");
        record.append(report_type == null ? "" : report_type);
        record.append("||||||");
        record.append('\r');
        return record.toString();
    }

    private String getPatientRecord(int patient_sequence, String patient_id, String laboratory_pid, String pac_nome, String pac_sobrenome, String pac_sexo, Date dataNasc) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence);
        record.append("|");
        record.append(patient_id == null ? "" : patient_id);
        record.append("|");
        record.append(laboratory_pid == null ? "" : laboratory_pid);
        record.append("||");
        record.append(pac_sobrenome == null ? "" : pac_sobrenome);
        record.append(pac_nome == null ? "^^^^" : "^" + pac_nome + "^^^");
        record.append("||");
        record.append(dataNasc == null ? "" : Funcoes.formataData("yyyyMMdd", dataNasc));
        record.append("|");
        record.append(pac_sexo == null ? "" : pac_sexo);
        record.append("|||||");
        record.append('\r');
        return record.toString();
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado", "EOT", "NAK", "ENQ"}, null);
        if (op == 0) {
            this.query();
        } else if (op == 1) {
            this.handShakeCharReceived('\u0006');
        } else if (op == 2) {
            this.resultado();
        } else if (op == 3) {
            this.handShakeCharReceived('\u0004');
        } else if (op == 4) {
            this.handShakeCharReceived('\u0015');
        } else if (op == 5) {
            this.handShakeCharReceived('\u0005');
        }
    }

    private void query() {
        StringBuilder msg = new StringBuilder();
        msg.append("[STX]1H|@^\\|<1505245218_15231><1505245218_15232>||top300|||||top300||P|1394-97|20170912164018[CR]");
        msg.append("Q|1|^010004415004||||||||||O@N[CR]");
        msg.append("L|1|N[CR][ETX]AA[LINE]");
        msg.setLength(0);
        msg.append("[STX]1H|@^\\|<1505498065_22672><1505498065_22673>||top300|||||top300||P|1394-97|20170915145425[CR]");
        msg.append("Q|1|^012395601055@^012395539055@^012382874055||||||||||O@N[CR]");
        msg.append("L|1|N[CR][ETX]F8[LINE]");
        this.parse(this.equipamento.arruma(msg.toString()));
        this.handShakeCharReceived('\u0004');
    }

    private void resultado() {
        StringBuilder msg = new StringBuilder();
        msg.append("[STX]1H|@^\\|<1505496913_22605><1505497097_22621>||top300|||||top300||P|1394-97|20170915143817[CR]");
        msg.append("P|1||||^|||U|||||^[CR]");
        msg.append("O|1|012391722055|<1505496849_22582>|^^^131|R|20170915143513|||||||||P||||||||||O@F[CR]");
        msg.append("R|1|^^^131|10.9|s||N||F@V||SysAdmin^SysAdmin||2017[ETB]BD[LINE]");
        this.parse(this.equipamento.arruma(msg.toString()));
        msg.setLength(0);
        msg.append("[STX]20915143817|top300^03^1[CR]");
        msg.append("R|2|^^^131|108|%||H||F@V||SysAdmin^SysAdmin||20170915143817|top300^03^1[CR]");
        msg.append("C|1|I|5506^Acima[SP]intervalo[SP]normal^HN|I[CR]");
        msg.append("R|3|^^^131|0.93|INR||N||F@V||SysAdmin^SysAdmin||20170915143817|top300^03^1[CR]");
        msg.append("L|1|N[CR]");
        msg.append("[ETX]AA[LINE]");
        this.parse(this.equipamento.arruma(msg.toString()));
        msg.setLength(0);
        msg.append("[STX]1H|@^\\|<1505500420_22728><1505501565_22959>||top300|||||top300||P|1394-97|20170915155245[CR]");
        msg.append("P|1||||^|||U|||||^[CR]");
        msg.append("O|1|012391918055|<1505500414_22707>|^^^921|R|20170915153340|||||||||P||||||||||O@F[CR]");
        msg.append("R|1|^^^921|34.3|s||N||F@V||SysAdmin^SysAdmin||2017[ETB]A7[LINE]");
        this.parse(this.equipamento.arruma(msg.toString()));
        msg.setLength(0);
        msg.append("[STX]20915153920|top300^03^1[CR]");
        msg.append("R|2|^^^921|1.23|Ratio||N||F@V||SysAdmin^SysAdmin||20170915153920|top300^03^1[CR]");
        msg.append("L|1|N[CR][ETX]F8[LINE]");
        msg.append("");
        msg.append("");
        msg.append("");
        this.parse(this.equipamento.arruma(msg.toString()));
        this.parse(this.equipamento.arruma(msg.toString()));
    }
}

