/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.access;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.access.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;

public class InterfaceListener
extends InterfaceASTMListener {
    protected int MAX_PATIENT_NAME_CHARS = 30;
    protected int MAX_EXAMES = 10;
    protected String host_fil_codigo = null;
    protected String host_req_codigo = null;
    protected String host_rec_codigo = null;
    protected boolean hostQuery = false;
    protected boolean hostQueryVazio = false;

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        this.INSTRUMENT_NAME = "Access";
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            starting_range = starting_range.substring(1);
            if (starting_range.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                return;
            }
            this.host_fil_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboFilial());
            starting_range = starting_range.substring(ParametrosGerais.getDigitosTuboFilial());
            this.host_req_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            this.host_rec_codigo = starting_range.substring(ParametrosGerais.getDigitosTuboRequisicao());
            this.hostQuery = true;
            this.hostQueryVazio = false;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Access: Host Query Response");
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery) {
            this.responseHostQuery();
        }
    }

    public void responseHostQuery() {
        try {
            List<Object[]> reqs;
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String rack = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            String pac_exames = "";
            String acao = "A";
            DescritorCodigoEtiqueta descritorCodigoEtiqueta = DescritorCodigoEtiqueta.getDescritor(fil_codigo + req_codigo + rec_codigo);
            if (descritorCodigoEtiqueta != null) {
                fil_codigo = Funcoes.preencheZero(descritorCodigoEtiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                req_codigo = Funcoes.preencheZero(descritorCodigoEtiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                rec_codigo = Funcoes.preencheZero(descritorCodigoEtiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
            }
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req != null) {
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                rack = aba.getColIndice("Rack") >= 0 ? (String)req[aba.getColIndice("Rack")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                this.hostQueryVazio = false;
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, this.host_fil_codigo, int_codigo, this.host_req_codigo, mco_codigo, this.host_rec_codigo, pac_exames, acao);
            } else {
                this.hostQueryVazio = true;
                this.fireExcecaoEncontrada("Nenhuma amostra localizada com o ID: " + fil_codigo + req_codigo + rec_codigo + ".");
                this.enviarRequisicaoSemExame(this.host_fil_codigo, this.host_req_codigo);
            }
            this.hostQuery = false;
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Access: Host Query Response");
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames, acao, null);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            DescritorCodigoEtiqueta descritorCodigoEtiqueta = null;
            if (mapaParametros != null && !Funcoes.textoVazio(mapaParametros.get("codigoApoiado"))) {
                descritorCodigoEtiqueta = DescritorCodigoEtiqueta.getDescritor(mapaParametros.get("codigoApoiado"));
                fil_codigo = descritorCodigoEtiqueta.getFilialApoio();
            } else {
                descritorCodigoEtiqueta = DescritorCodigoEtiqueta.getDescritor(fil_codigo + req_codigo + rec_codigo);
            }
            String filialConvertida = "";
            filialConvertida = descritorCodigoEtiqueta != null ? Funcoes.preencheZero(descritorCodigoEtiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial()) : Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            this.fil_codigo = descritorCodigoEtiqueta != null ? Funcoes.preencheZero(descritorCodigoEtiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial()) : Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(filialConvertida, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            exa_lista = ExamesUtil.desmembrarExames(st, filialConvertida, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, filialConvertida, int_codigo, exa_lista);
            String nome = short_name;
            String sobrenome = null;
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String patient_id = req_codigo;
            String laboratory_pid = null;
            this.tx_list.add(ASTMStandard.getDefaultPatientRecord(1, patient_id, laboratory_pid, nome, sobrenome, pac_sexo));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            this.tx_list.add(ASTMStandard.getDefaultOrderRecord(1, codigo.toString(), alternativos, exa_lista, null, "R", acao, tipo_amostra, "O"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        if (!this.hostQueryVazio) {
            super.encerrarTransmissao();
        } else {
            this.interromperTimer();
            this.getPortaCOM().write(String.valueOf('\u0004'));
            this.getPortaCOM().clearInputString();
            this.setIdle();
        }
        this.hostQueryVazio = false;
    }

    private void enviarRequisicaoSemExame(String fil_codigo, String req_codigo) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("F"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
        }
    }

    @Override
    public String getErroTraduzido(String erro) {
        StringBuilder msg = new StringBuilder();
        if (!Funcoes.textoVazio(erro)) {
            String[] erros;
            for (String e : erros = erro.split(";")) {
                if (e.equalsIgnoreCase("CEX")) {
                    msg.append("Curve expired.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("CRH")) {
                    msg.append("Result higher than critical (panic) reference range.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("CRL")) {
                    msg.append("Result lower than critical (panic) reference range.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("EDT")) {
                    msg.append("Result edit (currently unused).\t");
                    continue;
                }
                if (e.equalsIgnoreCase("GRY")) {
                    msg.append("Qualitative result in gray zone.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("IND")) {
                    msg.append("Result is indeterminant.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("LEX")) {
                    msg.append("Lot expired.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("LOW")) {
                    msg.append("Result lower than the minimum reportable result.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("NCR")) {
                    msg.append("No curve.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("NRV")) {
                    msg.append("Insufficient reagent, reaction vessels, wash, substrate, waste, or reaction vessel waste.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("OLD")) {
                    msg.append("Sample old.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("ORH")) {
                    msg.append("Result higher than normal reference range.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("ORL")) {
                    msg.append("Result lower than normal reference range.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("OVR")) {
                    msg.append("Result out of range of curve.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("PEX")) {
                    msg.append("Pack expired.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("QCF")) {
                    msg.append(" Control is outside QC limits.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("QEX")) {
                    msg.append(" Control lot expired.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("QNS")) {
                    msg.append(" Quantity not sufficient.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("RLU")) {
                    msg.append(" Relative light unit (RLU) value is outside of the acceptable luminometer measuring range.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("SYS")) {
                    msg.append(" Instrument error.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("TMP")) {
                    msg.append(" One or more of the following is outside the temperature specification: Incubator, wash/read carousel, substrate, reagent.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("UNR")) {
                    msg.append(" The measured sample signal (RLU) is less than an RLU threshold limit for the least concentrated calibrator or calibration control for a positive slope assay, or is greater than the least concentrated calibrator for a negative slope assay, as defined in the assay protocol file.\t");
                    continue;
                }
                if (!e.equalsIgnoreCase("WVL")) continue;
                msg.append(" Quality control sample result was generated using a different reagent vial lot number than the vial lot number used to calibrate the assay.\t");
            }
        }
        return msg.toString();
    }

    @Override
    public void teste() {
        InterfaceListener epq = this;
        epq.parse(TestesInterface.arruma("[STX]1H|\\^&|||ACCESS^600961|||||LIS||P|1|20130902132625[CR][ETX]28[CR][LF]"));
        epq.parse(TestesInterface.arruma("[STX]2P|1|0633389[CR]"));
        epq.parse(TestesInterface.arruma("[STX]3O|1|010005486404|^1305^2|^^^HCG5^1|||||||||||Serum||||||||||F[CR]"));
        epq.parse(TestesInterface.arruma("[STX]4R|1|^^^HCddG5^1|1.305|mIU/mL||N||F||||20180403165348|506910[CR] "));
        epq.parse(TestesInterface.arruma("[STX]5L|1|F[CR][ETX]00[LINE]"));
    }
}

