/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.abl80flex;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.abl80flex.InterfaceListener;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    @Override
    public void recordFound(String record) throws Exception {
        String record_type = ASTMStandard.getRecordTypeIdentifier(record);
        if (record_type != null) {
            if (record_type.equals(ASTMStandard.RECORD_TYPE_HEADER)) {
                this.trataHeaderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_PATIENT)) {
                this.trataPatientRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_ORDER)) {
                this.trataOrderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_RESULT)) {
                this.trataResultRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_COMMENT)) {
                this.trataCommentRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_REQUEST)) {
                this.trataRequestRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_TERMINATION)) {
                this.trataTerminationRecord();
                return;
            }
        }
    }

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        if (this.exame_atual != null) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID);
        if (req_codigo == null || req_codigo.equals("")) {
            req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID);
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        Map<Integer, String> components = this.equip.parseOrderTestIDField((String)order_fields.get(ASTMStandard.ORDER_FIELD_TEST_ID));
        InterfaceListener cfr_ignored_0 = (InterfaceListener)this.equip;
        String emi_alternativo = "GASO";
        Statement st = Conexao.getStatement();
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        this.exame_atual.put(INT_CODIGO, int_codigo);
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
        if (int_codigo == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            return;
        }
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        if (this.exame_atual == null) {
            return;
        }
        String action_code = (String)this.exame_atual.get(ACTION_CODE);
        String report_type = (String)this.exame_atual.get(REPORT_TYPE);
        if (action_code != null) {
            this.equip.getClass();
            if (action_code.equals("Q")) {
                this.exame_atual = null;
                return;
            }
        }
        if (report_type != null) {
            this.equip.getClass();
            if (report_type.equals("X")) {
                this.exame_atual = null;
                return;
            }
        }
        Hashtable result_fields = ASTMStandard.parseDefaultResultRecord(record);
        String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
        String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
        String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        String aux = (String)result_fields.get(3);
        String[] campos = aux.split("\\^", -1);
        String campo = "";
        for (String c : campos) {
            if (Funcoes.textoVazio(c)) continue;
            campo = c;
            break;
        }
        String resultado = (String)result_fields.get(4);
        campo = this.parseCampo(campo);
        InterfaceListener cfr_ignored_0 = (InterfaceListener)this.equip;
        String emi_alternativo = "GASO";
        boolean campoAlternativo = false;
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (Funcoes.textoVazio(int_codigo)) {
            int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, campo);
            campoAlternativo = true;
        }
        if (Funcoes.textoVazio(int_codigo)) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo INT do exame n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        this.exame_atual.put(INT_CODIGO, int_codigo);
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
        resultado = resultado.replaceAll("\\.", ",");
        if (resultado.startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.length() >= 1 && resultado.charAt(resultado.length() - 1) == ',') {
            resultado = resultado + "0";
        }
        Statement st = Conexao.getStatement();
        this.exame_atual.put(campo, resultado);
        String flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS);
        if (flags != null && !flags.equals("") && !Funcoes.textoVazio(campo)) {
            this.exame_atual.put("flag_alerta", flags);
        }
    }

    private String parseCampo(String campo) {
        if (campo.equalsIgnoreCase("pH")) {
            return "gasometria_ph";
        }
        if (campo.equalsIgnoreCase("PCO2")) {
            return "gasometria_pco2";
        }
        if (campo.equalsIgnoreCase("PO2")) {
            return "gasometria_po2";
        }
        if (campo.equalsIgnoreCase("PO2(T)")) {
            return "gasometria_po2t";
        }
        if (campo.equalsIgnoreCase("Na+")) {
            return "gasometria_na";
        }
        if (campo.equalsIgnoreCase("K+")) {
            return "gasometria_k";
        }
        if (campo.equalsIgnoreCase("Cl-")) {
            return "gasometria_cl";
        }
        if (campo.equalsIgnoreCase("tHb")) {
            return "gasometria_thb";
        }
        if (campo.equalsIgnoreCase("SO2")) {
            return "gasometria_so2";
        }
        if (campo.equalsIgnoreCase("Hct")) {
            return "gasometria_hct";
        }
        if (campo.equalsIgnoreCase("tCO2(P)")) {
            return "gasometria_ctco2p";
        }
        if (campo.equalsIgnoreCase("RI")) {
            return "gasometria_ri";
        }
        if (campo.equalsIgnoreCase("ABE")) {
            return "gasometria_be";
        }
        if (campo.equalsIgnoreCase("pH(T)")) {
            return "gasometria_pht";
        }
        if (campo.equalsIgnoreCase("PCO2(T)")) {
            return "gasometria_pco2t";
        }
        if (campo.equalsIgnoreCase("pO2(A),T")) {
            return "gasometria_pao2t";
        }
        if (campo.equalsIgnoreCase("pO2(A)")) {
            return "gasometria_pao2";
        }
        if (campo.equalsIgnoreCase("HCO3-")) {
            return "gasometria_chco3";
        }
        if (campo.equalsIgnoreCase("RI,T")) {
            return "gasometria_rit";
        }
        if (campo.equalsIgnoreCase("CA++")) {
            return "gasometria_caa";
        }
        if (campo.equalsIgnoreCase("Lac")) {
            return "gasometria_lac";
        }
        if (campo.equalsIgnoreCase("AaDpO2")) {
            return "gasometria_aado2";
        }
        if (campo.equalsIgnoreCase("AaDpO2,T")) {
            return "gasometria_aado2t";
        }
        if (campo.equalsIgnoreCase("a/ApO2")) {
            return "gasometria_aa02";
        }
        if (campo.equalsIgnoreCase("a/ApO2,T")) {
            return "gasometria_aao2t";
        }
        if (campo.equalsIgnoreCase("SBE")) {
            return "gasometria_brecf";
        }
        if (campo.equalsIgnoreCase("Anion gap")) {
            return "gasometria_anion_gap";
        }
        if (campo.equalsIgnoreCase("Anion gap (K+)")) {
            return "gasometria_anion_gap_k";
        }
        if (campo.equalsIgnoreCase("Ca(7.4)")) {
            return "gasometria_caado2";
        }
        if (campo.equalsIgnoreCase("SBC")) {
            return "gasometria_chco3st";
        }
        if (campo.equalsIgnoreCase("tCO2(B)")) {
            return "gasometria_ctco2";
        }
        if (campo.equalsIgnoreCase("tO2")) {
            return "gasometria_ctco2";
        }
        if (campo.equalsIgnoreCase("cBase(B,ox)")) {
            return "gasometria_cbevt";
        }
        if (campo.equalsIgnoreCase("cBase(Ecf,ox)")) {
            return "gasometria_cbevv";
        }
        return campo;
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String fil_codigo = (String)dados.remove(FIL_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String req_codigo = (String)dados.remove(REQ_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        String rec_codigo = (String)dados.remove(REC_CODIGO);
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        Statement st = Conexao.getStatement();
        List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
        for (BDExame exame : exames) {
            this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getExame(), exame.getMaterial(), int_codigo, dados);
        }
    }
}

