/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.abl80flex;

import jalis.comum.Conexao;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.interfaces.abl80flex.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.util.Funcoes;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.util.HashMap;

public class InterfaceListener
extends InterfaceASTMListener {
    public static final String NOME_EXAME = "GASO";

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0004');
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            super.encerrarTransmissao();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (!Funcoes.textoVazio(message)) {
                this.parse(message);
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(1, message.length() - 2);
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size()) {
                    message = (String)this.rx_list.get(this.rx_list.getUltimoInserido()) + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                this.rx_list.add(message);
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                while (!this.rx_list.isEmpty()) {
                    String[] frames;
                    String s = (String)this.rx_list.remove(0);
                    for (String frame : frames = s.split(String.valueOf('\r'))) {
                        this.recordParser.recordFound(frame);
                    }
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }
}

