/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.a1c;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.comunicacao.PortaCOM;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private String NOME_EXAME = "a1c";
    protected int MAX_PATIENT_NAME_CHARS = 16;
    public static final int EQUIP_TIMEOUT = 5000;
    public static final int MAX_TENTATIVAS = 2;
    public static final int TIPO_REQ_NOVO = 0;
    public static final int TIPO_REQ_REPETICAO = 1;
    String int_codigo;
    String fil_codigo;
    String req_codigo;
    String mco_codigo;
    String rec_codigo;
    String pac_nome;
    String pac_exames;
    String pac_sexo;
    String req_idade;
    String req_data;
    String req_hora;
    String acao;
    String frame;
    int tx_counter = 0;

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            String[] exms;
            Statement st = Conexao.getStatement();
            for (String s : exms = exames.split(" ", 0)) {
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, s, mco_codigo, int_codigo, null, acao.equals("N") ? 1 : 3);
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    public String getErroTraduzido(String erro) {
        return erro;
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\r');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    void limpaDadosRequisicao() {
        this.frame = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
    }

    @Override
    public synchronized String parse(String message) {
        String retorno = null;
        String checksum = message.substring(message.length() - 2);
        if (this.checksum(message = message.replaceFirst(this.getMsgEnd(), ""), checksum)) {
            HashMap<TextStructureFields, String> fieldsValues = new HashMap<TextStructureFields, String>();
            try {
                int i = 0;
                for (TextStructureFields field : TextStructureFields.values()) {
                    fieldsValues.put(field, message.substring(i, i + field.tamanho).trim());
                    i += field.tamanho;
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                return "Erro ao realizar parse dos dados recebidos";
            }
            try {
                String barcode = (String)fieldsValues.get((Object)TextStructureFields.BARCODE);
                if (barcode == null || barcode.isEmpty()) {
                    this.fireExcecaoEncontrada("Problema ao recuperar o c\u00f3digo de barras. Verifique a configura\u00e7\u00e3o do aparelho e o leitor de c\u00f3digo de barras.");
                    return "";
                }
                if (barcode.contains("-")) {
                    return "";
                }
                int qtDigitosCodBarra = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (barcode.length() < qtDigitosCodBarra) {
                    return "";
                }
                retorno = this.parseResults(fieldsValues);
                if (retorno == null) {
                    return "";
                }
                if (retorno.startsWith("Erro")) {
                    return retorno;
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, 2000);
                return retorno;
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                    return "Erro ao inserir resultados recebidos ao banco de dados";
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    return "Erro ao inserir resultados recebidos ao banco de dados";
                }
            }
        }
        return "Erro ao receber resultado: CRC Mismatch!";
    }

    private String parseResults(Map<TextStructureFields, String> fieldsValues) throws SQLException {
        try {
            String barcode = fieldsValues.get((Object)TextStructureFields.BARCODE);
            Statement st = Conexao.getStatement();
            this.fil_codigo = barcode.substring(0, ParametrosGerais.getDigitosTuboFilial());
            this.req_codigo = barcode.substring(ParametrosGerais.getDigitosTuboFilial());
            this.rec_codigo = this.req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
            this.req_codigo = this.req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            if (this.fil_codigo.trim().isEmpty() || this.req_codigo.trim().isEmpty() || this.rec_codigo.trim().isEmpty()) {
                return null;
            }
            Object[] req = this.getRequisicaoAba(this.fil_codigo, this.req_codigo, this.rec_codigo);
            if (req == null) {
                return null;
            }
            this.int_codigo = this.getIntCodigo(this.fil_codigo, this.req_codigo, this.rec_codigo, this.NOME_EXAME);
            if (this.int_codigo == null) {
                this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel encontrar a interface! Verifique configura\u00e7\u00e3o do exame!");
                return null;
            }
            HashMap<String, Object> dados = new HashMap<String, Object>();
            dados.put("a1c_a1a", fieldsValues.get((Object)TextStructureFields.A1A).replace('.', ','));
            dados.put("a1c_a1b", fieldsValues.get((Object)TextStructureFields.A1B).replace('.', ','));
            dados.put("a1c_f", fieldsValues.get((Object)TextStructureFields.F).replace('.', ','));
            dados.put("a1c_la1c_plus", fieldsValues.get((Object)TextStructureFields.LA1C).replace('.', ','));
            dados.put("a1c_sa1c", fieldsValues.get((Object)TextStructureFields.SA1C).replace('.', ','));
            dados.put("a1c_ao", fieldsValues.get((Object)TextStructureFields.AO).replace('.', ','));
            dados.put("a1c_hbs", fieldsValues.get((Object)TextStructureFields.HBS).replace('.', ','));
            dados.put("a1c_total_a1", fieldsValues.get((Object)TextStructureFields.TOTAL_A1).replace('.', ','));
            List<BDExame> exames = BDUtil.getReqExamesMultGuia(this.fil_codigo, this.int_codigo, this.req_codigo, this.rec_codigo);
            for (BDExame exame : exames) {
                this.atualizarDadosExame(st, this.mco_codigo, this.mco_codigo, this.mco_codigo, exame.getExame(), exame.getMaterial(), this.mco_codigo, dados);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }

    public boolean checksum(String message, String sum) {
        return true;
    }

    public void encerrarTransmissao() throws Exception {
        if (this.tx_counter < 2) {
            Statement st = Conexao.getStatement();
            this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, this.acao.equals("N") ? 1 : 3);
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + this.pac_nome, 0, 10000);
            if (this.acao.equals("N")) {
                this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
            }
        }
        this.interromperTimer();
        this.getPortaCOM().clearInputString();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    private void retransmitirRecusado() throws Exception {
        if (this.tx_counter >= 2) {
            this.encerrarTransmissao();
            return;
        }
        this.setTX(5000);
        this.getPortaCOM().write(this.frame);
        ++this.tx_counter;
    }

    public void requisicaoExistente() throws Exception {
        Statement st = Conexao.getStatement();
        this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, this.acao.equals("N") ? 1 : 3);
        Conexao.arquivaSQL();
        this.fireMensagemEnviada("Pedido(s) re-enviado(s) com sucesso para " + this.pac_nome + ".", 0, 10000);
        this.interromperTimer();
        this.getPortaCOM().clearInputString();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela();
        this.setIdle();
    }

    public void alertarWorklistFull() throws Exception {
        this.tx_counter = 2;
        this.encerrarTransmissao();
        this.fireMensagemEnviada("Erro: O worklist est\u00e1 cheio ou o c\u00f3digo de barras est\u00e1 desligado.", 1, 5000);
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(5000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    private void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(5000);
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    private void abortarRecepcao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(3000);
    }

    public void caracterNaoEsperado() throws Exception {
    }

    private void tratarAcknowledge() throws Exception {
        if (this.isTX()) {
            this.encerrarTransmissao();
        } else {
            this.caracterNaoEsperado();
        }
    }

    private void tratarNegativeAck() throws Exception {
        if (this.isTX()) {
            this.retransmitirRecusado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    private void tratarCancel() throws Exception {
        if (this.isTX()) {
            this.alertarWorklistFull();
        } else {
            this.caracterNaoEsperado();
        }
    }

    private void tratarDelete() throws Exception {
        if (this.isTX()) {
            this.requisicaoExistente();
        } else {
            this.caracterNaoEsperado();
        }
    }

    @Override
    public void handShakeCharReceived(final char c) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    switch (c) {
                        case '\u0006': {
                            InterfaceListener.this.tratarAcknowledge();
                            break;
                        }
                        case '\u0015': {
                            InterfaceListener.this.tratarNegativeAck();
                            break;
                        }
                        case '\u0018': {
                            InterfaceListener.this.tratarCancel();
                            break;
                        }
                        case '\u007f': {
                            InterfaceListener.this.tratarDelete();
                            break;
                        }
                        default: {
                            InterfaceListener.this.caracterNaoEsperado();
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento.", 1, 5000);
                    InterfaceListener.this.setIdle();
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void dataChanged() {
        try {
            while (this.getPortaCOM().getInputString().contains(this.getMsgEnd())) {
                String message = ((PortaCOM)this.getPortaCOM()).removeInputString(this.getMsgEnd());
                if (!message.isEmpty()) {
                    String retorno = this.parse(message);
                    if (retorno != null && !retorno.isEmpty()) {
                        if (retorno.startsWith("Erro")) {
                            this.fireExcecaoEncontrada(retorno);
                        }
                        this.fireMensagemEnviada(retorno, 0, 10000);
                    }
                    if (!this.isRX()) continue;
                    this.aguardarProximoFrame();
                    continue;
                }
                if (!this.isRX()) continue;
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        try {
            if (this.isTX()) {
                this.abortarTransmissao();
            } else if (this.isRX()) {
                if (this.frame != null) {
                    this.abortarRecepcao();
                } else {
                    this.setIdle();
                }
            } else {
                this.setIdle();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    private static enum TextStructureFields {
        SAMPLE_NUMBER(5),
        A1A(5),
        A1B(5),
        F(5),
        LA1C(5),
        SA1C(5),
        AO(5),
        HBS(5),
        TOTAL_A1(5),
        BARCODE(13);

        public int tamanho;

        private TextStructureFields(int tamanho) {
            this.tamanho = tamanho;
        }
    }
}

