/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.exames;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.exames.Exame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.resultados.Exportacao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResolvedorResultado {
    private static final long EXPORTAR_NORMAL_AUTOMATICAMENTE = 1001003008L;

    public static void salvaDados(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String rec_kodigo, String exr_lotereag, String exr_serialreag, Map<String, Object> dados, boolean validarLiberado, AbstractInterfaceamentoListener listener) throws Exception {
        ResolvedorResultado.salvaDados(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, rec_kodigo, exr_lotereag, exr_serialreag, dados, Collections.EMPTY_LIST, validarLiberado, listener);
    }

    public static void salvaDados(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String exr_lotereag, String exr_serialreag, Map<String, Object> dados, boolean validarLiberado, AbstractInterfaceamentoListener listener) throws Exception {
        ResolvedorResultado.salvaDados(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, rec_codigo, exr_lotereag, exr_serialreag, dados, Collections.EMPTY_LIST, validarLiberado, listener);
    }

    public static void salvaDados(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String exr_lotereag, String exr_serialreag, Map<String, Object> dados, List<String> flags, boolean validarLiberado, AbstractInterfaceamentoListener listener) throws Exception {
        ResolvedorResultado.salvaDados(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, rec_codigo, exr_lotereag, exr_serialreag, dados, flags, validarLiberado, listener);
    }

    public static void salvaDados(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String rec_kodigo, String exr_lotereag, String exr_serialreag, Map<String, Object> dados, List<String> flags, boolean validarLiberado, AbstractInterfaceamentoListener listener) throws Exception {
        boolean recebeu_ok = false;
        String metCodigo = String.valueOf(BDUtil.getExameMetodo(fil_codigo, exa_codigo, mco_codigo, int_codigo));
        if (BDUtil.existeRequisicaoInterface(fil_codigo, int_codigo, req_codigo)) {
            ArrayList<Object> requisicoes = new ArrayList<String>();
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                requisicoes = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
            } else {
                requisicoes.add(req_codigo);
            }
            boolean isExameDesmembrado = false;
            ExameMaterial[] pais = null;
            for (String string : requisicoes) {
                if (BDUtil.existeDesmembramento(fil_codigo, int_codigo, string, rec_kodigo, exa_codigo, mco_codigo)) {
                    ExameMaterial[] exameMaterialArray = pais = BDUtil.getDesmExamesPai(fil_codigo, int_codigo, string, rec_kodigo, exa_codigo, mco_codigo);
                    int n = exameMaterialArray.length;
                    for (int i = 0; i < n; ++i) {
                        ExameMaterial ePai = exameMaterialArray[i];
                        String tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, string, rec_kodigo, int_codigo, ePai.getNomeExame(), ePai.getCodigoMaterial());
                        boolean salvou = ResolvedorResultado.salvaExameDesmembrado(st, fil_codigo, int_codigo, string, exa_codigo, mco_codigo, tuboPai, rec_kodigo, exr_lotereag, exr_serialreag, dados, flags);
                        recebeu_ok = recebeu_ok || salvou;
                    }
                    isExameDesmembrado = true;
                }
                boolean salvou = ResolvedorResultado.salvaExameNaoDesmembrado(st, fil_codigo, int_codigo, string, exa_codigo, mco_codigo, rec_codigo, exr_lotereag, exr_serialreag, dados, flags);
                recebeu_ok = recebeu_ok || salvou;
            }
            if (recebeu_ok) {
                StringBuilder msg = new StringBuilder("Resultado de exame recebido com sucesso para ");
                msg.append(BDUtil.getNomePaciente(fil_codigo, req_codigo));
                Variaveis.equip.novaMensagem(msg.toString(), 0, 10000);
                if (isExameDesmembrado) {
                    if (pais == null) {
                        pais = BDUtil.getDesmExamesPai(fil_codigo, int_codigo, req_codigo, rec_kodigo, exa_codigo, mco_codigo);
                    }
                    for (ExameMaterial pai : pais) {
                        if (!BDUtil.isGrupoInteiroPronto(fil_codigo, int_codigo, req_codigo, pai.getString(), pai.getCodigoMaterial(), rec_codigo)) continue;
                        String metCodigoPai = String.valueOf(BDUtil.getExameMetodo(fil_codigo, pai.getString(), pai.getCodigoMaterial(), int_codigo));
                        ResolvedorResultado.validarLiberacaoExame(st, fil_codigo, req_codigo, rec_codigo, pai.getCodigoMaterial(), int_codigo, pai.getString(), metCodigoPai, listener);
                    }
                }
                if (validarLiberado) {
                    ResolvedorResultado.validarLiberacaoExame(st, fil_codigo, req_codigo, rec_codigo, mco_codigo, int_codigo, exa_codigo, metCodigo, listener);
                }
            }
        } else {
            StringBuilder msg = new StringBuilder("Requisi\u00e7\u00e3o inexistente ou n\u00e3o interfaceada: ");
            msg.append(fil_codigo);
            msg.append(" ");
            msg.append(req_codigo);
            msg.append(" ");
            msg.append(rec_codigo);
            AbstractInterfaceamento equip = Variaveis.equip;
            equip.adicionarExcecao(msg.toString());
            equip.novaMensagem(msg.toString(), 1, 5000);
            equip.examesProntos.alertarUsuario();
        }
    }

    private static boolean salvaExameNaoDesmembrado(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String exr_lotereag, String exr_serialreag, Map<String, Object> dados, List<String> flags) throws SQLException, Exception {
        boolean recebeu_ok = false;
        if (BDUtil.existeExame(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo)) {
            recebeu_ok = true;
            BDUtil.setReagenteLoteESerial(st, fil_codigo, exa_codigo, mco_codigo, req_codigo, exr_lotereag, exr_serialreag);
            Exame exame = new Exame(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, rec_codigo);
            int sit = exame.getSituacaoExame();
            if (sit < 7) {
                exame.putDados(dados);
                exame.putFlags(flags);
                exame.setSituacaoExame(sit <= 2 || sit == 7 ? 2 : 4);
                exame.salvaDados(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
            }
        }
        return recebeu_ok;
    }

    private static boolean salvaExameDesmembrado(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String rec_kodigo, String exr_lotereag, String exr_serialreag, Map<String, Object> dados, List<String> flags) throws SQLException, Exception {
        boolean recebeu_ok = false;
        if (BDUtil.existeDesmembramento(fil_codigo, int_codigo, req_codigo, rec_kodigo, exa_codigo, mco_codigo)) {
            recebeu_ok = true;
            ExameMaterial[] pais = BDUtil.getDesmExamesPai(fil_codigo, int_codigo, req_codigo, rec_kodigo, exa_codigo, mco_codigo);
            String exa_kodigo = exa_codigo;
            String mco_kodigo = mco_codigo;
            for (ExameMaterial pai : pais) {
                exa_codigo = pai.getNomeExame();
                int sit_pai = BDUtil.getExmSituacao(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo = pai.getCodigoMaterial(), rec_codigo);
                if (sit_pai >= 7) continue;
                BDUtil.setReagenteLoteESerial(st, fil_codigo, exa_codigo, mco_codigo, req_codigo, exr_lotereag, exr_serialreag);
                int situacao_filho = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, exa_kodigo, mco_kodigo);
                if (situacao_filho < 7) {
                    Exame exame = new Exame(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, rec_kodigo);
                    if (dados.get("rack_position") != null) {
                        exame.setValor("rack_position", dados.get("rack_position"));
                    }
                    Set<String> keyset = dados.keySet();
                    for (String key : keyset) {
                        String campo = Exame.montaCampoExameFilho(exa_kodigo, mco_kodigo, key);
                        exame.setValor(campo, dados.get(key));
                    }
                    exame.putFlags(flags);
                    exame.setSituacaoExameFilho(new ExameMaterial(exa_kodigo, new Integer(mco_kodigo)), situacao_filho <= 2 ? 2 : 4);
                    exame.salvaDados(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, rec_kodigo);
                }
                if (BDUtil.isGrupoInteiroPronto(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo)) {
                    BDUtil.setExmSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, 2);
                    continue;
                }
                if (!BDUtil.isGrupoInteiroRepetido(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo)) continue;
                BDUtil.setExmSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, 4);
            }
        }
        return recebeu_ok;
    }

    public static void validarLiberacaoExame(Statement st, String fil_codigo, String req_codigo, String rec_codigo, String mco_codigo, String int_codigo, String exa_codigo, String metCodigo, AbstractInterfaceamentoListener listener) throws Exception {
        Exame exame = new Exame(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, rec_codigo);
        exame.putDados(ExameUtil.getDadosExameRequisicao(req_codigo, exa_codigo, mco_codigo, fil_codigo, false, false));
        Map<String, Object> dados = exame.getDados();
        String pac_codigo = BDUtil.getCodigoPaciente(fil_codigo, req_codigo);
        Map<Integer, String> res_anteriores = BDUtil.getExmResultadosAnteriores(fil_codigo, pac_codigo, req_codigo, exa_codigo, mco_codigo, metCodigo);
        Registro reg = BDUtil.getDadosRequisicao(fil_codigo, req_codigo);
        if (reg != null) {
            String con_codigo = reg.getString("con_codigo");
            String des_codigo = reg.getString("des_codigo");
            String req_idade = reg.getString("req_idade");
            String req_anomes = reg.getString("req_anomes");
            reg = BDUtil.getDadosExameRequisicaoJalis(fil_codigo, req_codigo, exa_codigo, mco_codigo);
            if (reg != null) {
                boolean isPodeConferirResultado;
                String exr_resultado = reg.getString("exr_resultado");
                String exr_situacao = reg.getString("exr_situacao");
                int met_codigo = BDUtil.getExameMetodo(fil_codigo, exa_codigo, mco_codigo, int_codigo);
                if (met_codigo < 0) {
                    return;
                }
                boolean salvoParcial = exr_situacao != null && exr_situacao.equalsIgnoreCase("P");
                String lay_codigo = ExameUtil.getCodigoLayout(fil_codigo, con_codigo, des_codigo);
                String elm_formato = ExameUtil.pegaLayoutIdade(fil_codigo, Integer.parseInt(req_idade), req_anomes, lay_codigo, exa_codigo, Integer.parseInt(mco_codigo), met_codigo, "elm_formato");
                Map<String, Map<String, String>> historicos = ExameUtil.getHistoricos(exa_codigo, fil_codigo);
                if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
                    historicos = ExameUtil.getHistoricos(null, fil_codigo);
                }
                String atributos = salvoParcial ? exr_resultado : elm_formato;
                Digitacao digi = new Digitacao();
                digi.carregarCampos(atributos, dados, null, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"), res_anteriores, true, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, null, null);
                String parametros = StringUtil.getValor(atributos, "parametros");
                String xml = StringUtil.getValor(parametros, "conferenciaAutomatica");
                String tipoCalculo = StringUtil.getValor(xml, "tipoCalculo");
                if (Funcoes.textoVazio(tipoCalculo)) {
                    tipoCalculo = "Desativada";
                }
                boolean bl = isPodeConferirResultado = !tipoCalculo.equalsIgnoreCase("Desativada");
                if (digi.possuiCamposForaDaReferencia()) {
                    BDUtil.setValorAlterado(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, 1);
                }
                if (!isPodeConferirResultado) {
                    if (!digi.possuiCamposForaDaReferencia() && Acesso.getAcesso(1001003008L) && BDUtil.getExamePermiteValidarAutomatico(fil_codigo, exa_codigo, mco_codigo, int_codigo)) {
                        ResolvedorResultado.alterarSituacaoResultado(st, fil_codigo, req_codigo, rec_codigo, mco_codigo, int_codigo, exa_codigo);
                    }
                } else {
                    isPodeConferirResultado = ExameUtil.validarResultadoDeConferenciaAutomatica(fil_codigo, req_codigo, pac_codigo, exa_codigo, String.valueOf(mco_codigo), metCodigo, int_codigo, digi.getResultadoDigitacao());
                    if (isPodeConferirResultado && Acesso.getAcesso(1001003008L) && BDUtil.getExamePermiteValidarAutomatico(fil_codigo, exa_codigo, mco_codigo, int_codigo)) {
                        ResolvedorResultado.alterarSituacaoResultado(st, fil_codigo, req_codigo, rec_codigo, mco_codigo, int_codigo, exa_codigo);
                        if (listener.equipamento.configuracao.getExportarExamesValidadosAutomaticamente() && !Funcoes.textoVazio(Variaveis.login)) {
                            Exportacao.exportarExame(listener.equipamento, st, fil_codigo, req_codigo, int_codigo, exa_codigo, mco_codigo, rec_codigo, digi.getResultadoDigitacao(), digi.getResultado());
                        }
                    }
                }
            }
        }
    }

    private static void alterarSituacaoResultado(Statement st, String fil_codigo, String req_codigo, String rec_codigo, String mco_codigo, String int_codigo, String exa_codigo) {
        try {
            int sit = BDUtil.getExmSituacao(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
            BDUtil.setExmSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, sit == 2 || sit >= 7 ? 7 : 4);
            Conexao.arquivaSQL();
        }
        catch (SQLException ex) {
            try {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

