/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.exames;

import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.CodString;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExamesUtil {
    public static ExameMaterial[] anexarCodigoMaterial(String[] exames, String mco_codigo) {
        ExameMaterial[] lista = new ExameMaterial[exames.length];
        for (int i = 0; i < exames.length; ++i) {
            lista[i] = new ExameMaterial(exames[i], Integer.parseInt(mco_codigo));
        }
        return lista;
    }

    public static ExameMaterial[] anexarCodigoMaterial(List<String> exames, String mco_codigo) {
        ExameMaterial[] lista = new ExameMaterial[exames.size()];
        for (int i = 0; i < exames.size(); ++i) {
            lista[i] = new ExameMaterial(exames.get(i), Funcoes.textoVazio(mco_codigo) ? 1 : Integer.parseInt(mco_codigo));
        }
        return lista;
    }

    public static String[] removerCodigoMaterial(CodString[] exames) {
        String[] lista = new String[exames.length];
        for (int i = 0; i < exames.length; ++i) {
            lista[i] = exames[i].getString();
        }
        return lista;
    }

    public static ExameMaterial[] desmembrarExames(Statement st, String fil_codigo, String int_codigo, ExameMaterial[] exames) throws SQLException {
        ArrayList<ExameMaterial> nova_lista = new ArrayList<ExameMaterial>();
        for (ExameMaterial exm : exames) {
            String mco_codigo;
            String exa_codigo = exm.getString();
            if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exa_codigo, mco_codigo = exm.getCodigo().toString())) {
                ExameMaterial[] filhos;
                for (ExameMaterial filho : filhos = BDUtil.getExamesFilhos(fil_codigo, int_codigo, exa_codigo, mco_codigo)) {
                    nova_lista.add(filho);
                }
                continue;
            }
            nova_lista.add(exm);
        }
        ExameMaterial[] retorno = nova_lista.toArray(new ExameMaterial[nova_lista.size()]);
        return retorno;
    }

    public static ExameMaterial[] getAlternativos(Statement st, String fil_codigo, String int_codigo, ExameMaterial[] exames) throws SQLException {
        ExameMaterial[] alternativos = new ExameMaterial[exames.length];
        int i = -1;
        for (ExameMaterial exm : exames) {
            String exa_codigo = exm.getString();
            String mco_codigo = exm.getCodigo().toString();
            String alternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exa_codigo, mco_codigo, int_codigo);
            alternativos[++i] = new ExameMaterial(alternativo, new Integer(exm.getCodigoMaterial()));
        }
        return alternativos;
    }

    public static String getMaterialAlternativo(Statement st, String fil_codigo, String int_codigo, ExameMaterial[] exames) throws SQLException {
        String retorno = " ";
        int i = -1;
        for (ExameMaterial exm : exames) {
            String mco_codigo;
            String exa_codigo = exm.getString();
            String materialAlternativo = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_codigo, mco_codigo = exm.getCodigo().toString(), int_codigo);
            if (materialAlternativo == null || materialAlternativo.trim().length() <= 0) continue;
            retorno = materialAlternativo;
        }
        return retorno;
    }

    public static Map<String, List<ExameMaterial>> getexamesCurva(String fil_codigo, String req_codigo, String rec_codigo, String int_codigo, ExameMaterial[] alternativosCurva, Statement st) throws SQLException {
        LinkedHashMap lista = new LinkedHashMap();
        LinkedHashMap<String, List<ExameMaterial>> listaNova = new LinkedHashMap<String, List<ExameMaterial>>();
        for (int i = 0; i < alternativosCurva.length; ++i) {
            String tubo = BDUtil.getExameDesmembradoTubo(fil_codigo, req_codigo, rec_codigo, int_codigo, alternativosCurva[i].getNomeExame(), alternativosCurva[i].getCodigoMaterial());
            if (Funcoes.textoVazio(tubo)) continue;
            if (!lista.containsKey(tubo)) {
                lista.put(tubo, new ArrayList());
            }
            ((List)lista.get(tubo)).add(alternativosCurva[i]);
        }
        for (String key : lista.keySet()) {
            for (ExameMaterial exameMaterial : (List)lista.get(key)) {
                String alternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exameMaterial.getString(), exameMaterial.getCodigo().toString(), int_codigo);
                if (!listaNova.containsKey(key)) {
                    listaNova.put(key, new ArrayList());
                }
                ExameMaterial novoExameMaterial = new ExameMaterial(alternativo, new Integer(exameMaterial.getCodigoMaterial()));
                if (((List)listaNova.get(key)).contains(novoExameMaterial)) continue;
                ((List)listaNova.get(key)).add(novoExameMaterial);
            }
        }
        return listaNova;
    }

    public static ExameMaterial[] removeDuplicados(ExameMaterial[] alternativos) {
        ArrayList<ExameMaterial> temporario = new ArrayList<ExameMaterial>();
        for (ExameMaterial e : alternativos) {
            if (temporario.contains(e)) continue;
            temporario.add(e);
        }
        alternativos = new ExameMaterial[temporario.size()];
        for (int i = 0; i < temporario.size(); ++i) {
            alternativos[i] = (ExameMaterial)temporario.get(i);
        }
        return alternativos;
    }

    public static ExameMaterial[] separaExamesCurva(String fil_codigo, String int_codigo, String mco_codigo, ExameMaterial[] exa_lista, List<ExameMaterial> exa_listaCurva) throws SQLException, NumberFormatException {
        ArrayList<ExameMaterial> lista = new ArrayList<ExameMaterial>();
        for (ExameMaterial exameMaterial : exa_lista) {
            if (BDUtil.isExameCurva(fil_codigo, int_codigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial())) {
                exa_listaCurva.add(exameMaterial);
                continue;
            }
            lista.add(exameMaterial);
        }
        return lista.isEmpty() ? null : lista.toArray(new ExameMaterial[lista.size()]);
    }

    public static Map<String, List<ExameMaterial>> getAlternativosCurva(String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, Statement st, List<ExameMaterial> exa_listaCurva, String tuboPai, boolean hostQuery, List<String> examesFilho) throws SQLException {
        return ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, st, exa_listaCurva, tuboPai, hostQuery, examesFilho, false);
    }

    public static Map<String, List<ExameMaterial>> getAlternativosCurva(String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, Statement st, List<ExameMaterial> exa_listaCurva, String tuboPai, boolean hostQuery, List<String> examesFilho, boolean enviarTodos) throws SQLException {
        ArrayList<String> exameCurva = new ArrayList<String>();
        for (ExameMaterial exameMaterial : exa_listaCurva) {
            exameCurva.add(exameMaterial.getNomeExame());
        }
        ExameMaterial[] listaCurva = ExamesUtil.anexarCodigoMaterial(exameCurva.toArray(new String[exameCurva.size()]), mco_codigo);
        listaCurva = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
        Map<String, List<ExameMaterial>> alternativosCurva = ExamesUtil.getexamesCurva(fil_codigo, req_codigo, !Funcoes.textoVazio(tuboPai) ? tuboPai : rec_codigo, int_codigo, listaCurva, st);
        for (ExameMaterial ex : listaCurva) {
            if (hostQuery && !Funcoes.textoVazio(tuboPai) && (rec_codigo.equals(BDUtil.getExameDesmembradoTubo(fil_codigo, req_codigo, tuboPai, int_codigo, ex.getNomeExame(), mco_codigo)) || enviarTodos)) {
                examesFilho.add(ex.getNomeExame());
                continue;
            }
            if (hostQuery) continue;
            examesFilho.add(ex.getNomeExame());
        }
        if (hostQuery && !Funcoes.textoVazio(tuboPai) && alternativosCurva.containsKey(rec_codigo)) {
            List<ExameMaterial> tmp = alternativosCurva.remove(rec_codigo);
            alternativosCurva.clear();
            alternativosCurva.put(rec_codigo, tmp);
        } else if (hostQuery && Funcoes.textoVazio(tuboPai)) {
            alternativosCurva.clear();
            examesFilho.clear();
        }
        return alternativosCurva;
    }
}

