/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.configuracao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.EquipamentoFilial;
import jalis.laboratorio.interfaceamento.configuracao.ExameDesmembrado;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.CodString;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import jalis.util.sql.SalvaDadosException;
import jalis.util.tabela.TabelaModelada;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class TrocaEquipamento
extends JDialog
implements ActionListener {
    private static final int EXM_CODIGO = 0;
    private static final int EXM_DESCRICAO = 1;
    private static final int EXM_MATERIAL = 2;
    private static final int EXM_MATCODIGO = 3;
    private static final int INT_CODIGO = 4;
    private static final int FIL_CODIGO = 5;
    private static final int EXM_DESMEMBRADO = 6;
    private static final int EXM_METODOS = 7;
    private static final int INT_NAOENVIADOS = 8;
    private static final int INT_PENDENTES = 9;
    private static final int INT_PRONTOS = 10;
    private static final int EXM_COLUNAS = 11;
    private static final int MET_CODIGO = 0;
    private static final int MET_DESCRICAO = 1;
    private static final int MET_PADRAO = 2;
    private static final int MET_COLUNAS = 3;
    private String STATUS_NAOENVIADO = "N\u00e3o Enviado";
    private String STATUS_PENDENTE = "Pendente";
    private JPanel panelEquipamento = new JPanel(new FlowLayout(0));
    private JComboBox comboEquipamentoOrigem;
    private JComboBox comboEquipamentoDestino;
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JButton buttonFechar = new BotaoNavegavel("Fechar", 'F');
    private JButton buttonTransferir = new BotaoNavegavel("Transferir", 'T');
    TabelaModelada tabelaExames = new TabelaModelada(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Mat"});
    JScrollPane scrollExames = new JScrollPane(this.tabelaExames);
    TabelaModelada tabelaSelecionado = new TabelaModelada(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Mat"});
    JScrollPane scrollSelecionado = new JScrollPane(this.tabelaSelecionado);
    TabelaModelada tabelaMetodoExame = new TabelaModelada(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"});
    JScrollPane scrollMetodoExame = new JScrollPane(this.tabelaMetodoExame);
    JPanel panelCentroExames = new JPanel(new BorderLayout());
    JPanel panelBotoesTroca = new JPanel(new GridBagLayout());
    JButton buttonAdicionarExame = new JButton(">");
    JButton buttonRemoverExame = new JButton("<");
    JPanel panelCheckBox = new JPanel(new GridBagLayout());
    JCheckBox checkExameNaoEnviados = new JCheckBox("Mover exames n\u00e3o enviados");
    JCheckBox checkExameEnviados = new JCheckBox("Mover exames pendentes");
    JComboBox comboMudarSituacao = ComponenteFactory.novoJComboBox(new String[]{this.STATUS_NAOENVIADO, this.STATUS_PENDENTE});
    JPanel panelCentro = new JPanel(new BorderLayout());

    public TrocaEquipamento(JFrame owner, ArrayList<EquipamentoFilial> equipamentos) {
        super(owner);
        this.setTitle("Troca de exames entre equipamentos");
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setSize(new Dimension(650, 550));
        this.setLayout(new BorderLayout());
        this.setLocationRelativeTo(owner);
        this.checkExameEnviados.setSelected(true);
        this.checkExameNaoEnviados.setSelected(true);
        try {
            Statement st = Conexao.getStatement();
            this.panelEquipamento.add(new JLabel("Equipamento Origem"));
            this.comboEquipamentoOrigem = ComponenteFactory.novoJComboBox(equipamentos.toArray());
            this.panelEquipamento.add(this.comboEquipamentoOrigem);
            this.panelEquipamento.add(new JLabel("Equipamento Destino"));
            this.comboEquipamentoDestino = ComponenteFactory.novoJComboBox(BDUtil.getInterfaces(Variaveis.filialPadrao));
            this.panelEquipamento.add(this.comboEquipamentoDestino);
            this.add((Component)this.panelEquipamento, "North");
            Conexao.fecharStatement(st);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.comboEquipamentoOrigem.addActionListener(this);
        this.buttonFechar.addActionListener(this);
        this.buttonTransferir.addActionListener(this);
        this.panelBotoes.add(this.buttonTransferir);
        this.panelBotoes.add(this.buttonFechar);
        this.add((Component)this.panelBotoes, "South");
        this.tabelaExames.forceSize(0, 50);
        this.tabelaExames.forceSize(2, 40);
        this.tabelaSelecionado.forceSize(0, 50);
        this.tabelaSelecionado.forceSize(2, 40);
        this.tabelaMetodoExame.forceSize(0, 50);
        this.tabelaMetodoExame.setDefaultRenderer(Object.class, new RendererMetodos());
        this.tabelaSelecionado.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int row = TrocaEquipamento.this.tabelaSelecionado.getSelectedRow();
                    if (row >= 0 && row < TrocaEquipamento.this.tabelaSelecionado.getRowCount()) {
                        TrocaEquipamento.this.exibirMetodos(row);
                    } else {
                        while (TrocaEquipamento.this.tabelaMetodoExame.getRowCount() > 0) {
                            TrocaEquipamento.this.tabelaMetodoExame.deleteRow(0);
                        }
                    }
                }
            }
        });
        this.tabelaMetodoExame.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (TrocaEquipamento.this.tabelaMetodoExame.getSelectedRow() >= 0 && e.getClickCount() == 2) {
                    TrocaEquipamento.this.trocarMetodo(TrocaEquipamento.this.tabelaMetodoExame.getSelectedRow());
                }
            }
        });
        this.tabelaMetodoExame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (TrocaEquipamento.this.tabelaMetodoExame.getSelectedRow() >= 0 && e.getKeyCode() == 32) {
                    TrocaEquipamento.this.trocarMetodo(TrocaEquipamento.this.tabelaMetodoExame.getSelectedRow());
                }
            }
        });
        JPanel panelExames = new JPanel(new BorderLayout());
        panelExames.add(this.scrollExames);
        panelExames.setBorder(ComponenteFactory.novoTitledEtchedBorder("Exames"));
        panelExames.setPreferredSize(new Dimension(250, 380));
        JPanel panelSelecionado = new JPanel(new BorderLayout());
        panelSelecionado.add((Component)this.scrollSelecionado, "Center");
        panelSelecionado.setBorder(ComponenteFactory.novoTitledEtchedBorder("Exames Selecionados"));
        panelSelecionado.setPreferredSize(new Dimension(250, 380));
        JPanel panelMetodo = new JPanel(new BorderLayout());
        panelMetodo.setBorder(ComponenteFactory.novoTitledEtchedBorder("M\u00e9todos do Exame"));
        panelMetodo.add((Component)this.scrollMetodoExame, "Center");
        panelMetodo.setPreferredSize(new Dimension(250, 100));
        panelSelecionado.add((Component)panelMetodo, "South");
        this.panelCentroExames.add((Component)panelExames, "West");
        this.panelCentroExames.add((Component)panelSelecionado, "East");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        this.buttonAdicionarExame.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAdicionarExame.addActionListener(this);
        this.panelBotoesTroca.add((Component)this.buttonAdicionarExame, c);
        ++c.gridy;
        this.buttonRemoverExame.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoverExame.addActionListener(this);
        this.panelBotoesTroca.add((Component)this.buttonRemoverExame, c);
        this.panelCentroExames.add((Component)this.panelBotoesTroca, "Center");
        this.panelCentro.add((Component)this.panelCentroExames, "Center");
        this.panelCheckBox.setBorder(ComponenteFactory.novoTitledEtchedBorder("Op\u00e7\u00f5es"));
        this.panelCheckBox.setPreferredSize(new Dimension(550, 100));
        this.checkExameEnviados.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TrocaEquipamento.this.comboMudarSituacao.setEnabled(TrocaEquipamento.this.checkExameEnviados.isSelected());
            }
        });
        this.comboMudarSituacao.setEnabled(false);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        this.panelCheckBox.add((Component)this.checkExameNaoEnviados, c);
        ++c.gridy;
        this.panelCheckBox.add((Component)this.checkExameEnviados, c);
        ++c.gridy;
        this.panelCheckBox.add((Component)new JLabel("Mover pendentes com a situa\u00e7\u00e3o"), c);
        ++c.gridx;
        this.panelCheckBox.add((Component)this.comboMudarSituacao, c);
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.fill = 1;
        this.panelCheckBox.add((Component)new JPanel(), c);
        this.panelCentro.add((Component)this.panelCheckBox, "South");
        this.add((Component)this.panelCentro, "Center");
        this.loadExames();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonAdicionarExame) {
            this.transferirExame(this.tabelaExames, this.tabelaSelecionado);
        } else if (e.getSource() == this.buttonRemoverExame) {
            this.transferirExame(this.tabelaSelecionado, this.tabelaExames);
        } else if (e.getSource() == this.buttonTransferir) {
            this.transferirExamesSelecionados();
        } else if (e.getSource() == this.comboEquipamentoOrigem) {
            this.loadExames();
        }
    }

    private void loadExames() {
        try {
            ArrayList<Object[]> exames = new ArrayList<Object[]>();
            Statement s = Conexao.getStatement();
            StringBuilder query = new StringBuilder();
            query.append("select a.fil_codigo, a.exa_codigo, a.mco_codigo, a.int_codigo, b.exa_descricao, ");
            query.append("c.mco_abreviatura, a.int_codigo from examematinterface a left join exames b on a.fil_codigo = ");
            query.append("b.fil_codigo and a.exa_codigo = b.exa_codigo left join materialcoleta c on a.fil_codigo ");
            query.append("= c.fil_codigo and a.mco_codigo = c.mco_codigo where ");
            EquipamentoFilial e = (EquipamentoFilial)this.comboEquipamentoOrigem.getSelectedItem();
            query.append(" a.fil_codigo = ").append(e.getFilial());
            query.append(" and a.int_codigo = ").append(e.getEquipamento());
            query.append(" and emi_padrao = true order by exa_codigo");
            ResultSet rs = Conexao.executeQuery(s, query.toString());
            while (rs != null && rs.next()) {
                Object[] linha = new Object[11];
                linha[5] = rs.getString("fil_codigo");
                linha[0] = rs.getString("exa_codigo");
                linha[3] = rs.getString("mco_codigo");
                linha[1] = rs.getString("exa_descricao");
                linha[2] = rs.getString("mco_abreviatura");
                linha[6] = this.getExamesDesmPai(rs.getString("fil_codigo"), rs.getString("int_codigo"), rs.getString("exa_codigo"), rs.getString("mco_codigo"));
                linha[7] = this.getExamesMetodos(rs.getString("fil_codigo"), rs.getString("exa_codigo"), rs.getString("mco_codigo"));
                linha[4] = rs.getString("int_codigo");
                linha[8] = this.getQuantidadeExamesInterfaceamento(rs.getString("fil_codigo"), rs.getString("int_codigo"), rs.getString("exa_codigo"), rs.getString("mco_codigo"), 0);
                linha[9] = this.getQuantidadeExamesInterfaceamento(rs.getString("fil_codigo"), rs.getString("int_codigo"), rs.getString("exa_codigo"), rs.getString("mco_codigo"), 1);
                linha[10] = this.getQuantidadeExamesInterfaceamento(rs.getString("fil_codigo"), rs.getString("int_codigo"), rs.getString("exa_codigo"), rs.getString("mco_codigo"), 2);
                exames.add(linha);
            }
            this.tabelaExames.setData(exames);
            if (exames.size() > 0) {
                this.tabelaExames.selectRow(0);
            }
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar exames.", ex.getStackTrace());
        }
    }

    private void transferirExame(TabelaModelada origem, TabelaModelada destino) {
        try {
            Statement st = Conexao.getStatement();
            this.comboEquipamentoDestino.setEnabled(this.tabelaSelecionado.getRowCount() == 0);
            this.comboEquipamentoOrigem.setEnabled(this.tabelaSelecionado.getRowCount() == 0);
            int row = origem.getSelectedRow();
            if (row < 0) {
                return;
            }
            Object[] linha = origem.getRow(row);
            if ((Integer)linha[10] > 0 && Funcoes.mensagem(this, "Existem requisi\u00e7\u00f5es prontas com este exame n\u00e3o exportadas no interfaceamento!\nDeseja continuar", 4) != 0) {
                return;
            }
            CodString equipamento = (CodString)this.comboEquipamentoDestino.getSelectedItem();
            if (!this.existeConfiguracaoOutroEquipamento((String)linha[5], (String)linha[0], (String)linha[3], equipamento.getCodigo().toString())) {
                Funcoes.mensagem(this, "N\u00e3o existe configura\u00e7\u00e3o deste exame para o equipamento de destino!\nAntes de continuar \u00e9 necess\u00e1rio criar a configura\u00e7\u00e3o.", 2);
                this.comboEquipamentoDestino.setEnabled(this.tabelaSelecionado.getRowCount() == 0);
                this.comboEquipamentoOrigem.setEnabled(this.tabelaSelecionado.getRowCount() == 0);
                return;
            }
            EquipamentoFilial equip = (EquipamentoFilial)this.comboEquipamentoOrigem.getSelectedItem();
            if (equip.getEquipamento().intValue() == equipamento.getCodigo().intValue()) {
                Funcoes.mensagem(this, "Equipamento selecionado \u00e9 o mesmo de Origem!", 2);
                return;
            }
            ExameMaterial[] exames = (ExameMaterial[])linha[6];
            ArrayList<ExameMaterial> lista = new ArrayList<ExameMaterial>();
            if (exames != null && exames.length > 0) {
                for (ExameMaterial e : exames) {
                    for (int i = 0; i < origem.getRowCount(); ++i) {
                        ExameMaterial[] exas;
                        Object[] li = origem.getRow(i);
                        if (!li[0].toString().equalsIgnoreCase(e.getNomeExame())) continue;
                        for (ExameMaterial ex : exas = (ExameMaterial[])li[6]) {
                            if (lista.contains(ex)) continue;
                            lista.add(ex);
                        }
                    }
                    lista.add(e);
                }
                StringBuilder msg = new StringBuilder();
                msg.append("O exame ").append(linha[1]).append(" \u00e9 um exame desmembrado ou faz parte de um desmembramento.\n");
                msg.append("Os seguintes exames ser\u00e3o transferidos juntos:\n");
                for (ExameMaterial e : lista) {
                    if (e.getNomeExame().equalsIgnoreCase(linha[0].toString())) continue;
                    msg.append(" - ").append(BDUtil.getExmDescricao(Variaveis.filialPadrao, e.getNomeExame())).append("\n");
                }
                msg.append("Deseja continuar?");
                if (Funcoes.mensagem(this, msg.toString(), 4) == 0) {
                    destino.addRow(linha);
                    origem.deleteRow(row);
                    for (ExameMaterial e : lista) {
                        for (int i = 0; i < origem.getRowCount(); ++i) {
                            linha = origem.getRow(i);
                            if (!e.getNomeExame().toString().equalsIgnoreCase(linha[0].toString()) || !e.getCodigoMaterial().toString().equalsIgnoreCase(linha[3].toString())) continue;
                            destino.addRow(linha);
                            origem.deleteRow(i);
                        }
                    }
                }
            } else {
                destino.addRow(linha);
                origem.deleteRow(row);
            }
            Conexao.fecharStatement(st);
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "TrocaEquipamento: 276");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void transferirExamesSelecionados() {
        block23: {
            EquipamentoFilial equipamentoOrigem;
            CodString equipamentoDestino;
            Statement st;
            SplashMensagem mensagem;
            block22: {
                block21: {
                    mensagem = SplashMensagem.getInstancia(this);
                    st = Conexao.getStatement();
                    equipamentoDestino = (CodString)this.comboEquipamentoDestino.getSelectedItem();
                    equipamentoOrigem = (EquipamentoFilial)this.comboEquipamentoOrigem.getSelectedItem();
                    if (equipamentoDestino.getCodigo().intValue() != equipamentoOrigem.getEquipamento().intValue()) break block21;
                    Funcoes.mensagem(this, "Equipamento selecionado \u00e9 o mesmo de Origem!", 2);
                    mensagem.apagar();
                    Conexao.fecharStatement(st);
                    return;
                }
                if (this.tabelaSelecionado.getRowCount() != 0) break block22;
                Funcoes.mensagem(this, "Nenhum exame foi selecionado para transfer\u00eancia", 2);
                mensagem.apagar();
                Conexao.fecharStatement(st);
                return;
            }
            try {
                StringBuilder sql = new StringBuilder();
                ArrayList<ExameDesmembrado> examesDesmembrados = new ArrayList<ExameDesmembrado>();
                for (int row = 0; row < this.tabelaSelecionado.getRowCount(); ++row) {
                    Object[] linha = this.tabelaSelecionado.getRow(row);
                    SalvaDados salvar = new SalvaDados("examematinterface", 2);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, linha[5]);
                    salvar.adicionaCampo("exa_codigo", 0, false, true, linha[0]);
                    salvar.adicionaCampo("mco_codigo", 2, false, true, linha[3]);
                    salvar.adicionaCampo("int_codigo", 2, false, true, equipamentoDestino.getCodigo());
                    salvar.adicionaCampo("emi_padrao", 4, false, false, true);
                    DBUtil.gravaAutoCopia(linha[5].toString(), st, salvar, "fil_codigo", ParametrosGerais.getCopiaExame(), null, 1);
                    salvar.limpar();
                    salvar.adicionaCampo("fil_codigo", 2, false, true, linha[5]);
                    salvar.adicionaCampo("exa_codigo", 0, false, true, linha[0]);
                    salvar.adicionaCampo("mco_codigo", 2, false, true, linha[3]);
                    salvar.adicionaCampo("int_codigo", 2, false, true, (int)equipamentoOrigem.getEquipamento());
                    salvar.adicionaCampo("emi_padrao", 4, false, false, false);
                    DBUtil.gravaAutoCopia(linha[5].toString(), st, salvar, "fil_codigo", ParametrosGerais.getCopiaExame(), null, 1);
                    ArrayList metodos = (ArrayList)linha[7];
                    for (int j = 0; j < metodos.size(); ++j) {
                        Object[] metodo = (Object[])metodos.get(j);
                        String padrao = (String)metodo[2];
                        if (!padrao.equalsIgnoreCase("t")) continue;
                        salvar.limpar();
                        salvar.setTabela("examematcoleta");
                        salvar.adicionaCampo("fil_codigo", 2, false, true, linha[5]);
                        salvar.adicionaCampo("exa_codigo", 0, false, true, linha[0]);
                        salvar.adicionaCampo("mco_codigo", 2, false, true, linha[3]);
                        salvar.adicionaCampo("met_codigo", 2, false, false, metodo[0]);
                        DBUtil.gravaAutoCopia(linha[5].toString(), st, salvar, "fil_codigo", ParametrosGerais.getCopiaExame(), null, 1);
                    }
                    String[] situacoes = null;
                    if (this.checkExameNaoEnviados.isSelected() && this.checkExameEnviados.isSelected()) {
                        situacoes = new String[]{"0", "1"};
                    } else if (this.checkExameNaoEnviados.isSelected()) {
                        situacoes = new String[]{"0"};
                    } else if (this.checkExameEnviados.isSelected()) {
                        situacoes = new String[]{"1"};
                    }
                    ArrayList<ExameDesmembrado> examesDesmembradosTmp = this.getExamesDesmembrados(linha[5].toString(), linha[0].toString(), linha[3].toString(), equipamentoOrigem.getEquipamento().toString(), situacoes);
                    if (examesDesmembradosTmp.size() > 0) {
                        examesDesmembrados.addAll(examesDesmembradosTmp);
                    }
                    for (ExameDesmembrado e : examesDesmembradosTmp) {
                        e.deleteExame(st);
                    }
                    if (this.checkExameNaoEnviados.isSelected()) {
                        sql.setLength(0);
                        sql.append("update interfaceexamerequisicao set int_codigo = ");
                        sql.append(equipamentoDestino.getCodigo());
                        sql.append(" where exa_codigo = '").append(linha[0]).append("'");
                        sql.append(" and fil_codigo = ").append(linha[5]);
                        sql.append(" and mco_codigo = ").append(linha[3]);
                        sql.append(" and int_codigo = ").append(equipamentoOrigem.getEquipamento());
                        sql.append(" and ier_situacao = ").append(0);
                        Conexao.executeUpdate(Variaveis.filialPadrao, st, sql.toString());
                    }
                    if (!this.checkExameEnviados.isSelected()) continue;
                    sql.setLength(0);
                    sql.append("update interfaceexamerequisicao set int_codigo = ");
                    sql.append(equipamentoDestino.getCodigo());
                    if (this.comboMudarSituacao.getSelectedItem() == this.STATUS_NAOENVIADO) {
                        sql.append(", ier_situacao = 0 ");
                    }
                    sql.append(" where exa_codigo = '").append(linha[0]).append("'");
                    sql.append(" and fil_codigo = ").append(linha[5]);
                    sql.append(" and mco_codigo = ").append(linha[3]);
                    sql.append(" and int_codigo = ").append(equipamentoOrigem.getEquipamento());
                    sql.append(" and ier_situacao = ").append(1);
                    Conexao.executeUpdate(Variaveis.filialPadrao, st, sql.toString());
                }
                for (ExameDesmembrado e : examesDesmembrados) {
                    e.insertExame(st, equipamentoDestino.getCodigo().toString());
                }
                Conexao.arquivaSQL();
                Funcoes.mensagem(this, "Exames atualizados com sucesso!", 2);
                this.loadExames();
                while (this.tabelaSelecionado.getRowCount() > 0) {
                    this.tabelaSelecionado.deleteRow(0);
                }
                this.checkExameEnviados.setSelected(true);
                this.checkExameEnviados.setEnabled(true);
                this.checkExameNaoEnviados.setSelected(true);
                this.checkExameNaoEnviados.setEnabled(true);
                mensagem.apagar();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "TrocaEquipamento: 288");
                mensagem.apagar();
                Conexao.fecharStatement(st);
                break block23;
            }
            catch (SalvaDadosException ex2) {
                ErrorLogger.mostraMensagem(this, ex2.getMessage(), ex2.getStackTrace(), "TrocaEquipamento: 307");
                mensagem.apagar();
                {
                    catch (Throwable throwable) {
                        mensagem.apagar();
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
    }

    private ExameMaterial[] getExamesDesmPai(String fil_codigo, String int_codigo, String exa_codigo, String mco_codigo) throws SQLException {
        Statement st = Conexao.getStatement();
        ExameMaterial[] exames = BDUtil.getExamesFilhos(fil_codigo, int_codigo, exa_codigo, mco_codigo);
        StringBuilder sql = new StringBuilder();
        sql.append("select exa_codigo, mco_codigo from examematintdesmembrar ");
        sql.append(" where fil_codigo = ").append(fil_codigo);
        sql.append(" and int_codigo = ").append(int_codigo);
        sql.append(" and exa_kodigo = '").append(exa_codigo).append("'");
        sql.append(" and mco_kodigo = ").append(mco_codigo);
        ResultSet rst = Conexao.executeQuery(st, sql.toString());
        ArrayList<ExameMaterial> lista = new ArrayList<ExameMaterial>();
        if (exames.length > 0) {
            while (rst.next()) {
                for (ExameMaterial e : exames) {
                    if (e.getNomeExame().toString().equalsIgnoreCase(rst.getString("exa_codigo")) || e.getCodigoMaterial().toString().equalsIgnoreCase(rst.getString("mco_codigo"))) continue;
                    lista.add(new ExameMaterial(rst.getString("exa_codigo"), rst.getInt("mco_codigo")));
                }
            }
        } else {
            while (rst.next()) {
                lista.add(new ExameMaterial(rst.getString("exa_codigo"), rst.getInt("mco_codigo")));
            }
        }
        for (ExameMaterial e : exames) {
            lista.add(e);
        }
        ExameMaterial[] retorno = new ExameMaterial[lista.size()];
        for (int i = 0; i < lista.size(); ++i) {
            retorno[i] = (ExameMaterial)lista.get(i);
        }
        return retorno;
    }

    private ArrayList getExamesMetodos(String fil_codigo, String exa_codigo, String mco_codigo) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder sql = new StringBuilder();
        sql.append("select distinct ");
        sql.append(" b.met_codigo, met_descricao ");
        sql.append("from ");
        sql.append(" examelayoutmetodo a ");
        sql.append(" left join metodologia b on a.fil_codigo = b.fil_codigo and a.met_codigo = b.met_codigo ");
        sql.append("where ");
        sql.append(" a.fil_codigo = ").append(fil_codigo).append(" and ");
        sql.append(" a.exa_codigo = '").append(exa_codigo).append("' and ");
        sql.append(" a.mco_codigo = ").append(mco_codigo);
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        ArrayList<Object[]> retorno = new ArrayList<Object[]>();
        while (rs.next()) {
            Object[] linha = new Object[]{rs.getString("met_codigo"), rs.getString("met_descricao"), this.getMetodoPadrao(fil_codigo, exa_codigo, mco_codigo, rs.getString("met_codigo"))};
            retorno.add(linha);
        }
        return retorno;
    }

    private String getMetodoPadrao(String fil_codigo, String exa_codigo, String mco_codigo, String met_codigo) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder sql = new StringBuilder();
        sql.append("select met_codigo ");
        sql.append("from ");
        sql.append(" examematcoleta ");
        sql.append("where ");
        sql.append(" fil_codigo = ").append(fil_codigo).append(" and ");
        sql.append(" exa_codigo = '").append(exa_codigo).append("' and ");
        sql.append(" mco_codigo = ").append(mco_codigo);
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        if (rs.next()) {
            return rs.getString("met_codigo").equalsIgnoreCase(met_codigo) ? "t" : "f";
        }
        return "f";
    }

    private int getQuantidadeExamesInterfaceamento(String fil_codigo, String int_codigo, String exa_codigo, String mco_codigo, int situacao) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder sql = new StringBuilder();
        sql.append("select count(*) as count ");
        sql.append("from ");
        sql.append(" interfaceexamerequisicao ier ");
        if (situacao == 2) {
            sql.append("JOIN requisicao req ON ier.fil_codigo = req.fil_codigo and ier.req_codigo = req.req_codigo ");
            sql.append("JOIN examerequisicao exr ON ier.fil_codigo = exr.fil_codigo and ier.req_codigo = exr.req_codigo and ier.exa_codigo = exr.exa_codigo and ier.mco_codigo = exr.mco_codigo ");
        }
        sql.append("where ");
        sql.append(" ier.fil_codigo = ").append(fil_codigo).append(" and ");
        sql.append(" ier.exa_codigo = '").append(exa_codigo).append("' and ");
        sql.append(" ier.mco_codigo = ").append(mco_codigo).append(" and ");
        sql.append(" ier.int_codigo = ").append(int_codigo).append(" and ");
        if (situacao != 2) {
            sql.append(" ier.ier_situacao = ").append(situacao);
        } else {
            sql.append(" ier.ier_situacao >= ").append(situacao).append(" and ier.ier_situacao <= ").append(7);
            sql.append(" and exr.exr_situacao not in ( ");
            sql.append("'").append("T").append("', ");
            sql.append("'").append("A").append("', ");
            sql.append("'").append("F").append("', ");
            sql.append("'").append("R").append("', ");
            sql.append("'").append("N").append("', ");
            sql.append("'").append("C").append("', ");
            sql.append("'").append("L").append("', ");
            sql.append("'").append("E").append("', ");
            sql.append("'").append("I").append("' ");
            sql.append(") ");
            sql.append("and not exr.exr_excluido ");
            sql.append("and not req.req_excluida ");
        }
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        if (rs.next()) {
            return rs.getInt("count");
        }
        return 0;
    }

    private void exibirMetodos(int row) {
        ArrayList metodos = (ArrayList)this.tabelaSelecionado.getValueAt(row, 7);
        while (this.tabelaMetodoExame.getRowCount() > 0) {
            this.tabelaMetodoExame.deleteRow(0);
        }
        for (int i = 0; i < metodos.size(); ++i) {
            this.tabelaMetodoExame.addRow((Object[])metodos.get(i));
        }
    }

    private void trocarMetodo(int row) {
        Object[] exame = this.tabelaMetodoExame.getRow(row);
        for (int i = 0; i < this.tabelaMetodoExame.getRowCount(); ++i) {
            Object[] linha = this.tabelaMetodoExame.getRow(i);
            linha[2] = "f";
        }
        exame[2] = "t";
        this.tabelaMetodoExame.revalidate();
        this.tabelaMetodoExame.repaint();
    }

    private ArrayList<ExameDesmembrado> getExamesDesmembrados(String fil_codigo, String exa_codigo, String mco_codigo, String int_codigo, String[] situacoes) throws SQLException {
        ArrayList<ExameDesmembrado> exames = new ArrayList<ExameDesmembrado>();
        Statement st = Conexao.getStatement();
        StringBuilder sql = new StringBuilder();
        sql.append("select * from interfaceexamerequisicaodesm ");
        sql.append(" where fil_codigo = ").append(fil_codigo);
        sql.append(" and int_codigo = ").append(int_codigo);
        sql.append(" and exa_codigo = '").append(exa_codigo).append("'");
        sql.append(" and mco_codigo = ").append(mco_codigo);
        if (situacoes != null) {
            sql.append(" and erd_situacao in( ").append(StringUtil.implode(situacoes, ",")).append(" )");
        }
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        while (rs.next()) {
            ExameDesmembrado exame = new ExameDesmembrado();
            exame.fil_codigo = rs.getString("fil_codigo");
            exame.int_codigo = rs.getString("int_codigo");
            exame.exa_codigo = rs.getString("exa_codigo");
            exame.mco_codigo = rs.getString("mco_codigo");
            exame.req_codigo = rs.getString("req_codigo");
            exame.rec_codigo = rs.getString("rec_codigo");
            exame.exa_kodigo = rs.getString("exa_kodigo");
            exame.mco_kodigo = rs.getString("mco_kodigo");
            exame.erd_situacao = this.comboMudarSituacao.getSelectedItem() == this.STATUS_NAOENVIADO ? String.valueOf(0) : rs.getString("erd_situacao");
            exame.rec_kodigo = rs.getString("rec_kodigo");
            exames.add(exame);
        }
        return exames;
    }

    private boolean existeConfiguracaoOutroEquipamento(String fil_codigo, String exa_codigo, String mco_codigo, String int_codigo) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder sql = new StringBuilder();
        sql.append("select count(*) as count from examematinterface ");
        sql.append(" where fil_codigo = ").append(fil_codigo);
        sql.append(" and int_codigo = ").append(int_codigo);
        sql.append(" and exa_codigo = '").append(exa_codigo).append("'");
        sql.append(" and mco_codigo = ").append(mco_codigo);
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        if (rs.next()) {
            return rs.getInt("count") > 0;
        }
        return false;
    }

    class RendererMetodos
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            Color cor = UIManager.getColor("Table.selectionBackground");
            JLabel label = new JLabel();
            label.setOpaque(true);
            label.setFont(table.getFont());
            label.setText((String)value);
            if (TrocaEquipamento.this.tabelaMetodoExame.getValueAt(row, 2).equals("t")) {
                if (selected) {
                    label.setBackground(Color.gray);
                } else {
                    label.setBackground(Color.lightGray);
                }
            } else if (selected) {
                label.setBackground(cor);
            } else {
                label.setBackground(Color.white);
            }
            return label;
        }
    }
}

