/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.configuracao;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.FlowController;
import jalis.laboratorio.interfaceamento.comunicacao.PortaCOM;
import jalis.laboratorio.interfaceamento.comunicacao.PortaFILE;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocket;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketServer;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketServerDouble;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketServerTriplex;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketSingle;
import jalis.laboratorio.interfaceamento.configuracao.EquipamentoFilial;
import jalis.laboratorio.interfaceamento.configuracao.ProtocoloInterface;
import jalis.service.cadastro.exame.InterfaceService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.util.ArrayList;

public class ConfiguracaoSerial {
    private ProtocoloInterface protocolo;
    private String porta;
    private String descricao;
    private Integer velocidade;
    private Integer dataBits;
    private Integer stopBits;
    private Integer paridade;
    private Integer fluxo;
    private ArrayList<EquipamentoFilial> equipamentos = new ArrayList();
    private AbstractPort portaCOM;
    private AbstractInterfaceamentoListener interfaceamentoListener;
    private FlowController fluxoController;
    private String diretorioExportacao;
    private String diretorioImportacao;
    private String comandoExportacao;
    private String comandoImportacao;
    private String variaveisConfiguracao;
    private String portaSocketOutput;
    private String portaSocketInput;
    private String portaSocketInputTriplex;
    private String enderecoSocket;
    private String[] filtroColetas;
    private String[] filtroDestinos;
    private String[] filtroSituacoesReq;
    private String fonteOdbcWorklist;
    private String fonteOdbcResultados;

    public static ArrayList<ConfiguracaoSerial> loadConfiguracoes(String xml) {
        try {
            String[] interfaceamentos;
            ArrayList<ConfiguracaoSerial> configuracoes = new ArrayList<ConfiguracaoSerial>();
            if (Funcoes.textoVazio(xml)) {
                return configuracoes;
            }
            for (String s : interfaceamentos = StringUtil.getValores(xml, "interfaceamento")) {
                ConfiguracaoSerial c = new ConfiguracaoSerial();
                c.carregarXML(s);
                if (c.equipamentos.size() <= 0) continue;
                configuracoes.add(c);
            }
            return configuracoes;
        }
        catch (Exception e) {
            return new ArrayList<ConfiguracaoSerial>();
        }
    }

    public void addEquipamento(EquipamentoFilial c) {
        this.equipamentos.add(c);
    }

    public ArrayList<EquipamentoFilial> getEquipamentos() {
        return this.equipamentos;
    }

    public String getPorta() {
        return this.porta;
    }

    public void setPorta(String porta) {
        this.porta = porta;
    }

    public String getPortaSocketOutput() {
        return this.portaSocketOutput;
    }

    public void setPortaSocketOutput(String portaSocketOutput) {
        this.portaSocketOutput = portaSocketOutput;
    }

    public String getEnderecoSocket() {
        return this.enderecoSocket;
    }

    public void setEnderecoSocket(String enderecoSocket) {
        this.enderecoSocket = enderecoSocket;
    }

    public String getPortaSocketInput() {
        return this.portaSocketInput;
    }

    public void setPortaSocketInput(String portaSocketInput) {
        this.portaSocketInput = portaSocketInput;
    }

    public String getPortaSocketInputTriplex() {
        return this.portaSocketInputTriplex;
    }

    public void setPortaSocketInputTriplex(String portaSocketInputTriplex) {
        this.portaSocketInputTriplex = portaSocketInputTriplex;
    }

    public ProtocoloInterface getProtocolo() {
        return this.protocolo;
    }

    public void setProtocolo(ProtocoloInterface protocolo) {
        this.protocolo = protocolo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String toString() {
        return this.getDescricao();
    }

    public Integer getDataBits() {
        return this.dataBits;
    }

    public void setDataBits(Integer dataBits) {
        this.dataBits = dataBits;
    }

    public Integer getFluxo() {
        return this.fluxo;
    }

    public void setFluxo(Integer fluxo) {
        this.fluxo = fluxo;
    }

    public Integer getParidade() {
        return this.paridade;
    }

    public void setParidade(Integer paridade) {
        this.paridade = paridade;
    }

    public Integer getStopBits() {
        return this.stopBits;
    }

    public void setStopBits(Integer stopBits) {
        this.stopBits = stopBits;
    }

    public Integer getVelocidade() {
        return this.velocidade;
    }

    public void setVelocidade(Integer velocidade) {
        this.velocidade = velocidade;
    }

    public String getDiretorioExportacao() {
        return this.diretorioExportacao;
    }

    public void setDiretorioExportacao(String diretorioExportacao) {
        this.diretorioExportacao = diretorioExportacao;
    }

    public String getDiretorioImportacao() {
        return this.diretorioImportacao;
    }

    public void setDiretorioImportacao(String diretorioImportacao) {
        this.diretorioImportacao = diretorioImportacao;
    }

    public String getComandoExportacao() {
        return this.comandoExportacao;
    }

    public void setComandoExportacao(String comandoExportacao) {
        this.comandoExportacao = comandoExportacao;
    }

    public String getComandoImportacao() {
        return this.comandoImportacao;
    }

    public void setComandoImportacao(String comandoImportacao) {
        this.comandoImportacao = comandoImportacao;
    }

    public String getVariaveisConfiguracao() {
        return this.variaveisConfiguracao;
    }

    public void setVariaveisConfiguracao(String variaveisConfiguracao) {
        this.variaveisConfiguracao = variaveisConfiguracao;
    }

    public String getXML() {
        try {
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir("interfaceamento");
            xml.escrever("descricao", this.getDescricao());
            xml.abrir("protocolo");
            xml.escrever("protocolo_descricao", this.getProtocolo().getDescricao());
            xml.escrever("protocolo_classe", this.getProtocolo().getClasse());
            xml.fechar("protocolo");
            xml.abrir("filtro");
            if (this.filtroColetas != null && this.filtroColetas.length > 0) {
                xml.escrever("coleta", StringUtil.implode(this.filtroColetas, ","));
            }
            if (this.filtroDestinos != null && this.filtroDestinos.length > 0) {
                xml.escrever("destino", StringUtil.implode(this.filtroDestinos, ","));
            }
            if (this.filtroSituacoesReq != null && this.filtroSituacoesReq.length > 0) {
                xml.escrever("situacaoRequisicao", StringUtil.implode(this.filtroSituacoesReq, ","));
            }
            xml.fechar("filtro");
            if (!Funcoes.textoVazio(this.getPorta())) {
                xml.abrir("porta");
                xml.escrever("endereco", this.getPorta());
                xml.escrever("velocidade", Integer.toString(this.getVelocidade()));
                xml.escrever("dataBits", Integer.toString(this.getDataBits()));
                xml.escrever("stopBits", Integer.toString(this.getStopBits()));
                xml.escrever("paridade", Integer.toString(this.getParidade()));
                xml.escrever("fluxo", Integer.toString(this.getFluxo()));
                xml.fechar("porta");
            } else if (!Funcoes.textoVazio(this.getEnderecoSocket())) {
                xml.abrir("socket");
                xml.escrever("endereco", this.getEnderecoSocket());
                xml.escrever("portaInput", this.getPortaSocketInput());
                xml.escrever("portaInputTriplex", this.getPortaSocketInputTriplex());
                xml.escrever("portaOutput", this.getPortaSocketOutput());
                xml.fechar("socket");
            } else if (!Funcoes.textoVazio(this.getFonteOdbcWorklist())) {
                xml.abrir("odbc");
                xml.escrever("odbcWorklist", this.getFonteOdbcWorklist());
                xml.escrever("odbcResultados", this.getFonteOdbcResultados());
                xml.fechar("odbc");
            } else {
                xml.abrir("arquivo");
                xml.escrever("diretorio_exportacao", this.getDiretorioExportacao());
                xml.escrever("diretorio_importacao", this.getDiretorioImportacao());
                xml.escrever("comando_exportacao", this.getComandoExportacao());
                xml.escrever("comando_importacao", this.getComandoImportacao());
                xml.fechar("arquivo");
            }
            xml.escrever("variaveis_configuracao", this.getVariaveisConfiguracao());
            xml.abrir("equipamentos");
            for (EquipamentoFilial e : this.equipamentos) {
                xml.abrir("equipamento");
                xml.escrever("filial", Integer.toString(e.getFilial()));
                xml.escrever("equipamento_codigo", Integer.toString(e.getEquipamento()));
                xml.escrever("equipamento_descricao", e.getDescricao());
                xml.fechar("equipamento");
            }
            xml.fechar("equipamentos");
            xml.fechar("interfaceamento");
            return xml.getXML();
        }
        catch (XMLStringBuilderException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void carregarXML(String xml) {
        String[] equipamentos;
        String odbc;
        String arquivo;
        String porta;
        String socket;
        this.setDescricao(StringUtil.getValor(xml, "descricao"));
        ProtocoloInterface p = new ProtocoloInterface();
        p.setDescricao(StringUtil.getValor(xml, "protocolo_descricao"));
        p.setClasse(StringUtil.getValor(xml, "protocolo_classe"));
        this.setProtocolo(p);
        String xmlFiltros = StringUtil.getValor(xml, "filtro");
        if (!Funcoes.textoVazio(xmlFiltros)) {
            String filtroSitReqString;
            String filtroDestinosString;
            String filtroColetasString = StringUtil.getValor(xmlFiltros, "coleta");
            if (!Funcoes.textoVazio(filtroColetasString)) {
                this.filtroColetas = filtroColetasString.split(",");
            }
            if (!Funcoes.textoVazio(filtroDestinosString = StringUtil.getValor(xmlFiltros, "destino"))) {
                this.filtroDestinos = filtroDestinosString.split(",");
            }
            if (!Funcoes.textoVazio(filtroSitReqString = StringUtil.getValor(xmlFiltros, "situacaoRequisicao"))) {
                this.filtroSituacoesReq = filtroSitReqString.split(",");
            }
        }
        if (!Funcoes.textoVazio(socket = StringUtil.getValor(xml, "socket"))) {
            this.setEnderecoSocket(StringUtil.getValor(socket, "endereco"));
            this.setPortaSocketInput(StringUtil.getValor(socket, "portaInput"));
            this.setPortaSocketInputTriplex(StringUtil.getValor(socket, "portaInputTriplex"));
            this.setPortaSocketOutput(StringUtil.getValor(socket, "portaOutput"));
        }
        if (!Funcoes.textoVazio(porta = StringUtil.getValor(xml, "porta")) && Funcoes.textoVazio(socket)) {
            this.setPorta(StringUtil.getValor(xml, "endereco"));
            this.setVelocidade(Integer.parseInt(StringUtil.getValor(xml, "velocidade")));
            this.setDataBits(Integer.parseInt(StringUtil.getValor(xml, "dataBits")));
            this.setStopBits(Integer.parseInt(StringUtil.getValor(xml, "stopBits")));
            this.setParidade(Integer.parseInt(StringUtil.getValor(xml, "paridade")));
            this.setFluxo(Integer.parseInt(StringUtil.getValor(xml, "fluxo")));
        }
        if (!Funcoes.textoVazio(arquivo = StringUtil.getValor(xml, "arquivo"))) {
            this.setDiretorioExportacao(StringUtil.getValor(xml, "diretorio_exportacao"));
            this.setDiretorioImportacao(StringUtil.getValor(xml, "diretorio_importacao"));
            this.setComandoExportacao(StringUtil.getValor(xml, "comando_exportacao"));
            this.setComandoImportacao(StringUtil.getValor(xml, "comando_importacao"));
        }
        if (!Funcoes.textoVazio(odbc = StringUtil.getValor(xml, "odbc"))) {
            this.setFonteOdbcResultados(StringUtil.getValor(odbc, "odbcResultados"));
            this.setFonteOdbcWorklist(StringUtil.getValor(odbc, "odbcWorklist"));
        }
        this.setVariaveisConfiguracao(StringUtil.getValor(xml, "variaveis_configuracao"));
        for (String s : equipamentos = StringUtil.getValores(StringUtil.getValor(xml, "equipamentos"), "equipamento")) {
            if (Funcoes.textoVazio(s.trim())) continue;
            EquipamentoFilial e = new EquipamentoFilial();
            e.setFilial(Integer.parseInt(StringUtil.getValor(s, "filial")));
            e.setEquipamento(Integer.parseInt(StringUtil.getValor(s, "equipamento_codigo")));
            e.setDescricao(StringUtil.getValor(s, "equipamento_descricao"));
            e.setPermitirGravarLog(new InterfaceService().interfacePermiteGravarLog(StringUtil.getValor(s, "filial"), StringUtil.getValor(s, "equipamento_codigo")));
            this.addEquipamento(e);
        }
    }

    public void setPortaCOM(AbstractPort portaCOM) {
        this.portaCOM = portaCOM;
    }

    public AbstractPort getPortaCOM() {
        return this.portaCOM;
    }

    public boolean load(int tipo_interfaceamento) {
        try {
            if (tipo_interfaceamento == 0) {
                try {
                    this.portaCOM = new PortaCOM();
                }
                catch (Exception e) {
                    return false;
                }
                ArrayList<String> lista = ((PortaCOM)this.portaCOM).getListaPortasSeriaisDisponiveis();
                if (lista.isEmpty()) {
                    Funcoes.showAlertaOK(null, "Nenhuma porta serial foi encontrada neste computador.");
                    return false;
                }
                if (!lista.contains(this.getPorta())) {
                    Funcoes.showAlertaOK(null, "A porta serial " + this.getPorta() + " n\u00e3o foi encontrada neste computador.");
                    return false;
                }
                this.portaCOM.open(this.getPorta());
                ((PortaCOM)this.portaCOM).setSerialPortParams(this.velocidade, this.dataBits, this.stopBits, this.paridade, this.fluxo);
            } else if (tipo_interfaceamento == 3) {
                this.portaCOM = new PortaSocketServer();
                ((PortaSocketServer)this.portaCOM).open(this.enderecoSocket, Integer.parseInt(this.portaSocketInput), !Funcoes.textoVazio(this.portaSocketInputTriplex) ? Integer.parseInt(this.portaSocketInputTriplex) : 0);
            } else if (tipo_interfaceamento == 8) {
                this.portaCOM = new PortaSocketServerDouble();
                ((PortaSocketServerDouble)this.portaCOM).open(this.enderecoSocket, Integer.parseInt(this.portaSocketInput), Integer.parseInt(this.portaSocketOutput));
            } else if (tipo_interfaceamento == 9) {
                this.portaCOM = new PortaSocketServerTriplex();
                ((PortaSocketServerTriplex)this.portaCOM).open(this.enderecoSocket, Integer.parseInt(this.portaSocketInput), Integer.parseInt(this.portaSocketOutput), !Funcoes.textoVazio(this.portaSocketInputTriplex) ? Integer.parseInt(this.portaSocketInputTriplex) : 0);
            } else if (tipo_interfaceamento == 4 || tipo_interfaceamento == 5) {
                this.portaCOM = new PortaSocketSingle();
                ((PortaSocketSingle)this.portaCOM).open(this.enderecoSocket, Integer.parseInt(this.portaSocketInput));
            } else if (tipo_interfaceamento == 2) {
                this.portaCOM = new PortaSocket();
                ((PortaSocket)this.portaCOM).open(this.enderecoSocket, Integer.parseInt(this.portaSocketOutput), Integer.parseInt(this.portaSocketInput));
            } else {
                this.portaCOM = new PortaFILE();
                this.portaCOM.open(this.getPorta());
            }
            return true;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.toString() + "\nN\u00e3o foi poss\u00edvel carregar configura\u00e7\u00f5es de porta serial!\n" + "Verifique a configura\u00e7\u00e3o.", e.getStackTrace());
            this.portaCOM = null;
            return false;
        }
    }

    public void setInterfaceamentoListener(AbstractInterfaceamentoListener interfaceamentoListener) {
        this.interfaceamentoListener = interfaceamentoListener;
    }

    public AbstractInterfaceamentoListener getInterfacementoListener() {
        return this.interfaceamentoListener;
    }

    public void setFluxoController(FlowController fluxoController) {
        this.fluxoController = fluxoController;
    }

    public FlowController getFluxoController() {
        return this.fluxoController;
    }

    public String[] getFiltroColetas() {
        return this.filtroColetas;
    }

    public void setFiltroColetas(String[] filtroColetas) {
        this.filtroColetas = filtroColetas;
    }

    public String[] getFiltroDestinos() {
        return this.filtroDestinos;
    }

    public void setFiltroDestinos(String[] filtroDestinos) {
        this.filtroDestinos = filtroDestinos;
    }

    public String[] getFiltroSituacoesReq() {
        return this.filtroSituacoesReq;
    }

    public void setFiltroSituacoesReq(String[] filtroSituacoesReq) {
        this.filtroSituacoesReq = filtroSituacoesReq;
    }

    public String getFonteOdbcWorklist() {
        return this.fonteOdbcWorklist;
    }

    public void setFonteOdbcWorklist(String fonteOdbcWorklist) {
        this.fonteOdbcWorklist = fonteOdbcWorklist;
    }

    public String getFonteOdbcResultados() {
        return this.fonteOdbcResultados;
    }

    public void setFonteOdbcResultados(String fonteOdbcResultados) {
        this.fonteOdbcResultados = fonteOdbcResultados;
    }
}

