/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.configuracao;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.configuracao.EquipamentoFilial;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.Rack;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.TabelaModelada;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ConfigRack
extends FrmPadrao {
    JPanel jPanelMain = new JPanel(new BorderLayout());
    JPanel jPanelConfig = new JPanel(new BorderLayout());
    JPanel jPanelFechar = new JPanel(new FlowLayout(2));
    JPanel jPanelCampos = new JPanel(null);
    JPanel jPanelButtons = new JPanel(new FlowLayout(3));
    JTextField jTextFieldValor = new TTextField(5, 3);
    JTextField jTextFieldRack = new TTextField(5, 3);
    JLabel jLabelValor = new JLabel("Valor da rack", 4);
    JLabel jLabelRack = new JLabel("C\u00f3digo da rack", 4);
    JButton jButtonExcluir = new BotaoNavegavel("Excluir", 'X');
    JButton jButtonAdicionar = new BotaoNavegavel("Adicionar", 'A');
    JButton jButtonFechar = new BotaoNavegavel("Fechar", 'F');
    TabelaModelada tabelaRacks = new TabelaModelada(new String[]{"N\u00ba", "Valor"});
    JPanel panel_tabela = new JPanel(null);
    JScrollPane scroll = new JScrollPane(this.tabelaRacks);
    String fil_codigo = Variaveis.filialPadrao;
    JLabel jLabelEquipamento = new JLabel("Equipamento", 4);
    JComboBox jComboEquipamento = new JComboBox();

    public ConfigRack() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        for (ConfiguracaoSerial c : Variaveis.equipamentos) {
            for (EquipamentoFilial e : c.getEquipamentos()) {
                this.jComboEquipamento.addItem(e);
            }
        }
        Funcoes.criaBarraDescricao(this, "Configura\u00e7\u00e3o de Racks", "Configura\u00e7\u00e3o das racks utilizadas pelos equipamentos interfaceados nessa esta\u00e7\u00e3o", "rack_interfac.jpg");
        this.add((Component)this.jPanelMain, "Center");
        this.jPanelMain.add((Component)this.jPanelFechar, "South");
        if (Variaveis.equipamentos != null && Variaveis.equipamentos.size() > 0) {
            this.jTextFieldRack.setEnabled(true);
            this.jTextFieldRack.setEditable(true);
            this.jPanelCampos.setOpaque(true);
            this.jPanelMain.add((Component)this.jPanelConfig, "North");
            this.jPanelMain.add((Component)this.panel_tabela, "Center");
            this.jPanelConfig.add((Component)this.jPanelCampos, "Center");
            this.jPanelConfig.add((Component)this.jPanelButtons, "South");
            this.jPanelCampos.setPreferredSize(new Dimension(453, 80));
            this.jPanelCampos.add((Component)this.jLabelEquipamento, null);
            this.jPanelCampos.add((Component)this.jComboEquipamento, null);
            this.jPanelCampos.add((Component)this.jTextFieldValor, null);
            this.jPanelCampos.add((Component)this.jTextFieldRack, null);
            this.jPanelCampos.add((Component)this.jLabelValor, null);
            this.jPanelCampos.add((Component)this.jLabelRack, null);
            this.jPanelButtons.setPreferredSize(new Dimension(322, 37));
            this.jPanelButtons.add((Component)this.jButtonAdicionar, null);
            this.jPanelButtons.add((Component)this.jButtonExcluir, null);
            this.jPanelFechar.setPreferredSize(new Dimension(78, 35));
            this.jLabelEquipamento.setBounds(new Rectangle(5, 10, 120, 15));
            this.jLabelEquipamento.setDisplayedMnemonic('C');
            this.jLabelEquipamento.setLabelFor(this.jTextFieldRack);
            this.jLabelRack.setBounds(new Rectangle(5, 33, 120, 15));
            this.jLabelRack.setDisplayedMnemonic('C');
            this.jLabelRack.setLabelFor(this.jTextFieldRack);
            this.jLabelValor.setBounds(new Rectangle(5, 56, 120, 15));
            this.jLabelValor.setDisplayedMnemonic('V');
            this.jLabelValor.setLabelFor(this.jTextFieldValor);
            this.jComboEquipamento.setBounds(new Rectangle(129, 7, 250, 20));
            this.jTextFieldRack.setDisabledTextColor(Color.black);
            this.jTextFieldRack.setBounds(new Rectangle(129, 31, 50, 20));
            this.jTextFieldValor.setPreferredSize(new Dimension(200, 20));
            this.jTextFieldValor.setDisabledTextColor(Color.black);
            this.jTextFieldValor.setBounds(new Rectangle(129, 55, 50, 20));
            this.jComboEquipamento.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigRack.this.loadBDValues();
                }
            });
            this.jButtonExcluir.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigRack.this.jButtonExcluir_actionPerformed(e);
                }
            });
            this.jButtonAdicionar.removeKeyListener(this.jButtonAdicionar.getKeyListeners()[1]);
            this.jButtonAdicionar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigRack.this.jButtonAdicionar_actionPerformed(e);
                }
            });
            this.panel_tabela.add(this.scroll);
            this.scroll.setBounds(5, 5, 175, 300);
            this.scroll.getViewport().setBackground(Color.lightGray);
            this.scroll.setPreferredSize(new Dimension(453, 300));
            this.tableInit();
            this.loadBDValues();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConfigRack.this.jTextFieldRack.grabFocus();
                }
            });
        } else {
            JLabel msg = new JLabel("Nenhum interfaceamento carregado no momento.", 0);
            this.jPanelMain.add((Component)msg, "Center");
        }
        this.jPanelFechar.add(this.jButtonFechar);
        this.jButtonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigRack.this.setVisible(false);
            }
        });
    }

    public void tableInit() {
        this.tabelaRacks.forceSize(0, 75);
        this.tabelaRacks.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    ConfigRack.this.jButtonExcluir.doClick();
                } else if (e.getKeyChar() == '\n') {
                    e.consume();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                }
            }
        });
    }

    public void loadBDValues() {
        try {
            Statement st = Conexao.getStatement();
            EquipamentoFilial e = (EquipamentoFilial)this.jComboEquipamento.getSelectedItem();
            ArrayList<Rack> racks = BDUtil.getRackList(this.fil_codigo, e.getEquipamento().toString());
            ArrayList<Object[]> dados = new ArrayList<Object[]>();
            for (Rack rack : racks) {
                Object[] linha = new Object[]{rack.getCodigo(), rack.getValor()};
                dados.add(linha);
            }
            this.tabelaRacks.setData(dados);
            this.tabelaRacks.grabFocus();
        }
        catch (Exception ex1) {
            ex1.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex1.getMessage(), ex1.getStackTrace());
        }
    }

    private String checkFields(String rack_number) {
        String error = "";
        if (!rack_number.equals("")) {
            int rows = this.tabelaRacks.getRowCount();
            for (int i = 0; i < rows; ++i) {
                if (!((String)this.tabelaRacks.getValueAt(i, 0)).equals(rack_number)) continue;
                error = "A rack n\u00ba " + rack_number + " j\u00e1 est\u00e1 cadastrada.";
                break;
            }
        } else {
            error = "A rack a ser cadastrada deve possuir um n\u00famero.";
        }
        return error;
    }

    void jButtonAdicionar_actionPerformed(ActionEvent e) {
        String error = this.checkFields(this.jTextFieldRack.getText());
        if (!error.equals("")) {
            Funcoes.showErro(Laboratorio.getInstancia(), error);
        } else {
            try {
                Statement st = Conexao.getStatement();
                String rack = this.jTextFieldRack.getText();
                String valor = this.jTextFieldValor.getText();
                if (rack != null && !rack.equals("") && valor != null && !valor.equals("")) {
                    EquipamentoFilial equip = (EquipamentoFilial)this.jComboEquipamento.getSelectedItem();
                    BDUtil.insertRack(st, this.fil_codigo, equip.getEquipamento().toString(), rack, valor);
                    this.tabelaRacks.addSortedRow(new Object[]{this.jTextFieldRack.getText(), this.jTextFieldValor.getText()});
                    this.jTextFieldValor.setText("");
                    this.jTextFieldRack.setText("");
                    Conexao.arquivaSQL();
                } else {
                    Funcoes.showAlertaOK(null, "Nenhum campo pode ser vazio");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfigRack.this.jTextFieldRack.grabFocus();
            }
        });
    }

    void jButtonExcluir_actionPerformed(ActionEvent e) {
        if (this.tabelaRacks.getSelectedRow() >= 0) {
            int row = this.tabelaRacks.getSelectedRow();
            String rack_number = (String)this.tabelaRacks.getValueAt(row, 0);
            int answer = Funcoes.showPerguntaSimNao(Laboratorio.getInstancia(), "Excluir Cadastro de Rack", "Tem certeza que deseja excluir a rack n\u00famero " + rack_number + "?");
            if (answer == 0) {
                try {
                    Statement st = Conexao.getStatement();
                    EquipamentoFilial equip = (EquipamentoFilial)this.jComboEquipamento.getSelectedItem();
                    BDUtil.deleteRack(st, this.fil_codigo, equip.getEquipamento().toString(), (String)this.tabelaRacks.getValueAt(row, 0));
                    this.tabelaRacks.deleteRow(row);
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1010060004");
    }
}

