/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.configuracao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.configurador.DialogoConfigurador;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.configuracao.DadosModelos;
import jalis.laboratorio.interfaceamento.configuracao.EquipamentoFilial;
import jalis.laboratorio.interfaceamento.configuracao.TrocaEquipamento;
import jalis.laboratorio.interfaceamento.exames.RelacionamentoCampos;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.util.CodString;
import jalis.util.DBUtil;
import jalis.util.DialogUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import jalis.util.tabela.TabelaModelada;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class ConfigLayout
extends FrmPadrao
implements ActionListener {
    private static final int FIL_CODIGO = 0;
    private static final int EXM_CODIGO = 1;
    private static final int EXM_DESCRICAO = 2;
    private static final int EXM_MATERIAL = 3;
    private static final int EXM_MATCODIGO = 4;
    private static final int EXM_MODELOS = 5;
    private static final int INT_CODIGO = 6;
    private static final int EXM_COLUNAS = 7;
    private static final int MOD_CODIGO = 0;
    private static final int MOD_NOME = 1;
    private static final int MOD_IDADEMIN = 2;
    private static final int MOD_IDADEMINTIPO = 3;
    private static final int MOD_IDADEMAX = 4;
    private static final int MOD_IDADEMAXTIPO = 5;
    private static final int MOD_METODO = 6;
    private static final int MOD_METCODIGO = 7;
    private static final int MOD_ELMFORMATO = 8;
    private static final int MOD_ELAPADRAO = 9;
    private static final int MOD_COLUNAS = 10;
    private final String AGRUPAR_POR_FILIAL = "relacionamentocampos.agruparporfilial";
    JPanel jPanelMain = new JPanel(new BorderLayout());
    JPanel jPanelExames = new JPanel(new BorderLayout());
    JPanel jPanelModelos = new JPanel(new BorderLayout());
    JPanel jPanelButtonsRight = new JPanel(new FlowLayout(2));
    JPanel jPanelButtonsLeft = new JPanel(new FlowLayout(0));
    TabelaModelada tabela_exames = new TabelaModelada(new String[]{"F", "C\u00f3digo", "Descri\u00e7\u00e3o", "Mat"});
    TabelaModelada tabela_modelos = new TabelaModelada(new String[]{"C\u00f3digo", "Nome", "Idade M\u00edn", "Tipo", "Idade M\u00e1x", "Tipo", "M\u00e9todo"});
    JScrollPane scroll_exames = new JScrollPane(this.tabela_exames);
    JScrollPane scroll_modelos = new JScrollPane(this.tabela_modelos);
    JButton jButtonConfigurar = new BotaoNavegavel("Configurar", 'C');
    JButton jButtonFechar = new BotaoNavegavel("Fechar", 'F');
    JPanel panelEquipamento = new JPanel(new FlowLayout(0));
    JComboBox comboEquipamento;
    JButton jButtonTrocarEquipamento = new BotaoNavegavel("Trocar Aparelho", 'T');
    JCheckBox checkAgruparFiliais = ComponenteFactory.novoJCheckBox("Agrupar filiais", this);
    JComboBox comboModelos = ComponenteFactory.novoJComboBox(this);

    public ConfigLayout() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.jbInit();
            this.loadExames();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            ScreenUtil.requisitarFoco(this.tabela_exames);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Relacionamento de campos", "Relacionamento de campos do interfaceamento aos campos do modelo espec\u00edfico.", "interface/inter_relacionamento.jpg");
        this.add((Component)ComponenteFactory.novoJPanelBorderLayout(null, null, null, this.jPanelButtonsRight, this.jPanelButtonsLeft), "South");
        this.add((Component)this.jPanelMain, "Center");
        if (Variaveis.equipamentos == null || Variaveis.equipamentos.size() == 0) {
            Statement st = Conexao.getStatement();
            this.panelEquipamento.add(new JLabel("Equipamento"));
            this.comboEquipamento = ComponenteFactory.novoJComboBox(BDUtil.getInterfaces(Variaveis.filialPadrao));
            this.panelEquipamento.add(this.comboEquipamento);
            this.jPanelMain.add((Component)this.panelEquipamento, "North");
            this.comboEquipamento.addActionListener(this);
        }
        this.checkAgruparFiliais.setSelected(ParametrosUsuarios.contemParametro("relacionamentocampos.agruparporfilial") && ParametrosUsuarios.getValor("relacionamentocampos.agruparporfilial").equals("1"));
        JPanel panelCombo = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelCombo.add((Component)new JLabel("Filtrar modelo:"), c);
        c.weightx = 1.0;
        ++c.gridx;
        c.insets.bottom = 1;
        c.fill = 2;
        panelCombo.add((Component)this.comboModelos, c);
        this.jPanelMain.add((Component)this.jPanelExames, "West");
        this.jPanelMain.add((Component)this.jPanelModelos, "Center");
        this.jPanelExames.setBorder(ComponenteFactory.novoTitledEtchedBorder("Exames"));
        this.jPanelExames.setPreferredSize(new Dimension(250, 380));
        this.jPanelModelos.setBorder(ComponenteFactory.novoTitledEtchedBorder("Modelos"));
        this.jPanelExames.add((Component)this.scroll_exames, "Center");
        this.jPanelModelos.add((Component)panelCombo, "North");
        this.jPanelModelos.add((Component)this.scroll_modelos, "Center");
        if (Acesso.getAcesso(Long.parseLong("1010060005"))) {
            this.jPanelExames.add((Component)this.jButtonTrocarEquipamento, "South");
        }
        this.tabela_exames.forceSize(0, 20);
        this.tabela_exames.forceSize(1, 50);
        this.tabela_exames.forceSize(3, 40);
        this.tabela_modelos.forceSize(0, 50);
        this.tabela_modelos.forceSize(2, 70);
        this.tabela_modelos.forceSize(3, 50);
        this.tabela_modelos.forceSize(4, 70);
        this.tabela_modelos.forceSize(5, 50);
        this.tabela_modelos.setDefaultRenderer(Object.class, new RendererModelos());
        this.jPanelButtonsRight.add(this.jButtonConfigurar);
        this.jPanelButtonsRight.add(this.jButtonFechar);
        this.jPanelButtonsLeft.add(this.checkAgruparFiliais);
        this.tabela_exames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 39) {
                    ConfigLayout.this.tabela_modelos.grabFocus();
                }
                if (e.getKeyChar() == '\n') {
                    e.consume();
                }
            }
        });
        this.tabela_modelos.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                ConfigLayout.this.modelosKeyPressed(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 37) {
                    ConfigLayout.this.tabela_exames.grabFocus();
                }
                if (e.getKeyChar() == '\n') {
                    e.consume();
                }
            }
        });
        this.tabela_modelos.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (e.getButton() == 1) {
                        ConfigLayout.this.abrirConfigurador();
                    }
                }
            }
        });
        this.tabela_exames.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row;
                if (!e.getValueIsAdjusting() && (row = ConfigLayout.this.tabela_exames.getSelectedRow()) >= 0 && row < ConfigLayout.this.tabela_exames.getRowCount()) {
                    ConfigLayout.this.showModelos(row, true, -1);
                }
            }
        });
        this.jButtonConfigurar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigLayout.this.abrirConfigurador();
            }
        });
        this.jButtonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigLayout.this.setVisible(false);
            }
        });
        this.jButtonTrocarEquipamento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigLayout.this.trocaEquipamento();
            }
        });
    }

    private void loadExames() {
        try {
            ArrayList<Object[]> exames = new ArrayList<Object[]>();
            Statement s = Conexao.getStatement();
            StringBuilder query = new StringBuilder();
            query.append("select ");
            if (this.checkAgruparFiliais.isSelected()) {
                query.append(" distinct ").append(StringUtil.textoDBEscape(Variaveis.filialPadrao)).append("::int as fil_codigo,");
            } else {
                query.append("a.fil_codigo,");
            }
            query.append("a.exa_codigo, a.mco_codigo, a.int_codigo, b.exa_descricao, ");
            query.append("c.mco_abreviatura, a.int_codigo, f.fil_tipobase ");
            query.append("from examematinterface a ");
            query.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
            query.append("left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo ");
            query.append("join filiais_postocoleta f on a.fil_codigo = f.fil_codigo ");
            query.append("where ");
            if (Variaveis.equipamentos == null || Variaveis.equipamentos.size() == 0) {
                query.append(" a.fil_codigo = ").append(Variaveis.filialPadrao);
                CodString e = (CodString)this.comboEquipamento.getSelectedItem();
                query.append(" and a.int_codigo = ").append(e.getCodigo());
            } else {
                query.append(BDUtil.montaSQLEquipamentoFilial());
            }
            query.append(" and emi_padrao = true order by exa_codigo, mco_codigo, fil_codigo ");
            ResultSet rs = Conexao.executeQuery(s, query.toString());
            while (rs != null && rs.next()) {
                Object[] linha = new Object[7];
                linha[0] = rs.getString("fil_codigo");
                linha[1] = rs.getString("exa_codigo");
                linha[4] = rs.getString("mco_codigo");
                linha[2] = rs.getString("exa_descricao");
                linha[3] = rs.getString("mco_abreviatura");
                linha[5] = this.loadModelos((String)linha[0], (String)linha[1], (String)linha[4]);
                linha[6] = rs.getString("int_codigo");
                exames.add(linha);
            }
            this.tabela_exames.setData(exames);
            if (exames.size() > 0) {
                this.tabela_exames.selectRow(0);
            }
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar exames.", ex.getStackTrace());
        }
    }

    private ArrayList loadModelos(String fil_codigo, String exa_codigo, String mco_codigo) {
        try {
            Statement s = Conexao.getStatement();
            StringBuilder query = new StringBuilder();
            query.append("select a.lay_codigo, a.lay_descricao, b.ela_idadefim, b.ela_idadeini, ");
            query.append("b.ela_idadefimtipo, b.ela_idadeinitipo, b.ela_padrao, c.met_codigo, ");
            query.append("c.elm_formato, d.met_descricao ");
            query.append("from layout a ");
            query.append("left join examelayout b on a.lay_codigo = b.lay_codigo and a.fil_codigo = b.fil_codigo ");
            query.append("left join examelayoutmetodo c on a.lay_codigo = c.lay_codigo and a.fil_codigo = c.fil_codigo ");
            query.append(" and b.exa_codigo = c.exa_codigo and b.mco_codigo = c.mco_codigo ");
            query.append(" and b.ela_idadeini = c.ela_idadeini and b.ela_idadefim = c.ela_idadefim ");
            query.append(" and b.ela_idadeinitipo = c.ela_idadeinitipo and b.ela_idadefimtipo = c.ela_idadefimtipo ");
            query.append("left join metodologia d on a.fil_codigo = d.fil_codigo and c.met_codigo = d.met_codigo ");
            query.append("where a.fil_codigo = ");
            query.append(fil_codigo);
            query.append(" and b.exa_codigo = '");
            query.append(exa_codigo);
            query.append("' and b.mco_codigo = ");
            query.append(mco_codigo);
            query.append(" order by b.mco_codigo, b.ela_idadeini, c.met_codigo");
            ResultSet rs = Conexao.executeQuery(s, query.toString());
            ArrayList<Object[]> modelos = new ArrayList<Object[]>();
            while (rs != null && rs.next()) {
                Object[] linha = new Object[10];
                linha[0] = rs.getString("lay_codigo");
                linha[1] = rs.getString("lay_descricao");
                linha[2] = rs.getString("ela_idadeini");
                linha[3] = Tipos.tipoIdade(rs.getString("ela_idadeinitipo"));
                linha[4] = rs.getString("ela_idadefim");
                linha[5] = Tipos.tipoIdade(rs.getString("ela_idadefimtipo"));
                linha[8] = rs.getString("elm_formato");
                linha[6] = rs.getString("met_descricao");
                linha[7] = rs.getString("met_codigo");
                linha[9] = rs.getString("ela_padrao");
                modelos.add(linha);
            }
            return modelos;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar layouts.", ex.getStackTrace());
            return new ArrayList();
        }
    }

    private void showModelos(int row, boolean recarregarCombo, int modeloSelecionado) {
        if (row < -1 || row > this.tabela_exames.getRowCount()) {
            Funcoes.mensagem(this, "Menhum exame selecionado", 5);
            return;
        }
        ArrayList modelos = (ArrayList)this.tabela_exames.getValueAt(row, 5);
        if (modeloSelecionado > -1) {
            ArrayList o = new ArrayList();
            modelos.forEach(v -> {
                String tmp;
                String string = tmp = v[0] != null ? (String)v[0] : "";
                if (Funcoes.isNumeric(tmp) && Integer.parseInt(tmp) == modeloSelecionado) {
                    o.add(v);
                }
            });
            this.tabela_modelos.setData(o);
        } else {
            this.tabela_modelos.setData(modelos);
        }
        if (this.tabela_modelos.getRowCount() > 0) {
            this.tabela_modelos.selectRow(0);
        }
        if (recarregarCombo) {
            ArrayList<DadosModelos> lista = new ArrayList<DadosModelos>();
            if (null != modelos && modelos.size() > 0) {
                for (Object[] o : modelos) {
                    DadosModelos tmp;
                    String codigo = (String)o[0];
                    String descricao = (String)o[1];
                    if (!Funcoes.isNumeric(codigo) || Funcoes.textoVazio(descricao) || lista.contains(tmp = new DadosModelos(Integer.parseInt(codigo), descricao))) continue;
                    lista.add(tmp);
                }
            }
            this.comboModelos.removeAllItems();
            this.comboModelos.addItem(new DadosModelos(-1, "Todos"));
            for (DadosModelos d : lista) {
                this.comboModelos.addItem(d);
            }
        }
    }

    private void modelosKeyPressed(KeyEvent e) {
        block3: {
            block2: {
                char c = e.getKeyChar();
                if (c == ' ') break block2;
                if (c != '\n') break block3;
            }
            this.abrirConfigurador();
            e.consume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abrirConfigurador() {
        try {
            int row_exa = this.tabela_exames.getSelectedRow();
            Statement st = Conexao.getStatement();
            if (row_exa >= 0) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                String fil_codigo = (String)this.tabela_exames.getValueAt(row_exa, 0);
                String exa_codigo = (String)this.tabela_exames.getValueAt(row_exa, 1);
                String mco_codigo = (String)this.tabela_exames.getValueAt(row_exa, 4);
                String int_codigo = (String)this.tabela_exames.getValueAt(row_exa, 6);
                int row_mod = this.tabela_modelos.getSelectedRow();
                if (row_mod >= 0) {
                    String lay_codigo = (String)this.tabela_modelos.getValueAt(row_mod, 0);
                    String ela_idadeini = (String)this.tabela_modelos.getValueAt(row_mod, 2);
                    String ela_idadefim = (String)this.tabela_modelos.getValueAt(row_mod, 4);
                    String ela_idadeinitipo = ((String)this.tabela_modelos.getValueAt(row_mod, 3)).substring(0, 1).toUpperCase();
                    String ela_idadefimtipo = ((String)this.tabela_modelos.getValueAt(row_mod, 5)).substring(0, 1).toUpperCase();
                    String met_codigo = (String)this.tabela_modelos.getValueAt(row_mod, 7);
                    String exa_descricao = BDUtil.getExmDescricao(fil_codigo, exa_codigo);
                    DialogoConfigurador dlg = new DialogoConfigurador((Frame)Laboratorio.getInstancia(), "", true, false);
                    dlg.setTipoConfiguracao(0);
                    dlg.setTitle("Relacionamento de campos [" + exa_codigo + "] " + exa_descricao);
                    dlg.setAtributosDaPagina(ExameUtil.getCabecalhoRodape(fil_codigo, String.valueOf(ParametrosGerais.getLayCodigo())));
                    dlg.setAtributos((String)this.tabela_modelos.getValueAt(row_mod, 8));
                    dlg.setCamposBanco(Impressao.CAMPOS_EXAME);
                    dlg.setInterfaceRelacionamento(RelacionamentoCampos.getInstancia(this, fil_codigo, exa_codigo, mco_codigo, int_codigo));
                    dlg.setPreferredSize(dlg.getSize());
                    this.setCursor(Cursor.getDefaultCursor());
                    DialogUtil.centerAndShow(dlg, true, false);
                    if (dlg.ok()) {
                        this.salvaFormatoLayout(dlg.getAtributos(), fil_codigo, exa_codigo, mco_codigo, lay_codigo, ela_idadeini, ela_idadefim, ela_idadeinitipo, ela_idadefimtipo, met_codigo);
                    }
                    this.tabela_exames.selectRow(row_exa);
                    if (this.tabela_modelos.getRowCount() <= row_mod) {
                        this.tabela_modelos.selectRow(row_mod);
                    }
                    this.tabela_modelos.grabFocus();
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void salvaFormatoLayout(String atributos, String fil_codigo, String exa_codigo, String mco_codigo, String lay_codigo, String ela_idadeini, String ela_idadefim, String ela_idadeinitipo, String ela_idadefimtipo, String met_codigo) {
        try {
            Statement s = Conexao.getStatement();
            SalvaDados salvar = new SalvaDados("examelayoutmetodo", 2);
            salvar.adicionaCampo("fil_codigo", 2, false, true, fil_codigo);
            salvar.adicionaCampo("exa_codigo", 0, false, true, exa_codigo);
            salvar.adicionaCampo("lay_codigo", 2, false, true, lay_codigo);
            salvar.adicionaCampo("mco_codigo", 2, false, true, mco_codigo);
            salvar.adicionaCampo("ela_idadeini", 2, false, true, ela_idadeini);
            salvar.adicionaCampo("ela_idadefim", 2, false, true, ela_idadefim);
            salvar.adicionaCampo("ela_idadeinitipo", 0, false, true, ela_idadeinitipo);
            salvar.adicionaCampo("ela_idadefimtipo", 0, false, true, ela_idadefimtipo);
            salvar.adicionaCampo("met_codigo", 2, false, true, met_codigo);
            salvar.adicionaCampo("elm_formato", 0, true, false, StringUtil.textoDB(atributos));
            DBUtil.gravaAutoCopia(s, salvar, "fil_codigo", ParametrosGerais.getCopiaExame());
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel atualizar o layout.\n" + ex.getMessage(), ex.getStackTrace(), "ConfigLayout (433)");
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1010060003");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.comboEquipamento) {
            while (this.tabela_modelos.getRowCount() > 0) {
                this.tabela_modelos.deleteRow(0);
            }
            this.loadExames();
        } else if (e.getSource() == this.comboModelos) {
            this.carregarModeloSelecionado();
        } else if (e.getSource() == this.checkAgruparFiliais) {
            this.agruparFiliais();
        }
    }

    private void agruparFiliais() {
        ParametrosUsuarios.setValor("relacionamentocampos.agruparporfilial", this.checkAgruparFiliais.isSelected() ? "1" : "0");
        this.tabela_modelos.setData(new ArrayList());
        this.loadExames();
    }

    private void carregarModeloSelecionado() {
        DadosModelos selecionado;
        if (null != this.comboModelos.getSelectedItem() && null != (selecionado = (DadosModelos)this.comboModelos.getSelectedItem())) {
            this.showModelos(this.tabela_exames.getSelectedRow(), false, selecionado.codigo);
        }
    }

    private void trocaEquipamento() {
        ArrayList<EquipamentoFilial> equipamentos = new ArrayList<EquipamentoFilial>();
        if (Variaveis.equipamentos == null || Variaveis.equipamentos.size() == 0) {
            EquipamentoFilial e = new EquipamentoFilial();
            CodString equip = (CodString)this.comboEquipamento.getSelectedItem();
            e.setFilial(Integer.parseInt(Variaveis.filialPadrao));
            e.setEquipamento(equip.getCodigo());
            e.setDescricao(equip.getString());
            equipamentos.add(e);
        } else {
            for (ConfiguracaoSerial c : Variaveis.equipamentos) {
                for (EquipamentoFilial e : c.getEquipamentos()) {
                    equipamentos.add(e);
                }
            }
        }
        TrocaEquipamento tela = new TrocaEquipamento(Laboratorio.getInstancia(), equipamentos);
        tela.setVisible(true);
        while (this.tabela_modelos.getRowCount() > 0) {
            this.tabela_modelos.deleteRow(0);
        }
        this.loadExames();
    }

    class RendererModelos
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            Color cor = UIManager.getColor("Table.selectionBackground");
            JLabel label = new JLabel();
            label.setOpaque(true);
            label.setFont(table.getFont());
            label.setText((String)value);
            if (ConfigLayout.this.tabela_modelos.getValueAt(row, 9).equals("t")) {
                if (selected) {
                    label.setBackground(Color.gray);
                } else {
                    label.setBackground(Color.lightGray);
                }
            } else if (selected) {
                label.setBackground(cor);
            } else {
                label.setBackground(Color.white);
            }
            return label;
        }
    }
}

