/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.configuracao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoFactory;
import jalis.laboratorio.interfaceamento.InterfaceamentoConfiguracao;
import jalis.laboratorio.interfaceamento.comunicacao.PortaCOM;
import jalis.laboratorio.interfaceamento.configuracao.CommunicationTest;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.configuracao.DialogFiltro;
import jalis.laboratorio.interfaceamento.configuracao.EquipamentoFilial;
import jalis.laboratorio.interfaceamento.configuracao.JCheckVariavel;
import jalis.laboratorio.interfaceamento.configuracao.ProtocoloInterface;
import jalis.laboratorio.interfaceamento.configuracao.TelaAjuda;
import jalis.laboratorio.interfaceamento.interfaces.sysmexuf1000i.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.CodString;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class ConfigEquipamento
extends FrmPadrao
implements ActionListener {
    private JPanel panelCenter = new JPanel(null);
    private JPanel panelButtons = new JPanel(new FlowLayout(2));
    private JPanel panelPorta = ComponenteFactory.novoJPanel(new GridBagLayout(), ComponenteFactory.novoTitledEtchedBorder("Op\u00e7\u00f5es Porta"));
    private JScrollPane scrolOpcoes = new JScrollPane();
    private JPanel panelOpcoes = new JPanel(new BorderLayout());
    private JLabel labelProtocolo = new JLabel("Protocolo");
    private JComboBox comboProtocolo = new JComboBox();
    private JLabel labelPorta = new JLabel("Porta");
    private JComboBox comboPorta = new JComboBox();
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o");
    private TTextField textDescricao = ComponenteFactory.novoTTextField(50, 3);
    private JLabel labelFilial = new JLabel("Filial");
    private JComboBox comboFilial = new JComboBox();
    private DefaultListModel modeloEquipamentos = new DefaultListModel();
    private JList listEquipamentos = ComponenteFactory.novoJList(this.modeloEquipamentos, null, null, null);
    private JScrollPane scrollEquipamentos = new JScrollPane(this.listEquipamentos);
    private JButton buttonAdicionar = ComponenteFactory.novoJButton(">", 'A', this);
    private JButton buttonRemover = ComponenteFactory.novoJButton("<", 'R', this);
    private DefaultListModel modeloSelecionados = new DefaultListModel();
    private JList listSelecionados = ComponenteFactory.novoJList(this.modeloSelecionados, null, null, null);
    private JScrollPane scrollSelecionados = new JScrollPane(this.listSelecionados);
    private JLabel labelVelocidade = new JLabel("Velocidade");
    private JComboBox comboVelocidade = new JComboBox();
    private JLabel labelDataBits = new JLabel("Bits de Dados");
    private JComboBox comboDataBits = new JComboBox();
    private JLabel labelStopBits = new JLabel("Bits de Parada");
    private JComboBox comboStopBits = new JComboBox();
    private JLabel labelParidade = new JLabel("Paridade");
    private JComboBox comboParidade = new JComboBox();
    private JLabel labelFluxo = new JLabel("Fluxo");
    private JComboBox comboFluxo = new JComboBox();
    private JButton buttonLoopback = ComponenteFactory.novoJButton("Testar Loopback", 'L', this);
    private JButton buttonDefault = ComponenteFactory.novoJButton("Carregar Padr\u00e3o", 'D', this);
    private JButton buttonTest = ComponenteFactory.novoJButton("Testar Comunica\u00e7\u00e3o", 'T', this);
    private JLabel labelDirExportacao = new JLabel("Dir. Exporta\u00e7\u00e3o");
    private TTextField textDirExportacao = ComponenteFactory.novoTTextField(300, 3);
    private JButton buttonDirExportacao = ComponenteFactory.novoJButton("...", 'E', this);
    private JLabel labelDirImportacao = new JLabel("Dir. Importa\u00e7\u00e3o");
    private TTextField textDirImportacao = ComponenteFactory.novoTTextField(300, 3);
    private JButton buttonDirImportacao = ComponenteFactory.novoJButton("...", 'I', this);
    private JLabel labelComandoExportacao = new JLabel("Cmd. Exporta\u00e7\u00e3o");
    private TTextField textComandoExportacao = ComponenteFactory.novoTTextField(300, 3);
    private JButton buttonComandoExportacao = ComponenteFactory.novoJButton("...", 'P', this);
    private JLabel labelComandoImportacao = new JLabel("Cmd. Importa\u00e7\u00e3o");
    private TTextField textComandoImportacao = ComponenteFactory.novoTTextField(300, 3);
    private JButton buttonComandoImportacao = ComponenteFactory.novoJButton("...", 'Q', this);
    private TTextField textDirImportacaoImagem;
    private JLabel labelEnderecoSocket;
    private TTextField textEnderecoSocket;
    private JLabel labelPortaSocketOutput;
    private TTextField textPortaSocketOutput;
    private JLabel labelPortaSocketInput;
    private TTextField textPortaSocketInput;
    private JLabel labelPortaSocketInputTriplex;
    private TTextField textPortaSocketInputTriplex;
    private JLabel labelFonteOdbcWorklist;
    private TTextField textFonteOdbcWorklist;
    private JLabel labelFonteOdbcResultados;
    private TTextField textFonteOdbcResultados;
    private JLabel labelVariaveis;
    private JTextArea textVariaveis;
    private JScrollPane scrollVariaveis;
    private JButton buttonFechar;
    private JButton buttonSalvar;
    private JButton buttonNovo;
    private JButton buttonLimpar;
    private JButton buttonApagar;
    private JButton buttonAjuda;
    private JButton buttonFiltro;
    private String[] filtroColetas;
    private String[] filtroDestinos;
    private String[] filtroSituacoesReq;
    private ArrayList<ProtocoloInterface> protocolos;
    private ArrayList<ConfiguracaoSerial> configuracoes;
    private InterfaceamentoConfiguracao configuracao;
    private ProtocoloInterface protocolo;
    private AbstractInterfaceamentoFactory abf;

    public ConfigEquipamento() {
        new ComponenteFactory();
        this.textDirImportacaoImagem = ComponenteFactory.novoTTextField(10000, 3);
        this.labelEnderecoSocket = new JLabel("Endere\u00e7o");
        this.textEnderecoSocket = ComponenteFactory.novoTTextField(15, 3);
        this.labelPortaSocketOutput = new JLabel("Porta Output");
        this.textPortaSocketOutput = ComponenteFactory.novoTTextField(5, 1);
        this.labelPortaSocketInput = new JLabel("Porta Input");
        this.textPortaSocketInput = ComponenteFactory.novoTTextField(5, 1);
        this.labelPortaSocketInputTriplex = new JLabel("Porta Input Auxiliar");
        this.textPortaSocketInputTriplex = ComponenteFactory.novoTTextField(5, 1);
        this.labelFonteOdbcWorklist = new JLabel("Odbc WorkList");
        this.textFonteOdbcWorklist = ComponenteFactory.novoTTextField(105, 3);
        this.labelFonteOdbcResultados = new JLabel("Odbc Resultados");
        this.textFonteOdbcResultados = ComponenteFactory.novoTTextField(105, 3);
        this.labelVariaveis = new JLabel("Vari\u00e1veis");
        this.textVariaveis = new JTextArea();
        this.scrollVariaveis = new JScrollPane(this.textVariaveis);
        this.buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
        this.buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this);
        this.buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
        this.buttonLimpar = ComponenteFactory.novoJButton("Limpar", 'i', this);
        this.buttonApagar = ComponenteFactory.novoJButton("Remover Configuracao", 'R', this);
        this.buttonAjuda = ComponenteFactory.novoJButton("Ajuda", 'A', this);
        this.buttonFiltro = ComponenteFactory.novoJButton("Filtro Requisi\u00e7\u00f5es", 'l', this);
        this.protocolos = new ArrayList();
        this.configuracoes = new ArrayList();
        try {
            this.jbInit();
            this.loadDisponiveis();
            this.loadParametros();
            this.comboFilial.addActionListener(this);
            this.comboProtocolo.addActionListener(this);
            this.comboPorta.addActionListener(this);
            if (this.configuracoes.size() > 0) {
                this.comboProtocolo.setSelectedItem(this.configuracoes.get(0).getProtocolo());
            }
            this.carregaEquipamentosFilial();
            this.carregaProcolo();
            if (this.configuracoes.size() > 0) {
                this.filtroColetas = this.configuracoes.get(0).getFiltroColetas();
                this.filtroDestinos = this.configuracoes.get(0).getFiltroDestinos();
                this.filtroSituacoesReq = this.configuracoes.get(0).getFiltroSituacoesReq();
            }
            if (this.abf.getTipoComunicacao() == 0) {
                this.carregaDadosPorta(this.comboPorta.getSelectedItem().toString());
            } else if (this.abf.getTipoComunicacao() == 1) {
                this.carregaDadosArquivo();
            } else if (this.abf.getTipoComunicacao() == 2) {
                this.carregaDadosSocket();
            } else if (this.abf.getTipoComunicacao() == 3) {
                this.carregaDadosSocket();
            } else if (this.abf.getTipoComunicacao() == 4) {
                this.carregaDadosSocket();
            } else if (this.abf.getTipoComunicacao() == 8) {
                this.carregaDadosSocket();
            } else if (this.abf.getTipoComunicacao() == 9) {
                this.carregaDadosSocket();
            } else if (this.abf.getTipoComunicacao() == 6) {
                this.carregaDadosOdbc();
            } else if (this.abf.getTipoComunicacao() == 7) {
                this.carregaDadosManual();
            }
            this.montaPanelVariaveis();
            if (Variaveis.equip != null) {
                this.buttonSalvar.setEnabled(false);
                this.buttonNovo.setEnabled(false);
                this.buttonLimpar.setEnabled(false);
                this.buttonApagar.setEnabled(false);
                this.buttonAjuda.setEnabled(false);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ConfigEquipamento (137)");
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Configura\u00e7\u00e3o de Equipamento", "Configura\u00e7\u00e3o do protocolo de comunica\u00e7\u00e3o e interfaceamento do equipamento configurado", "interface/config_interface.jpg");
        JPanel panelCenter = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        panelCenter.add((Component)this.labelProtocolo, c);
        ++c.gridx;
        this.comboProtocolo.setPreferredSize(new Dimension(250, 20));
        this.comboProtocolo.setMinimumSize(new Dimension(250, 20));
        panelCenter.add((Component)this.comboProtocolo, c);
        ++c.gridy;
        c.gridx = 0;
        panelCenter.add((Component)this.labelPorta, c);
        ++c.gridx;
        this.comboPorta.setPreferredSize(new Dimension(250, 20));
        this.comboPorta.setMinimumSize(new Dimension(250, 20));
        panelCenter.add((Component)this.comboPorta, c);
        JPanel panelFundo = ComponenteFactory.novoJPanel(new GridBagLayout(), ComponenteFactory.novoTitledEtchedBorder(""));
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panelCenter.add((Component)panelFundo, c);
        this.add((Component)panelCenter, "Center");
        c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        panelFundo.add((Component)this.labelDescricao, c);
        ++c.gridx;
        this.textDescricao.setPreferredSize(new Dimension(250, 20));
        this.textDescricao.setMinimumSize(new Dimension(250, 20));
        panelFundo.add((Component)this.textDescricao, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        panelFundo.add((Component)new JPanel(), c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        panelFundo.add((Component)this.buttonFiltro, c);
        JPanel panelEquipamento = ComponenteFactory.novoJPanel(new GridBagLayout(), ComponenteFactory.novoTitledEtchedBorder("Equipamento"));
        ++c.gridy;
        c.gridx = 0;
        c.fill = 1;
        c.gridwidth = 4;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panelFundo.add((Component)panelEquipamento, c);
        ++c.gridy;
        c.gridwidth = 2;
        c.fill = 1;
        c.weighty = 0.0;
        c.weightx = 0.0;
        this.panelPorta.setPreferredSize(new Dimension(100, 200));
        this.panelPorta.setMinimumSize(new Dimension(100, 200));
        this.panelPorta.setMaximumSize(new Dimension(100, 200));
        panelFundo.add((Component)this.panelPorta, c);
        c.gridx = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        this.scrolOpcoes.setPreferredSize(new Dimension(300, 230));
        this.scrolOpcoes.setMinimumSize(new Dimension(300, 230));
        this.scrolOpcoes.setMaximumSize(new Dimension(300, 230));
        panelFundo.add((Component)this.scrolOpcoes, c);
        this.scrolOpcoes.setBorder(ComponenteFactory.novoTitledEtchedBorder("Op\u00e7\u00f5es Protocolo"));
        this.scrolOpcoes.setViewportView(this.panelOpcoes);
        c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        panelEquipamento.add((Component)this.labelFilial, c);
        ++c.gridx;
        this.comboFilial.setPreferredSize(new Dimension(250, 20));
        this.comboFilial.setMinimumSize(new Dimension(250, 20));
        panelEquipamento.add((Component)this.comboFilial, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.scrollEquipamentos.setPreferredSize(new Dimension(250, 100));
        this.scrollEquipamentos.setMinimumSize(new Dimension(250, 100));
        panelEquipamento.add((Component)this.scrollEquipamentos, c);
        c.gridx = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 3;
        JPanel panelButtonEquipamentos = new JPanel(new GridBagLayout());
        panelButtonEquipamentos.setMinimumSize(new Dimension(50, 100));
        panelButtonEquipamentos.setPreferredSize(new Dimension(50, 100));
        panelButtonEquipamentos.setMaximumSize(new Dimension(50, 100));
        panelEquipamento.add((Component)panelButtonEquipamentos, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.scrollSelecionados.setPreferredSize(new Dimension(250, 100));
        this.scrollSelecionados.setMinimumSize(new Dimension(250, 100));
        panelEquipamento.add((Component)this.scrollSelecionados, c);
        this.buttonAdicionar.setPreferredSize(new Dimension(50, 20));
        this.buttonAdicionar.setMinimumSize(new Dimension(50, 20));
        this.buttonRemover.setPreferredSize(new Dimension(50, 20));
        this.buttonRemover.setMinimumSize(new Dimension(50, 20));
        GridBagConstraints cons = new GridBagConstraints();
        cons.insets = new Insets(2, 2, 2, 2);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 1;
        panelButtonEquipamentos.add((Component)this.buttonAdicionar, cons);
        ++cons.gridy;
        panelButtonEquipamentos.add((Component)this.buttonRemover, cons);
        this.panelButtons.add(this.buttonAjuda);
        this.panelButtons.add(this.buttonLimpar);
        this.panelButtons.add(this.buttonNovo);
        this.panelButtons.add(this.buttonSalvar);
        this.panelButtons.add(this.buttonFechar);
        this.add((Component)this.panelButtons, "South");
        this.listEquipamentos.setFont(new Font(this.listEquipamentos.getFont().getName(), 0, this.listEquipamentos.getFont().getSize()));
        this.listSelecionados.setFont(new Font(this.listSelecionados.getFont().getName(), 0, this.listSelecionados.getFont().getSize()));
    }

    public void loadDisponiveis() {
        try {
            CodString[] filiais;
            Map<String, String> faces = BDUtil.getInterfacesProtocolosDisponiveis();
            for (String s : faces.keySet()) {
                ProtocoloInterface p = new ProtocoloInterface();
                p.setClasse(faces.get(s));
                p.setDescricao(s);
                this.protocolos.add(p);
                this.comboProtocolo.addItem(p);
            }
            if (Variaveis.equip == null) {
                PortaCOM port = new PortaCOM();
                ArrayList<String> lista = port.getListaPortasSeriaisDisponiveis();
                while (!lista.isEmpty()) {
                    this.comboPorta.addItem(lista.remove(0));
                }
            }
            for (CodString s : filiais = BDUtil.getFiliais()) {
                this.comboFilial.addItem(s);
                if (!s.getCodigo().toString().equals(Variaveis.filialPadrao)) continue;
                this.comboFilial.setSelectedItem(s);
            }
            this.comboVelocidade.addItem(new CodString(300, "300"));
            this.comboVelocidade.addItem(new CodString(1200, "1200"));
            this.comboVelocidade.addItem(new CodString(2400, "2400"));
            this.comboVelocidade.addItem(new CodString(4800, "4800"));
            this.comboVelocidade.addItem(new CodString(9600, "9600"));
            this.comboVelocidade.addItem(new CodString(19200, "19200"));
            this.comboVelocidade.addItem(new CodString(38400, "38400"));
            this.comboVelocidade.addItem(new CodString(57600, "57600"));
            this.comboVelocidade.addItem(new CodString(115200, "115200"));
            this.comboDataBits.addItem(new CodString(5, "5"));
            this.comboDataBits.addItem(new CodString(6, "6"));
            this.comboDataBits.addItem(new CodString(7, "7"));
            this.comboDataBits.addItem(new CodString(8, "8"));
            this.comboStopBits.addItem(new CodString(1, "1"));
            this.comboStopBits.addItem(new CodString(3, "1.5"));
            this.comboStopBits.addItem(new CodString(2, "2"));
            this.comboParidade.addItem(new CodString(0, "Nenhuma"));
            this.comboParidade.addItem(new CodString(2, "Par"));
            this.comboParidade.addItem(new CodString(1, "\u00cdmpar"));
            this.comboParidade.addItem(new CodString(4, "Space"));
            this.comboParidade.addItem(new CodString(3, "Mark"));
            this.comboFluxo.addItem(new CodString(0, "Nenhum"));
            this.comboFluxo.addItem(new CodString(3, "Hardware"));
            this.comboFluxo.addItem(new CodString(12, "Software"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    public void loadParametros() {
        this.configuracoes = ConfiguracaoSerial.loadConfiguracoes(ParametrosLocais.getParametro("xml_interfaceamento"));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1010060002");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonSalvar) {
            if (this.abf.getTipoComunicacao() == 0) {
                this.salvarDadosPorta();
            } else if (this.abf.getTipoComunicacao() == 1) {
                this.salvarDadosArquivo();
            } else if (this.abf.getTipoComunicacao() == 2) {
                this.salvarDadosSocket();
            } else if (this.abf.getTipoComunicacao() == 3) {
                this.salvarDadosSocket();
            } else if (this.abf.getTipoComunicacao() == 4) {
                this.salvarDadosSocket();
            } else if (this.abf.getTipoComunicacao() == 8) {
                this.salvarDadosSocket();
            } else if (this.abf.getTipoComunicacao() == 9) {
                this.salvarDadosSocket();
            } else if (this.abf.getTipoComunicacao() == 6) {
                this.salvarDadosOdbc();
            } else if (this.abf.getTipoComunicacao() == 7) {
                this.salvarDadosManual();
            }
            this.salvarParametros();
        } else if (e.getSource() == this.buttonLimpar) {
            this.limpar();
        } else if (e.getSource() == this.buttonNovo) {
            this.novo();
        } else if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.comboFilial) {
            this.carregaEquipamentosFilial();
        } else if (e.getSource() == this.comboProtocolo) {
            this.carregaProcolo();
        } else if (e.getSource() == this.comboPorta) {
            this.carregaDadosPorta(this.comboPorta.getSelectedItem().toString());
        } else if (e.getSource() == this.buttonAdicionar) {
            this.adicionarEquipamento();
        } else if (e.getSource() == this.buttonRemover) {
            this.removerEquipamento();
        } else if (e.getSource() == this.buttonDefault) {
            this.configuracaoDefault();
        } else if (e.getSource() == this.buttonTest) {
            this.configuracaoTest();
        } else if (e.getSource() == this.buttonApagar) {
            this.removerConfiguracao();
        } else if (e.getSource() == this.buttonAjuda) {
            this.mostrarAjuda();
        } else if (e.getSource() == this.buttonDirExportacao) {
            this.buscaDiretorio(this.textDirExportacao);
        } else if (e.getSource() == this.buttonDirImportacao) {
            this.buscaDiretorio(this.textDirImportacao);
        } else if (e.getSource() == this.buttonComandoExportacao) {
            this.buscaPrograma(this.textComandoExportacao);
        } else if (e.getSource() == this.buttonComandoImportacao) {
            this.buscaPrograma(this.textComandoImportacao);
        } else if (e.getSource() == this.buttonFiltro) {
            this.configurarFiltro();
        } else if (e.getSource() instanceof JButton && ((JButton)e.getSource()).getName().equalsIgnoreCase(InterfaceConfiguracao.getCaminhoPastaImagens())) {
            this.buscaDiretorioImagens(this.textDirImportacaoImagem);
        }
    }

    private void salvarParametros() {
        try {
            ArrayList<Object> confOriginal = new ArrayList();
            confOriginal = ConfiguracaoSerial.loadConfiguracoes(ParametrosLocais.getParametro("xml_interfaceamento"));
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (ConfiguracaoSerial configuracaoSerial : this.configuracoes) {
                configuracaoSerial.setProtocolo(this.protocolo);
                configuracaoSerial.setFiltroColetas(this.filtroColetas);
                configuracaoSerial.setFiltroDestinos(this.filtroDestinos);
                configuracaoSerial.setFiltroSituacoesReq(this.filtroSituacoesReq);
            }
            StringBuilder xml = new StringBuilder();
            for (ConfiguracaoSerial c : this.configuracoes) {
                xml.append(c.getXML());
            }
            ParametrosLocais.setParametro("xml_interfaceamento", xml.toString());
            ParametrosLocais.salvaParametros();
            ParametrosLocais.carregaParametros();
            Variaveis.equipamentos = ConfiguracaoSerial.loadConfiguracoes(xml.toString());
            String string = "update interface set int_xml = ? where fil_codigo = ? and int_codigo = ?";
            PreparedStatement ps = Conexao.getPreparedStatement(string);
            for (ConfiguracaoSerial configuracaoSerial : confOriginal) {
                for (EquipamentoFilial e : configuracaoSerial.getEquipamentos()) {
                    ps.setString(1, "");
                    ps.setInt(2, e.getFilial());
                    ps.setInt(3, e.getEquipamento());
                    ps.addBatch();
                }
            }
            for (ConfiguracaoSerial configuracaoSerial : this.configuracoes) {
                for (EquipamentoFilial e : configuracaoSerial.getEquipamentos()) {
                    xml.setLength(0);
                    xml.append("<protocolo>").append(this.protocolo.getClasse()).append("</protocolo>\n");
                    xml.append("<variaveis>");
                    xml.append(configuracaoSerial.getVariaveisConfiguracao());
                    xml.append("</variaveis>");
                    ps.setString(1, xml.toString());
                    ps.setInt(2, e.getFilial());
                    ps.setInt(3, e.getEquipamento());
                    ps.addBatch();
                }
            }
            ps.executeBatch();
            Conexao.arquivaSQL();
            Funcoes.mensagem(null, "Configura\u00e7\u00f5es salvas com sucesso", 5);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void novo() {
        this.textDescricao.setText("");
        this.modeloEquipamentos.removeAllElements();
        this.modeloSelecionados.removeAllElements();
        this.configuracaoDefault();
        this.carregaProcolo();
    }

    private void configuracaoDefault() {
        this.comboVelocidade.setSelectedIndex(4);
        this.comboDataBits.setSelectedIndex(3);
        this.comboStopBits.setSelectedIndex(2);
        this.comboParidade.setSelectedIndex(0);
        this.comboFluxo.setSelectedIndex(0);
    }

    private void carregaEquipamentosFilial() {
        try {
            if (this.comboFilial.getSelectedIndex() >= 0) {
                CodString filial = (CodString)this.comboFilial.getSelectedItem();
                CodString[] equipamentos = BDUtil.getInterfaces(Integer.toString(filial.getCodigo()));
                this.modeloEquipamentos.removeAllElements();
                for (CodString c : equipamentos) {
                    boolean achou = false;
                    for (int i = 0; i < this.modeloSelecionados.getSize(); ++i) {
                        EquipamentoFilial sel = (EquipamentoFilial)this.modeloSelecionados.get(i);
                        if (sel.getFilial().intValue() != filial.getCodigo().intValue() || sel.getEquipamento().intValue() != c.getCodigo().intValue()) continue;
                        achou = true;
                    }
                    if (achou) continue;
                    EquipamentoFilial e = new EquipamentoFilial();
                    e.setFilial(filial.getCodigo());
                    e.setEquipamento(c.getCodigo());
                    e.setDescricao(c.getString());
                    this.modeloEquipamentos.addElement(e);
                }
                this.listEquipamentos.setModel(this.modeloEquipamentos);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void carregaProcolo() {
        try {
            this.protocolo = (ProtocoloInterface)this.comboProtocolo.getSelectedItem();
            this.abf = (AbstractInterfaceamentoFactory)Class.forName("jalis.laboratorio.interfaceamento.interfaces." + this.protocolo.getClasse() + ".InterfaceamentoFactory").newInstance();
            try {
                this.configuracao = (InterfaceamentoConfiguracao)Class.forName("jalis.laboratorio.interfaceamento.interfaces." + this.protocolo.getClasse() + ".InterfaceConfiguracao").newInstance();
            }
            catch (ClassNotFoundException e) {
                this.configuracao = new InterfaceamentoConfiguracao();
            }
            if (this.abf.getTipoComunicacao() == 0) {
                this.configPanelPorta();
            } else if (this.abf.getTipoComunicacao() == 1) {
                this.configPanelArquivo();
            } else if (this.abf.getTipoComunicacao() == 2) {
                this.configPanelSocket();
            } else if (this.abf.getTipoComunicacao() == 3) {
                this.configPanelSocket();
            } else if (this.abf.getTipoComunicacao() == 4) {
                this.configPanelSocket();
            } else if (this.abf.getTipoComunicacao() == 8) {
                this.configPanelSocket();
            } else if (this.abf.getTipoComunicacao() == 9) {
                this.configPanelSocket();
            } else if (this.abf.getTipoComunicacao() == 6) {
                this.configPanelOdbc();
            } else if (this.abf.getTipoComunicacao() == 7) {
                this.configPanelManual();
            }
            if (this.configuracao != null) {
                this.montaPanelVariaveis();
            }
            this.revalidate();
            this.repaint();
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void carregaDadosPorta(String porta) {
        int i;
        this.modeloSelecionados.removeAllElements();
        ConfiguracaoSerial c = null;
        for (ConfiguracaoSerial c1 : this.configuracoes) {
            if (!c1.getPorta().equalsIgnoreCase(porta)) continue;
            c = c1;
        }
        if (c == null) {
            return;
        }
        this.comboProtocolo.setSelectedItem(c.getProtocolo());
        this.textDescricao.setText(c.getDescricao());
        for (EquipamentoFilial e : c.getEquipamentos()) {
            for (int i2 = 0; i2 < this.modeloEquipamentos.getSize(); ++i2) {
                EquipamentoFilial sel = (EquipamentoFilial)this.modeloEquipamentos.get(i2);
                if (sel.getFilial().intValue() != e.getFilial().intValue() || sel.getEquipamento().intValue() != e.getEquipamento().intValue()) continue;
                this.modeloEquipamentos.removeElement(sel);
            }
            this.modeloSelecionados.addElement(e);
        }
        for (i = 0; i < this.comboVelocidade.getModel().getSize(); ++i) {
            if (((CodString)this.comboVelocidade.getModel().getElementAt(i)).getCodigo().intValue() != c.getVelocidade().intValue()) continue;
            this.comboVelocidade.setSelectedIndex(i);
        }
        for (i = 0; i < this.comboDataBits.getItemCount(); ++i) {
            if (((CodString)this.comboDataBits.getItemAt(i)).getCodigo().intValue() != c.getDataBits().intValue()) continue;
            this.comboDataBits.setSelectedIndex(i);
        }
        for (i = 0; i < this.comboStopBits.getItemCount(); ++i) {
            if (((CodString)this.comboStopBits.getItemAt(i)).getCodigo().intValue() != c.getStopBits().intValue()) continue;
            this.comboStopBits.setSelectedIndex(i);
        }
        for (i = 0; i < this.comboParidade.getItemCount(); ++i) {
            if (((CodString)this.comboParidade.getItemAt(i)).getCodigo().intValue() != c.getParidade().intValue()) continue;
            this.comboParidade.setSelectedIndex(i);
        }
        for (i = 0; i < this.comboFluxo.getItemCount(); ++i) {
            if (((CodString)this.comboFluxo.getItemAt(i)).getCodigo().intValue() != c.getFluxo().intValue()) continue;
            this.comboFluxo.setSelectedIndex(i);
        }
        this.carregaEquipamentosFilial();
    }

    private void carregaDadosArquivo() {
        this.modeloSelecionados.removeAllElements();
        if (this.configuracoes.size() != 1) {
            return;
        }
        ConfiguracaoSerial c = this.configuracoes.get(0);
        this.comboProtocolo.setSelectedItem(c.getProtocolo());
        this.textDescricao.setText(c.getDescricao());
        for (EquipamentoFilial e : c.getEquipamentos()) {
            for (int i = 0; i < this.modeloEquipamentos.getSize(); ++i) {
                EquipamentoFilial sel = (EquipamentoFilial)this.modeloEquipamentos.get(i);
                if (sel.getFilial().intValue() != e.getFilial().intValue() || sel.getEquipamento().intValue() != e.getEquipamento().intValue()) continue;
                this.modeloEquipamentos.removeElement(sel);
            }
            this.modeloSelecionados.addElement(e);
        }
        this.textDirExportacao.setText(c.getDiretorioExportacao());
        this.textDirImportacao.setText(c.getDiretorioImportacao());
        this.textComandoExportacao.setText(c.getComandoExportacao());
        this.textComandoImportacao.setText(c.getComandoImportacao());
        this.carregaEquipamentosFilial();
    }

    private void carregaDadosSocket() {
        this.modeloSelecionados.removeAllElements();
        if (this.configuracoes.size() != 1) {
            return;
        }
        ConfiguracaoSerial c = this.configuracoes.get(0);
        this.comboProtocolo.setSelectedItem(c.getProtocolo());
        this.textDescricao.setText(c.getDescricao());
        for (EquipamentoFilial e : c.getEquipamentos()) {
            for (int i = 0; i < this.modeloEquipamentos.getSize(); ++i) {
                EquipamentoFilial sel = (EquipamentoFilial)this.modeloEquipamentos.get(i);
                if (sel.getFilial().intValue() != e.getFilial().intValue() || sel.getEquipamento().intValue() != e.getEquipamento().intValue()) continue;
                this.modeloEquipamentos.removeElement(sel);
            }
            this.modeloSelecionados.addElement(e);
        }
        this.textEnderecoSocket.setText(c.getEnderecoSocket());
        this.textPortaSocketInput.setText(c.getPortaSocketInput());
        this.textPortaSocketInputTriplex.setText(c.getPortaSocketInputTriplex());
        this.textPortaSocketOutput.setText(c.getPortaSocketOutput());
        this.carregaEquipamentosFilial();
    }

    private void carregaDadosOdbc() {
        this.modeloSelecionados.removeAllElements();
        if (this.configuracoes.size() != 1) {
            return;
        }
        ConfiguracaoSerial c = this.configuracoes.get(0);
        this.comboProtocolo.setSelectedItem(c.getProtocolo());
        this.textDescricao.setText(c.getDescricao());
        for (EquipamentoFilial e : c.getEquipamentos()) {
            for (int i = 0; i < this.modeloEquipamentos.getSize(); ++i) {
                EquipamentoFilial sel = (EquipamentoFilial)this.modeloEquipamentos.get(i);
                if (sel.getFilial().intValue() != e.getFilial().intValue() || sel.getEquipamento().intValue() != e.getEquipamento().intValue()) continue;
                this.modeloEquipamentos.removeElement(sel);
            }
            this.modeloSelecionados.addElement(e);
        }
        this.textFonteOdbcWorklist.setText(c.getFonteOdbcWorklist());
        this.textFonteOdbcResultados.setText(c.getFonteOdbcResultados());
        this.carregaEquipamentosFilial();
    }

    private void carregaDadosManual() {
        this.modeloSelecionados.removeAllElements();
        if (this.configuracoes.size() != 1) {
            return;
        }
        ConfiguracaoSerial c = this.configuracoes.get(0);
        this.comboProtocolo.setSelectedItem(c.getProtocolo());
        this.textDescricao.setText(c.getDescricao());
        for (EquipamentoFilial e : c.getEquipamentos()) {
            for (int i = 0; i < this.modeloEquipamentos.getSize(); ++i) {
                EquipamentoFilial sel = (EquipamentoFilial)this.modeloEquipamentos.get(i);
                if (sel.getFilial().intValue() != e.getFilial().intValue() || sel.getEquipamento().intValue() != e.getEquipamento().intValue()) continue;
                this.modeloEquipamentos.removeElement(sel);
            }
            this.modeloSelecionados.addElement(e);
        }
        this.carregaEquipamentosFilial();
    }

    private void salvarDadosPorta() {
        if (this.comboPorta.getSelectedIndex() < 0) {
            return;
        }
        String porta = this.comboPorta.getSelectedItem().toString();
        ConfiguracaoSerial conf = null;
        if (this.configuracoes.size() == 1 && Funcoes.textoVazio(this.configuracoes.get(0).getPorta())) {
            this.configuracoes = new ArrayList();
        } else {
            for (ConfiguracaoSerial c : this.configuracoes) {
                if (!c.getPorta().equalsIgnoreCase(porta)) continue;
                conf = c;
            }
        }
        if (conf == null) {
            conf = new ConfiguracaoSerial();
            conf.setPorta(porta);
            this.configuracoes.add(conf);
        }
        conf.setDescricao(this.textDescricao.getText());
        conf.getEquipamentos().clear();
        for (int i = 0; i < this.modeloSelecionados.getSize(); ++i) {
            conf.addEquipamento((EquipamentoFilial)this.modeloSelecionados.get(i));
        }
        conf.setVelocidade(((CodString)this.comboVelocidade.getSelectedItem()).getCodigo());
        conf.setDataBits(((CodString)this.comboDataBits.getSelectedItem()).getCodigo());
        conf.setStopBits(((CodString)this.comboStopBits.getSelectedItem()).getCodigo());
        conf.setParidade(((CodString)this.comboParidade.getSelectedItem()).getCodigo());
        conf.setFluxo(((CodString)this.comboFluxo.getSelectedItem()).getCodigo());
        this.salvarVariaveis(conf);
    }

    private void salvarDadosArquivo() {
        ConfiguracaoSerial conf = new ConfiguracaoSerial();
        this.configuracoes = new ArrayList();
        this.configuracoes.add(conf);
        conf.setDescricao(this.textDescricao.getText());
        conf.getEquipamentos().clear();
        for (int i = 0; i < this.modeloSelecionados.getSize(); ++i) {
            conf.addEquipamento((EquipamentoFilial)this.modeloSelecionados.get(i));
        }
        conf.setDiretorioExportacao(this.textDirExportacao.getText());
        conf.setDiretorioImportacao(this.textDirImportacao.getText());
        conf.setComandoExportacao(this.textComandoExportacao.getText());
        conf.setComandoImportacao(this.textComandoImportacao.getText());
        this.salvarVariaveis(conf);
    }

    private void salvarDadosSocket() {
        ConfiguracaoSerial conf = new ConfiguracaoSerial();
        this.configuracoes = new ArrayList();
        this.configuracoes.add(conf);
        conf.setDescricao(this.textDescricao.getText());
        conf.getEquipamentos().clear();
        for (int i = 0; i < this.modeloSelecionados.getSize(); ++i) {
            conf.addEquipamento((EquipamentoFilial)this.modeloSelecionados.get(i));
        }
        conf.setPortaSocketInput(this.textPortaSocketInput.getText());
        conf.setPortaSocketOutput(this.textPortaSocketOutput.getText());
        conf.setPortaSocketInputTriplex(this.textPortaSocketInputTriplex.getText());
        conf.setEnderecoSocket(this.textEnderecoSocket.getText());
        this.salvarVariaveis(conf);
    }

    private void salvarDadosOdbc() {
        ConfiguracaoSerial conf = new ConfiguracaoSerial();
        this.configuracoes = new ArrayList();
        this.configuracoes.add(conf);
        conf.setDescricao(this.textDescricao.getText());
        conf.getEquipamentos().clear();
        for (int i = 0; i < this.modeloSelecionados.getSize(); ++i) {
            conf.addEquipamento((EquipamentoFilial)this.modeloSelecionados.get(i));
        }
        conf.setFonteOdbcWorklist(this.textFonteOdbcWorklist.getText());
        conf.setFonteOdbcResultados(this.textFonteOdbcResultados.getText());
        this.salvarVariaveis(conf);
    }

    private void salvarDadosManual() {
        ConfiguracaoSerial conf = new ConfiguracaoSerial();
        this.configuracoes = new ArrayList();
        this.configuracoes.add(conf);
        conf.setDescricao(this.textDescricao.getText());
        conf.getEquipamentos().clear();
        for (int i = 0; i < this.modeloSelecionados.getSize(); ++i) {
            conf.addEquipamento((EquipamentoFilial)this.modeloSelecionados.get(i));
        }
        this.salvarVariaveis(conf);
    }

    private void adicionarEquipamento() {
        if (!this.listEquipamentos.isSelectionEmpty()) {
            EquipamentoFilial equip = (EquipamentoFilial)this.modeloEquipamentos.remove(this.listEquipamentos.getSelectedIndex());
            this.modeloSelecionados.addElement(equip);
        } else {
            Funcoes.mensagem(this, "Selecione um equipamento", 5);
        }
    }

    private void removerEquipamento() {
        if (!this.listSelecionados.isSelectionEmpty()) {
            EquipamentoFilial selecionado = (EquipamentoFilial)this.modeloSelecionados.get(this.listSelecionados.getSelectedIndex());
            CodString filial = (CodString)this.comboFilial.getSelectedItem();
            if (selecionado.getFilial().intValue() == filial.getCodigo().intValue()) {
                int index = this.listSelecionados.getSelectedIndex();
                this.modeloSelecionados.remove(index);
                this.modeloEquipamentos.addElement(selecionado);
            }
        } else {
            Funcoes.mensagem(this, "Selecione um equipamento", 5);
        }
    }

    private void configuracaoTest() {
        String porta = this.comboPorta.getSelectedItem().toString();
        int velocidade = ((CodString)this.comboVelocidade.getSelectedItem()).getCodigo();
        int dataBits = ((CodString)this.comboDataBits.getSelectedItem()).getCodigo();
        int stopBits = ((CodString)this.comboStopBits.getSelectedItem()).getCodigo();
        int paridade = ((CodString)this.comboParidade.getSelectedItem()).getCodigo();
        int fluxo = ((CodString)this.comboFluxo.getSelectedItem()).getCodigo();
        CommunicationTest tela = new CommunicationTest(null, porta, velocidade, dataBits, stopBits, paridade, fluxo);
        tela.setVisible(true);
    }

    private void limpar() {
        String porta = this.comboPorta.getSelectedItem().toString();
        ConfiguracaoSerial conf = null;
        for (ConfiguracaoSerial c : this.configuracoes) {
            if (!c.getPorta().equalsIgnoreCase(porta)) continue;
            conf = c;
        }
        if (conf != null) {
            this.configuracoes.remove(conf);
        }
        this.textDescricao.setText("");
        while (this.modeloSelecionados.getSize() > 0) {
            this.modeloSelecionados.remove(0);
        }
    }

    private void removerConfiguracao() {
    }

    private void configPanelPorta() {
        this.panelPorta.removeAll();
        this.comboPorta.setEnabled(true);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridwidth = 1;
        c.fill = 1;
        c.weightx = 1.0;
        this.labelVelocidade.setPreferredSize(new Dimension(80, 20));
        this.labelVelocidade.setMinimumSize(new Dimension(80, 20));
        this.panelPorta.add((Component)this.labelVelocidade, c);
        ++c.gridx;
        this.comboVelocidade.setPreferredSize(new Dimension(100, 20));
        this.comboVelocidade.setMinimumSize(new Dimension(100, 20));
        this.panelPorta.add((Component)this.comboVelocidade, c);
        ++c.gridy;
        c.gridx = 0;
        this.labelDataBits.setPreferredSize(new Dimension(80, 20));
        this.labelDataBits.setMinimumSize(new Dimension(80, 20));
        this.panelPorta.add((Component)this.labelDataBits, c);
        ++c.gridx;
        this.comboDataBits.setPreferredSize(new Dimension(100, 20));
        this.comboDataBits.setMinimumSize(new Dimension(100, 20));
        this.panelPorta.add((Component)this.comboDataBits, c);
        ++c.gridy;
        c.gridx = 0;
        this.labelStopBits.setPreferredSize(new Dimension(80, 20));
        this.labelStopBits.setMinimumSize(new Dimension(80, 20));
        this.panelPorta.add((Component)this.labelStopBits, c);
        ++c.gridx;
        this.comboStopBits.setPreferredSize(new Dimension(100, 20));
        this.comboStopBits.setMinimumSize(new Dimension(100, 20));
        this.panelPorta.add((Component)this.comboStopBits, c);
        ++c.gridy;
        c.gridx = 0;
        this.labelParidade.setPreferredSize(new Dimension(80, 20));
        this.labelParidade.setMinimumSize(new Dimension(80, 20));
        this.panelPorta.add((Component)this.labelParidade, c);
        ++c.gridx;
        this.comboParidade.setPreferredSize(new Dimension(100, 20));
        this.comboParidade.setMinimumSize(new Dimension(100, 20));
        this.panelPorta.add((Component)this.comboParidade, c);
        ++c.gridy;
        c.gridx = 0;
        this.labelFluxo.setPreferredSize(new Dimension(80, 20));
        this.labelFluxo.setMinimumSize(new Dimension(80, 20));
        this.panelPorta.add((Component)this.labelFluxo, c);
        ++c.gridx;
        this.comboFluxo.setPreferredSize(new Dimension(100, 20));
        this.comboFluxo.setMinimumSize(new Dimension(100, 20));
        this.panelPorta.add((Component)this.comboFluxo, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 2;
        this.panelPorta.add((Component)this.buttonLoopback, c);
        ++c.gridx;
        this.panelPorta.add((Component)this.buttonDefault, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        this.panelPorta.add((Component)this.buttonTest, c);
    }

    private void configPanelArquivo() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.panelPorta.removeAll();
        this.comboPorta.setEnabled(false);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridwidth = 1;
        c.fill = 1;
        c.weightx = 1.0;
        this.labelDirExportacao.setPreferredSize(new Dimension(100, 20));
        this.labelDirExportacao.setMinimumSize(new Dimension(100, 20));
        this.panelPorta.add((Component)this.labelDirExportacao, c);
        ++c.gridx;
        this.textDirExportacao.setPreferredSize(new Dimension(120, 20));
        this.textDirExportacao.setMinimumSize(new Dimension(120, 20));
        this.panelPorta.add((Component)this.textDirExportacao, c);
        ++c.gridx;
        this.buttonDirExportacao.setPreferredSize(new Dimension(20, 20));
        this.buttonDirExportacao.setMinimumSize(new Dimension(20, 20));
        this.buttonDirExportacao.setMaximumSize(new Dimension(20, 20));
        this.panelPorta.add((Component)this.buttonDirExportacao, c);
        ++c.gridy;
        c.gridx = 0;
        this.labelDirImportacao.setPreferredSize(new Dimension(100, 20));
        this.labelDirImportacao.setMinimumSize(new Dimension(100, 20));
        this.panelPorta.add((Component)this.labelDirImportacao, c);
        ++c.gridx;
        this.textDirImportacao.setPreferredSize(new Dimension(120, 20));
        this.textDirImportacao.setMinimumSize(new Dimension(120, 20));
        this.panelPorta.add((Component)this.textDirImportacao, c);
        ++c.gridx;
        this.buttonDirImportacao.setPreferredSize(new Dimension(20, 20));
        this.buttonDirImportacao.setMinimumSize(new Dimension(20, 20));
        this.buttonDirImportacao.setMaximumSize(new Dimension(20, 20));
        this.panelPorta.add((Component)this.buttonDirImportacao, c);
        ++c.gridy;
        c.gridx = 0;
        this.labelComandoExportacao.setPreferredSize(new Dimension(100, 20));
        this.labelComandoExportacao.setMinimumSize(new Dimension(100, 20));
        this.panelPorta.add((Component)this.labelComandoExportacao, c);
        ++c.gridx;
        this.textComandoExportacao.setPreferredSize(new Dimension(120, 20));
        this.textComandoExportacao.setMinimumSize(new Dimension(120, 20));
        this.panelPorta.add((Component)this.textComandoExportacao, c);
        ++c.gridx;
        this.buttonComandoExportacao.setPreferredSize(new Dimension(20, 20));
        this.buttonComandoExportacao.setMinimumSize(new Dimension(20, 20));
        this.buttonComandoExportacao.setMaximumSize(new Dimension(20, 20));
        this.panelPorta.add((Component)this.buttonComandoExportacao, c);
        ++c.gridy;
        c.gridx = 0;
        this.labelComandoImportacao.setPreferredSize(new Dimension(100, 20));
        this.labelComandoImportacao.setMinimumSize(new Dimension(100, 20));
        this.panelPorta.add((Component)this.labelComandoImportacao, c);
        ++c.gridx;
        this.textComandoImportacao.setPreferredSize(new Dimension(120, 20));
        this.textComandoImportacao.setMinimumSize(new Dimension(120, 20));
        this.panelPorta.add((Component)this.textComandoImportacao, c);
        ++c.gridx;
        this.buttonComandoImportacao.setPreferredSize(new Dimension(20, 20));
        this.buttonComandoImportacao.setMinimumSize(new Dimension(20, 20));
        this.buttonComandoImportacao.setMaximumSize(new Dimension(20, 20));
        this.panelPorta.add((Component)this.buttonComandoImportacao, c);
        ++c.gridy;
        c.gridx = 0;
        this.labelVariaveis.setPreferredSize(new Dimension(100, 20));
        this.labelVariaveis.setMinimumSize(new Dimension(100, 20));
        this.panelPorta.add((Component)this.labelVariaveis, c);
        ++c.gridx;
        this.scrollVariaveis.setPreferredSize(new Dimension(100, 20));
        this.scrollVariaveis.setMinimumSize(new Dimension(100, 20));
        c.fill = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelPorta.add((Component)this.scrollVariaveis, c);
        this.textVariaveis.setText("");
        if (this.configuracao != null) {
            for (String s : this.configuracao.getConstantes()) {
                this.textVariaveis.append(s);
                this.textVariaveis.append("\n");
            }
        }
    }

    private void configPanelSocket() {
        this.panelPorta.removeAll();
        this.comboPorta.setEnabled(false);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridwidth = 1;
        this.labelEnderecoSocket.setPreferredSize(new Dimension(100, 20));
        this.labelEnderecoSocket.setMinimumSize(new Dimension(100, 20));
        this.panelPorta.add((Component)this.labelEnderecoSocket, c);
        ++c.gridx;
        c.fill = 1;
        c.weightx = 1.0;
        this.textEnderecoSocket.setPreferredSize(new Dimension(120, 20));
        this.textEnderecoSocket.setMinimumSize(new Dimension(120, 20));
        this.panelPorta.add((Component)this.textEnderecoSocket, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        c.weightx = 0.0;
        this.labelPortaSocketOutput.setPreferredSize(new Dimension(100, 20));
        this.labelPortaSocketOutput.setMinimumSize(new Dimension(100, 20));
        this.panelPorta.add((Component)this.labelPortaSocketOutput, c);
        ++c.gridx;
        c.fill = 1;
        c.weightx = 1.0;
        this.textPortaSocketOutput.setPreferredSize(new Dimension(120, 20));
        this.textPortaSocketOutput.setMinimumSize(new Dimension(120, 20));
        this.panelPorta.add((Component)this.textPortaSocketOutput, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        c.weightx = 0.0;
        this.labelPortaSocketInput.setPreferredSize(new Dimension(100, 20));
        this.labelPortaSocketInput.setMinimumSize(new Dimension(100, 20));
        this.panelPorta.add((Component)this.labelPortaSocketInput, c);
        ++c.gridx;
        c.fill = 1;
        c.weightx = 1.0;
        this.textPortaSocketInput.setPreferredSize(new Dimension(120, 20));
        this.textPortaSocketInput.setMinimumSize(new Dimension(120, 20));
        this.panelPorta.add((Component)this.textPortaSocketInput, c);
        if (this.abf.getTipoComunicacao() == 9 || this.abf.getTipoComunicacao() == 3) {
            ++c.gridy;
            c.gridx = 0;
            c.fill = 0;
            c.weightx = 0.0;
            this.labelPortaSocketInputTriplex.setPreferredSize(new Dimension(120, 20));
            this.labelPortaSocketInputTriplex.setMinimumSize(new Dimension(120, 20));
            this.panelPorta.add((Component)this.labelPortaSocketInputTriplex, c);
            ++c.gridx;
            c.fill = 1;
            c.weightx = 1.0;
            this.textPortaSocketInputTriplex.setPreferredSize(new Dimension(120, 20));
            this.textPortaSocketInputTriplex.setMinimumSize(new Dimension(120, 20));
            this.panelPorta.add((Component)this.textPortaSocketInputTriplex, c);
        }
        ++c.gridy;
        c.gridx = 0;
        c.fill = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelPorta.add((Component)new JPanel(), c);
    }

    private void configPanelOdbc() {
        this.panelPorta.removeAll();
        this.comboPorta.setEnabled(false);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridwidth = 1;
        this.labelFonteOdbcWorklist.setPreferredSize(new Dimension(120, 20));
        this.labelFonteOdbcWorklist.setMinimumSize(new Dimension(120, 20));
        this.panelPorta.add((Component)this.labelFonteOdbcWorklist, c);
        ++c.gridx;
        c.fill = 1;
        c.weightx = 1.0;
        this.textFonteOdbcWorklist.setPreferredSize(new Dimension(100, 20));
        this.textFonteOdbcWorklist.setMinimumSize(new Dimension(100, 20));
        this.panelPorta.add((Component)this.textFonteOdbcWorklist, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        c.weightx = 0.0;
        this.labelFonteOdbcResultados.setPreferredSize(new Dimension(120, 20));
        this.labelFonteOdbcResultados.setMinimumSize(new Dimension(120, 20));
        this.panelPorta.add((Component)this.labelFonteOdbcResultados, c);
        ++c.gridx;
        c.fill = 1;
        c.weightx = 1.0;
        this.textFonteOdbcResultados.setPreferredSize(new Dimension(100, 20));
        this.textFonteOdbcResultados.setMinimumSize(new Dimension(100, 20));
        this.panelPorta.add((Component)this.textFonteOdbcResultados, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelPorta.add((Component)new JPanel(), c);
    }

    private void configPanelManual() {
        this.panelPorta.removeAll();
        this.comboPorta.setEnabled(false);
    }

    private void buscaDiretorioImagens(TTextField text) {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser("Selecione um Diret\u00f3rio");
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(this) == 0) {
            text.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void buscaDiretorio(TTextField text) {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser("Selecione um Diret\u00f3rio");
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(this) == 0) {
            text.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void buscaPrograma(TTextField text) {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser("Selecione um programa");
        chooser.setFileSelectionMode(0);
        if (chooser.showOpenDialog(this) == 0) {
            text.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void mostrarAjuda() {
        TelaAjuda tela = new TelaAjuda(Laboratorio.getInstancia());
        if (!Funcoes.textoVazio(this.abf.getSerialInfo())) {
            try {
                tela.setPage(ConfigEquipamento.class.getResource(this.abf.getSerialInfo()));
            }
            catch (Exception e) {
                tela.setText(this.abf.getSerialInfo());
            }
        }
        tela.setVisible(true);
    }

    private void montaPanelVariaveis() {
        this.panelOpcoes.removeAll();
        this.panelOpcoes.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        if (this.configuracao != null && this.configuracoes != null && this.configuracoes.size() > 0 && this.configuracoes.get(0) != null) {
            this.configuracao.setXmlVariaveis(this.configuracoes.get(0).getVariaveisConfiguracao());
        }
        if (this.configuracao != null) {
            this.adicionaVariaveis(c, this.configuracao.getXmlVariaveis());
        }
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 4;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelOpcoes.add((Component)new JPanel(), c);
    }

    private void adicionaVariaveis(GridBagConstraints c, String xml) {
        String[] variaveis = StringUtil.getValores(xml, "variavel");
        ArrayList<JComponent> campos = new ArrayList<JComponent>();
        for (String s : variaveis) {
            JComponent campo = null;
            String nome = StringUtil.getValor(s, "nome");
            String valor = StringUtil.getValor(s, "valor");
            String tipo = StringUtil.getValor(s, "tipo");
            String toolTipText = StringUtil.getValor(s, "toolTipText");
            String dependente = StringUtil.getValor(s, "dependente");
            JLabel label = new JLabel(this.configuracao.getNomeVariavel(nome));
            label.setToolTipText(toolTipText);
            this.panelOpcoes.add((Component)label, c);
            ++c.gridx;
            Dimension d = null;
            if (tipo.equalsIgnoreCase(InterfaceamentoConfiguracao.EDIT_RELACIONA) || tipo.equalsIgnoreCase(InterfaceamentoConfiguracao.EDIT)) {
                campo = ComponenteFactory.novoTTextField(100, 3);
                ((JTextComponent)campo).setText(valor);
                d = new Dimension(100, 20);
            } else if (tipo.equalsIgnoreCase(InterfaceamentoConfiguracao.CHECK)) {
                campo = new JCheckVariavel("");
                campo.setToolTipText(toolTipText);
                if (!Funcoes.textoVazio(dependente)) {
                    for (String dp : dependente.split(";")) {
                        for (JComponent jc : campos) {
                            if (!jc.getName().equalsIgnoreCase(dp)) continue;
                            ((JCheckVariavel)campo).setPai((JCheckVariavel)jc);
                            ((JCheckVariavel)jc).addFilho((JCheckVariavel)campo);
                        }
                    }
                }
                ((JCheckVariavel)campo).setSelected(valor.equalsIgnoreCase("1"));
                ((JCheckVariavel)campo).addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        boolean b = ((JCheckVariavel)e.getSource()).isSelected();
                        if (b) {
                            ((JCheckVariavel)e.getSource()).marcarPai();
                        } else {
                            ((JCheckVariavel)e.getSource()).desmarcarFilhos();
                        }
                    }
                });
                d = new Dimension(20, 20);
                campos.add(campo);
            } else if (tipo.equalsIgnoreCase(InterfaceamentoConfiguracao.TIPO_ARQUIVO)) {
                this.textDirImportacaoImagem = ComponenteFactory.novoTTextField(10000, 3);
                this.textDirImportacaoImagem.setText(valor);
                d = new Dimension(100, 20);
                this.adicionaCampo(c, this.textDirImportacaoImagem, nome, d);
                ++c.gridx;
                campo = ComponenteFactory.novoJButton("...", 'E', this);
                d = new Dimension(20, 20);
            }
            this.adicionaCampo(c, campo, nome, d);
            ++c.gridy;
            c.gridx = 0;
        }
    }

    private void adicionaCampo(GridBagConstraints c, JComponent campo, String nome, Dimension d) {
        campo.setPreferredSize(d);
        campo.setSize(d);
        campo.setMinimumSize(d);
        campo.setMaximumSize(d);
        campo.setName(nome);
        this.panelOpcoes.add((Component)campo, c);
    }

    private void salvarVariaveis(ConfiguracaoSerial conf) {
        try {
            Component[] componentes = this.panelOpcoes.getComponents();
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir("variaveis");
            for (Component c : componentes) {
                if (c instanceof TTextField) {
                    xml.abrir("variavel");
                    xml.escrever("nome", c.getName());
                    xml.escrever("valor", ((TTextField)c).getText());
                    xml.escrever("tipo", InterfaceamentoConfiguracao.EDIT_RELACIONA);
                    xml.fechar("variavel");
                    continue;
                }
                if (!(c instanceof JCheckBox)) continue;
                xml.abrir("variavel");
                xml.escrever("nome", c.getName());
                xml.escrever("valor", ((JCheckBox)c).isSelected() ? "1" : "0");
                xml.escrever("tipo", InterfaceamentoConfiguracao.CHECK);
                xml.fechar("variavel");
            }
            xml.fechar("variaveis");
            this.configuracao.setXmlVariaveis(xml.getXML());
            conf.setVariaveisConfiguracao(this.configuracao.getXmlVariaveis());
        }
        catch (XMLStringBuilderException e) {
            e.printStackTrace();
            conf.setVariaveisConfiguracao("");
        }
    }

    private void configurarFiltro() {
        DialogFiltro dialogFiltros = new DialogFiltro(Laboratorio.getInstancia());
        if (this.filtroColetas != null && this.filtroColetas.length > 0) {
            dialogFiltros.getItemColeta().setSelecionados(this.filtroColetas);
            dialogFiltros.getItemColeta().setSelected(true);
        }
        if (this.filtroDestinos != null && this.filtroDestinos.length > 0) {
            dialogFiltros.getItemDestino().setSelecionados(this.filtroDestinos);
            dialogFiltros.getItemDestino().setSelected(true);
        }
        if (this.filtroSituacoesReq != null && this.filtroSituacoesReq.length > 0) {
            dialogFiltros.getItemSituacaoReq().setSelecionados(this.filtroSituacoesReq);
            dialogFiltros.getItemSituacaoReq().setSelected(true);
        }
        dialogFiltros.setVisible(true);
        if (dialogFiltros.getOK()) {
            this.filtroColetas = dialogFiltros.getItemColeta().getSelecionados();
            this.filtroDestinos = dialogFiltros.getItemDestino().getSelecionados();
            this.filtroSituacoesReq = dialogFiltros.getItemSituacaoReq().getSelecionados();
        }
    }
}

