/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.configuracao;

import jalis.comum.Conexao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.comunicacao.DataChangedListener;
import jalis.laboratorio.interfaceamento.comunicacao.PortaCOM;
import jalis.laboratorio.interfaceamento.comunicacao.SoftHandShakeListener;
import jalis.laboratorio.interfaceamento.configuracao.Aparelho;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class CommunicationTest
extends JDialog
implements ActionListener,
DataChangedListener,
SoftHandShakeListener {
    private String portName;
    private int baudRate;
    private int dataBits;
    private int stopBits;
    private int parity;
    private int flowControl;
    private String sNUL = "[NUL]";
    private String sSOH = "[SOH]";
    private String sSTX = "[STX]";
    private String sETX = "[ETX]";
    private String sEOT = "[EOT]";
    private String sENQ = "[ENQ]";
    private String sACK = "[ACK]";
    private String sLF = "[LF]";
    private String sCR = "[CR]";
    private String sDLE = "[DLE]";
    private String sDC1 = "[DC1]";
    private String sNAK = "[NAK]";
    private String sSYN = "[SYN]";
    private String sETB = "[ETB]";
    private String sCAN = "[CAN]";
    private String sSP = "[SP]";
    private String sDEL = "[DEL]";
    private String sLINE = "[LINE]";
    private String sFD = "[FD]";
    private String sEB = "[EB]";
    private char NUL = '\u0000';
    private char SOH = '\u0001';
    private char STX = (char)2;
    private char ETX = (char)3;
    private char EOT = (char)4;
    private char ENQ = (char)5;
    private char ACK = (char)6;
    private char LF = (char)10;
    private char CR = (char)13;
    private char DLE = (char)16;
    private char DC1 = (char)17;
    private char NAK = (char)21;
    private char SYN = (char)22;
    private char ETB = (char)23;
    private char CAN = (char)24;
    private char EB = (char)28;
    private char SP = (char)32;
    private char DEL = (char)127;
    private String LINE = String.valueOf(this.CR) + String.valueOf(this.LF);
    private char FD = (char)253;
    private JPanel pnlAparelho = new JPanel(new FlowLayout(0));
    private JLabel lblAparelho = new JLabel("Aparelho");
    private JComboBox cbxAparelho = new JComboBox();
    private JButton btnRequisicao = ComponenteFactory.novoJButton("Requisicao", 'R', this);
    private JButton btnResultado = ComponenteFactory.novoJButton("Resultado", 'L', this);
    private JPanel pnlCommand = new JPanel(new BorderLayout());
    private JTextArea txtCommand = new JTextArea();
    private JScrollPane srcCommand = new JScrollPane(this.txtCommand);
    private JPanel pnlCommandButtons = new JPanel();
    private JButton btnSend = ComponenteFactory.novoJButton("Enviar", 'E', this);
    private JButton btnClearCommand = ComponenteFactory.novoJButton("Limpar", 'L', this);
    private JLabel lblReport = new JLabel("Retorno");
    private JPanel pnlReport = new JPanel(new BorderLayout());
    private JPanel pnlReportButton = new JPanel(new FlowLayout(2));
    private JTextArea txtReport = new JTextArea();
    private JScrollPane srcReport = new JScrollPane(this.txtReport);
    private JCheckBox chkPortaAberta = ComponenteFactory.novoJCheckBox("Manter Porta Aberta", this);
    private JButton btnSave = ComponenteFactory.novoJButton("Salvar", 'S', this);
    private JButton btnClose = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JButton btnClearReport = ComponenteFactory.novoJButton("Limpar", 'I', this);
    private JPanel pnlButtons = new JPanel(new FlowLayout(0, 2, 1));
    private JButton btnNUL = ComponenteFactory.novoJButton(this.sNUL, '0', this);
    private JButton btnSOH = ComponenteFactory.novoJButton(this.sSOH, '0', this);
    private JButton btnSTX = ComponenteFactory.novoJButton(this.sSTX, '0', this);
    private JButton btnETX = ComponenteFactory.novoJButton(this.sETX, '0', this);
    private JButton btnEOT = ComponenteFactory.novoJButton(this.sEOT, '0', this);
    private JButton btnENQ = ComponenteFactory.novoJButton(this.sENQ, '0', this);
    private JButton btnACK = ComponenteFactory.novoJButton(this.sACK, '0', this);
    private JButton btnLF = ComponenteFactory.novoJButton(this.sLF, '0', this);
    private JButton btnCR = ComponenteFactory.novoJButton(this.sCR, '0', this);
    private JButton btnDLE = ComponenteFactory.novoJButton(this.sDLE, '0', this);
    private JButton btnDC1 = ComponenteFactory.novoJButton(this.sDC1, '0', this);
    private JButton btnNAK = ComponenteFactory.novoJButton(this.sNAK, '0', this);
    private JButton btnSYN = ComponenteFactory.novoJButton(this.sSYN, '0', this);
    private JButton btnETB = ComponenteFactory.novoJButton(this.sETB, '0', this);
    private JButton btnCAN = ComponenteFactory.novoJButton(this.sCAN, '0', this);
    private JButton btnSP = ComponenteFactory.novoJButton(this.sSP, '0', this);
    private JButton btnDEL = ComponenteFactory.novoJButton(this.sDEL, '0', this);
    private JButton btnLINE = ComponenteFactory.novoJButton(this.sLINE, '0', this);
    private JButton btnFD = ComponenteFactory.novoJButton(this.sFD, '0', this);
    private JButton btnEB = ComponenteFactory.novoJButton(this.sEB, '0', this);
    private ArrayList<Aparelho> aparelhos;
    private PortaCOM porta;

    public CommunicationTest(JFrame owner, String portName, int baudRate, int dataBits, int stopBits, int parity, int flowControl) {
        super(owner);
        this.setModal(true);
        this.setTitle("Teste de Comunica\u00e7\u00e3o");
        this.setLayout(new BorderLayout());
        this.portName = portName;
        this.baudRate = baudRate;
        this.dataBits = dataBits;
        this.stopBits = stopBits;
        this.parity = parity;
        this.flowControl = flowControl;
        this.configComboAparelho();
        this.pnlAparelho.add(this.lblAparelho);
        this.pnlAparelho.add(this.cbxAparelho);
        this.pnlAparelho.add(this.btnRequisicao);
        this.pnlAparelho.add(this.btnResultado);
        this.srcCommand.setPreferredSize(new Dimension(300, 100));
        this.pnlCommand.add((Component)this.pnlAparelho, "North");
        this.pnlCommand.add((Component)this.srcCommand, "Center");
        this.pnlCommandButtons.setPreferredSize(new Dimension(100, 50));
        this.pnlCommandButtons.setLayout(null);
        this.pnlCommandButtons.add(this.btnSend);
        this.pnlCommandButtons.add(this.btnClearCommand);
        this.btnSend.setBounds(10, 10, 80, 24);
        this.btnClearCommand.setBounds(10, 40, 80, 24);
        this.pnlCommand.add((Component)this.pnlCommandButtons, "East");
        this.pnlButtons.add(this.btnNUL);
        this.pnlButtons.add(this.btnSOH);
        this.pnlButtons.add(this.btnSTX);
        this.pnlButtons.add(this.btnETX);
        this.pnlButtons.add(this.btnEOT);
        this.pnlButtons.add(this.btnENQ);
        this.pnlButtons.add(this.btnACK);
        this.pnlButtons.add(this.btnLF);
        this.pnlButtons.add(this.btnCR);
        this.pnlButtons.add(this.btnDLE);
        this.pnlButtons.add(this.btnDC1);
        this.pnlButtons.add(this.btnNAK);
        this.pnlButtons.add(this.btnSYN);
        this.pnlButtons.add(this.btnETB);
        this.pnlButtons.add(this.btnCAN);
        this.pnlButtons.add(this.btnSP);
        this.pnlButtons.add(this.btnDEL);
        this.pnlButtons.add(this.btnLINE);
        this.pnlButtons.add(this.btnFD);
        this.pnlButtons.add(this.btnEB);
        this.pnlCommand.add((Component)this.pnlButtons, "South");
        this.add((Component)this.pnlCommand, "North");
        this.srcReport.setPreferredSize(new Dimension(400, 250));
        this.pnlReportButton.add(this.chkPortaAberta);
        this.pnlReportButton.add(this.btnClearReport);
        this.pnlReportButton.add(this.btnSave);
        this.pnlReportButton.add(this.btnClose);
        this.pnlReport.add((Component)this.lblReport, "North");
        this.pnlReport.add((Component)this.srcReport, "Center");
        this.pnlReport.add((Component)this.pnlReportButton, "South");
        this.add((Component)this.pnlReport, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CommunicationTest.this.calcSizePanels();
            }
        });
        this.setPreferredSize(new Dimension(600, 450));
        this.pack();
        this.setLocationRelativeTo(owner);
        this.calcSizePanels();
    }

    private void calcSizePanels() {
        Dimension size = this.getSize();
        int sizeButton = this.btnNUL.getSize().width * this.pnlButtons.getComponentCount();
        int linhas = sizeButton / size.width + 1;
        int alturaLinhas = this.btnNUL.getSize().height * linhas + linhas * 4;
        size = new Dimension(size.width, alturaLinhas);
        this.pnlButtons.setPreferredSize(size);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnClose) {
            if (this.porta != null && this.porta.isOpened()) {
                this.porta.close();
            }
            this.setVisible(false);
        } else if (e.getSource() == this.btnClearCommand) {
            this.txtCommand.setText("");
        } else if (e.getSource() == this.btnClearReport) {
            this.txtReport.setText("");
        } else if (e.getSource() == this.btnSave) {
            if (this.txtReport.getText() != null && this.txtReport.getText().trim().length() > 0) {
                JFileChooser file = ComponenteFactory.novoJFileChooser();
                FileFilter flt = ComponenteFactory.novoFileFilter("Informe o arquivo a ser gerado", "txt");
                file.setFileFilter(flt);
                if (file.showSaveDialog(this) == 0) {
                    try {
                        StringUtil.escreverArquivoTexto(file.getSelectedFile().getAbsolutePath(), this.txtReport.getText());
                    }
                    catch (Exception e1) {
                        Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel gravar o arquivo.\nMensagem: " + e1.getMessage(), 1);
                    }
                }
            }
        } else if (e.getSource() == this.chkPortaAberta) {
            if (this.chkPortaAberta.isSelected()) {
                this.loadSerialCfg();
            } else {
                this.porta.close();
            }
        } else if (e.getSource() == this.btnSend) {
            this.sendCommands();
        } else if (e.getSource() == this.btnRequisicao) {
            this.loadTesteAparelho(false);
        } else if (e.getSource() == this.btnResultado) {
            this.loadTesteAparelho(true);
        } else if (e.getSource() == this.btnNUL) {
            this.txtCommand.append(this.sNUL);
        } else if (e.getSource() == this.btnSOH) {
            this.txtCommand.append(this.sSOH);
        } else if (e.getSource() == this.btnSTX) {
            this.txtCommand.append(this.sSTX);
        } else if (e.getSource() == this.btnETX) {
            this.txtCommand.append(this.sETX);
        } else if (e.getSource() == this.btnEOT) {
            this.txtCommand.append(this.sEOT);
        } else if (e.getSource() == this.btnENQ) {
            this.txtCommand.append(this.sENQ);
        } else if (e.getSource() == this.btnACK) {
            this.txtCommand.append(this.sACK);
        } else if (e.getSource() == this.btnLF) {
            this.txtCommand.append(this.sLF);
        } else if (e.getSource() == this.btnCR) {
            this.txtCommand.append(this.sCR);
        } else if (e.getSource() == this.btnDLE) {
            this.txtCommand.append(this.sDLE);
        } else if (e.getSource() == this.btnDC1) {
            this.txtCommand.append(this.sDC1);
        } else if (e.getSource() == this.btnNAK) {
            this.txtCommand.append(this.sNAK);
        } else if (e.getSource() == this.btnSYN) {
            this.txtCommand.append(this.sSYN);
        } else if (e.getSource() == this.btnETB) {
            this.txtCommand.append(this.sETB);
        } else if (e.getSource() == this.btnCAN) {
            this.txtCommand.append(this.sCAN);
        } else if (e.getSource() == this.btnSP) {
            this.txtCommand.append(this.sSP);
        } else if (e.getSource() == this.btnDEL) {
            this.txtCommand.append(this.sDEL);
        } else if (e.getSource() == this.btnLINE) {
            this.txtCommand.append(this.sLINE);
        } else if (e.getSource() == this.btnFD) {
            this.txtCommand.append(this.sFD);
        } else if (e.getSource() == this.btnEB) {
            this.txtCommand.append(this.sEB);
        }
    }

    private void sendCommands() {
        if (!this.loadSerialCfg()) {
            return;
        }
        if (Funcoes.textoVazio(this.txtCommand.getText())) {
            return;
        }
        String command = this.txtCommand.getText();
        String newCommand = "";
        String c = "";
        char[] a = command.toCharArray();
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == '[') {
                c = c + a[i];
                ++i;
                while (a[i] != ']') {
                    c = c + a[i];
                    ++i;
                }
                c = c + a[i];
                newCommand = newCommand + this.parseStringToConstant(c);
                c = "";
                continue;
            }
            if (a[i] == '\n' || a[i] == '\t') continue;
            newCommand = newCommand + a[i];
        }
        this.writeCommand(newCommand);
    }

    private void writeCommand(String command) {
        try {
            this.porta.write(command);
            this.porta.flush();
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            e.printStackTrace();
        }
    }

    private String parseStringToConstant(String command) {
        if (command.equalsIgnoreCase(this.sNUL)) {
            return String.valueOf(this.NUL);
        }
        if (command.equalsIgnoreCase(this.sSOH)) {
            return String.valueOf(this.SOH);
        }
        if (command.equalsIgnoreCase(this.sSTX)) {
            return String.valueOf(this.STX);
        }
        if (command.equalsIgnoreCase(this.sETX)) {
            return String.valueOf(this.ETX);
        }
        if (command.equalsIgnoreCase(this.sEOT)) {
            return String.valueOf(this.EOT);
        }
        if (command.equalsIgnoreCase(this.sENQ)) {
            return String.valueOf(this.ENQ);
        }
        if (command.equalsIgnoreCase(this.sACK)) {
            return String.valueOf(this.ACK);
        }
        if (command.equalsIgnoreCase(this.sLF)) {
            return String.valueOf(this.LF);
        }
        if (command.equalsIgnoreCase(this.sCR)) {
            return String.valueOf(this.CR);
        }
        if (command.equalsIgnoreCase(this.sDLE)) {
            return String.valueOf(this.DLE);
        }
        if (command.equalsIgnoreCase(this.sNAK)) {
            return String.valueOf(this.NAK);
        }
        if (command.equalsIgnoreCase(this.sSYN)) {
            return String.valueOf(this.SYN);
        }
        if (command.equalsIgnoreCase(this.sETB)) {
            return String.valueOf(this.ETB);
        }
        if (command.equalsIgnoreCase(this.sCAN)) {
            return String.valueOf(this.CAN);
        }
        if (command.equalsIgnoreCase(this.sSP)) {
            return String.valueOf(this.SP);
        }
        if (command.equalsIgnoreCase(this.sDEL)) {
            return String.valueOf(this.DEL);
        }
        if (command.equalsIgnoreCase(this.sLINE)) {
            return String.valueOf(this.LINE);
        }
        if (command.equalsIgnoreCase(this.sFD)) {
            return String.valueOf(this.FD);
        }
        if (command.equalsIgnoreCase(this.sEB)) {
            return String.valueOf(this.EB);
        }
        return "";
    }

    private boolean loadSerialCfg() {
        try {
            if (this.porta != null && this.porta.isOpened()) {
                return true;
            }
            this.porta = new PortaCOM();
            this.porta.open(this.portName);
            this.porta.setSerialPortParams(this.baudRate, this.dataBits, this.stopBits, this.parity, this.flowControl);
            this.porta.addDataChangedListener(this);
            this.porta.addSoftHandShakeListener(this);
            return true;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.toString() + "\nN\u00e3o foi poss\u00edvel carregar configura\u00e7\u00f5es de porta serial!\n" + "Verifique a configura\u00e7\u00e3o.", e.getStackTrace());
            return false;
        }
    }

    @Override
    public void dataChanged() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    String message = CommunicationTest.this.porta.getInputString();
                    if (!message.equals("")) {
                        CommunicationTest.this.txtReport.append(CommunicationTest.this.parseMessage(message));
                    }
                    CommunicationTest.this.porta.clearInputString();
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace());
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void handShakeCharReceived(char c) {
        this.txtReport.append(this.parseMessage(String.valueOf(c)));
    }

    private String parseMessage(String message) {
        String newMessage = "";
        if (message != null && message.length() > 0) {
            char[] a = message.toCharArray();
            for (int i = 0; i < a.length; ++i) {
                char c = a[i];
                if (c == this.NUL) {
                    newMessage = newMessage + this.sNUL;
                    continue;
                }
                if (c == this.SOH) {
                    newMessage = newMessage + this.sSOH;
                    continue;
                }
                if (c == this.STX) {
                    newMessage = newMessage + this.sSTX;
                    continue;
                }
                if (c == this.ETX) {
                    newMessage = newMessage + this.sETX;
                    continue;
                }
                if (c == this.EOT) {
                    newMessage = newMessage + this.sEOT;
                    continue;
                }
                if (c == this.ENQ) {
                    newMessage = newMessage + this.sENQ;
                    continue;
                }
                if (c == this.ACK) {
                    newMessage = newMessage + this.sACK;
                    continue;
                }
                if (c == this.LF) {
                    newMessage = newMessage + this.sLF;
                    newMessage = newMessage + "\n";
                    continue;
                }
                if (c == this.CR) {
                    if (i + 1 < a.length && a[i + 1] == this.LF) {
                        newMessage = newMessage + this.sLINE;
                        ++i;
                    } else {
                        newMessage = newMessage + this.sCR;
                    }
                    newMessage = newMessage + "\n";
                    continue;
                }
                newMessage = c == this.DLE ? newMessage + this.sDLE : (c == this.NAK ? newMessage + this.sNAK : (c == this.SYN ? newMessage + this.sSYN : (c == this.ETB ? newMessage + this.sETB : (c == this.CAN ? newMessage + this.sCAN : (c == this.SP ? newMessage + this.sSP : (c == this.DEL ? newMessage + this.sDEL : (c == this.FD ? newMessage + this.sFD : (c == this.EB ? newMessage + this.sEB : newMessage + c))))))));
            }
        }
        return newMessage;
    }

    private void configComboAparelho() {
        try {
            this.aparelhos = new ArrayList();
            Statement s = Conexao.getStatement();
            StringBuilder query = new StringBuilder();
            query.append("select * ");
            query.append("from aparelhosinterface ");
            query.append("order by apa_codigo");
            ResultSet rs = Conexao.executeQuery(s, query.toString());
            while (rs.next()) {
                Aparelho a = new Aparelho();
                a.setCodigo(rs.getInt("apa_codigo"));
                a.setNome(rs.getString("apa_nome"));
                a.setClasse(rs.getString("apa_classe"));
                this.aparelhos.add(a);
            }
            this.cbxAparelho.removeAllItems();
            for (Aparelho a : this.aparelhos) {
                this.cbxAparelho.addItem(a);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void loadTesteAparelho(boolean resultado) {
        if (this.cbxAparelho.getSelectedIndex() >= 0) {
            Aparelho a = (Aparelho)this.cbxAparelho.getSelectedItem();
            a.loadInterface();
            if (!resultado) {
                this.txtCommand.setText(this.parseMessage(a.getRequisicao()));
            } else {
                this.txtCommand.setText(this.parseMessage(a.getResultado()));
            }
        }
    }
}

