/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.comunicacao.processararquivo;

import jalis.laboratorio.Laboratorio;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.io.IOException;

public class ProcessaArquivoComunicacao {
    public boolean processarArquivoRxtx() {
        try {
            String[] lbPath;
            String[] bootPath;
            for (String string : bootPath = ProcessaArquivoComunicacao.initializePath("sun.boot.library.path")) {
                if (string.contains("..") || !this.loadLibrary("rxtxSerial", string) && !this.loadLibrary("rxtxParallel", string)) continue;
                return true;
            }
            for (String string : lbPath = ProcessaArquivoComunicacao.initializePath("java.library.path")) {
                if (string.contains(".") || string.contains("..") || !this.loadLibrary("rxtxSerial", string) && !this.loadLibrary("rxtxParallel", string)) continue;
                return true;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel processar dll/so de comunica\u00e7\u00e3o.", e.getStackTrace());
        }
        return false;
    }

    private static String[] initializePath(String propname) {
        String ldpath = System.getProperty(propname, "");
        String ps = File.pathSeparator;
        int ldlen = ldpath.length();
        int i = ldpath.indexOf(ps);
        int n = 0;
        while (i >= 0) {
            ++n;
            i = ldpath.indexOf(ps, i + 1);
        }
        String[] paths = new String[n + 1];
        i = 0;
        n = 0;
        int j = ldpath.indexOf(ps);
        while (j >= 0) {
            if (j - i > 0) {
                paths[n++] = ldpath.substring(i, j);
            } else if (j - i == 0) {
                paths[n++] = ".";
            }
            i = j + 1;
            j = ldpath.indexOf(ps, i);
        }
        paths[n] = ldpath.substring(i, ldlen);
        return paths;
    }

    public boolean loadLibrary(String name, String path) throws IOException {
        String soName = System.mapLibraryName(name);
        File dest = new File(path, soName);
        return dest.exists();
    }
}

