/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.comunicacao.log;

import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.interfaceamento.consulta.LogComunicacaoInterface;
import jalis.laboratorio.interfaceamento.comunicacao.arquivo.Arquivo;
import jalis.laboratorio.interfaceamento.comunicacao.arquivo.ArquivoException;
import jalis.laboratorio.interfaceamento.comunicacao.log.LogArquivoInterface;
import jalis.laboratorio.interfaceamento.comunicacao.log.LogInterfaceamento;
import jalis.laboratorio.interfaceamento.comunicacao.log.LogInterfaceamentoDao;
import jalis.laboratorio.interfaceamento.comunicacao.log.LogInterfaceamentoException;
import jalis.laboratorio.interfaceamento.configuracao.EquipamentoFilial;
import jalis.util.Funcoes;
import java.util.Date;

public class LogInterfaceamentoService {
    private static final String CAMINHO = System.getProperty("user.home").toString() + "/logDadosBrutos.txt";
    private final LogInterfaceamentoDao dao = new LogInterfaceamentoDao();
    private final Arquivo arquivo = new Arquivo(CAMINHO);

    public void escreverArquivo(LogComunicacaoInterface log) throws LogInterfaceamentoException {
        try {
            if (this.isPermitirGravarLog()) {
                String mensagem = this.criarMensagem(log.getLog());
                if (!this.arquivo.existe()) {
                    this.arquivo.criar("");
                }
                mensagem = this.removerLinhaVazia(mensagem);
                this.arquivo.escrever(mensagem);
            }
        }
        catch (ArquivoException e) {
            throw new LogInterfaceamentoException(e);
        }
    }

    public void salvarArquivo(Integer filial, Integer[] codigoInterfaceamento) throws LogInterfaceamentoException {
        try {
            if (this.isPermitirGravarLog()) {
                if (this.arquivo.existe()) {
                    String operacao = this.arquivo.ler();
                    if (!Funcoes.textoVazio(operacao)) {
                        char[] listaComparacao;
                        for (char valor : listaComparacao = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u000b', '\u0010', '\u0011', '\u0015', '\u0016', '\u0017', '\u0018', '\u001c', '\u001d', '\u001e', ' ', '\u007f', '\u00fd', '\u000b'}) {
                            if (!operacao.contains(String.valueOf(valor))) continue;
                            operacao = operacao.replace(String.valueOf(valor), Variaveis.equip.parseMessage(String.valueOf(valor)));
                        }
                        this.salvar(filial, codigoInterfaceamento, operacao);
                    }
                    this.arquivo.excluir();
                } else {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi encontrado o arquivo de comunica\u00e7\u00e3o do equipamento.", 2);
                }
            }
        }
        catch (ArquivoException e) {
            throw new LogInterfaceamentoException(e);
        }
    }

    private void salvar(Integer filial, Integer[] codigoInterfaceamentos, String operacao) throws LogInterfaceamentoException {
        Integer codigo = -1;
        for (Integer codInterfaceamento : codigoInterfaceamentos) {
            LogInterfaceamento log = new LogInterfaceamento(codigo, filial, codInterfaceamento, new Date(), operacao);
            this.dao.save(log);
        }
    }

    private String criarMensagem(String log) throws ArquivoException {
        if (this.arquivo.existe()) {
            StringBuilder mensagem = new StringBuilder(this.arquivo.ler());
            mensagem.append(log + "\n");
            return mensagem.toString();
        }
        return "";
    }

    public void criarArquivo(LogArquivoInterface log) throws LogInterfaceamentoException {
        try {
            if (this.isPermitirGravarLog()) {
                if (this.arquivo.existe()) {
                    this.salvarArquivo(log.getFilial(), log.getInterface());
                }
                this.arquivo.criar("");
            }
        }
        catch (ArquivoException e) {
            throw new LogInterfaceamentoException(e);
        }
    }

    private String removerLinhaVazia(String mensagem) {
        if (this.contemQuantidadeMinima(mensagem)) {
            int tamanho = mensagem.length();
            for (int x = 0; x < tamanho; ++x) {
                if (!this.contemLinhaVazia(mensagem, tamanho)) continue;
                mensagem = mensagem.substring(0, tamanho - 1);
                tamanho = mensagem.length();
            }
        }
        return mensagem;
    }

    private boolean contemQuantidadeMinima(String mensagem) {
        return !Funcoes.textoVazio(mensagem) && mensagem.length() > 3;
    }

    private boolean contemLinhaVazia(String mensagem, int tamanho) {
        return mensagem.substring(tamanho - 3, tamanho).contains("\n\n\n");
    }

    public boolean isPermitirGravarLog() {
        boolean permitirGravarLog = false;
        if (!Variaveis.equipamentos.isEmpty()) {
            for (EquipamentoFilial equipamentoFilial : Variaveis.equipamentos.get(0).getEquipamentos()) {
                permitirGravarLog = permitirGravarLog || equipamentoFilial.isPermitirGravarLog();
            }
        }
        return permitirGravarLog;
    }
}

