/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.comunicacao.log;

import jalis.comum.Conexao;
import jalis.laboratorio.interfaceamento.comunicacao.log.LogInterfaceamento;
import jalis.laboratorio.interfaceamento.comunicacao.log.LogInterfaceamentoException;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;

public class LogInterfaceamentoDao {
    protected static final String[] campos = new String[]{"lin_codigo", "fil_codigo", "int_codigo", "lin_datahora", "lin_operacao"};
    public static final String TABLE = "loginterface";

    private static final String getInsertSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into loginterface(lin_codigo, fil_codigo, int_codigo, lin_datahora, lin_operacao) ");
        sql.append("values(nextval('loginterface_lin_codigo_seq'), ?, ?, ?, ?);");
        return sql.toString();
    }

    public void save(LogInterfaceamento log) throws LogInterfaceamentoException {
        PreparedStatement pr = Conexao.getPreparedStatement(LogInterfaceamentoDao.getInsertSql());
        try {
            pr.setInt(1, log.getCodigoFilial());
            pr.setInt(2, log.getCodigoInterface());
            pr.setTimestamp(3, new Timestamp(log.getDataHora().getTime()));
            String operacao = log.getOperacao();
            if (!Funcoes.textoVazio(operacao)) {
                operacao = StringUtil.trocaCaracterUTF(operacao);
            }
            pr.setString(4, StringUtil.textoDB(operacao));
            pr.execute();
            Conexao.arquivaSQL();
            pr.close();
        }
        catch (SQLException e) {
            throw new LogInterfaceamentoException(e);
        }
    }
}

