/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.comunicacao.arquivo;

import jalis.laboratorio.interfaceamento.comunicacao.arquivo.ArquivoException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;

public class Arquivo {
    private final File file;

    public Arquivo(String caminho) {
        this.file = new File(caminho);
    }

    public void escrever(String mensagem) throws ArquivoException {
        try {
            PrintWriter pw = new PrintWriter(this.file);
            pw.print(mensagem);
            pw.close();
        }
        catch (IOException e) {
            throw new ArquivoException(e);
        }
    }

    public void criar(String mensagem) throws ArquivoException {
        try {
            Path path = this.file.toPath();
            List<String> linhas = Arrays.asList(mensagem.split("\n"));
            Charset charset = Charset.forName("latin1");
            Files.write(path, linhas, charset, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ArquivoException(e);
        }
    }

    public boolean existe() {
        return this.file.exists();
    }

    public String ler() throws ArquivoException {
        try {
            return new String(Files.readAllBytes(this.file.toPath()));
        }
        catch (IOException e) {
            throw new ArquivoException(e);
        }
    }

    public void excluir() throws ArquivoException {
        if (!this.file.delete()) {
            throw new ArquivoException("N\u00e3o foi possivel excluir o arquivo");
        }
    }
}

