/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.comunicacao;

import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.DataChangedListener;
import jalis.laboratorio.interfaceamento.comunicacao.LogFileListener;
import jalis.laboratorio.interfaceamento.comunicacao.LogListener;
import jalis.laboratorio.interfaceamento.comunicacao.SoftHandShakeListener;
import jalis.util.logger.ErrorLogger;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;

public class PortaSocketSingle
extends AbstractPort {
    private String stringInput = "";
    private DataOutputStream os;
    private BufferedInputStream is;
    private Socket socket;
    private String address;
    private int porta;
    private boolean executando = false;
    protected ArrayList<DataChangedListener> data_changed_listeners;
    protected ArrayList<SoftHandShakeListener> soft_handshake_listeners;

    @Override
    @Deprecated
    public void open(String address) throws Exception {
    }

    public void open(String address, int porta) throws IOException {
        this.data_changed_listeners = new ArrayList();
        this.soft_handshake_listeners = new ArrayList();
        this.log_listeners = new ArrayList();
        this.log_file_listeners = new ArrayList();
        this.stringInput = "";
        this.initSocket(address, porta);
        this.address = address;
        this.porta = porta;
    }

    public boolean isOpened() {
        return this.socket != null && this.socket.isConnected();
    }

    private void initSocket(String address, int porta) throws IOException {
        this.socket = new Socket(address, porta);
        this.is = new BufferedInputStream(this.socket.getInputStream());
        this.os = new DataOutputStream(this.socket.getOutputStream());
        this.executando = true;
        Thread threadReadInput = new Thread(){

            @Override
            public void run() {
                while (PortaSocketSingle.this.executando) {
                    PortaSocketSingle.this.readInput();
                    try {
                        1.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        threadReadInput.start();
    }

    private void reconecta() throws IOException {
        this.close();
        this.initSocket(this.address, this.porta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String messageString) throws IOException {
        this.log(messageString);
        if (this.isOpened() && messageString.length() > 0) {
            this.fireOutputLog(messageString);
            this.fireOutputLogFile(messageString);
            try {
                DataOutputStream dataOutputStream = this.os;
                synchronized (dataOutputStream) {
                    this.os.writeBytes(messageString);
                    this.os.flush();
                }
            }
            catch (IOException e) {
                this.reconecta();
                this.os.writeBytes(messageString);
                this.os.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.executando = false;
            this.os.close();
            DataOutputStream dataOutputStream = this.os;
            synchronized (dataOutputStream) {
                this.os.close();
            }
            this.socket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String removeInputString(String delimitador) {
        if (this.stringInput.indexOf(delimitador) >= 0) {
            int delsize = delimitador.length();
            String head = this.stringInput.substring(0, this.stringInput.indexOf(delimitador) + delsize);
            this.stringInput = this.stringInput.substring(this.stringInput.indexOf(delimitador) + delsize);
            return head;
        }
        return "";
    }

    public String removeInputString(int delimitador) {
        if (this.stringInput.length() > delimitador) {
            String head = this.stringInput.substring(0, delimitador);
            this.stringInput = this.stringInput.substring(delimitador);
            return head;
        }
        return "";
    }

    public int getStringInputLength() {
        return this.stringInput.length();
    }

    public synchronized void readInput() {
        if (this.socket == null) {
            return;
        }
        try {
            byte[] readBuffer = new byte[this.is.available()];
            int numBytes = this.is.read(readBuffer);
            String tempString = new String(readBuffer, 0, numBytes);
            if (numBytes == 1) {
                char c = tempString.charAt(0);
                if (this.isHandShakeChar(c)) {
                    this.fireInputLog(tempString);
                    this.fireInputLogFile(tempString);
                    this.fireInputSoftHandshake(c);
                } else {
                    this.stringInput = this.stringInput + tempString;
                    this.fireInputLog(tempString);
                    this.fireInputLogFile(tempString);
                    this.fireInputChanged();
                }
            } else if (tempString != null && !tempString.isEmpty()) {
                this.stringInput = this.stringInput + tempString;
                this.fireInputLog(tempString);
                this.fireInputLogFile(tempString);
                this.fireInputChanged();
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortSocket:228");
        }
    }

    private void fireInputChanged() {
        if (this.socket == null) {
            return;
        }
        for (DataChangedListener listener : this.data_changed_listeners) {
            listener.dataChanged();
        }
    }

    private void fireInputSoftHandshake(char c) {
        if (this.socket == null) {
            return;
        }
        for (SoftHandShakeListener listener : this.soft_handshake_listeners) {
            listener.handShakeCharReceived(c);
        }
    }

    private void fireInputLog(String log) {
        for (LogListener listener : this.log_listeners) {
            listener.inputLog(log);
        }
    }

    private void fireOutputLog(String log) {
        for (LogListener listener : this.log_listeners) {
            listener.outputLog(log);
        }
    }

    private void fireInputLogFile(String log) {
        for (LogFileListener listener : this.log_file_listeners) {
            listener.inputLogFile(log);
        }
    }

    private void fireOutputLogFile(String log) {
        for (LogFileListener listener : this.log_file_listeners) {
            listener.outputLogFile(log);
        }
    }

    public boolean isHandShakeChar(char c) {
        return c == this.ACK || c == this.NAK || c == this.ENQ || c == this.SYN || c == this.DEL || c == this.CAN || c == this.NUL || c == this.EOT || c == this.DLE || c == this.STX;
    }

    @Override
    @Deprecated
    public void flush() {
    }

    @Override
    public void clearInputString() {
        this.stringInput = "";
    }

    @Override
    public String getInputString() {
        return this.stringInput;
    }

    @Override
    public void removeHandshakeAndDataListeners() {
        if (this.socket != null) {
            this.data_changed_listeners.clear();
            this.soft_handshake_listeners.clear();
        }
    }

    @Override
    public void addDataChangedListener(DataChangedListener listener) {
        if (!this.data_changed_listeners.contains(listener)) {
            this.data_changed_listeners.add(listener);
        }
    }

    @Override
    public void addSoftHandShakeListener(SoftHandShakeListener listener) {
        if (!this.soft_handshake_listeners.contains(listener)) {
            this.soft_handshake_listeners.add(listener);
        }
    }

    @Override
    public void read(String tempString, int numBytes) {
        try {
            this.log(tempString);
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        if (numBytes == 1) {
            char c = tempString.charAt(0);
            if (this.isHandShakeChar(c)) {
                this.fireInputLog(tempString);
                this.fireInputLogFile(tempString);
                this.fireInputSoftHandshake(c);
            } else {
                this.stringInput = this.stringInput + tempString;
                this.fireInputLog(tempString);
                this.fireInputLogFile(tempString);
                this.fireInputChanged();
            }
        } else if (tempString != null && !tempString.isEmpty()) {
            this.stringInput = this.stringInput + tempString;
            this.fireInputLog(tempString);
            this.fireInputLogFile(tempString);
            this.fireInputChanged();
        }
    }
}

