/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.comunicacao;

import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.DataChangedListenerInput;
import jalis.laboratorio.interfaceamento.comunicacao.DataChangedListenerOutput;
import jalis.laboratorio.interfaceamento.comunicacao.LogListener;
import jalis.laboratorio.interfaceamento.comunicacao.SoftHandShakeListenerInput;
import jalis.laboratorio.interfaceamento.comunicacao.SoftHandShakeListenerOutput;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;

public class PortaSocketServerTriplex
extends AbstractPort {
    private StringBuilder stringInput = new StringBuilder();
    private String lastInput = "";
    private StringBuilder stringOutput = new StringBuilder();
    private String lastOutput = "";
    private StringBuilder stringInputTriplex = new StringBuilder();
    private String lastInputTriplex = "";
    private BufferedInputStream inIs;
    private DataOutputStream inOs;
    private DataOutputStream outOs;
    private BufferedInputStream outIs;
    private DataOutputStream inOsTriplex;
    private BufferedInputStream inIsTriplex;
    private Socket socketIn;
    private Socket socketInTriplex;
    private Socket socketOut;
    private String address;
    private boolean executando = false;
    private boolean buscaHandshakeMensagemInteira = false;
    private int portaIn;
    private int portaOut;
    private int portaInTriplex;
    private boolean escreverEmBytes = true;
    protected ArrayList<DataChangedListenerInput> data_changed_listeners_input;
    protected ArrayList<SoftHandShakeListenerInput> soft_handshake_listeners_input;
    protected ArrayList<DataChangedListenerInput> data_changed_listeners_inputTriplex;
    protected ArrayList<SoftHandShakeListenerInput> soft_handshake_listeners_inputTriplex;
    protected ArrayList<DataChangedListenerOutput> data_changed_listeners_output;
    protected ArrayList<SoftHandShakeListenerOutput> soft_handshake_listeners_output;
    private boolean ignoraSTX = false;
    private ServerSocket serverIn;
    private Socket serverOut;
    private ServerSocket serverInTriplex;

    @Override
    @Deprecated
    public void open(String address) throws Exception {
    }

    public void open(String address, int portaIn, int portaOut, int portaInTriplex) throws IOException {
        this.escreverLog("Inicializando o socket", new Date());
        this.log_listeners = new ArrayList();
        this.stringInput = new StringBuilder();
        this.data_changed_listeners_input = new ArrayList();
        this.data_changed_listeners_output = new ArrayList();
        this.data_changed_listeners_inputTriplex = new ArrayList();
        this.soft_handshake_listeners_input = new ArrayList();
        this.soft_handshake_listeners_output = new ArrayList();
        this.soft_handshake_listeners_inputTriplex = new ArrayList();
        this.lastInputTriplex = "";
        this.stringInputTriplex = new StringBuilder();
        this.stringOutput = new StringBuilder();
        this.lastOutput = "";
        this.stringInput = new StringBuilder();
        this.lastInput = "";
        this.escreverLog("Abrindo o socket!", new Date());
        this.initSocket(address, portaOut, portaIn, portaInTriplex);
        this.address = address;
        this.portaIn = portaIn;
        this.portaOut = portaOut;
        this.portaInTriplex = portaInTriplex;
        this.escreverLog("Socket Aberto!", new Date());
        this.aguardaConexao();
    }

    private void initSocket(String address2, int portaOutput, int portaInput, int portaInputTriplex) throws IOException {
        if (portaOutput != portaInput) {
            this.escreverLog("Abrindo porta de entrada " + portaInput, new Date());
            this.serverIn = new ServerSocket(portaInput);
        }
        if (portaOutput != portaInputTriplex && portaInput != portaInputTriplex) {
            this.escreverLog("Abrindo porta de envio " + portaInputTriplex, new Date());
            this.serverInTriplex = new ServerSocket(portaInputTriplex);
        }
        this.escreverLog("Abrindo porta de envio " + portaOutput, new Date());
        this.executando = true;
    }

    public boolean isOpened() {
        return this.socketIn != null && this.socketIn.isConnected() && this.socketInTriplex != null && this.socketInTriplex.isConnected();
    }

    public void setEscreverEmBytes(boolean escreverEmBytes) {
        this.escreverEmBytes = escreverEmBytes;
    }

    private void aguardaConexao() throws IOException {
        Thread threadAguardaConexaoIn = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        PortaSocketServerTriplex.this.escreverLog("Esperando conex\u00e3o de saida!", new Date());
                        PortaSocketServerTriplex.this.socketIn = PortaSocketServerTriplex.this.serverIn.accept();
                        PortaSocketServerTriplex.this.escreverLog("Aceitou a conex\u00e3o!", new Date());
                        PortaSocketServerTriplex.this.inIs = new BufferedInputStream(PortaSocketServerTriplex.this.socketIn.getInputStream());
                        PortaSocketServerTriplex.this.inOs = new DataOutputStream(PortaSocketServerTriplex.this.socketIn.getOutputStream());
                        PortaSocketServerTriplex.this.executando = true;
                        PortaSocketServerTriplex.this.escreverLog("Abrindo Thread de leitura!", new Date());
                        Thread threadReadInput = new Thread(){

                            @Override
                            public void run() {
                                PortaSocketServerTriplex.this.escreverLog("Thread de leitura Iniciada!", new Date());
                                while (PortaSocketServerTriplex.this.executando) {
                                    PortaSocketServerTriplex.this.readInput();
                                    try {
                                        1.sleep(50L);
                                    }
                                    catch (InterruptedException e) {
                                        System.out.println("Exception in");
                                    }
                                }
                            }
                        };
                        threadReadInput.start();
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
        };
        threadAguardaConexaoIn.start();
        Thread threadAguardaConexaoInTriplex = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        PortaSocketServerTriplex.this.escreverLog("Esperando conex\u00e3o de entrada!", new Date());
                        PortaSocketServerTriplex.this.socketInTriplex = PortaSocketServerTriplex.this.serverInTriplex.accept();
                        PortaSocketServerTriplex.this.escreverLog("Aceitou a conex\u00e3o!", new Date());
                        PortaSocketServerTriplex.this.inIsTriplex = new BufferedInputStream(PortaSocketServerTriplex.this.socketInTriplex.getInputStream());
                        PortaSocketServerTriplex.this.inOsTriplex = new DataOutputStream(PortaSocketServerTriplex.this.socketInTriplex.getOutputStream());
                        PortaSocketServerTriplex.this.executando = true;
                        PortaSocketServerTriplex.this.escreverLog("Abrindo Thread de leitura!", new Date());
                        Thread threadReadInputTriplex = new Thread(){

                            @Override
                            public void run() {
                                PortaSocketServerTriplex.this.escreverLog("Thread de leitura Iniciada!", new Date());
                                while (PortaSocketServerTriplex.this.executando) {
                                    PortaSocketServerTriplex.this.readInputTriplex();
                                    try {
                                        1.sleep(50L);
                                    }
                                    catch (InterruptedException e) {
                                        System.out.println("Exception tri");
                                    }
                                }
                            }
                        };
                        threadReadInputTriplex.start();
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    return;
                }
            }
        };
        threadAguardaConexaoInTriplex.start();
    }

    @Override
    @Deprecated
    public void write(String messageString) throws IOException {
        this.log(messageString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeIn(String messageString) throws IOException {
        this.log(messageString);
        this.escreverLog("Tentando escrever dados na porta!", new Date());
        if (this.socketIn != null && this.socketIn.isConnected() && messageString.length() > 0) {
            this.fireOutputLog("(In)" + this.portaIn + messageString);
            try {
                DataOutputStream dataOutputStream = this.inOs;
                synchronized (dataOutputStream) {
                    this.lastInput = messageString;
                    if (this.escreverEmBytes) {
                        this.inOs.write(messageString.getBytes());
                    } else {
                        this.inOs.writeUTF(messageString);
                    }
                    this.inOs.flush();
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortSocket:124");
                this.closeSocket();
                this.aguardaConexao();
            }
        }
        if ((!this.isOpened() || Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "interfaceTeste.jalis")) && messageString.length() > 0) {
            this.fireOutputLog("(In)" + this.portaIn + messageString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeInTriplex(String messageString) throws IOException {
        this.log(messageString);
        this.escreverLog("Tentando escrever dados na porta!", new Date());
        if (this.socketInTriplex != null && this.socketInTriplex.isConnected() && messageString.length() > 0) {
            this.fireOutputLog("(In)" + this.portaInTriplex + messageString);
            try {
                BufferedInputStream bufferedInputStream = this.inIsTriplex;
                synchronized (bufferedInputStream) {
                    this.lastInputTriplex = messageString;
                    if (this.escreverEmBytes) {
                        this.inOsTriplex.write(messageString.getBytes());
                    } else {
                        this.inOsTriplex.writeUTF(messageString);
                    }
                    this.inOsTriplex.flush();
                    this.escreverLog("Dados escritos na porta!", new Date());
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortSocket:124");
                this.closeSocket();
                this.aguardaConexao();
            }
        }
    }

    public void writeOut(String messageString) throws IOException {
        this.socketOut = new Socket(this.address, this.portaOut);
        try {
            this.outIs = new BufferedInputStream(this.socketOut.getInputStream());
            this.outOs = new DataOutputStream(this.socketOut.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.socketOut != null && this.socketOut.isConnected() && messageString.length() > 0) {
            try {
                if (this.outOs != null) {
                    this.outOs.flush();
                    this.fireOutputLog("(Out" + this.portaOut + ") " + messageString);
                    this.outOs.write(messageString.toString().getBytes());
                    this.outOs.flush();
                }
                try {
                    Thread tout = new Thread(){

                        @Override
                        public void run() {
                            while (PortaSocketServerTriplex.this.executando) {
                                PortaSocketServerTriplex.this.readOutput();
                                try {
                                    3.sleep(50L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                    };
                    tout.start();
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSocket() {
        try {
            DataOutputStream dataOutputStream;
            this.escreverLog("Fechando Socket!", new Date());
            this.executando = false;
            if (this.inOs != null) {
                this.inOs.close();
                dataOutputStream = this.inOs;
                synchronized (dataOutputStream) {
                    this.inOs.close();
                }
            }
            if (this.socketIn != null) {
                this.socketIn.close();
                this.socketIn = null;
            }
            if (this.inOsTriplex != null) {
                this.inOsTriplex.close();
                dataOutputStream = this.inOsTriplex;
                synchronized (dataOutputStream) {
                    this.inOsTriplex.close();
                }
            }
            if (this.socketInTriplex != null) {
                this.socketInTriplex.close();
                this.socketInTriplex = null;
            }
            this.escreverLog("Socket Fechado!", new Date());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        try {
            this.closeSocket();
            if (this.serverIn != null) {
                this.serverIn.close();
            }
            if (this.serverInTriplex != null) {
                this.serverInTriplex.close();
            }
            if (this.serverOut != null) {
                this.serverOut.close();
            }
            this.serverIn = null;
            this.serverOut = null;
            this.serverInTriplex = null;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortSocket:146");
        }
    }

    @Override
    public String removeInputString(String delimitador) {
        if (this.stringInput.toString().indexOf(delimitador) >= 0) {
            int delsize = delimitador.length();
            String head = this.stringInput.substring(0, this.stringInput.indexOf(delimitador) + delsize);
            this.stringInput = new StringBuilder(this.stringInput.substring(this.stringInput.indexOf(delimitador) + delsize));
            return head;
        }
        return "";
    }

    public String removeInputStringTriplex(String delimitador) {
        if (this.stringInputTriplex.toString().indexOf(delimitador) >= 0) {
            int delsize = delimitador.length();
            String head = this.stringInputTriplex.substring(0, this.stringInputTriplex.indexOf(delimitador) + delsize);
            this.stringInputTriplex = new StringBuilder(this.stringInputTriplex.substring(this.stringInputTriplex.indexOf(delimitador) + delsize));
            return head;
        }
        return "";
    }

    public String removeOutputString(String delimitador) {
        if (this.stringOutput.toString().indexOf(delimitador) >= 0) {
            int delsize = delimitador.length();
            String head = this.stringOutput.substring(0, this.stringOutput.indexOf(delimitador) + delsize);
            this.stringOutput = new StringBuilder(this.stringOutput.substring(this.stringOutput.indexOf(delimitador) + delsize));
            return head;
        }
        return "";
    }

    public String removeInputString(int delimitador) {
        if (this.stringInput.toString().length() > delimitador) {
            String head = this.stringInput.substring(0, delimitador);
            this.stringInput = new StringBuilder(this.stringInput.substring(delimitador));
            return head;
        }
        return "";
    }

    public int getStringInputLength() {
        return this.stringInput.length();
    }

    public int getStringInputTriplexLength() {
        return this.stringInputTriplex.length();
    }

    public synchronized void readInputTriplex() {
        if (this.socketInTriplex == null) {
            return;
        }
        int numBytes = 0;
        try {
            byte[] readBuffer = new byte[this.inIsTriplex.available()];
            String tempString = "";
            numBytes = this.inIsTriplex.read(readBuffer);
            tempString = tempString + new String(readBuffer, 0, numBytes);
            if (this.buscaHandshakeMensagemInteira) {
                String mensagemParcial = "";
                for (char c : tempString.toCharArray()) {
                    if (this.isHandShakeChar(c)) {
                        if (!mensagemParcial.isEmpty()) {
                            this.stringInputTriplex.append(mensagemParcial);
                            this.fireInputLog("(in)" + this.portaInTriplex + mensagemParcial);
                            this.fireInputChanged();
                            mensagemParcial = "";
                        }
                        this.fireInputLog(String.valueOf(c));
                        this.fireHandShakeCharReceivedInput(c);
                        continue;
                    }
                    mensagemParcial = mensagemParcial + c;
                }
                if (!mensagemParcial.isEmpty()) {
                    this.stringInputTriplex.append(mensagemParcial);
                    this.fireInputLog("(IN)" + this.portaInTriplex + mensagemParcial);
                    this.fireInputChanged();
                }
            } else if (tempString != null && tempString.length() > 0) {
                this.escreverLog("Dados lidos na porta!", new Date());
                this.fireInputLog("(IN)" + this.portaInTriplex + tempString);
                if (tempString.length() == 1 && this.isHandShakeChar(tempString.charAt(0))) {
                    this.fireHandShakeCharReceivedInput(tempString.charAt(0));
                } else {
                    this.stringInputTriplex.append(tempString);
                    this.fireInputTriplexChanged();
                }
            }
            this.log(tempString);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortSocket:228");
            this.closeSocket();
            try {
                this.aguardaConexao();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public synchronized void readInputTriplex(String message) {
        int numBytes = 0;
        try {
            byte[] readBuffer = message.getBytes();
            String tempString = "";
            numBytes = message.length();
            tempString = tempString + new String(readBuffer, 0, numBytes);
            if (this.buscaHandshakeMensagemInteira) {
                String mensagemParcial = "";
                for (char c : tempString.toCharArray()) {
                    if (this.isHandShakeChar(c)) {
                        if (!mensagemParcial.isEmpty()) {
                            this.stringInputTriplex.append(mensagemParcial);
                            this.fireInputLog("(in)" + this.portaInTriplex + mensagemParcial);
                            this.fireInputChanged();
                            mensagemParcial = "";
                        }
                        this.fireInputLog(String.valueOf(c));
                        this.fireHandShakeCharReceivedInput(c);
                        continue;
                    }
                    mensagemParcial = mensagemParcial + c;
                }
                if (!mensagemParcial.isEmpty()) {
                    this.stringInputTriplex.append(mensagemParcial);
                    this.fireInputLog("(IN)" + this.portaInTriplex + mensagemParcial);
                    this.fireInputChanged();
                }
            } else if (tempString != null && tempString.length() > 0) {
                this.escreverLog("Dados lidos na porta!", new Date());
                this.fireInputLog("(IN)" + this.portaInTriplex + tempString);
                if (tempString.length() == 1 && this.isHandShakeChar(tempString.charAt(0))) {
                    this.fireHandShakeCharReceivedInput(tempString.charAt(0));
                } else {
                    this.stringInputTriplex.append(tempString);
                    this.fireInputTriplexChanged();
                }
            }
            this.log(tempString);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortSocket:228");
            this.closeSocket();
            try {
                this.aguardaConexao();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public synchronized void readInput() {
        if (this.socketIn == null) {
            return;
        }
        int numBytes = 0;
        try {
            byte[] readBuffer = new byte[this.inIs.available()];
            String tempString = "";
            numBytes = this.inIs.read(readBuffer);
            tempString = tempString + new String(readBuffer, 0, numBytes);
            if (this.buscaHandshakeMensagemInteira) {
                String mensagemParcial = "";
                for (char c : tempString.toCharArray()) {
                    if (this.isHandShakeChar(c)) {
                        if (!mensagemParcial.isEmpty()) {
                            this.stringInput.append(mensagemParcial);
                            this.fireInputLog("(IN)" + this.portaIn + mensagemParcial);
                            this.fireInputChanged();
                            mensagemParcial = "";
                        }
                        this.fireInputLog(String.valueOf(c));
                        this.fireHandShakeCharReceivedInput(c);
                        continue;
                    }
                    mensagemParcial = mensagemParcial + c;
                }
                if (!mensagemParcial.isEmpty()) {
                    this.stringInput.append(mensagemParcial);
                    this.fireInputLog("(IN)" + this.portaIn + mensagemParcial);
                    this.fireInputChanged();
                }
            } else if (tempString != null && tempString.length() > 0) {
                this.escreverLog("Dados lidos na porta!", new Date());
                this.fireInputLog("(IN)" + this.portaIn + tempString);
                if (tempString.length() == 1 && this.isHandShakeChar(tempString.charAt(0))) {
                    this.fireHandShakeCharReceivedInput(tempString.charAt(0));
                } else {
                    this.stringInput.append(tempString);
                    this.fireInputChanged();
                }
            }
            this.log(tempString);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortSocket:228");
            this.closeSocket();
            try {
                this.aguardaConexao();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public synchronized void readInput(String message) {
        int numBytes = 0;
        try {
            byte[] readBuffer = message.getBytes();
            String tempString = "";
            numBytes = message.length();
            tempString = tempString + new String(readBuffer, 0, numBytes);
            if (this.buscaHandshakeMensagemInteira) {
                String mensagemParcial = "";
                for (char c : tempString.toCharArray()) {
                    if (this.isHandShakeChar(c)) {
                        if (!mensagemParcial.isEmpty()) {
                            this.stringInput.append(mensagemParcial);
                            this.fireInputLog("(IN)" + this.portaIn + mensagemParcial);
                            this.fireInputChanged();
                            mensagemParcial = "";
                        }
                        this.fireInputLog(String.valueOf(c));
                        this.fireHandShakeCharReceivedInput(c);
                        continue;
                    }
                    mensagemParcial = mensagemParcial + c;
                }
                if (!mensagemParcial.isEmpty()) {
                    this.stringInput.append(mensagemParcial);
                    this.fireInputLog("(IN)" + this.portaIn + mensagemParcial);
                    this.fireInputChanged();
                }
            } else if (tempString != null && tempString.length() > 0) {
                this.escreverLog("Dados lidos na porta!", new Date());
                this.fireInputLog("(IN)" + this.portaIn + tempString);
                if (tempString.length() == 1 && this.isHandShakeChar(tempString.charAt(0))) {
                    this.fireHandShakeCharReceivedInput(tempString.charAt(0));
                } else {
                    this.stringInput.append(tempString);
                    this.fireInputChanged();
                }
            }
            this.fireInputLog("(IN)" + this.portaIn + tempString);
            this.log(tempString);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortSocket:228");
            this.closeSocket();
            try {
                this.aguardaConexao();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public synchronized void readOutput() {
        if (this.socketOut == null) {
            return;
        }
        int numBytes = 0;
        try {
            byte[] readBuffer = new byte[this.outIs.available()];
            String tempString = "";
            numBytes = this.outIs.read(readBuffer);
            tempString = tempString + new String(readBuffer, 0, numBytes);
            if (this.buscaHandshakeMensagemInteira) {
                String mensagemParcial = "";
                for (char c : tempString.toCharArray()) {
                    if (this.isHandShakeChar(c)) {
                        if (!mensagemParcial.isEmpty()) {
                            this.stringOutput.append(mensagemParcial);
                            this.fireOutputLog("(out)" + this.portaOut + mensagemParcial);
                            this.fireOutputChanged();
                            mensagemParcial = "";
                        }
                        this.fireOutputLog(String.valueOf(c));
                        this.fireHandShakeCharReceivedOutput(c);
                        continue;
                    }
                    mensagemParcial = mensagemParcial + c;
                }
                if (!mensagemParcial.isEmpty()) {
                    this.stringOutput.append(mensagemParcial);
                    this.fireInputLog("(out)" + this.portaOut + mensagemParcial);
                    this.fireOutputChanged();
                }
            } else if (tempString != null && tempString.length() > 0) {
                this.escreverLog("Dados lidos na porta!", new Date());
                this.fireOutputLog(tempString);
                if (tempString.length() == 1 && this.isHandShakeChar(tempString.charAt(0))) {
                    this.fireHandShakeCharReceivedOutput(tempString.charAt(0));
                } else {
                    this.stringOutput.append(tempString);
                    this.fireOutputChanged();
                }
            }
            this.log(tempString);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortSocket:228");
            this.closeSocket();
            try {
                this.aguardaConexao();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public synchronized void readOutput(String tempo) {
        int numBytes = 0;
        try {
            byte[] readBuffer = tempo.getBytes();
            numBytes = tempo.length();
            String tempString = new String(readBuffer, 0, numBytes);
            if (this.buscaHandshakeMensagemInteira) {
                String mensagemParcial = "";
                for (char c : tempString.toCharArray()) {
                    if (this.isHandShakeChar(c)) {
                        if (!mensagemParcial.isEmpty()) {
                            this.stringOutput.append(mensagemParcial);
                            this.fireInputLog("(out)" + this.portaOut + mensagemParcial);
                            this.fireInputChanged();
                            mensagemParcial = "";
                        }
                        this.fireInputLog(String.valueOf(c));
                        this.fireHandShakeCharReceivedOutput(c);
                        continue;
                    }
                    mensagemParcial = mensagemParcial + c;
                }
                if (!mensagemParcial.isEmpty()) {
                    this.stringOutput.append(mensagemParcial);
                    this.fireInputLog("(out)" + this.portaOut + mensagemParcial);
                    this.fireOutputChanged();
                }
            } else if (tempString != null && tempString.length() > 0) {
                this.escreverLog("Dados lidos na porta!", new Date());
                this.fireInputLog(tempString);
                if (tempString.length() == 1 && this.isHandShakeChar(tempString.charAt(0))) {
                    this.fireHandShakeCharReceivedOutput(tempString.charAt(0));
                } else {
                    this.stringOutput.append(tempString);
                    this.fireOutputChanged();
                }
            }
            this.log(tempString);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortSocket:228");
            this.closeSocket();
            try {
                this.aguardaConexao();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void fireInputChanged() {
        for (DataChangedListenerInput tmp : this.data_changed_listeners_input) {
            tmp.dataChangedInput();
        }
    }

    private void fireInputTriplexChanged() {
        for (DataChangedListenerInput tmp : this.data_changed_listeners_inputTriplex) {
            tmp.dataChangedInputTriplex();
        }
    }

    private void fireHandShakeCharReceivedInputTriplex(char c) {
        for (SoftHandShakeListenerOutput softHandShakeListenerOutput : this.soft_handshake_listeners_inputTriplex) {
            softHandShakeListenerOutput.handShakeCharReceivedOutput(c);
        }
    }

    private void fireHandShakeCharReceivedOutput(char c) {
        for (SoftHandShakeListenerOutput tmp : this.soft_handshake_listeners_output) {
            tmp.handShakeCharReceivedOutput(c);
        }
    }

    private void fireHandShakeCharReceivedInput(char c) {
        for (SoftHandShakeListenerInput tmp : this.soft_handshake_listeners_input) {
            tmp.handShakeCharReceivedInput(c);
        }
    }

    private void fireInputLog(String log) {
        for (LogListener tmp : this.log_listeners) {
            tmp.inputLog(log);
        }
    }

    private void fireOutputLog(String log) {
        for (LogListener tmp : this.log_listeners) {
            tmp.outputLog(log);
        }
    }

    public String removeStringInput(String delimitador) {
        if (this.stringInput.indexOf(delimitador) >= 0) {
            int delsize = delimitador.length();
            String head = this.stringInput.substring(0, this.stringInput.indexOf(delimitador) + delsize);
            this.stringInput = new StringBuilder(this.stringInput.substring(this.stringInput.indexOf(delimitador) + delsize));
            return head;
        }
        return "";
    }

    public String removeStringInputTriplex(String delimitador) {
        if (this.stringInputTriplex.indexOf(delimitador) >= 0) {
            int delsize = delimitador.length();
            String head = this.stringInputTriplex.substring(0, this.stringInputTriplex.indexOf(delimitador) + delsize);
            this.stringInputTriplex = new StringBuilder(this.stringInputTriplex.substring(this.stringInputTriplex.indexOf(delimitador) + delsize));
            return head;
        }
        return "";
    }

    public String removeStringOutput(String delimitador) {
        if (this.stringOutput.indexOf(delimitador) >= 0) {
            int delsize = delimitador.length();
            String head = this.stringOutput.substring(0, this.stringOutput.indexOf(delimitador) + delsize);
            this.stringOutput = new StringBuilder(this.stringOutput.substring(this.stringOutput.indexOf(delimitador) + delsize));
            return head;
        }
        return "";
    }

    public int getStringOutputLength() {
        return this.stringOutput.length();
    }

    public void clearStringOutput() {
        this.stringOutput.setLength(0);
    }

    private void fireOutputChanged() {
        for (DataChangedListenerOutput tmp : this.data_changed_listeners_output) {
            tmp.dataChangedOutput();
        }
    }

    public boolean isHandShakeChar(char c) {
        return c == this.ACK || c == this.NAK || c == this.ENQ || c == this.SYN || c == this.DEL || c == this.CAN || c == this.NUL || c == this.EOT || c == this.DLE || c == this.DC1;
    }

    private String replaceSpecialChars(String s) {
        s = s.replaceAll(String.valueOf(this.SOH), "<SOH>");
        s = s.replaceAll(String.valueOf(this.STX), "<STX>");
        s = s.replaceAll(String.valueOf(this.ETX), "<ETX>");
        s = s.replaceAll(String.valueOf(this.EOT), "<EOT>");
        s = s.replaceAll(String.valueOf(this.ACK), "<ACK>");
        s = s.replaceAll(String.valueOf(this.NAK), "<NAK>");
        s = s.replaceAll(String.valueOf(this.DEL), "<DEL>");
        s = s.replaceAll(String.valueOf(this.DLE), "<DLE>");
        s = s.replaceAll(String.valueOf(this.ENQ), "<ENQ>");
        s = s.replaceAll(String.valueOf(this.SYN), "<SYN>");
        s = s.replaceAll(String.valueOf(this.ETB), "<ETB>");
        s = s.replaceAll(String.valueOf(this.CAN), "<CAN>");
        s = s.replaceAll(String.valueOf(this.NUL), "<NUL>");
        s = s.replaceAll(String.valueOf(this.LF), "<LF>");
        s = s.replaceAll(String.valueOf(this.CR), "<CR>");
        s = s.replaceAll(String.valueOf(this.SP), "<SP>");
        return s;
    }

    @Override
    @Deprecated
    public void flush() {
    }

    @Override
    public void clearInputString() {
        if (this.stringInput != null) {
            this.stringInput.setLength(0);
        }
    }

    @Override
    public String getInputString() {
        return this.stringInput.toString();
    }

    public String getInputTriplexString() {
        return this.stringInputTriplex.toString();
    }

    public String getOutputString() {
        return this.stringOutput.toString();
    }

    @Override
    public void removeHandshakeAndDataListeners() {
        if (this.socketIn != null) {
            this.data_changed_listeners_input.clear();
            this.soft_handshake_listeners_input.clear();
        }
        if (this.socketInTriplex != null) {
            this.data_changed_listeners_inputTriplex.clear();
            this.soft_handshake_listeners_inputTriplex.clear();
        }
        if (this.socketOut != null) {
            this.data_changed_listeners_output.clear();
            this.soft_handshake_listeners_output.clear();
        }
    }

    public void addDataChangedListenerOutput(DataChangedListenerOutput listener) {
        if (!this.data_changed_listeners_output.contains(listener)) {
            this.data_changed_listeners_output.add(listener);
        }
    }

    public void addDataChangedListenerInput(DataChangedListenerInput listener) {
        if (!this.data_changed_listeners_input.contains(listener)) {
            this.data_changed_listeners_input.add(listener);
        }
    }

    public void addDataChangedListenerInputTriplex(DataChangedListenerInput listener) {
        if (!this.data_changed_listeners_inputTriplex.contains(listener)) {
            this.data_changed_listeners_inputTriplex.add(listener);
        }
    }

    public void addSoftHandShakeListenerInput(SoftHandShakeListenerInput listener) {
        if (!this.soft_handshake_listeners_input.contains(listener)) {
            this.soft_handshake_listeners_input.add(listener);
        }
    }

    public void addSoftHandShakeListenerInputTriplex(SoftHandShakeListenerInput listener) {
        if (!this.soft_handshake_listeners_inputTriplex.contains(listener)) {
            this.soft_handshake_listeners_inputTriplex.add(listener);
        }
    }

    public void addSoftHandShakeListenerOutput(SoftHandShakeListenerOutput listener) {
        if (!this.soft_handshake_listeners_output.contains(listener)) {
            this.soft_handshake_listeners_output.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void escreverLog(String texto, Date data) {
        String nomeArquivo = System.getProperty("user.home").toString() + "/.socket.log";
        texto = Funcoes.formataData("dd/MM/yyyy HH:mm:ss", data) + " - " + texto + "\t- " + Variaveis.login;
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(nomeArquivo, true));
            out.write(texto + "\n");
            out.flush();
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortSocket:392");
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void read(String tempString, int numBytes) {
        try {
            this.log(tempString);
            this.escreverLog("Dados lidos na porta!", new Date());
            this.fireInputLog(tempString);
            if (this.contemSomenteUmChar(tempString) && this.isHandShakeChar(tempString.charAt(0))) {
                this.fireHandShakeCharReceivedOutput(tempString.charAt(0));
            } else {
                this.stringInput.append(tempString);
                this.fireInputChanged();
            }
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        if (tempString != null && tempString.length() > 0) {
            this.stringInput.append(tempString);
            this.fireInputLog(tempString);
            this.fireInputChanged();
        }
    }

    public void readTriplex(String tempString, int numBytes) {
        try {
            this.log(tempString);
            this.escreverLog("Dados lidos na porta!", new Date());
            this.fireInputLog(tempString);
            if (this.contemSomenteUmChar(tempString) && this.isHandShakeChar(tempString.charAt(0))) {
                this.fireHandShakeCharReceivedInputTriplex(tempString.charAt(0));
            } else {
                this.stringInputTriplex.append(tempString);
                this.fireInputTriplexChanged();
            }
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        if (tempString != null && tempString.length() > 0) {
            this.stringInputTriplex.append(tempString);
            this.fireInputLog(tempString);
            this.fireInputTriplexChanged();
        }
    }

    private boolean contemSomenteUmChar(String tempString) {
        return tempString.length() == 1;
    }

    public void setIgnoraSTX(boolean ignoraSTX) {
        this.ignoraSTX = ignoraSTX;
    }
}

