/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.comunicacao;

import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.DataChangedListener;
import jalis.laboratorio.interfaceamento.comunicacao.LogListener;
import jalis.laboratorio.interfaceamento.comunicacao.SoftHandShakeListener;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;

public class PortaSocketServer
extends AbstractPort {
    private StringBuilder stringInput = new StringBuilder();
    private StringBuilder stringInputAux = new StringBuilder();
    private String lastOutput = "";
    private DataOutputStream os;
    private BufferedInputStream is;
    private BufferedInputStream isAux;
    private Socket socket;
    private Socket socketAux;
    private String address;
    private int porta;
    private int portaAux;
    private boolean executando = false;
    private boolean escreverEmBytes = false;
    private boolean ignoraSTX = false;
    private boolean buscaHandshakeMensagemInteira = false;
    private boolean considerarSTXComoHandShake = true;
    protected ArrayList<DataChangedListener> data_changed_listeners;
    protected ArrayList<SoftHandShakeListener> soft_handshake_listeners;
    private ServerSocket server;
    private ServerSocket serverAux;

    @Override
    @Deprecated
    public void open(String address) throws Exception {
    }

    public void open(String address, int porta, int portaAux) throws IOException {
        this.escreverLog("Inicializando o socket", new Date());
        this.data_changed_listeners = new ArrayList();
        this.soft_handshake_listeners = new ArrayList();
        this.log_listeners = new ArrayList();
        this.lastOutput = "";
        this.stringInput = new StringBuilder();
        if (portaAux > 0) {
            this.stringInputAux = new StringBuilder();
        }
        this.escreverLog("Abrindo o socket!", new Date());
        this.server = new ServerSocket(porta);
        if (portaAux > 0) {
            this.serverAux = new ServerSocket(portaAux);
        }
        this.escreverLog("Socket Aberto!", new Date());
        this.aguardaConexao();
        this.address = address;
        this.porta = porta;
        if (portaAux > 0) {
            this.portaAux = portaAux;
        }
    }

    public boolean isOpened() {
        return this.socket != null && this.socket.isConnected();
    }

    public void setBuscaHandshakeMensagemInteira(boolean flag) {
        this.buscaHandshakeMensagemInteira = flag;
    }

    public void setEscreverEmBytes(boolean escreverEmBytes) {
        this.escreverEmBytes = escreverEmBytes;
    }

    public void setIgnoraSTX(boolean ignoraSTX) {
        this.ignoraSTX = ignoraSTX;
    }

    public void setConsiderarSTXComoHandShake(boolean considerarSTXComoHandShake) {
        this.considerarSTXComoHandShake = considerarSTXComoHandShake;
    }

    private void aguardaConexao() throws IOException {
        Thread threadAguardaConexao = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        PortaSocketServer.this.escreverLog("Esperando conex\u00e3o!", new Date());
                        PortaSocketServer.this.socket = PortaSocketServer.this.server.accept();
                        if (PortaSocketServer.this.portaAux > 0) {
                            PortaSocketServer.this.socketAux = PortaSocketServer.this.serverAux.accept();
                        }
                        PortaSocketServer.this.escreverLog("Aceitou a conex\u00e3o!", new Date());
                        PortaSocketServer.this.is = new BufferedInputStream(PortaSocketServer.this.socket.getInputStream());
                        if (PortaSocketServer.this.portaAux > 0) {
                            PortaSocketServer.this.isAux = new BufferedInputStream(PortaSocketServer.this.socketAux.getInputStream());
                        }
                        PortaSocketServer.this.os = new DataOutputStream(PortaSocketServer.this.socket.getOutputStream());
                        PortaSocketServer.this.executando = true;
                        PortaSocketServer.this.escreverLog("Abrindo Thread de leitura!", new Date());
                        Thread threadReadInput = new Thread(){

                            @Override
                            public void run() {
                                PortaSocketServer.this.escreverLog("Thread de leitura Iniciada!", new Date());
                                while (PortaSocketServer.this.executando) {
                                    PortaSocketServer.this.readInput();
                                    if (PortaSocketServer.this.portaAux > 0) {
                                        PortaSocketServer.this.readInputAux();
                                    }
                                    try {
                                        1.sleep(50L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                            }
                        };
                        threadReadInput.start();
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
        };
        threadAguardaConexao.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String messageString) throws IOException {
        this.log(messageString);
        this.escreverLog("Tentando escrever dados na porta!", new Date());
        if (this.isOpened() && messageString.length() > 0) {
            this.fireOutputLog(messageString);
            try {
                DataOutputStream dataOutputStream = this.os;
                synchronized (dataOutputStream) {
                    this.lastOutput = messageString;
                    if (this.escreverEmBytes) {
                        this.os.write(messageString.getBytes());
                    } else {
                        this.os.writeUTF(messageString);
                    }
                    this.os.flush();
                    this.escreverLog("Dados escritos na porta!", new Date());
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortSocket:124");
                this.closeSocket();
                this.aguardaConexao();
            }
        }
        if (!this.isOpened() && messageString.length() > 0 || Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "interfaceTeste.jalis")) {
            this.fireOutputLog(messageString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSocket() {
        try {
            this.escreverLog("Fechando Socket!", new Date());
            this.executando = false;
            if (this.os != null) {
                this.os.close();
                DataOutputStream dataOutputStream = this.os;
                synchronized (dataOutputStream) {
                    this.os.close();
                }
            }
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
            this.escreverLog("Socket Fechado!", new Date());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        try {
            this.closeSocket();
            this.server.close();
            this.server = null;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortSocket:146");
        }
    }

    @Override
    public String removeInputString(String delimitador) {
        if (this.stringInput.indexOf(delimitador) >= 0) {
            int delsize = delimitador.length();
            String head = this.stringInput.substring(0, this.stringInput.indexOf(delimitador) + delsize);
            this.stringInput = new StringBuilder(this.stringInput.substring(this.stringInput.indexOf(delimitador) + delsize));
            return head;
        }
        return "";
    }

    public String removeInputString(int delimitador) {
        if (this.stringInput.length() > delimitador) {
            String head = this.stringInput.substring(0, delimitador);
            this.stringInput = new StringBuilder(this.stringInput.substring(delimitador));
            return head;
        }
        return "";
    }

    public int getStringInputLength() {
        return this.stringInput.length();
    }

    public synchronized void readInput() {
        if (this.socket == null) {
            return;
        }
        int numBytes = 0;
        try {
            byte[] readBuffer = new byte[this.is.available()];
            String tempString = "";
            numBytes = this.is.read(readBuffer);
            tempString = tempString + new String(readBuffer, 0, numBytes);
            if (this.buscaHandshakeMensagemInteira) {
                String mensagemParcial = "";
                for (char c : tempString.toCharArray()) {
                    if (this.isHandShakeChar(c)) {
                        if (!mensagemParcial.isEmpty()) {
                            this.stringInput.append(mensagemParcial);
                            this.fireInputLog(mensagemParcial);
                            this.fireInputChanged();
                            mensagemParcial = "";
                        }
                        this.fireInputLog(String.valueOf(c));
                        this.fireHandShakeCharReceivedOutput(c);
                        continue;
                    }
                    mensagemParcial = mensagemParcial + c;
                }
                if (!mensagemParcial.isEmpty()) {
                    this.stringInput.append(mensagemParcial);
                    this.fireInputLog(mensagemParcial);
                    this.fireInputChanged();
                }
            } else if (tempString != null && tempString.length() > 0) {
                this.escreverLog("Dados lidos na porta!", new Date());
                this.fireInputLog(tempString);
                if (tempString.length() == 1 && this.isHandShakeChar(tempString.charAt(0))) {
                    this.fireHandShakeCharReceivedOutput(tempString.charAt(0));
                } else if (tempString.length() == 2 && this.isHandShakeChar(tempString.charAt(0))) {
                    this.fireHandShakeCharReceivedOutput(tempString.charAt(1));
                } else {
                    this.stringInput.append(tempString);
                    this.fireInputChanged();
                }
            }
            this.log(tempString);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortSocket:228");
            this.closeSocket();
            try {
                this.aguardaConexao();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public synchronized void readInputAux() {
        if (this.socketAux == null) {
            return;
        }
        int numBytes = 0;
        try {
            byte[] readBuffer = new byte[this.isAux.available()];
            String tempString = "";
            numBytes = this.isAux.read(readBuffer);
            tempString = tempString + new String(readBuffer, 0, numBytes);
            if (this.buscaHandshakeMensagemInteira) {
                String mensagemParcial = "";
                for (char c : tempString.toCharArray()) {
                    if (this.isHandShakeChar(c)) {
                        if (!mensagemParcial.isEmpty()) {
                            this.stringInputAux.append(mensagemParcial);
                            this.fireInputLog(mensagemParcial);
                            this.fireInputChanged();
                            mensagemParcial = "";
                        }
                        this.fireInputLog(String.valueOf(c));
                        this.fireHandShakeCharReceivedOutput(c);
                        continue;
                    }
                    mensagemParcial = mensagemParcial + c;
                }
                if (!mensagemParcial.isEmpty()) {
                    this.stringInputAux.append(mensagemParcial);
                    this.fireInputLog(mensagemParcial);
                    this.fireInputChanged();
                }
            } else if (tempString != null && tempString.length() > 0) {
                this.escreverLog("Dados lidos na porta!", new Date());
                this.fireInputLog(tempString);
                if (tempString.length() == 1 && this.isHandShakeChar(tempString.charAt(0))) {
                    this.fireHandShakeCharReceivedOutput(tempString.charAt(0));
                } else if (tempString.length() == 2 && this.isHandShakeChar(tempString.charAt(0))) {
                    this.fireHandShakeCharReceivedOutput(tempString.charAt(1));
                } else {
                    this.stringInput.append(tempString);
                    this.fireInputChanged();
                }
            }
            this.log(tempString);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortSocket:228");
            this.closeSocket();
            try {
                this.aguardaConexao();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public synchronized void readInput(String tempString) {
        boolean numBytes = false;
        try {
            if (this.buscaHandshakeMensagemInteira) {
                String mensagemParcial = "";
                for (char c : tempString.toCharArray()) {
                    if (this.isHandShakeChar(c)) {
                        if (!mensagemParcial.isEmpty()) {
                            this.stringInput.append(mensagemParcial);
                            this.fireInputLog(mensagemParcial);
                            this.fireInputChanged();
                            mensagemParcial = "";
                        }
                        this.fireInputLog(String.valueOf(c));
                        this.fireHandShakeCharReceivedOutput(c);
                        continue;
                    }
                    mensagemParcial = mensagemParcial + c;
                }
                if (!mensagemParcial.isEmpty()) {
                    this.stringInput.append(mensagemParcial);
                    this.fireInputLog(mensagemParcial);
                    this.fireInputChanged();
                }
            } else if (tempString != null && tempString.length() > 0) {
                this.escreverLog("Dados lidos na porta!", new Date());
                this.fireInputLog(tempString);
                if (tempString.length() == 1 && this.isHandShakeChar(tempString.charAt(0))) {
                    this.fireHandShakeCharReceivedOutput(tempString.charAt(0));
                } else if (tempString.length() == 2 && this.isHandShakeChar(tempString.charAt(1))) {
                    this.fireHandShakeCharReceivedOutput(tempString.charAt(1));
                } else {
                    this.stringInput.append(tempString);
                    this.fireInputChanged();
                }
            }
            this.log(tempString);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortSocket:228");
            this.closeSocket();
            try {
                this.aguardaConexao();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void fireInputChanged() {
        for (DataChangedListener tmp : this.data_changed_listeners) {
            tmp.dataChanged();
        }
    }

    private void fireHandShakeCharReceivedOutput(char c) {
        for (SoftHandShakeListener tmp : this.soft_handshake_listeners) {
            tmp.handShakeCharReceived(c);
        }
    }

    private void fireInputLog(String log) {
        for (LogListener tmp : this.log_listeners) {
            tmp.inputLog(log);
        }
    }

    private void fireOutputLog(String log) {
        for (LogListener tmp : this.log_listeners) {
            tmp.outputLog(log);
        }
    }

    public boolean isHandShakeChar(char c) {
        return c == this.ACK || c == this.NAK || c == this.ENQ || c == this.SYN || c == this.DEL || c == this.CAN || c == this.NUL || c == this.EOT || c == this.DLE || this.considerarSTXComoHandShake && c == this.STX;
    }

    private String replaceSpecialChars(String s) {
        s = s.replaceAll(String.valueOf(this.SOH), "<SOH>");
        s = s.replaceAll(String.valueOf(this.STX), "<STX>");
        s = s.replaceAll(String.valueOf(this.ETX), "<ETX>");
        s = s.replaceAll(String.valueOf(this.EOT), "<EOT>");
        s = s.replaceAll(String.valueOf(this.ACK), "<ACK>");
        s = s.replaceAll(String.valueOf(this.NAK), "<NAK>");
        s = s.replaceAll(String.valueOf(this.DEL), "<DEL>");
        s = s.replaceAll(String.valueOf(this.DLE), "<DLE>");
        s = s.replaceAll(String.valueOf(this.ENQ), "<ENQ>");
        s = s.replaceAll(String.valueOf(this.SYN), "<SYN>");
        s = s.replaceAll(String.valueOf(this.ETB), "<ETB>");
        s = s.replaceAll(String.valueOf(this.CAN), "<CAN>");
        s = s.replaceAll(String.valueOf(this.NUL), "<NUL>");
        s = s.replaceAll(String.valueOf(this.LF), "<LF>");
        s = s.replaceAll(String.valueOf(this.CR), "<CR>");
        s = s.replaceAll(String.valueOf(this.SP), "<SP>");
        return s;
    }

    @Override
    @Deprecated
    public void flush() {
    }

    @Override
    public void clearInputString() {
        if (this.stringInput != null) {
            this.stringInput.setLength(0);
        }
    }

    @Override
    public String getInputString() {
        return this.stringInput.toString();
    }

    @Override
    public void removeHandshakeAndDataListeners() {
        if (this.socket != null) {
            this.data_changed_listeners.clear();
            this.soft_handshake_listeners.clear();
        }
    }

    @Override
    public void addDataChangedListener(DataChangedListener listener) {
        if (!this.data_changed_listeners.contains(listener)) {
            this.data_changed_listeners.add(listener);
        }
    }

    @Override
    public void addSoftHandShakeListener(SoftHandShakeListener listener) {
        if (!this.soft_handshake_listeners.contains(listener)) {
            this.soft_handshake_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void escreverLog(String texto, Date data) {
        String nomeArquivo = System.getProperty("user.home").toString() + "/.socket.log";
        texto = Funcoes.formataData("dd/MM/yyyy HH:mm:ss", data) + " - " + texto + "\t- " + Variaveis.login;
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(nomeArquivo, true));
            out.write(texto + "\n");
            out.flush();
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortSocket:392");
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void read(String tempString, int numBytes) {
        try {
            if (!Funcoes.textoVazio(tempString)) {
                this.log(tempString);
                this.escreverLog("Dados lidos na porta!", new Date());
                this.fireInputLog(tempString);
                if (this.contemSomenteUmChar(tempString) && this.isHandShakeChar(tempString.charAt(0))) {
                    this.fireHandShakeCharReceivedOutput(tempString.charAt(0));
                } else if (tempString.length() == 2 && this.isHandShakeChar(tempString.charAt(1))) {
                    this.fireHandShakeCharReceivedOutput(tempString.charAt(1));
                } else {
                    this.stringInput.append(tempString);
                    this.fireInputChanged();
                }
            }
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    private boolean contemSomenteUmChar(String tempString) {
        return tempString.length() == 1;
    }

    public StringBuilder getStringInput() {
        return this.stringInput;
    }

    public StringBuilder getStringInputAux() {
        return this.stringInputAux;
    }

    public String getLastOutput() {
        return this.lastOutput;
    }

    public DataOutputStream getOs() {
        return this.os;
    }

    public BufferedInputStream getIs() {
        return this.is;
    }

    public BufferedInputStream getIsAux() {
        return this.isAux;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public Socket getSocketAux() {
        return this.socketAux;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPorta() {
        return this.porta;
    }

    public int getPortaAux() {
        return this.portaAux;
    }

    public boolean isExecutando() {
        return this.executando;
    }

    public boolean isEscreverEmBytes() {
        return this.escreverEmBytes;
    }

    public boolean isIgnoraSTX() {
        return this.ignoraSTX;
    }

    public boolean isBuscaHandshakeMensagemInteira() {
        return this.buscaHandshakeMensagemInteira;
    }

    public boolean isConsiderarSTXComoHandShake() {
        return this.considerarSTXComoHandShake;
    }

    @Override
    public ArrayList<DataChangedListener> getDataChangedListeners() {
        return this.data_changed_listeners;
    }

    @Override
    public ArrayList<SoftHandShakeListener> getSoftHandshakeListeners() {
        return this.soft_handshake_listeners;
    }

    public ServerSocket getServer() {
        return this.server;
    }

    public ServerSocket getServerAux() {
        return this.serverAux;
    }

    public void setStringInput(StringBuilder stringInput) {
        this.stringInput = stringInput;
    }

    public void setStringInputAux(StringBuilder stringInputAux) {
        this.stringInputAux = stringInputAux;
    }

    public void setLastOutput(String lastOutput) {
        this.lastOutput = lastOutput;
    }

    public void setOs(DataOutputStream os) {
        this.os = os;
    }

    public void setIs(BufferedInputStream is) {
        this.is = is;
    }

    public void setIsAux(BufferedInputStream isAux) {
        this.isAux = isAux;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public void setSocketAux(Socket socketAux) {
        this.socketAux = socketAux;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPorta(int porta) {
        this.porta = porta;
    }

    public void setPortaAux(int portaAux) {
        this.portaAux = portaAux;
    }

    public void setExecutando(boolean executando) {
        this.executando = executando;
    }

    public void setServer(ServerSocket server) {
        this.server = server;
    }

    public void setServerAux(ServerSocket serverAux) {
        this.serverAux = serverAux;
    }

    public ArrayList<DataChangedListener> getDataChangedListenersSocketServer() {
        return this.data_changed_listeners;
    }

    public void setDataChangedListenersSocketServer(ArrayList<DataChangedListener> dataChangedListeners) {
        this.data_changed_listeners = dataChangedListeners;
    }

    public ArrayList<SoftHandShakeListener> getSoftHandshakeListenersSocketServer() {
        return this.soft_handshake_listeners;
    }

    public void setSoftHandshakeListenersSocketServer(ArrayList<SoftHandShakeListener> softHandshakeListeners) {
        this.soft_handshake_listeners = softHandshakeListeners;
    }
}

