/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.comunicacao;

import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.DataChangedListenerInput;
import jalis.laboratorio.interfaceamento.comunicacao.DataChangedListenerOutput;
import jalis.laboratorio.interfaceamento.comunicacao.LogListener;
import jalis.laboratorio.interfaceamento.comunicacao.SoftHandShakeListener;
import jalis.laboratorio.interfaceamento.comunicacao.SoftHandShakeListenerInput;
import jalis.laboratorio.interfaceamento.comunicacao.SoftHandShakeListenerOutput;
import jalis.util.logger.ErrorLogger;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;

public class PortaSocket
extends AbstractPort {
    private String stringInput = "";
    private String lastInput = "";
    private String stringOutput = "";
    private String lastOutput = "";
    private DataOutputStream osOutput;
    private BufferedInputStream isOutput;
    private DataOutputStream osInput;
    private BufferedInputStream isInput;
    private Socket socketOutput;
    private Socket socketInput;
    private String address;
    private int portaOutput;
    private int portaInput;
    private boolean executando = false;
    protected ArrayList<DataChangedListenerInput> data_changed_listeners_input;
    protected ArrayList<SoftHandShakeListenerInput> soft_handshake_listeners_input;
    protected ArrayList<DataChangedListenerOutput> data_changed_listeners_output;
    protected ArrayList<SoftHandShakeListenerOutput> soft_handshake_listeners_output;

    @Override
    @Deprecated
    public void open(String address) throws Exception {
    }

    public void open(String address, int portaOutput, int portaInput) throws IOException {
        this.data_changed_listeners_input = new ArrayList();
        this.data_changed_listeners_output = new ArrayList();
        this.soft_handshake_listeners_input = new ArrayList();
        this.soft_handshake_listeners_output = new ArrayList();
        this.log_listeners = new ArrayList();
        this.stringOutput = "";
        this.lastOutput = "";
        this.stringInput = "";
        this.lastInput = "";
        this.initSocket(address, portaOutput, portaInput);
        this.address = address;
        this.portaOutput = portaOutput;
        this.portaInput = portaInput;
    }

    public boolean isOpened() {
        if (this.portaOutput == this.portaInput) {
            return this.socketOutput != null && this.socketOutput.isConnected();
        }
        return this.socketOutput != null && this.socketOutput.isConnected() && this.socketInput != null && this.socketInput.isConnected();
    }

    private void initSocket(String address, int portaOutput, int portaInput) throws IOException {
        if (portaOutput != portaInput) {
            this.socketInput = new Socket(address, portaInput);
            this.socketInput.setKeepAlive(true);
        }
        this.socketOutput = new Socket(address, portaOutput);
        this.socketOutput.setKeepAlive(true);
        this.executando = true;
        try {
            this.isOutput = new BufferedInputStream(this.socketOutput.getInputStream());
            this.osOutput = new DataOutputStream(this.socketOutput.getOutputStream());
            if (this.socketInput != null) {
                this.isInput = new BufferedInputStream(this.socketInput.getInputStream());
                this.osInput = new DataOutputStream(this.socketInput.getOutputStream());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Thread threadReadInput = new Thread(){

            @Override
            public void run() {
                while (PortaSocket.this.executando) {
                    PortaSocket.this.readInput();
                    try {
                        1.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        threadReadInput.setPriority(1);
        threadReadInput.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOutput(String messageString) throws IOException {
        this.log(messageString);
        if (this.isOpened() && messageString.length() > 0) {
            this.fireOutputLog(messageString);
            try {
                DataOutputStream dataOutputStream = this.osOutput;
                synchronized (dataOutputStream) {
                    this.lastOutput = messageString;
                    this.osOutput.writeUTF(messageString);
                    this.osOutput.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeInput(String messageString) throws IOException {
        this.log(messageString);
        if (this.isOpened() && messageString.length() > 0) {
            this.fireOutputLog(messageString);
            try {
                DataOutputStream dataOutputStream = this.osInput;
                synchronized (dataOutputStream) {
                    this.osInput.writeUTF(messageString);
                    this.lastInput = messageString;
                    this.osInput.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block8: {
            try {
                this.executando = false;
                this.osOutput.close();
                DataOutputStream dataOutputStream = this.osOutput;
                synchronized (dataOutputStream) {
                    this.osOutput.close();
                }
                this.socketOutput.close();
                if (this.socketInput == null) break block8;
                this.osInput.close();
                dataOutputStream = this.osInput;
                synchronized (dataOutputStream) {
                    this.osInput.close();
                }
                this.socketInput.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getStringOutput() {
        return this.stringOutput;
    }

    public String getStringInput() {
        return this.stringInput;
    }

    public String removeStringInput(String delimitador) {
        if (this.stringInput.indexOf(delimitador) >= 0) {
            int delsize = delimitador.length();
            String head = this.stringInput.substring(0, this.stringInput.indexOf(delimitador) + delsize);
            this.stringInput = this.stringInput.substring(this.stringInput.indexOf(delimitador) + delsize);
            return head;
        }
        return "";
    }

    public String removeStringInput(String delimitador, boolean caracterEspecial) {
        int posicao = -1;
        if (this.stringInput.contains(delimitador) && caracterEspecial) {
            for (int i = 0; i < this.stringInput.length(); ++i) {
                if (this.stringInput.length() < i + 1 || this.stringInput.charAt(i) != '\u001c' || this.stringInput.charAt(i + 1) != '\r') continue;
                posicao = i;
            }
        }
        if (posicao >= 0) {
            int delsize = delimitador.length();
            String head = this.stringInput.substring(0, posicao + delsize);
            this.stringInput = this.stringInput.substring(posicao + delsize);
            return head;
        }
        return "";
    }

    public String removeStringOutput(String delimitador) {
        if (this.stringOutput.indexOf(delimitador) >= 0) {
            int delsize = delimitador.length();
            String head = this.stringOutput.substring(0, this.stringOutput.indexOf(delimitador) + delsize);
            this.stringOutput = this.stringOutput.substring(this.stringOutput.indexOf(delimitador) + delsize);
            return head;
        }
        return "";
    }

    public String removeStringInput(int delimitador) {
        if (this.stringInput.length() > delimitador) {
            String head = this.stringInput.substring(0, delimitador);
            this.stringInput = this.stringInput.substring(delimitador);
            return head;
        }
        return "";
    }

    public String removeStringOutput(int delimitador) {
        if (this.stringOutput.length() > delimitador) {
            String head = this.stringOutput.substring(0, delimitador);
            this.stringOutput = this.stringOutput.substring(delimitador);
            return head;
        }
        return "";
    }

    public int getStringInputLength() {
        return this.stringInput.length();
    }

    public int getStringOutputLength() {
        return this.stringOutput.length();
    }

    public void clearStringOutput() {
        this.stringOutput = "";
    }

    public synchronized void readOutput() {
        int numBytes = 0;
        try {
            byte[] readBuffer = new byte[this.isOutput.available()];
            String tempString = "";
            numBytes = this.isOutput.read(readBuffer);
            tempString = tempString + new String(readBuffer, 0, numBytes);
            if (tempString != null && tempString.length() > 0) {
                this.stringOutput = this.stringOutput + tempString;
                this.fireInputLog(tempString);
                this.fireOutputChanged();
                this.log(this.stringOutput);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortSocket:228");
        }
    }

    public synchronized void readInput() {
        if (this.socketInput == null) {
            return;
        }
        int numBytes = 0;
        try {
            byte[] readBuffer = new byte[this.isInput.available()];
            String tempString = "";
            numBytes = this.isInput.read(readBuffer);
            tempString = tempString + new String(readBuffer, 0, numBytes);
            this.read(tempString, numBytes);
            this.log(tempString);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortSocket:228");
        }
    }

    private void fireInputChanged() {
        if (this.socketInput == null) {
            return;
        }
        for (DataChangedListenerInput tmp : this.data_changed_listeners_input) {
            tmp.dataChangedInput();
        }
    }

    private void fireOutputChanged() {
        for (DataChangedListenerOutput tmp : this.data_changed_listeners_output) {
            tmp.dataChangedOutput();
        }
    }

    private void fireHandShakeCharReceivedOutput(char c) {
        for (SoftHandShakeListener softHandShakeListener : this.soft_handshake_listeners_output) {
            softHandShakeListener.handShakeCharReceived(c);
        }
    }

    private void fireHandShakeCharReceivedInput(char c) {
        if (this.socketInput == null) {
            return;
        }
        for (SoftHandShakeListener softHandShakeListener : this.soft_handshake_listeners_input) {
            softHandShakeListener.handShakeCharReceived(c);
        }
    }

    private void fireInputLog(String log) {
        for (LogListener tmp : this.log_listeners) {
            tmp.inputLog(log);
        }
    }

    private void fireOutputLog(String log) {
        for (LogListener tmp : this.log_listeners) {
            tmp.outputLog(log);
        }
    }

    public boolean isHandShakeChar(char c) {
        return c == this.ACK || c == this.NAK || c == this.ENQ || c == this.SYN || c == this.DEL || c == this.CAN || c == this.NUL || c == this.EOT || c == this.DLE || c == this.STX;
    }

    private String replaceSpecialChars(String s) {
        s = s.replaceAll(String.valueOf(this.SOH), "<SOH>");
        s = s.replaceAll(String.valueOf(this.STX), "<STX>");
        s = s.replaceAll(String.valueOf(this.ETX), "<ETX>");
        s = s.replaceAll(String.valueOf(this.EOT), "<EOT>");
        s = s.replaceAll(String.valueOf(this.ACK), "<ACK>");
        s = s.replaceAll(String.valueOf(this.NAK), "<NAK>");
        s = s.replaceAll(String.valueOf(this.DEL), "<DEL>");
        s = s.replaceAll(String.valueOf(this.DLE), "<DLE>");
        s = s.replaceAll(String.valueOf(this.ENQ), "<ENQ>");
        s = s.replaceAll(String.valueOf(this.SYN), "<SYN>");
        s = s.replaceAll(String.valueOf(this.ETB), "<ETB>");
        s = s.replaceAll(String.valueOf(this.CAN), "<CAN>");
        s = s.replaceAll(String.valueOf(this.NUL), "<NUL>");
        s = s.replaceAll(String.valueOf(this.LF), "<LF>");
        s = s.replaceAll(String.valueOf(this.CR), "<CR>");
        s = s.replaceAll(String.valueOf(this.SP), "<SP>");
        return s;
    }

    @Override
    @Deprecated
    public void flush() {
    }

    @Override
    @Deprecated
    public void clearInputString() {
    }

    @Override
    @Deprecated
    public String getInputString() {
        return null;
    }

    @Override
    @Deprecated
    public String removeInputString(String delimitador) {
        return null;
    }

    @Override
    public void removeHandshakeAndDataListeners() {
        if (this.socketInput != null) {
            this.data_changed_listeners_input.clear();
            this.soft_handshake_listeners_input.clear();
        }
        this.data_changed_listeners_output.clear();
        this.soft_handshake_listeners_output.clear();
    }

    public void addDataChangedListenerOutput(DataChangedListenerOutput listener) {
        if (!this.data_changed_listeners_output.contains(listener)) {
            this.data_changed_listeners_output.add(listener);
        }
    }

    public void addDataChangedListenerInput(DataChangedListenerInput listener) {
        if (!this.data_changed_listeners_input.contains(listener)) {
            this.data_changed_listeners_input.add(listener);
        }
    }

    public void addSoftHandShakeListenerInput(SoftHandShakeListenerInput listener) {
        if (!this.soft_handshake_listeners_input.contains(listener)) {
            this.soft_handshake_listeners_input.add(listener);
        }
    }

    public void addSoftHandShakeListenerOutput(SoftHandShakeListenerOutput listener) {
        if (!this.soft_handshake_listeners_output.contains(listener)) {
            this.soft_handshake_listeners_output.add(listener);
        }
    }

    @Override
    @Deprecated
    public void write(String messageString) throws IOException {
        this.log(messageString);
    }

    @Override
    public void read(String tempString, int numBytes) {
        if (tempString != null && tempString.length() > 0) {
            this.stringInput = this.stringInput + tempString;
            this.fireInputLog(tempString);
            this.fireInputChanged();
        }
    }
}

