/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.comunicacao;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.DataChangedListener;
import jalis.laboratorio.interfaceamento.comunicacao.LogFileListener;
import jalis.laboratorio.interfaceamento.comunicacao.LogListener;
import jalis.laboratorio.interfaceamento.comunicacao.SoftHandShakeListener;
import jalis.laboratorio.interfaceamento.comunicacao.processararquivo.ProcessaArquivoComunicacao;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TooManyListenersException;

public class PortaCOM
extends AbstractPort {
    public int DEFAULT_BAUDRATE = 9600;
    public int DEFAULT_DATABITS = 8;
    public int DEFAULT_STOPBITS = 1;
    public int DEFAULT_PARITY = 0;
    public int DEFAULT_FLOWCONTROL = 12;
    private String inputString = "";
    private String lastOutput = "";
    private CommPortIdentifier portId;
    private OutputStream outputStream;
    private InputStream inputStream;
    private SerialPort serialPort = null;
    private OuvinteSerial ouvinteSerial;
    private String porta_atual;
    private ArrayList<String> lista_portas = new ArrayList();
    private boolean buscaHandshakeMansagemInteira = false;

    public PortaCOM() {
        try {
            Class<?> portaComm = Class.forName("gnu.io.SerialPortEventListener");
            if (new ProcessaArquivoComunicacao().processarArquivoRxtx()) {
                Enumeration enu = CommPortIdentifier.getPortIdentifiers();
                while (enu.hasMoreElements()) {
                    CommPortIdentifier porta = (CommPortIdentifier)enu.nextElement();
                    if (porta.getPortType() != 1) continue;
                    this.lista_portas.add(porta.getName());
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.lista_portas = new ArrayList();
        }
    }

    @Override
    public void open(String address) throws IOException, PortInUseException, NoSuchPortException {
        if (this.serialPort != null) {
            this.close();
        }
        this.data_changed_listeners = new ArrayList();
        this.soft_handshake_listeners = new ArrayList();
        this.log_listeners = new ArrayList();
        this.log_file_listeners = new ArrayList();
        this.inputString = "";
        this.lastOutput = "";
        this.initPort(address);
        try {
            this.ouvinteSerial = new OuvinteSerial();
            this.serialPort.addEventListener((SerialPortEventListener)this.ouvinteSerial);
        }
        catch (TooManyListenersException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortCOM");
        }
        this.porta_atual = address;
    }

    public String getPorta_atual() {
        return this.porta_atual;
    }

    public ArrayList<String> getListaPortasSeriaisDisponiveis() {
        return (ArrayList)this.lista_portas.clone();
    }

    public boolean isOpened() {
        return this.serialPort != null;
    }

    private void initPort(String portname) throws NoSuchPortException, PortInUseException, IOException {
        this.portId = CommPortIdentifier.getPortIdentifier((String)portname);
        this.serialPort = (SerialPort)this.portId.open("Jalis - Interfaceamento", 30000);
        this.inputStream = this.serialPort.getInputStream();
        this.outputStream = this.serialPort.getOutputStream();
        this.serialPort.notifyOnDataAvailable(true);
    }

    public int getBaudRate() {
        return this.serialPort.getBaudRate();
    }

    public int getDataBits() {
        return this.serialPort.getDataBits();
    }

    public int getParity() {
        return this.serialPort.getParity();
    }

    public int getStopBits() {
        return this.serialPort.getStopBits();
    }

    public boolean isCTS() {
        return this.serialPort.isCTS();
    }

    public boolean isDSR() {
        return this.serialPort.isDSR();
    }

    public void setRTS(boolean b) {
        this.serialPort.setRTS(b);
    }

    public void setDTR(boolean b) {
        this.serialPort.setDTR(b);
    }

    public void setNotifyOnCTS(boolean b) {
        this.serialPort.notifyOnCTS(b);
    }

    public void setNotifyOnDSR(boolean b) {
        this.serialPort.notifyOnDSR(b);
    }

    public void setSerialPortParams(int baudRate, int dataBits, int stopBits, int parity, int flowControl) throws UnsupportedCommOperationException {
        this.serialPort.setSerialPortParams(baudRate, dataBits, stopBits, parity);
        this.serialPort.setFlowControlMode(flowControl);
    }

    @Override
    public void write(String messageString) throws IOException {
        this.log(messageString);
        if (this.isOpened() && messageString.length() > 0) {
            this.fireOutputLog(messageString);
            this.fireOutputLogFile(messageString);
            this.outputStream.write(messageString.getBytes());
            this.lastOutput = messageString;
            this.outputStream.flush();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void flush() {
        try {
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        if (this.isOpened()) {
            this.serialPort.close();
            this.serialPort = null;
        }
    }

    @Override
    public String getInputString() {
        return this.inputString;
    }

    @Override
    public String removeInputString(String delimitador) {
        if (this.inputString.indexOf(delimitador) >= 0) {
            int delsize = delimitador.length();
            String head = this.inputString.substring(0, this.inputString.indexOf(delimitador) + delsize);
            this.inputString = this.inputString.substring(this.inputString.indexOf(delimitador) + delsize);
            return head;
        }
        return "";
    }

    public String removeInputString(String delimitador, int offset) {
        int inputStringLenght = this.inputString.length();
        int delimitadorLenght = delimitador.length() + offset;
        int delimitadorIndex = this.inputString.indexOf(delimitador);
        if (delimitadorIndex > -1 && inputStringLenght >= delimitadorIndex + delimitadorLenght) {
            String head = this.inputString.substring(0, delimitadorIndex + delimitadorLenght);
            this.inputString = this.inputString.substring(delimitadorIndex + delimitadorLenght);
            return head;
        }
        return "";
    }

    public int getInputStringLength() {
        return this.inputString.length();
    }

    @Override
    public void clearInputString() {
        this.inputString = "";
    }

    public synchronized void read() {
        int numBytes = 0;
        try {
            byte[] readBuffer = new byte[4096];
            String tempString = "";
            while (this.inputStream.available() > 0) {
                numBytes = this.inputStream.read(readBuffer);
                tempString = tempString + new String(readBuffer, 0, numBytes);
            }
            this.log(tempString);
            this.read(tempString, numBytes);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortCOM");
        }
    }

    public void setBuscaHandshakeMensagemInteira(boolean flag) {
        this.buscaHandshakeMansagemInteira = flag;
    }

    private void fireInputChanged() {
        for (DataChangedListener tmp : this.data_changed_listeners) {
            tmp.dataChanged();
        }
    }

    private void fireHandShakeCharReceived(char c) {
        for (SoftHandShakeListener tmp : this.soft_handshake_listeners) {
            tmp.handShakeCharReceived(c);
        }
    }

    private void fireInputLog(String log) {
        for (LogListener tmp : this.log_listeners) {
            tmp.inputLog(log);
        }
    }

    private void fireOutputLog(String log) {
        for (LogListener tmp : this.log_listeners) {
            tmp.outputLog(log);
        }
    }

    private void fireInputLogFile(String log) {
        for (LogFileListener tmp : this.log_file_listeners) {
            tmp.inputLogFile(log);
        }
    }

    private void fireOutputLogFile(String log) {
        for (LogFileListener tmp : this.log_file_listeners) {
            tmp.outputLogFile(log);
        }
    }

    public boolean isHandShakeChar(char c) {
        return c == this.ACK || c == this.NAK || c == this.ENQ || c == this.SYN || c == this.DEL || c == this.CAN || c == this.NUL || c == this.EOT || c == this.DLE || c == this.DC1;
    }

    private String replaceSpecialChars(String s) {
        s = s.replaceAll(String.valueOf(this.SOH), "<SOH>");
        s = s.replaceAll(String.valueOf(this.STX), "<STX>");
        s = s.replaceAll(String.valueOf(this.ETX), "<ETX>");
        s = s.replaceAll(String.valueOf(this.EOT), "<EOT>");
        s = s.replaceAll(String.valueOf(this.ACK), "<ACK>");
        s = s.replaceAll(String.valueOf(this.NAK), "<NAK>");
        s = s.replaceAll(String.valueOf(this.DEL), "<DEL>");
        s = s.replaceAll(String.valueOf(this.DLE), "<DLE>");
        s = s.replaceAll(String.valueOf(this.ENQ), "<ENQ>");
        s = s.replaceAll(String.valueOf(this.SYN), "<SYN>");
        s = s.replaceAll(String.valueOf(this.ETB), "<ETB>");
        s = s.replaceAll(String.valueOf(this.CAN), "<CAN>");
        s = s.replaceAll(String.valueOf(this.NUL), "<NUL>");
        s = s.replaceAll(String.valueOf(this.LF), "<LF>");
        s = s.replaceAll(String.valueOf(this.CR), "<CR>");
        s = s.replaceAll(String.valueOf(this.SP), "<SP>");
        return s;
    }

    @Override
    public void read(String tempString, int numBytes) {
        if (this.buscaHandshakeMansagemInteira) {
            String mensagemParcial = "";
            for (char c : tempString.toCharArray()) {
                if (this.isHandShakeChar(c)) {
                    if (!mensagemParcial.isEmpty()) {
                        this.inputString = this.inputString + mensagemParcial;
                        this.fireInputLog(mensagemParcial);
                        this.fireInputLogFile(mensagemParcial);
                        this.fireInputChanged();
                        mensagemParcial = "";
                    }
                    this.fireInputLog(String.valueOf(c));
                    this.fireInputLogFile(String.valueOf(c));
                    this.fireHandShakeCharReceived(c);
                    continue;
                }
                mensagemParcial = mensagemParcial + c;
            }
            if (!mensagemParcial.isEmpty()) {
                this.inputString = this.inputString + mensagemParcial;
                this.fireInputLog(mensagemParcial);
                this.fireInputLogFile(mensagemParcial);
                this.fireInputChanged();
            }
        } else {
            this.fireInputLog(tempString);
            this.fireInputLogFile(tempString);
            if (tempString.length() == 1 && this.isHandShakeChar(tempString.charAt(0))) {
                this.fireHandShakeCharReceived(tempString.charAt(0));
            } else {
                this.inputString = this.inputString + tempString;
                this.fireInputChanged();
            }
        }
        try {
            this.log(tempString);
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    class OuvinteSerial
    implements SerialPortEventListener {
        OuvinteSerial() {
        }

        public void serialEvent(SerialPortEvent serialPortEvent) {
            try {
                int type = serialPortEvent.getEventType();
                switch (type) {
                    case 1: {
                        PortaCOM.this.read();
                        break;
                    }
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PortCOM");
            }
        }
    }
}

