/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.comunicacao;

import jalis.laboratorio.interfaceamento.comunicacao.FCStateListener;
import jalis.laboratorio.interfaceamento.comunicacao.FCTimeOutListener;
import jalis.util.logger.ErrorLogger;
import java.util.ArrayList;
import java.util.EventObject;

public class FlowController {
    public static final int ESTADO_IDLE = 0;
    public static final int ESTADO_TX = 1;
    public static final int ESTADO_RX = 2;
    protected static final int ESTADO_PAUSE = 3;
    private int estado = 0;
    private FCTimer timer;
    ArrayList<FCTimeOutListener> timeout_listeners = new ArrayList();
    ArrayList<FCStateListener> state_listeners = new ArrayList();

    public void setEstado(int novo_estado) {
        if (novo_estado <= 2) {
            this.estado = novo_estado;
            try {
                this.fireFCStateChanged(novo_estado);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "setEstado");
            }
        }
    }

    public void setEstado(int novo_estado, int tempo_milissegundos) {
        if (novo_estado <= 2) {
            this.estado = novo_estado;
            try {
                this.fireFCStateChanged(novo_estado);
                this.iniciarTimer(tempo_milissegundos);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "setEstado");
            }
        }
    }

    public void setPausa() {
        this.estado = 2;
        try {
            this.fireFCStateChanged(3);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "setPausa");
        }
    }

    public void setPausa(int tempo_milissegundos) {
        this.estado = 2;
        try {
            this.fireFCStateChanged(3);
            this.iniciarTimer(tempo_milissegundos);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "setPausa");
        }
    }

    public int getEstado() {
        return this.estado;
    }

    public boolean isIdle() {
        return this.estado == 0;
    }

    public boolean isTX() {
        return this.estado == 1;
    }

    public boolean isRX() {
        return this.estado == 2;
    }

    public void iniciarTimer(int tempo_milissegundos) {
        this.interromperTimer();
        this.timer = new FCTimer(tempo_milissegundos);
        this.timer.start();
    }

    public void interromperTimer() {
        if (this.timer != null && !this.timer.isInterrupted()) {
            this.timer.interrupt();
        }
    }

    public void addFCTimeOutListener(FCTimeOutListener listener) {
        if (!this.timeout_listeners.contains(listener)) {
            this.timeout_listeners.add(listener);
        }
    }

    private void fireFCTimedOut() throws Exception {
        for (FCTimeOutListener tmp : this.timeout_listeners) {
            tmp.fcTimedOut(new EventObject(this));
        }
    }

    public void addFCStateListener(FCStateListener listener) {
        if (!this.state_listeners.contains(listener)) {
            this.state_listeners.add(listener);
        }
    }

    private void fireFCStateChanged(int novo_estado) throws Exception {
        for (FCStateListener tmp : this.state_listeners) {
            tmp.fcStateChanged(new EventObject(this), novo_estado);
        }
    }

    class FCTimer
    extends Thread {
        int time;

        public FCTimer(int time_milliseconds) {
            this.time = time_milliseconds;
        }

        @Override
        public void run() {
            try {
                FCTimer.sleep(this.time);
                FlowController.this.fireFCTimedOut();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "FlowController");
            }
        }
    }
}

