/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.comunicacao;

import jalis.laboratorio.cadastro.interfaceamento.consulta.LogComunicacaoInterface;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.comunicacao.DataChangedListener;
import jalis.laboratorio.interfaceamento.comunicacao.LogFileListener;
import jalis.laboratorio.interfaceamento.comunicacao.LogListener;
import jalis.laboratorio.interfaceamento.comunicacao.SoftHandShakeListener;
import jalis.laboratorio.interfaceamento.comunicacao.log.LogInterfaceamentoException;
import jalis.laboratorio.interfaceamento.comunicacao.log.LogInterfaceamentoService;
import java.io.IOException;
import java.util.ArrayList;

public abstract class AbstractPort {
    public char NUL = '\u0000';
    public char SOH = '\u0001';
    public char STX = (char)2;
    public char ETX = (char)3;
    public char EOT = (char)4;
    public char ENQ = (char)5;
    public char ACK = (char)6;
    public char LF = (char)10;
    public char CR = (char)13;
    public char DLE = (char)16;
    public char DC1 = (char)17;
    public char NAK = (char)21;
    public char SYN = (char)22;
    public char ETB = (char)23;
    public char CAN = (char)24;
    public char SP = (char)32;
    public char DEL = (char)127;
    public String LINE = String.valueOf(this.CR) + String.valueOf(this.LF);
    protected ArrayList<DataChangedListener> data_changed_listeners;
    protected ArrayList<SoftHandShakeListener> soft_handshake_listeners;
    protected ArrayList<LogListener> log_listeners;
    protected ArrayList<LogFileListener> log_file_listeners;
    private final LogInterfaceamentoService logService = new LogInterfaceamentoService();
    private AbstractInterfaceamento equipamento;

    public abstract void open(String var1) throws Exception;

    public void removeHandshakeAndDataListeners() {
        this.data_changed_listeners.clear();
        this.soft_handshake_listeners.clear();
    }

    public void addDataChangedListener(DataChangedListener listener) {
        if (!this.data_changed_listeners.contains(listener)) {
            this.data_changed_listeners.add(listener);
        }
    }

    public void removeLogListeners() {
        this.log_listeners.clear();
    }

    public void addLogListener(LogListener listener) {
        if (!this.log_listeners.contains(listener)) {
            this.log_listeners.add(listener);
        }
    }

    public ArrayList<LogListener> getLogListeners() {
        return this.log_listeners;
    }

    public void removeLogFileListeners() {
        this.log_file_listeners.clear();
    }

    public void addLogFileListener(LogFileListener listener) {
        if (!this.log_file_listeners.contains(listener)) {
            this.log_file_listeners.add(listener);
        }
    }

    public ArrayList<LogFileListener> getLogFileListeners() {
        return this.log_file_listeners;
    }

    public void addSoftHandShakeListener(SoftHandShakeListener listener) {
        if (!this.soft_handshake_listeners.contains(listener)) {
            this.soft_handshake_listeners.add(listener);
        }
    }

    public abstract void read(String var1, int var2);

    public abstract void clearInputString();

    public abstract void flush();

    public abstract void close();

    public abstract void write(String var1) throws IOException;

    public void log(String messageString) throws IOException {
        if (this.equipamento != null) {
            messageString = this.equipamento.parseMessage(messageString);
        }
        this.escreverArquivo(messageString);
    }

    private void escreverArquivo(String messageString) throws IOException {
        block4: {
            try {
                if (this.equipamento != null) {
                    char[] listaComparacao;
                    for (char valor : listaComparacao = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u000b', '\u0010', '\u0011', '\u0015', '\u0016', '\u0017', '\u0018', '\u001c', '\u001d', '\u001e', ' ', '\u007f', '\u00fd', '\u000b', '\u001c'}) {
                        if (!messageString.contains(String.valueOf(valor))) continue;
                        messageString = messageString.replace(String.valueOf(valor), this.equipamento.parseMessage(String.valueOf(valor)));
                    }
                }
                this.logService.escreverArquivo(new LogComunicacaoInterface(messageString));
            }
            catch (LogInterfaceamentoException e) {
                if (e.getMessage().contains("ClosedByInterruptException") || e.getMessage().contains("IOException")) break block4;
                throw new IOException(e);
            }
        }
    }

    public abstract String getInputString();

    public abstract String removeInputString(String var1);

    public void setEquipamento(AbstractInterfaceamento equipamento) {
        this.equipamento = equipamento;
    }

    public AbstractInterfaceamento getEquipamento() {
        return this.equipamento;
    }

    public ArrayList<DataChangedListener> getDataChangedListeners() {
        return this.data_changed_listeners;
    }

    public void setDataChangedListeners(ArrayList<DataChangedListener> dataChangedListeners) {
        this.data_changed_listeners = dataChangedListeners;
    }

    public ArrayList<SoftHandShakeListener> getSoftHandshakeListeners() {
        return this.soft_handshake_listeners;
    }

    public void setSoftHandshakeListeners(ArrayList<SoftHandShakeListener> softHandshakeListeners) {
        this.soft_handshake_listeners = softHandshakeListeners;
    }

    public void setLogListeners(ArrayList<LogListener> logListeners) {
        this.log_listeners = logListeners;
    }

    public void setLogFileListeners(ArrayList<LogFileListener> logFileListeners) {
        this.log_file_listeners = logFileListeners;
    }

    public LogInterfaceamentoService getLogService() {
        return this.logService;
    }
}

