/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.componentes;

import jalis.laboratorio.interfaceamento.componentes.RendererPanelHistoricos;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.ExameUtil;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.TabelaModelada;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;

public class PanelHistoricos
extends JPanel {
    TabelaModelada tabela = new TabelaModelada(new String[]{"", "Descri\u00e7\u00e3o"});
    JScrollPane scroll_panel = new JScrollPane(this.tabela);
    public static final int HISTORICO_CAMPO = 0;
    public static final int HISTORICO_DESCRICAO = 1;

    public PanelHistoricos(boolean editavel, boolean ordenavel_manualmente) {
        try {
            this.jbInit();
            this.setEditavel(editavel);
            this.setOrdenavelManualmente(ordenavel_manualmente);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroll_panel, "Center");
        this.tabela.forceSize(0, 25);
        this.tabela.getTableHeader().setEnabled(false);
        this.setRenderer(new RendererPanelHistoricos());
    }

    public void loadHistoricos(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo) {
        try {
            ArrayList<Object[]> historicos = BDUtil.getExmHistoricos(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
            this.tabela.setData(historicos);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    public void loadHistoricos(String xml_valores) {
        try {
            Map<String, Object> dados = StringUtil.getMapDeXML(xml_valores);
            Set<String> keyset = dados.keySet();
            ArrayList<Object[]> historicos = new ArrayList<Object[]>();
            int i = 0;
            for (String k : keyset) {
                if (!k.matches("observacao_[012][0-9]")) continue;
                String campo = StringUtil.preencheString(String.valueOf(++i), 2, '0', 1);
                historicos.add(new Object[]{campo, dados.get(k)});
            }
            this.tabela.setData(historicos);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    public void loadAllHistoricos(String exa_codigo, String fil_codigo) {
        Map<String, String> temp = ExameUtil.getHistoricos(exa_codigo, fil_codigo).get("historicoporcodigo");
        ArrayList<String[]> historicos = new ArrayList<String[]>();
        Set<String> keys = temp.keySet();
        for (String key : keys) {
            historicos.add(new String[]{key, temp.get(key)});
        }
        this.tabela.setData(historicos);
    }

    public void setEditavel(boolean editavel) {
        this.tabela.setEnabled(editavel);
    }

    public void setOrdenavelManualmente(boolean ordenavel) {
        this.tabela.setOrdenavelManualmente(ordenavel);
    }

    public void forceSize(int column, int width) {
        this.tabela.forceSize(column, width);
    }

    public int getRowCount() {
        return this.tabela.getRowCount();
    }

    public int getSelectedRow() {
        return this.tabela.getSelectedRow();
    }

    public Object[] getRow(int row) {
        return this.tabela.getRow(row);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.tabela.getValueAt(rowIndex, columnIndex);
    }

    public void addHistorico(String ieh_campo, String ieh_descricao) {
        this.tabela.addRow(new Object[]{ieh_campo, ieh_descricao});
    }

    public boolean existe(String valor, int coluna) {
        boolean existe = false;
        for (int i = 0; i < this.tabela.getRowCount(); ++i) {
            if (!((String)this.tabela.getValueAt(i, coluna)).equals(valor)) continue;
            existe = true;
            break;
        }
        return existe;
    }

    public void setRenderer(TableCellRenderer renderer) {
        this.tabela.setDefaultRenderer(Object.class, renderer);
    }

    public TableCellRenderer getRenderer() {
        return this.tabela.getDefaultRenderer(Object.class);
    }
}

