/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.componentes;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.renderer.TabelaExamesRenderer;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.TabelaModelada;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class PanelExamesAgrupados
extends JPanel {
    TabelaModelada tabela;
    TabelaExamesAgrupadosRenderer renderer = new TabelaExamesAgrupadosRenderer();
    JScrollPane scrollPanel;
    ArrayList<String> colunasVisiveis;
    ArrayList<String> colunasOcultas;
    ArrayList<PanelAbaAbstrata.Coluna> colunas;
    AbstractInterfaceamento equipamento;

    public PanelExamesAgrupados(AbstractInterfaceamento equipamento, ArrayList<String> colunasVisiveis, ArrayList<String> colunasOcultas, ArrayList<PanelAbaAbstrata.Coluna> colunas) {
        this.equipamento = equipamento;
        this.colunasVisiveis = colunasVisiveis;
        this.colunasOcultas = colunasOcultas;
        this.colunas = colunas;
        this.setLayout(new BorderLayout());
    }

    public void configTabela() {
        this.tabela = this.equipamento.getAbaProntos().getTabela();
        this.tabela.setDefaultRenderer(Object.class, this.renderer);
        this.renderer.addColunasCentralizadas(new Integer[]{this.getColIndice("C\u00f3digo"), this.getColIndice("S"), this.getColIndice("Ide"), this.getColIndice("Mat.")});
        this.renderer.setColunaValidacao(this.getColIndice("Sit"));
        this.renderer.setColunaDataPrevisao(this.getColIndice("Previs\u00e3o"));
        this.renderer.setColunaUrgente(this.getColIndice("Urgente"));
        this.scrollPanel = new JScrollPane(this.tabela);
        this.add((Component)this.scrollPanel, "Center");
    }

    public void setTabela(TabelaModelada tabela) {
        this.scrollPanel = new JScrollPane(tabela);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPanel, "Center");
    }

    public TabelaModelada getTabela() {
        return this.tabela;
    }

    public void loadExamesAgrupados(String fil_codigo, String req_codigo) {
        try {
            ArrayList<Object[]> dados_temp = new ArrayList<Object[]>();
            Statement st = Conexao.getStatement();
            StringBuilder query = new StringBuilder();
            Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(fil_codigo, req_codigo, true);
            query.append("select a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo, a.rec_codigo, ");
            query.append("a.ier_situacao, a.ier_xmlvalores, b.req_anomes, b.req_idade, ");
            query.append("c.pac_nome, c.pac_sexo, d.mco_abreviatura, e.exr_dataentregaprev, a.ier_rackpos, (b.req_urgente or (coalesce(e.exr_urgente, false))) as req_urgente, ");
            query.append("a.int_codigo, f.emi_alternativo ");
            query.append("from interfaceexamerequisicao a ");
            query.append("left join requisicao b on a.fil_codigo=b.fil_codigo and a.req_codigo=b.req_codigo ");
            query.append("left join paciente c on a.fil_codigo=c.fil_codigo and b.pac_codigo=c.pac_codigo ");
            query.append("left join materialcoleta d on a.fil_codigo=d.fil_codigo and a.mco_codigo=d.mco_codigo ");
            query.append("left join examerequisicao e on a.fil_codigo=e.fil_codigo and a.req_codigo=e.req_codigo ");
            query.append(" and a.exa_codigo=e.exa_codigo and a.mco_codigo=e.mco_codigo ");
            query.append("left join examematinterface f on a.fil_codigo=f.fil_codigo and a.exa_codigo=f.exa_codigo and a.mco_codigo=f.mco_codigo and a.int_codigo=f.int_codigo ");
            query.append("where ").append(BDUtil.montaSQLEquipamentoFilial());
            query.append(" and a.fil_codigo = ").append(fil_codigo);
            if (multiguias != null && ParametrosGerais.isAgruparGuiasInterface()) {
                this.adicionarReqsMultiguia(query, multiguias);
            } else {
                query.append(" and a.req_codigo = ").append(req_codigo);
            }
            query.append(" order by a.req_codigo, a.rec_codigo, a.exa_codigo");
            ResultSet rs = Conexao.executeQuery(st, query.toString());
            while (rs != null && rs.next()) {
                if (BDUtil.isExameDesmembrado(rs.getString("fil_codigo"), rs.getString("int_codigo"), rs.getString("exa_codigo"), rs.getString("mco_codigo"))) {
                    query.setLength(0);
                    query.append("select a.fil_codigo, a.req_codigo, a.exa_kodigo, a.mco_kodigo, a.rec_codigo, ");
                    query.append("a.erd_situacao, b.req_anomes, b.req_idade, ");
                    query.append("c.pac_nome, c.pac_sexo, d.mco_abreviatura, e.exr_dataentregaprev, (b.req_urgente or (coalesce(e.exr_urgente, false))) as req_urgente, ");
                    query.append("a.int_codigo, f.emi_alternativo, a.exa_codigo ");
                    query.append("from interfaceexamerequisicaodesm a ");
                    query.append("left join requisicao b on a.fil_codigo=b.fil_codigo and a.req_codigo=b.req_codigo ");
                    query.append("left join paciente c on a.fil_codigo=c.fil_codigo and b.pac_codigo=c.pac_codigo ");
                    query.append("left join materialcoleta d on a.fil_codigo=d.fil_codigo and a.mco_codigo=d.mco_codigo ");
                    query.append("left join examerequisicao e on a.fil_codigo=e.fil_codigo and a.req_codigo=e.req_codigo ");
                    query.append(" and a.exa_codigo=e.exa_codigo and a.mco_codigo=e.mco_codigo ");
                    query.append("left join examematinterface f on a.fil_codigo=f.fil_codigo and a.exa_codigo=f.exa_codigo and a.mco_codigo=f.mco_codigo and a.int_codigo=f.int_codigo ");
                    query.append("where a.fil_codigo = ").append(rs.getString("fil_codigo"));
                    query.append(" and a.int_codigo = ").append(rs.getString("int_codigo"));
                    query.append(" and a.req_codigo = ").append(rs.getInt("req_codigo"));
                    query.append(" and a.exa_codigo = '").append(rs.getString("exa_codigo")).append("'");
                    query.append(" order by a.req_codigo, a.rec_codigo, a.exa_codigo");
                    Statement sta = Conexao.getStatement();
                    ResultSet rst = Conexao.executeQuery(sta, query.toString());
                    while (rst != null && rst.next()) {
                        Object[] linha = new Object[this.getColCount()];
                        req_codigo = Funcoes.preencheZero(rst.getInt("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
                        req_codigo = req_codigo + Funcoes.preencheZero(rst.getInt("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao());
                        String idade = String.valueOf(rst.getInt("req_idade")) + " " + Tipos.tipoIdade(rst.getString("req_anomes"));
                        linha[this.getColIndice((String)"C\u00f3digo")] = req_codigo;
                        linha[this.getColIndice((String)"Paciente")] = rst.getString("pac_nome");
                        linha[this.getColIndice((String)"S")] = rst.getString("pac_sexo");
                        linha[this.getColIndice((String)"Ide")] = idade;
                        linha[this.getColIndice((String)"Exame")] = rst.getString("exa_kodigo") + " (" + rst.getString("exa_codigo") + ")";
                        linha[this.getColIndice((String)"Sit")] = Funcoes.textoVazio(rst.getString("erd_situacao")) ? "0" : rst.getString("erd_situacao");
                        linha[this.getColIndice((String)"Mat.")] = rst.getString("mco_abreviatura");
                        linha[this.getColIndice((String)"C\u00f3d. Mat.")] = rst.getString("mco_kodigo");
                        linha[this.getColIndice((String)"Tubo")] = rst.getString("rec_codigo");
                        String xml = rs.getString("ier_xmlvalores");
                        linha[this.getColIndice((String)"Valores")] = xml;
                        linha[this.getColIndice((String)"Previs\u00e3o")] = rst.getTimestamp("exr_dataentregaprev");
                        linha[this.getColIndice((String)"Urgente")] = rst.getBoolean("req_urgente");
                        linha[this.getColIndice((String)"Interface")] = rst.getString("int_codigo");
                        linha[this.getColIndice((String)"Alternativo")] = rst.getString("emi_alternativo");
                        if (xml != null) {
                            Map<String, Object> dados = StringUtil.getMapDeXML(xml);
                            for (PanelAbaAbstrata.Coluna c : this.colunas) {
                                int index = this.getColIndice(c.getNomeColuna());
                                String campo = c.getNomeCampo() + "@" + rst.getString("exa_kodigo") + "#" + rst.getString("mco_kodigo");
                                String valor = this.notNull((String)dados.get(campo));
                                linha[index] = valor;
                            }
                        }
                        dados_temp.add(linha);
                    }
                    continue;
                }
                Object[] linha = new Object[this.getColCount()];
                req_codigo = Funcoes.preencheZero(rs.getInt("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
                req_codigo = req_codigo + Funcoes.preencheZero(rs.getInt("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao());
                String idade = String.valueOf(rs.getInt("req_idade")) + " " + Tipos.tipoIdade(rs.getString("req_anomes"));
                linha[this.getColIndice((String)"C\u00f3digo")] = req_codigo;
                linha[this.getColIndice((String)"Paciente")] = rs.getString("pac_nome");
                linha[this.getColIndice((String)"S")] = rs.getString("pac_sexo");
                linha[this.getColIndice((String)"Ide")] = idade;
                linha[this.getColIndice((String)"Exame")] = rs.getString("exa_codigo");
                linha[this.getColIndice((String)"Sit")] = rs.getString("ier_situacao");
                linha[this.getColIndice((String)"Mat.")] = rs.getString("mco_abreviatura");
                linha[this.getColIndice((String)"C\u00f3d. Mat.")] = rs.getString("mco_codigo");
                linha[this.getColIndice((String)"Tubo")] = rs.getString("rec_codigo");
                String xml = rs.getString("ier_xmlvalores");
                linha[this.getColIndice((String)"Valores")] = xml;
                linha[this.getColIndice((String)"Previs\u00e3o")] = rs.getTimestamp("exr_dataentregaprev");
                linha[this.getColIndice((String)"Contador")] = rs.getString("ier_rackpos");
                linha[this.getColIndice((String)"Rack")] = rs.getString("ier_rackpos");
                linha[this.getColIndice((String)"Urgente")] = rs.getBoolean("req_urgente");
                linha[this.getColIndice((String)"Interface")] = rs.getString("int_codigo");
                linha[this.getColIndice((String)"Alternativo")] = rs.getString("emi_alternativo");
                if (xml != null) {
                    Map<String, Object> dados = StringUtil.getMapDeXML(xml);
                    for (PanelAbaAbstrata.Coluna c : this.colunas) {
                        int index = this.getColIndice(c.getNomeColuna());
                        String campo = c.getNomeCampo();
                        String valor = this.notNull((String)dados.get(campo));
                        linha[index] = valor;
                    }
                }
                dados_temp.add(linha);
            }
            this.tabela.setSortedData(dados_temp, this.getColIndice("C\u00f3digo"));
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void adicionarReqsMultiguia(StringBuilder query, Integer[] multiguias) {
        query.append(" and a.req_codigo in (");
        for (int i = 0; i < multiguias.length; ++i) {
            query.append(multiguias[i]);
            if (i >= multiguias.length - 1) continue;
            query.append(", ");
        }
        query.append(") ");
    }

    public int getColCount() {
        return this.colunasVisiveis.size() + this.colunasOcultas.size();
    }

    public int getColIndice(String nome_coluna) {
        int c = this.colunasVisiveis.indexOf(nome_coluna);
        if (c >= 0) {
            return c;
        }
        c = this.colunasOcultas.indexOf(nome_coluna);
        if (c >= 0) {
            return this.colunasVisiveis.size() + c;
        }
        return -1;
    }

    public String notNull(String text) {
        return text == null || text.equals("null") ? "" : text;
    }

    class TabelaExamesAgrupadosRenderer
    extends TabelaExamesRenderer {
        JLabel labelPronto = new JLabel("Pronto");
        JLabel labelRepetindo = new JLabel("Repetindo");
        JLabel labelRepetido = new JLabel("Repetido");
        JLabel labelValidado = new JLabel("Validado");
        JLabel labelAguardando = new JLabel("Aguardando");

        public TabelaExamesAgrupadosRenderer() {
            this.labelPronto.setOpaque(true);
            this.labelRepetindo.setOpaque(true);
            this.labelRepetido.setOpaque(true);
            this.labelValidado.setOpaque(true);
            this.labelAguardando.setOpaque(true);
        }

        @Override
        public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            JLabel c = this;
            if (column == this.coluna_validacao) {
                switch (Integer.parseInt((String)value)) {
                    case 2: {
                        c = this.labelPronto;
                        break;
                    }
                    case 3: {
                        c = this.labelRepetindo;
                        break;
                    }
                    case 4: {
                        c = this.labelRepetido;
                        break;
                    }
                    case 7: {
                        c = this.labelValidado;
                    }
                }
            } else if (column == this.coluna_flag) {
                Boolean temFlag;
                c = this.label_vazio;
                if (this.coluna_flag >= 0 && (temFlag = (Boolean)table.getValueAt(row, this.coluna_flag)) != null && temFlag.booleanValue()) {
                    c = this.label_flag;
                }
            } else {
                this.setValue(value);
                if (c instanceof JLabel) {
                    c.setHorizontalAlignment(this.centralizadas.contains(column) ? 0 : 10);
                }
            }
            if (selected) {
                ((Component)c).setForeground(table.getSelectionForeground());
                ((Component)c).setBackground(table.getSelectionBackground());
            } else {
                ((Component)c).setBackground(table.getBackground());
            }
            try {
                boolean bol;
                if (this.coluna_dataPrevisao >= 0) {
                    Date dtAtual;
                    Date dt = (Date)table.getValueAt(row, this.coluna_dataPrevisao);
                    if (dt.before(dtAtual = new Date())) {
                        ((Component)c).setForeground(Color.RED);
                    } else if (Funcoes.hoje(Funcoes.formataData(dt))) {
                        ((Component)c).setForeground(Color.BLUE);
                    } else {
                        ((Component)c).setForeground(table.getForeground());
                    }
                }
                if (this.coluna_urgente >= 0 && !selected && (bol = ((Boolean)table.getValueAt(row, this.coluna_urgente)).booleanValue())) {
                    ((Component)c).setBackground(ScreenUtil.clarearCor(Color.RED, 200));
                }
            }
            catch (Exception bol) {
                // empty catch block
            }
            ((Component)c).setFont(table.getFont());
            if (focused) {
                Border border = selected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.focusCellHighlightBorder");
                ((JComponent)c).setBorder(border);
                if (!selected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        ((Component)c).setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        ((Component)c).setBackground(col);
                    }
                }
            } else {
                ((JComponent)c).setBorder(noFocusBorder);
            }
            return c;
        }
    }
}

