/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.abas.renderer;

import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

public class TabelaExamesRenderer
extends DefaultTableCellRenderer {
    protected ArrayList<Integer> centralizadas = new ArrayList();
    protected int coluna_validacao = -1;
    protected int coluna_dataPrevisao = -1;
    protected int coluna_urgente = -1;
    protected int coluna_examerotina = -1;
    protected int coluna_flag = -1;
    protected int coluna_valorAlterado = -1;
    protected JCheckBox check = new JCheckBox();
    protected ImageIcon repetindo = ImagemUtils.carregaImagemJalis("sit_repetindo.png");
    protected ImageIcon com_repeticao = ImagemUtils.carregaImagemJalis("sit_com_repeticao.png");
    protected ImageIcon com_excecao = ImagemUtils.carregaImagemJalis("sit_com_excecao.png");
    protected ImageIcon flag = ImagemUtils.carregaImagemJalis("sit_flag.png");
    protected JLabel label_repetindo = new JLabel(this.repetindo, 0);
    protected JLabel label_com_repeticao = new JLabel(this.com_repeticao, 0);
    protected JLabel label_com_excecao = new JLabel(this.com_excecao, 0);
    protected JLabel label_flag = new JLabel(this.flag, 0);
    protected JLabel label_vazio = new JLabel();
    protected boolean destacarExames = false;
    public static final Color COR_VALORALTERADO = new Color(255, 204, 51);

    public TabelaExamesRenderer() {
        this.check.setHorizontalAlignment(0);
        this.label_repetindo.setOpaque(true);
        this.label_com_repeticao.setOpaque(true);
        this.label_com_excecao.setOpaque(true);
        this.label_flag.setOpaque(true);
        this.label_vazio.setOpaque(true);
    }

    public TabelaExamesRenderer(ArrayList<Integer> colunas_centralizadas) {
        if (colunas_centralizadas != null && !colunas_centralizadas.isEmpty()) {
            this.centralizadas = colunas_centralizadas;
        }
    }

    public TabelaExamesRenderer(int coluna_validacao) {
        if (coluna_validacao >= 0) {
            this.coluna_validacao = coluna_validacao;
        }
    }

    public TabelaExamesRenderer(ArrayList<Integer> colunas_centralizadas, int coluna_validacao) {
        if (colunas_centralizadas != null && !colunas_centralizadas.isEmpty()) {
            this.centralizadas = colunas_centralizadas;
        }
        if (coluna_validacao >= 0) {
            this.coluna_validacao = coluna_validacao;
        }
    }

    public void addColunaCentralizada(int coluna) {
        if (!this.centralizadas.contains(coluna)) {
            this.centralizadas.add(coluna);
        }
    }

    public void addColunasCentralizadas(Integer[] colunas) {
        Integer[] integerArray = colunas;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int coluna = integerArray[i];
            if (this.centralizadas.contains(coluna)) continue;
            this.centralizadas.add(coluna);
        }
    }

    public void setColunaValidacao(int coluna) {
        if (coluna >= 0) {
            this.coluna_validacao = coluna;
        }
    }

    public void setColunaFlag(int coluna) {
        if (coluna >= 0) {
            this.coluna_flag = coluna;
        }
    }

    public void setColunaDataPrevisao(int coluna) {
        if (coluna >= 0) {
            this.coluna_dataPrevisao = coluna;
        }
    }

    public void setColunaExameRotina(int coluna) {
        if (coluna >= 0) {
            this.coluna_examerotina = coluna;
        }
    }

    public void setColunaUrgente(int coluna) {
        if (coluna >= 0) {
            this.coluna_urgente = coluna;
        }
    }

    public void setColunaValorAlterado(int coluna) {
        if (coluna >= 0) {
            this.coluna_valorAlterado = coluna;
        }
    }

    public void setDestacarValoresAlterados(boolean destacarExames) {
        this.destacarExames = destacarExames;
    }

    public void corrigeIndices(int coluna_inserida) {
        try {
            for (int i = 0; i < this.centralizadas.size(); ++i) {
                int centralizada = this.centralizadas.get(i);
                if (coluna_inserida > centralizada) continue;
                this.centralizadas.set(i, centralizada++);
            }
            if (coluna_inserida <= this.coluna_validacao) {
                ++this.coluna_validacao;
            }
            if (coluna_inserida <= this.coluna_flag) {
                ++this.coluna_flag;
            }
            if (coluna_inserida <= this.coluna_dataPrevisao) {
                ++this.coluna_dataPrevisao;
            }
            if (coluna_inserida <= this.coluna_examerotina) {
                ++this.coluna_examerotina;
            }
            if (coluna_inserida <= this.coluna_urgente) {
                ++this.coluna_urgente;
            }
            if (coluna_inserida <= this.coluna_valorAlterado) {
                ++this.coluna_valorAlterado;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
        Component c;
        Component result = c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
        if (column == this.coluna_validacao) {
            switch (Integer.parseInt((String)value)) {
                case 2: {
                    this.check.setSelected(false);
                    c = this.check;
                    break;
                }
                case 3: {
                    c = this.label_repetindo;
                    break;
                }
                case 5: {
                    c = this.label_repetindo;
                    break;
                }
                case 4: {
                    c = this.label_com_repeticao;
                    break;
                }
                case 7: {
                    this.check.setSelected(true);
                    c = this.check;
                    break;
                }
                case 6: {
                    c = this.label_com_excecao;
                    break;
                }
                case 12: {
                    c = this.label_com_repeticao;
                    break;
                }
                default: {
                    c = this.label_com_repeticao;
                    break;
                }
            }
        } else if (column == this.coluna_flag) {
            Boolean temFlag;
            c = this.label_vazio;
            if (this.coluna_flag >= 0 && (temFlag = (Boolean)table.getValueAt(row, this.coluna_flag)) != null && temFlag.booleanValue()) {
                c = this.label_flag;
            }
        } else {
            this.setValue(value);
            if (c instanceof JLabel) {
                ((JLabel)c).setHorizontalAlignment(this.centralizadas.contains(column) ? 0 : 10);
            }
        }
        if (selected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        this.setFont(table.getFont());
        try {
            Boolean bol;
            Date dt;
            if (this.coluna_dataPrevisao >= 0 && (dt = (Date)table.getValueAt(row, this.coluna_dataPrevisao)) != null) {
                Date dtAtual = new Date();
                if (dt.before(dtAtual)) {
                    this.setForeground(Color.RED);
                } else if (Funcoes.hoje(Funcoes.formataData(dt))) {
                    this.setForeground(Color.BLUE);
                } else {
                    this.setForeground(table.getForeground());
                }
            }
            if (this.coluna_urgente >= 0 && !selected && table.getValueAt(row, this.coluna_urgente) != null && table.getValueAt(row, this.coluna_urgente) instanceof Boolean && (bol = (Boolean)table.getValueAt(row, this.coluna_urgente)).booleanValue()) {
                this.setBackground(ScreenUtil.clarearCor(Color.RED, 200));
            }
            if (this.destacarExames && this.coluna_valorAlterado >= 0 && table.getValueAt(row, this.coluna_valorAlterado) != null && table.getValueAt(row, this.coluna_valorAlterado) instanceof Integer) {
                Integer valorAlterado = (Integer)table.getValueAt(row, this.coluna_valorAlterado);
                if (selected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else if (valorAlterado == 1) {
                    ((JComponent)result).setBorder(BorderFactory.createMatteBorder(3, 0, 3, 0, COR_VALORALTERADO));
                }
            }
            if (this.coluna_examerotina >= 0 && table.getValueAt(row, this.coluna_examerotina) instanceof Boolean && !(bol = (Boolean)table.getValueAt(row, this.coluna_examerotina)).booleanValue()) {
                Font f = table.getFont();
                f = new Font(f.getName(), 1, f.getSize());
                c.setFont(f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (focused) {
            Border border = selected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.focusCellHighlightBorder");
            ((JComponent)c).setBorder(border);
            if (!selected && table.isCellEditable(row, column)) {
                Color col = UIManager.getColor("Table.focusCellForeground");
                if (col != null) {
                    c.setForeground(col);
                }
                if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                    c.setBackground(col);
                }
            }
        }
        return c;
    }
}

