/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.abas;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.renderer.TabelaExamesRenderer;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.TabelaModelada;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelecionaExame
extends JDialog
implements ActionListener {
    public static final String SIT_REPETIR = String.valueOf(3);
    public static final String SIT_PRONTO = String.valueOf(2);
    private AbstractInterfaceamento equipamento;
    private JLabel labelDescricao = new JLabel("Selecione os exames que ser\u00e3o re-enviados");
    private JPanel panelDescricao = new JPanel(new FlowLayout(0));
    ArrayList exames;
    protected ArrayList<PanelAbaAbstrata.Coluna> colunas = new ArrayList();
    private TabelaExamesRenderer rendererTabela = new TabelaExamesRenderer();
    private TabelaModelada tabelaExamesRepetir = new TabelaModelada(new ArrayList<String>());
    protected ArrayList<String> colunasVisiveis = new ArrayList();
    protected ArrayList<String> colunasOcultas = new ArrayList();
    private JScrollPane scrollTabela;
    private JLabel labelDescricaoDes = new JLabel("Exames desmembrado");
    private JPanel panelDescricaoDes = new JPanel(new BorderLayout());
    protected TabelaExamesRenderer rendererTabelaDes = new TabelaExamesRenderer();
    protected TabelaModelada tabelaExamesRepetirDes = new TabelaModelada(new ArrayList<String>());
    protected JScrollPane scrollTabelaDes;
    private JButton buttonOk = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));

    public SelecionaExame(AbstractInterfaceamento equipamento, ArrayList exames, ArrayList<PanelAbaAbstrata.Coluna> colunas, ArrayList<String> colunasVisiveis, ArrayList<String> colunasOcultas) {
        super(Laboratorio.getInstancia());
        this.colunas = colunas;
        this.colunasVisiveis = colunasVisiveis;
        this.colunasOcultas = colunasOcultas;
        this.equipamento = equipamento;
        this.setPreferredSize(new Dimension(800, 400));
        this.setSize(new Dimension(800, 400));
        this.setModal(true);
        this.setResizable(false);
        this.setTitle("Repetir Exame");
        this.setLocationRelativeTo(Laboratorio.getInstancia());
        this.initTable();
        this.initTableDes();
        this.init();
        try {
            ArrayList<Object[]> newExames = new ArrayList<Object[]>();
            for (int i = 0; i < exames.size(); ++i) {
                Object[] oldArray = (Object[])exames.get(i);
                Object[] newArray = new Object[oldArray.length + 1];
                System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
                this.carregarExamesFilhos(newArray);
                newExames.add(newArray);
            }
            this.exames = newExames;
        }
        catch (SQLException ex) {
            this.exames = new ArrayList();
        }
        this.carregarExames();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.panelDescricao.add(this.labelDescricao);
        this.add((Component)this.panelDescricao, "North");
        this.panelDescricaoDes.add((Component)this.labelDescricaoDes, "North");
        this.panelDescricaoDes.add((Component)this.scrollTabelaDes, "Center");
        JSplitPane splt = new JSplitPane(0, this.scrollTabela, this.panelDescricaoDes);
        splt.setDividerLocation(100);
        this.add((Component)splt, "Center");
        this.panelBotoes.add(this.buttonOk);
        this.panelBotoes.add(this.buttonCancelar);
        this.add((Component)this.panelBotoes, "South");
    }

    private void carregarExames() {
        this.tabelaExamesRepetir.setSortedData(this.exames, this.getColIndice("C\u00f3digo"));
    }

    protected void initTable() {
        for (String s : this.colunasVisiveis) {
            this.tabelaExamesRepetir.addColumn(s);
        }
        this.tabelaExamesRepetir.addColumn("Desmembrado");
        this.tabelaExamesRepetir.forceSize(this.getColIndice("C\u00f3digo"), 90);
        this.tabelaExamesRepetir.forceSize(this.getColIndice("S"), 40);
        this.tabelaExamesRepetir.forceSize(this.getColIndice("Ide"), 70);
        this.tabelaExamesRepetir.forceSize(this.getColIndice("Mat."), 50);
        this.tabelaExamesRepetir.forceSize(this.getColIndice("Exame"), 55);
        this.tabelaExamesRepetir.forceSize(this.getColIndice("Sit"), 60);
        this.tabelaExamesRepetir.forceSize(this.getColIndice("Sit") + 1, 0);
        if (this.equipamento.isContadorEnvio()) {
            this.tabelaExamesRepetir.forceSize(this.getColIndice("Contador"), 60);
        }
        this.tabelaExamesRepetir.setDefaultRenderer(Object.class, this.rendererTabela);
        this.rendererTabela.addColunasCentralizadas(new Integer[]{this.getColIndice("C\u00f3digo"), this.getColIndice("S"), this.getColIndice("Ide"), this.getColIndice("Mat.")});
        this.rendererTabela.setColunaValidacao(this.getColIndice("Sit"));
        this.rendererTabela.setColunaDataPrevisao(this.getColIndice("Previs\u00e3o"));
        this.rendererTabela.setColunaUrgente(this.getColIndice("Urgente"));
        this.scrollTabela = new JScrollPane(this.tabelaExamesRepetir);
        this.tabelaExamesRepetir.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SelecionaExame.this.tabelaExamesRepetir_mouseClicked(e);
            }
        });
        this.tabelaExamesRepetir.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SelecionaExame.this.popularTabelaExamesDes();
            }
        });
    }

    protected void initTableDes() {
        int col_material;
        int col_situacao = this.colunasVisiveis.indexOf("Sit");
        for (col_material = this.colunasVisiveis.indexOf("Mat."); col_material <= col_situacao && col_material < this.colunasVisiveis.size() - 1; ++col_material) {
            this.tabelaExamesRepetirDes.addColumn(this.colunasVisiveis.get(col_material));
        }
        this.tabelaExamesRepetirDes.addColumn(this.colunasVisiveis.get(col_material));
        col_situacao = this.tabelaExamesRepetirDes.getColumnCount() - 1;
        this.tabelaExamesRepetirDes.forceSize(0, 50);
        this.tabelaExamesRepetirDes.forceSize(1, 50);
        this.tabelaExamesRepetirDes.forceSize(col_situacao, 60);
        this.tabelaExamesRepetirDes.setDefaultRenderer(Object.class, this.rendererTabelaDes);
        this.rendererTabelaDes.setColunaValidacao(col_situacao);
        this.scrollTabelaDes = new JScrollPane(this.tabelaExamesRepetirDes);
        this.tabelaExamesRepetirDes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SelecionaExame.this.tabelaExamesRepetirDes_mouseClicked(e);
            }
        });
    }

    public int getColIndice(String nome_coluna) {
        int c = this.colunasVisiveis.indexOf(nome_coluna);
        if (c >= 0) {
            return c;
        }
        c = this.colunasOcultas.indexOf(nome_coluna);
        if (c >= 0) {
            return this.colunasVisiveis.size() + c;
        }
        return -1;
    }

    private void tabelaExamesRepetir_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 1) {
            int row = this.tabelaExamesRepetir.getSelectedRow();
            int col = this.getColIndice("Sit");
            if (row > -1) {
                Object[] exame = this.tabelaExamesRepetir.getRow(row);
                if (exame[exame.length - 1] != null) {
                    return;
                }
                if (this.tabelaExamesRepetir.getSelectedColumn() != col) {
                    return;
                }
                String sit = (String)this.tabelaExamesRepetir.getValueAt(row, col);
                if (!sit.equalsIgnoreCase(SIT_REPETIR)) {
                    this.tabelaExamesRepetir.setValueAt(SIT_REPETIR, row, col);
                } else {
                    this.tabelaExamesRepetir.setValueAt(SIT_PRONTO, row, col);
                }
            }
        }
    }

    public void tabelaExamesRepetirDes_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 1) {
            int row = this.tabelaExamesRepetirDes.getSelectedRow();
            int col = this.tabelaExamesRepetirDes.getColumnCount() - 1;
            if (this.tabelaExamesRepetirDes.getSelectedColumn() != col) {
                return;
            }
            String sit = (String)this.tabelaExamesRepetirDes.getValueAt(row, col);
            if (!sit.equalsIgnoreCase(SIT_REPETIR)) {
                this.tabelaExamesRepetirDes.setValueAt(SIT_REPETIR, row, col);
            } else {
                this.tabelaExamesRepetirDes.setValueAt(SIT_PRONTO, row, col);
            }
            boolean algumMarcado = false;
            for (int i = 0; i < this.tabelaExamesRepetir.getRowCount(); ++i) {
                if (!this.tabelaExamesRepetirDes.getValueAt(row, col).toString().equals(SIT_REPETIR)) continue;
                algumMarcado = true;
                break;
            }
            if (algumMarcado) {
                this.tabelaExamesRepetir.setValueAt(SIT_REPETIR, this.tabelaExamesRepetir.getSelectedRow(), this.getColIndice("Sit"));
            } else {
                this.tabelaExamesRepetir.setValueAt(SIT_PRONTO, this.tabelaExamesRepetir.getSelectedRow(), this.getColIndice("Sit"));
            }
        }
    }

    public ArrayList getRequisicaoExames() {
        return this.exames;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancelar) {
            this.exames = new ArrayList();
            this.setVisible(false);
        } else if (e.getSource() == this.buttonOk) {
            this.setVisible(false);
        }
    }

    public ArrayList carregaExamesDesmembrados(String fil_codigo, String req_codigo, String exa_codigo, String mco_codigo, String int_codigo) throws SQLException {
        ArrayList<Object[]> dados = new ArrayList<Object[]>();
        Statement s = Conexao.getStatement();
        StringBuilder query = new StringBuilder();
        query.append(" select ier_xmlvalores from ");
        query.append(" interfaceexamerequisicao where ");
        query.append(" fil_codigo = ").append(fil_codigo);
        query.append(" and req_codigo = ").append(req_codigo);
        query.append(" and mco_codigo = ").append(mco_codigo);
        query.append(" and exa_codigo = '").append(exa_codigo).append("'");
        query.append(" and int_codigo = ").append(int_codigo);
        ResultSet rs = Conexao.executeQuery(s, query.toString());
        if (!rs.next()) {
            return dados;
        }
        String xml = rs.getString("ier_xmlvalores");
        query.setLength(0);
        query.append(" select mco_abreviatura, exa_kodigo, erd_situacao ");
        query.append(" from interfaceexamerequisicaodesm a ");
        query.append(" left join materialcoleta b on a.fil_codigo = b.fil_codigo ");
        query.append(" and a.mco_kodigo = b.mco_codigo  ");
        query.append(" where a.fil_codigo = ").append(fil_codigo);
        query.append(" and a.req_codigo = ").append(req_codigo);
        query.append(" and a.exa_codigo = '").append(exa_codigo).append("'");
        query.append(" and a.mco_codigo = ").append(mco_codigo);
        query.append(" and a.int_codigo = ").append(int_codigo);
        rs = Conexao.executeQuery(s, query.toString());
        Map<String, Object> dadosXML = StringUtil.getMapDeXML(xml);
        while (rs.next()) {
            Object[] linha = new Object[this.tabelaExamesRepetirDes.getColumnCount()];
            int col = 0;
            linha[col++] = rs.getString("mco_abreviatura");
            linha[col++] = rs.getString("exa_kodigo");
            for (PanelAbaAbstrata.Coluna c : this.colunas) {
                for (String st : dadosXML.keySet()) {
                    String campo = st;
                    if (campo.indexOf("@") < 0) continue;
                    String exame = campo.substring(campo.indexOf("@") + 1, campo.indexOf("#"));
                    String material = campo.substring(campo.indexOf("#") + 1);
                    if (!(campo = campo.substring(0, campo.indexOf("@"))).equalsIgnoreCase(c.getNomeCampo()) || !rs.getString("exa_kodigo").equalsIgnoreCase(exame)) continue;
                    linha[col++] = dadosXML.get(st);
                }
            }
            linha[this.tabelaExamesRepetirDes.getColumnCount() - 1] = rs.getString("erd_situacao");
            dados.add(linha);
        }
        return dados;
    }

    private void carregarExamesFilhos(Object[] exame) throws SQLException {
        String mco_codigo;
        if (!this.validaExameDesmembrado(exame)) {
            exame[exame.length - 1] = null;
            return;
        }
        String aux = (String)exame[this.getColIndice("C\u00f3digo")];
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            aux = (String)exame[this.getColIndice("Multiguia")];
        }
        String fil_codigo = aux.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = aux.substring(ParametrosGerais.getDigitosTuboFilial());
        String int_codigo = (String)exame[this.getColIndice("Interface")];
        String exa_codigo = (String)exame[this.getColIndice("Exame")];
        ArrayList dados = this.carregaExamesDesmembrados(fil_codigo, req_codigo, exa_codigo, mco_codigo = (String)exame[this.getColIndice("C\u00f3d. Mat.")], int_codigo);
        if (dados.isEmpty()) {
            ArrayList<String> auxMultiguias = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
            for (int i = 0; i < auxMultiguias.size() && ((dados = this.carregaExamesDesmembrados(fil_codigo, auxMultiguias.get(i), exa_codigo, mco_codigo, int_codigo)) == null || dados.isEmpty()); ++i) {
            }
        }
        exame[exame.length - 1] = dados;
    }

    private boolean validaExameDesmembrado(Object[] exame) throws SQLException {
        String aux = (String)exame[this.getColIndice("C\u00f3digo")];
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            aux = (String)exame[this.getColIndice("Multiguia")];
        }
        String fil_codigo = aux.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = aux.substring(ParametrosGerais.getDigitosTuboFilial());
        String int_codigo = (String)exame[this.getColIndice("Interface")];
        String exa_codigo = (String)exame[this.getColIndice("Exame")];
        String mco_codigo = (String)exame[this.getColIndice("C\u00f3d. Mat.")];
        Statement st = Conexao.getStatement();
        boolean result = BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exa_codigo, mco_codigo);
        st.close();
        return result;
    }

    private void popularTabelaExamesDes() {
        int pos = this.tabelaExamesRepetir.getSelectedRow();
        if (pos > -1) {
            Object[] exame = this.tabelaExamesRepetir.getRow(pos);
            ArrayList desmembrado = (ArrayList)exame[exame.length - 1];
            if (desmembrado != null) {
                this.tabelaExamesRepetirDes.setData(desmembrado);
            } else {
                this.tabelaExamesRepetirDes.setData(new ArrayList());
            }
        }
    }

    public int retornaLinhaSelecionadaTabelaExamesRepetir() {
        return this.tabelaExamesRepetir.getSelectedRow() < 0 ? 0 : this.tabelaExamesRepetir.getSelectedRow();
    }
}

