/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.abas;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.informacao.InfoRequisicao;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.InterfaceamentoConfiguracao;
import jalis.laboratorio.interfaceamento.abas.renderer.TabelaExamesRenderer;
import jalis.laboratorio.interfaceamento.componentes.PanelBotoes;
import jalis.laboratorio.interfaceamento.componentes.PanelExamesAgrupados;
import jalis.laboratorio.interfaceamento.comunicacao.FlowController;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.configuracao.EquipamentoFilial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.Exame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.DBUtil;
import jalis.util.DialogUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TableUtil;
import jalis.util.TempoUtil;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.tabela.TabelaModelada;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class PanelAbaAbstrata
extends JPanel {
    public static final long NAO_ENVIADOS_EXCLUIR = 1001001001L;
    public static final long NAO_ENVIADOS_ENVIAR = 1001001002L;
    public static final long PENDENTES_EXCLUIR = 1001002001L;
    public static final long PENDENTES_RESULTADOS = 1001002002L;
    public static final long PRONTOS_EXCLUIR = 1001003001L;
    public static final long PRONTOS_EXPORTAR = 1001003002L;
    public static final long PRONTOS_LIBERAR_UM = 1001003003L;
    public static final long PRONTOS_REPETIR = 1001003004L;
    public static final long PRONTOS_EDITAR = 1001003005L;
    public static final long PRONTOS_VALIDACAO = 1001003006L;
    public static final long PRONTOS_CONFERIR = 1001003007L;
    public static final long PENDENTES_LOTE = 1001001003L;
    public static final long PRONTOS_EDITAR_VALIDO = 1001003009L;
    public static final String COL_CODIGO = "C\u00f3digo";
    public static final String COL_NOME = "Paciente";
    public static final String COL_SEXO = "S";
    public static final String COL_IDADE = "Ide";
    public static final String COL_DATA = "Data";
    public static final String COL_HORA = "Hora";
    public static final String COL_MATERIAL = "Mat.";
    public static final String COL_EXAME = "Exame";
    public static final String COL_USUARIO = "Usu\u00e1rio";
    public static final String COL_SITUACAO = "Sit";
    public static final String COL_CONTADOR = "Contador";
    public static final String COL_FLAG = "F";
    public static final String COL_MATCOD = "C\u00f3d. Mat.";
    public static final String COL_TUBO = "Tubo";
    public static final String COL_VALORES = "Valores";
    public static final String COL_DATAPREVISAO = "Previs\u00e3o";
    public static final String COL_RACKPOS = "Rack";
    public static final String COL_URGENTE = "Urgente";
    public static final String COL_INTERFACE = "Interface";
    public static final String COL_ALTERNATIVO = "Alternativo";
    public static final String COL_EXAMEROTINA = "Exame da Rotina";
    public static final String COL_MULTIGUIA = "Multiguia";
    public static final String COL_CODIGOTEMP = "C\u00f3digo Temp.";
    public static final String COL_TUBOSFILHO = "Tubos Filhos";
    public static final String COL_EXAMESFILHO = "Exames Filhos";
    public static final String COL_CODIGOAPOIADO = "Cod. Apoiado";
    public static final String COL_CODIGOMETODO = "Cod. M\u00e9todo";
    public static final String COL_CODIGOPACIENTE = "Cod. Paciente";
    public static final String COL_VALORALTERADO = "Valor Alterado";
    public static final String SIT_NAO_ENVIADO = String.valueOf(0);
    public static final String SIT_PENDENTE = String.valueOf(1);
    public static final String SIT_PRONTO = String.valueOf(2);
    public static final String SIT_REPETINDO = String.valueOf(3);
    public static final String SIT_A_REPETIR = String.valueOf(5);
    public static final String SIT_COM_REPETICAO = String.valueOf(4);
    public static final String SIT_PRONTO_VALIDADO = String.valueOf(7);
    public static final String SIT_EXPORTADO = String.valueOf(8);
    public static final String SIT_CANCELADO = String.valueOf(9);
    protected static final Cursor CURSOR_ESPERA = new Cursor(3);
    protected static final Cursor CURSOR_SETA = new Cursor(0);
    protected Color COR_ALERTA = SystemColor.inactiveCaption;
    protected Color COR_NORMAL = UIManager.getColor("TabbedPane.unselectedTabBackground");
    protected Color TEXTO = UIManager.getColor("TabbedPane.font");
    protected static final boolean ON = true;
    protected static final boolean OFF = false;
    private boolean loadingExames = false;
    protected JPanel jPanelMain = new JPanel(new BorderLayout());
    protected JPanel jPanelTop = new JPanel(new BorderLayout());
    protected JPanel jPanelEquip = new JPanel(new BorderLayout());
    protected JPanel jPanelHeader = new JPanel(new BorderLayout());
    protected JPanel jPanelFoot = new JPanel(new BorderLayout());
    protected PanelBotoes button_panel = new PanelBotoes("Linha selecionada");
    protected JSplitPane splitPane = new JSplitPane(0);
    protected JScrollPane scrollExames = new JScrollPane();
    protected AbstractInterfaceamento equipamento;
    protected ArrayList<Coluna> colunas = new ArrayList();
    protected TabelaExamesRenderer renderer = new TabelaExamesRenderer();
    protected TabelaModelada tabelaExames = new TabelaModelada(new ArrayList<String>());
    protected PanelExamesAgrupados panelAgrupados;
    protected ArrayList<String> colunasVisiveis = new ArrayList();
    protected ArrayList<String> colunasOcultas = new ArrayList();
    private JPanel jPanelInfo = new JPanel(new BorderLayout());
    private JPanel jPanelFind = new JPanel(new BorderLayout());
    private JPanel jPanelFindRight = new JPanel(null);
    private JButton jButtonFechar = new BotaoNavegavel("Fechar", ImagemUtils.carregaImagemJalis("botao_fechar.gif"), 'F');
    private JPanel jPanelFindLeft = new JPanel(null);
    private JTextField jTextFieldLocalizar = new JTextField();
    private JLabel jLabelLocalizar = new JLabel("Localizar:");
    private JLabel jLabelAlerta = new JLabel("Conte\u00fado n\u00e3o localizado!");
    protected JFrame parent;
    protected String variaveis;
    private static final String DESTACAR_EXAMES_FORA_VALOR_REFERENCIA = "destacarExamesValoresReferencia";
    private static final String NOME = "nome";
    private static final String VALOR = "valor";
    private static final String VARIAVEL = "variavel";
    protected JComboBox comboEquipamentos = new JComboBox();
    protected JPanel panelEquipamentos = ComponenteFactory.novoJPanelBorderLayout("Equipamento", this.comboEquipamentos);
    private ArrayList<ConfiguracaoSerial> configuracoes;
    AlertThread alerta = new AlertThread();
    protected JPopupMenu popupNaoEnviado = new JPopupMenu("N\u00e3o Enviado");
    protected JPopupMenu popupPendente = new JPopupMenu("Pendete");
    protected JPopupMenu popupPronto = new JPopupMenu("Pronto");
    protected JMenuItem menuItemNaoEnviado = new JMenuItem("Enviar para aba de n\u00e3o enviados");
    protected JMenuItem menuItemPendente = new JMenuItem("Enviar para aba de exames em processamento");
    protected JMenuItem menuItemNaoEnviadoPronto = new JMenuItem("Enviar para aba de n\u00e3o enviados");
    protected JMenuItem menuItemPendentePronto = new JMenuItem("Enviar para aba de exames em processamento");

    public PanelAbaAbstrata(JFrame parent, AbstractInterfaceamento equip, String nome, String descr, String icon_path) {
        try {
            this.parent = parent;
            this.equipamento = equip;
            Funcoes.criaBarraDescricao(this.jPanelTop, nome, descr, icon_path);
            this.configuracoes = new ArrayList();
            for (ConfiguracaoSerial c : Variaveis.equipamentos) {
                if (c.getPortaCOM() == null) continue;
                this.comboEquipamentos.addItem(c);
                this.configuracoes.add(c);
                this.variaveis = c.getVariaveisConfiguracao();
            }
            this.panelEquipamentos.setVisible(this.comboEquipamentos.getItemCount() > 1);
            this.destacarExamesForaDoValoresReferencia();
            this.jbInit();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(parent, e.getMessage(), e.getStackTrace(), "PanelAbaAbstrata");
        }
    }

    private void destacarExamesForaDoValoresReferencia() {
        String[] vars = StringUtil.getValores(this.variaveis, VARIAVEL);
        InterfaceamentoConfiguracao config = Variaveis.equip.configuracao;
        String valor = "";
        for (String var : vars) {
            String nome = StringUtil.getValor(var, NOME);
            if (!nome.equalsIgnoreCase(DESTACAR_EXAMES_FORA_VALOR_REFERENCIA)) continue;
            valor = StringUtil.getValor(var, VALOR);
        }
        if (!Funcoes.textoVazio(valor)) {
            config.setDestacarExamesForaValorReferencia(valor.equalsIgnoreCase("1"));
            this.renderer.setDestacarValoresAlterados(valor.equalsIgnoreCase("1"));
        }
    }

    public JComboBox getComboEquipamentos() {
        return this.comboEquipamentos;
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.jLabelLocalizar.setDisplayedMnemonic('F');
        this.jLabelLocalizar.setLabelFor(this.jTextFieldLocalizar);
        this.jLabelAlerta.setFont(new Font("Dialog", 1, 11));
        this.jLabelAlerta.setForeground(Color.red);
        this.jLabelAlerta.setBounds(new Rectangle(188, 6, 151, 15));
        this.jLabelAlerta.setVisible(false);
        this.scrollExames.setHorizontalScrollBarPolicy(30);
        this.add((Component)this.jPanelMain, "Center");
        this.add((Component)this.jPanelInfo, "South");
        this.jPanelEquip.add((Component)this.jPanelHeader, "Center");
        this.jPanelHeader.add((Component)this.button_panel, "Center");
        this.jPanelTop.add((Component)this.jPanelEquip, "South");
        this.jPanelEquip.setFocusable(false);
        this.jPanelTop.setFocusable(false);
        this.jPanelFindRight.setPreferredSize(new Dimension(80, 10));
        this.jButtonFechar.setBounds(new Rectangle(3, 3, 75, 21));
        this.jButtonFechar.setMaximumSize(new Dimension(69, 25));
        this.jButtonFechar.setMargin(new Insets(2, 1, 2, 1));
        this.jLabelLocalizar.setBounds(new Rectangle(5, 6, 58, 15));
        this.jTextFieldLocalizar.setBounds(new Rectangle(62, 3, 121, 21));
        this.jPanelFind.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jPanelFind.setPreferredSize(new Dimension(10, 30));
        this.jPanelInfo.setPreferredSize(new Dimension(10, 0));
        this.jPanelMain.add((Component)this.splitPane, "Center");
        this.splitPane.setBottomComponent(this.jPanelFoot);
        this.splitPane.setTopComponent(this.scrollExames);
        this.jPanelMain.add((Component)this.jPanelTop, "North");
        this.jPanelHeader.setPreferredSize(new Dimension(204, 50));
        this.jPanelFind.add((Component)this.jPanelFindRight, "East");
        this.jPanelFindRight.add((Component)this.jButtonFechar, null);
        this.jPanelFind.add((Component)this.jPanelFindLeft, "Center");
        this.jPanelFindLeft.add((Component)this.jTextFieldLocalizar, null);
        this.jPanelFindLeft.add((Component)this.jLabelLocalizar, null);
        this.jPanelFindLeft.add((Component)this.jLabelAlerta, null);
        this.scrollExames.setPreferredSize(new Dimension(700, 4));
        this.splitPane.getInputMap(2).put(KeyStroke.getKeyStroke("F6"), "none");
        this.splitPane.getInputMap(1).put(KeyStroke.getKeyStroke("F6"), "none");
        this.splitPane.getInputMap(0).put(KeyStroke.getKeyStroke("F6"), "none");
        this.splitPane.getInputMap(2).put(KeyStroke.getKeyStroke("F8"), "none");
        this.splitPane.getInputMap(1).put(KeyStroke.getKeyStroke("F8"), "none");
        this.splitPane.getInputMap(0).put(KeyStroke.getKeyStroke("F8"), "none");
        this.splitPane.setFocusable(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                PanelAbaAbstrata.this.scrollExames.setViewportView(PanelAbaAbstrata.this.tabelaExames);
                if ((JTabbedPane)PanelAbaAbstrata.this.getParent() != null) {
                    int aba_sel = ((JTabbedPane)PanelAbaAbstrata.this.getParent()).getSelectedIndex();
                    String loc = ParametrosLocais.getParametro("aba" + aba_sel);
                    if (loc != null && !loc.equals("")) {
                        PanelAbaAbstrata.this.splitPane.setDividerLocation(Integer.parseInt(loc));
                    }
                    PanelAbaAbstrata.this.removeComponentListener(PanelAbaAbstrata.this.getComponentListeners()[0]);
                }
            }
        });
        this.splitPane.getTopComponent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int loc = PanelAbaAbstrata.this.splitPane.getDividerLocation();
                if (loc >= 0) {
                    int aba_sel = ((JTabbedPane)PanelAbaAbstrata.this.getParent()).getSelectedIndex();
                    ParametrosLocais.setParametro("aba" + aba_sel, String.valueOf(loc));
                    ParametrosLocais.salvaParametros();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                PanelAbaAbstrata.this.this_componentShown(e);
            }
        });
        this.jTextFieldLocalizar.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PanelAbaAbstrata.this.realizaBusca();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PanelAbaAbstrata.this.realizaBusca();
            }
        });
        this.jTextFieldLocalizar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PanelAbaAbstrata.this.jTextFieldLocalizar_keyPressed(e);
            }
        });
        this.jTextFieldLocalizar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelAbaAbstrata.this.jButtonFechar.doClick();
            }
        });
        this.jTextFieldLocalizar.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanelAbaAbstrata.this.hideLocalizar();
                PanelAbaAbstrata.this.jTextFieldLocalizar.setText("");
            }
        });
        this.jButtonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelAbaAbstrata.this.hideLocalizar();
            }
        });
        this.getInputMap(0).put(KeyStroke.getKeyStroke("control L"), "exibe");
        this.getInputMap(1).put(KeyStroke.getKeyStroke("control L"), "exibe");
        this.getInputMap(2).put(KeyStroke.getKeyStroke("control L"), "exibe");
        this.getActionMap().put("exibe", new AbstractAction("exibe"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelAbaAbstrata.this.showLocalizar();
            }
        });
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(73, 2, true), "INFOREQUISICAO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelAbaAbstrata.this.showReqInfo();
            }
        });
        this.popupNaoEnviado.add(this.menuItemPendente);
        this.popupPendente.add(this.menuItemNaoEnviado);
        this.popupPronto.add(this.menuItemNaoEnviadoPronto);
        this.popupPronto.add(this.menuItemPendentePronto);
        this.tabelaExames.setSelectionMode(2);
        this.tabelaExames.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    PanelAbaAbstrata.this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    PanelAbaAbstrata.this.showPopupMenu(e);
                }
            }
        });
        this.menuItemPendente.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelAbaAbstrata.this.enviarExameNaoEnviadoParaPendente();
            }
        });
        this.menuItemNaoEnviado.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelAbaAbstrata.this.enviarExameParaNaoEnviado();
            }
        });
        this.menuItemPendentePronto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelAbaAbstrata.this.enviarExameProntoParaPendente();
            }
        });
        this.menuItemNaoEnviadoPronto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelAbaAbstrata.this.enviarExameParaNaoEnviado();
            }
        });
    }

    protected abstract void loadExames();

    public abstract void transmiteExames(int var1, String var2);

    public void transmiteExames(int row) {
        this.transmiteExames(row, null);
    }

    protected void requisitarResultado(int row) {
        String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_CODIGO));
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_MULTIGUIA));
        }
        String pac_nome = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_NOME));
        String pac_sexo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_SEXO));
        String pac_idade = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_IDADE));
        String exa_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_EXAME));
        String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_MATCOD));
        String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_TUBO));
        String hora = TempoUtil.getCurrentTime();
        String data = TempoUtil.getCurrentDateBr();
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_INTERFACE));
        try {
            this.equipamento.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, null, null, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exa_codigo, "R");
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace(), this.toString());
        }
    }

    public abstract String getAtalhos();

    public void setAmpulheta(boolean ampulheta_on) {
    }

    public void adicionarBotao(JButton botao, Insets insets, char mnemonico, String tooltiptext) {
        this.button_panel.addButton(botao, insets, mnemonico, tooltiptext);
    }

    public void adicionarPanelEmHeader(JPanel panel, String layout_constraint) {
        this.jPanelHeader.add((Component)panel, layout_constraint);
    }

    public void setFocoTabelaExames() {
        this.tabelaExames.grabFocus();
    }

    public int getRowCount() {
        return this.tabelaExames.getRowCount();
    }

    public int getSelectedRow() {
        return this.tabelaExames.getSelectedRow();
    }

    public Object getValueAt(int row, int column) {
        return this.tabelaExames.getValueAt(row, column);
    }

    public void setValueAt(Object value, int row, int column) {
        this.tabelaExames.setValueAt(value, row, column);
    }

    public int getColIndice(String nome_coluna) {
        int c = this.colunasVisiveis.indexOf(nome_coluna);
        if (c >= 0) {
            return c;
        }
        c = this.colunasOcultas.indexOf(nome_coluna);
        if (c >= 0) {
            return this.colunasVisiveis.size() + c;
        }
        return -1;
    }

    public int getColCount() {
        return this.colunasVisiveis.size() + this.colunasOcultas.size();
    }

    protected void addColVisivel(String nome_coluna) {
        this.colunasVisiveis.add(nome_coluna);
        this.tabelaExames.addColumn(nome_coluna);
    }

    protected void addColOculta(String nome_coluna) {
        this.colunasOcultas.add(nome_coluna);
    }

    public void addColVisivel(int index, String nome_coluna, String nome_campo, boolean centralizada) {
        this.colunasVisiveis.add(index, nome_coluna);
        this.colunas.add(new Coluna(nome_coluna, nome_campo));
        this.tabelaExames.addColumn(index, nome_coluna, false);
        this.renderer.corrigeIndices(index);
        if (centralizada) {
            this.renderer.addColunaCentralizada(index);
        }
    }

    public void forceColSize(int index, int size) {
        this.tabelaExames.forceSize(index, size);
    }

    public void alertarUsuario() {
        if (!this.isShowing()) {
            if (this.alerta != null && !this.alerta.isInterrupted()) {
                this.alerta.interrupt();
            }
            this.alerta = new AlertThread();
            this.alerta.start();
        }
    }

    public void reloadExames() {
        if (!this.loadingExames) {
            block7: {
                this.loadingExames = true;
                int selected = -1;
                String reqSel = "";
                String exaSel = "";
                int colCodigo = this.getColIndice(COL_CODIGO);
                int colExame = this.getColIndice(COL_EXAME);
                if (this.tabelaExames != null && this.tabelaExames.getRowCount() > 0 && colCodigo >= 0 && colExame >= 0 && (selected = this.tabelaExames.getSelectedRow()) >= 0 && selected < this.tabelaExames.getRowCount()) {
                    reqSel = (String)this.tabelaExames.getValueAt(selected, colCodigo);
                    exaSel = (String)this.tabelaExames.getValueAt(selected, colExame);
                }
                int coluna_ordenada = this.tabelaExames.getColunaOrdenada();
                this.loadExames();
                if (coluna_ordenada >= 0 && coluna_ordenada != this.tabelaExames.getColunaOrdenada()) {
                    this.tabelaExames.sortRowsByColumn(coluna_ordenada, true);
                }
                try {
                    if (selected < 0 || selected >= this.tabelaExames.getRowCount()) break block7;
                    int rowcount = this.tabelaExames.getRowCount();
                    String req = (String)this.tabelaExames.getValueAt(selected, this.getColIndice(COL_CODIGO));
                    String exa = (String)this.tabelaExames.getValueAt(selected, this.getColIndice(COL_EXAME));
                    if (reqSel.equalsIgnoreCase(req) && exaSel.equalsIgnoreCase(exa)) {
                        this.tabelaExames.selectRow(selected);
                        break block7;
                    }
                    for (int i = 0; i < rowcount && i <= this.tabelaExames.getRowCount(); ++i) {
                        req = (String)this.tabelaExames.getValueAt(i, this.getColIndice(COL_CODIGO));
                        exa = (String)this.tabelaExames.getValueAt(i, this.getColIndice(COL_EXAME));
                        if (!reqSel.equalsIgnoreCase(req) || !exaSel.equalsIgnoreCase(exa)) continue;
                        this.tabelaExames.selectRow(i);
                        break;
                    }
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this.parent, e.getMessage(), e.getStackTrace(), "PanelAbaAbstrata: 586");
                }
            }
            this.tabelaExames.revalidate();
            this.tabelaExames.grabFocus();
            this.loadingExames = false;
        }
    }

    void this_componentShown(ComponentEvent e) {
        this.setCursor(CURSOR_ESPERA);
        this.reloadExames();
        this.setCursor(CURSOR_SETA);
        if (this.alerta != null && !this.alerta.isInterrupted()) {
            this.alerta.interrupt();
        }
    }

    public void realizaBusca() {
        Thread pesquisa = new Thread("Thread - Pesquisa (Abas)"){

            @Override
            public void run() {
                Object cell;
                String prefix = PanelAbaAbstrata.this.jTextFieldLocalizar.getText().toLowerCase();
                if (prefix.equals("")) {
                    return;
                }
                int column = PanelAbaAbstrata.this.tabelaExames.getColunaOrdenada();
                int rows = PanelAbaAbstrata.this.tabelaExames.getRowCount();
                for (int i = 0; i < rows && (cell = PanelAbaAbstrata.this.tabelaExames.getValueAt(i, column)) instanceof String; ++i) {
                    String value = ((String)cell).toLowerCase();
                    if (!value.startsWith(prefix)) continue;
                    PanelAbaAbstrata.this.tabelaExames.selectRow(i);
                    TableUtil.scrollToCenter(PanelAbaAbstrata.this.tabelaExames, i);
                    PanelAbaAbstrata.this.tabelaExames.repaint();
                    PanelAbaAbstrata.this.jTextFieldLocalizar.setBackground(Color.white);
                    PanelAbaAbstrata.this.jTextFieldLocalizar.setForeground(Color.black);
                    PanelAbaAbstrata.this.jLabelAlerta.setVisible(false);
                    return;
                }
                PanelAbaAbstrata.this.jTextFieldLocalizar.setBackground(Color.red);
                PanelAbaAbstrata.this.jTextFieldLocalizar.setForeground(Color.white);
                PanelAbaAbstrata.this.getToolkit().beep();
                PanelAbaAbstrata.this.jLabelAlerta.setVisible(true);
            }
        };
        pesquisa.run();
    }

    public void showLocalizar() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PanelAbaAbstrata.this.setCursor(Cursor.getPredefinedCursor(3));
                PanelAbaAbstrata.this.jPanelInfo.add((Component)PanelAbaAbstrata.this.jPanelFind, "North");
                PanelAbaAbstrata.this.jPanelInfo.setPreferredSize(new Dimension(10, 30));
                PanelAbaAbstrata.this.revalidate();
                PanelAbaAbstrata.this.repaint();
                PanelAbaAbstrata.this.jTextFieldLocalizar.grabFocus();
                PanelAbaAbstrata.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void showLocalizar(char c) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.jPanelInfo.add((Component)this.jPanelFind, "North");
        this.jPanelInfo.setPreferredSize(new Dimension(10, 30));
        this.revalidate();
        this.repaint();
        this.jTextFieldLocalizar.setText(String.valueOf(c));
        this.jTextFieldLocalizar.grabFocus();
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void hideLocalizar() {
        this.jPanelInfo.remove(this.jPanelFind);
        this.jPanelInfo.setPreferredSize(new Dimension(10, 0));
        this.jPanelInfo.revalidate();
        this.jPanelInfo.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PanelAbaAbstrata.this.tabelaExames.grabFocus();
            }
        });
    }

    public String notNull(String text) {
        return text == null || text.equals("null") ? "" : text;
    }

    void showReqInfo() {
        int row = this.tabelaExames.getSelectedRow();
        if (this.parent instanceof Laboratorio) {
            GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)((Laboratorio)this.parent).getRootPane().getGlassPane();
            InfoRequisicao info = new InfoRequisicao((Frame)this.parent, glassPaneMensagem);
            if (row >= 0 && row < this.tabelaExames.getRowCount()) {
                String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_CODIGO));
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_CODIGOTEMP));
                }
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                if (!Funcoes.textoVazio(req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial()))) {
                    info.setRequisicao(fil_codigo, Integer.parseInt(req_codigo));
                }
            }
            DialogUtil.centerAndShow(info, true, false);
            this.requestFocus();
            this.tabelaExames.grabFocus();
            ((Laboratorio)this.parent).getRootPane().setGlassPane(glassPaneMensagem);
        }
    }

    public String deleteExameLocal(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String pac_nome) {
        String retorno = "";
        try {
            Statement st = Conexao.getStatement();
            BDUtil.deletarExame(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
            Conexao.arquivaSQL();
            st.close();
            retorno = "Exame " + exa_codigo + " do paciente " + pac_nome + " foi exclu\u00eddo.";
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this.parent, e.getMessage(), e.getStackTrace(), "deleteExameLocal");
            try {
                Conexao.anulaSQL();
                this.equipamento.refreshSelected();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace(), "deleteExameLocal");
            }
            retorno = "Houve um erro ao tentar excluir exame " + exa_codigo + " do paciente " + pac_nome + ".";
        }
        this.tabelaExames.grabFocus();
        return retorno;
    }

    public void jTextFieldLocalizar_keyPressed(KeyEvent e) {
        block5: {
            int row;
            block7: {
                int key;
                block6: {
                    block4: {
                        key = e.getKeyCode();
                        row = this.tabelaExames.getSelectedRow();
                        if (key != 38 || row < 0 || row - 1 < 0) break block4;
                        this.tabelaExames.selectRow(row - 1);
                        this.hideLocalizar();
                        break block5;
                    }
                    if (key != 40 || row < 0 || row + 1 >= this.tabelaExames.getRowCount()) break block6;
                    this.tabelaExames.selectRow(row + 1);
                    this.hideLocalizar();
                    break block5;
                }
                if (key == 40) break block7;
                if (key != 38) break block5;
            }
            if (row < 0 && this.tabelaExames.getRowCount() > 0) {
                this.tabelaExames.selectRow(0);
                this.hideLocalizar();
            }
        }
    }

    public void reloadLinha(int row) {
        this.setAmpulheta(true);
        if (row >= 0 && row < this.tabelaExames.getRowCount()) {
            String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_CODIGO));
            String exa_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_EXAME));
            String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_MATCOD));
            String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_TUBO));
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_CODIGOTEMP));
            }
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_INTERFACE));
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
            try {
                String requisicao = req_codigo;
                List<BDExame> reqs = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, requisicao, rec_codigo);
                if (reqs != null && reqs.size() > 1) {
                    this.reloadExames();
                } else {
                    Exame exame = new Exame(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
                    int situacao = exame.getSituacaoExame();
                    int valorAlterado = exame.getValorAlterado();
                    String user = "";
                    if (!Funcoes.textoVazio(exame.getUsuarioExame())) {
                        user = exame.getUsuarioExame();
                    }
                    Map<String, Object> dados = exame.getDados();
                    String xml = StringUtil.getXMLDeMap(dados);
                    for (Coluna c : this.colunas) {
                        this.tabelaExames.setValueAt(this.notNull((String)dados.get(c.getNomeCampo())), row, this.getColIndice(c.getNomeColuna()));
                    }
                    this.tabelaExames.setValueAt(String.valueOf(situacao), row, this.getColIndice(COL_SITUACAO));
                    this.tabelaExames.setValueAt(valorAlterado, row, this.getColIndice(COL_VALORALTERADO));
                    this.tabelaExames.setValueAt(String.valueOf(user), row, this.getColIndice(COL_USUARIO));
                    this.tabelaExames.setValueAt(xml, row, this.getColIndice(COL_VALORES));
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "reloadLinha");
                this.reloadExames();
            }
        }
        this.setAmpulheta(false);
    }

    public void transmiteLinha(int sendRow, long acesso, String exames) {
        String fil_codigo;
        ConfiguracaoSerial c;
        if (sendRow >= 0 && this.tabelaExames.getRowCount() > 0 && (c = this.getConfiguracaoPorta(fil_codigo = this.getValueAt(sendRow, this.getColIndice(COL_CODIGO)).toString().substring(0, ParametrosGerais.getDigitosTuboFilial()), this.getValueAt(sendRow, this.getColIndice(COL_INTERFACE)).toString())) != null && c.getFluxoController() != null && c.getFluxoController().isIdle()) {
            ThreadEnvio transmissor = new ThreadEnvio(sendRow, acesso, c.getFluxoController(), exames);
            transmissor.start();
        }
    }

    public void transmiteLinha(int sendRow, long acesso) {
        this.transmiteLinha(sendRow, acesso, null);
    }

    public ArrayList<ConfiguracaoSerial> getConfiguracoesPorta() {
        return this.configuracoes;
    }

    public ConfiguracaoSerial getConfiguracaoPortaSelecionada() {
        return (ConfiguracaoSerial)this.comboEquipamentos.getSelectedItem();
    }

    public ConfiguracaoSerial getConfiguracaoPorta(String fil_codigo, String int_codigo) {
        if (this.equipamento.getStatusAutoEnvio() != null && this.equipamento.getStatusAutoEnvio().isRunning()) {
            for (ConfiguracaoSerial c : this.getConfiguracoesPorta()) {
                for (EquipamentoFilial e : c.getEquipamentos()) {
                    if (e.getFilial() != Integer.parseInt(fil_codigo) || e.getEquipamento() != Integer.parseInt(int_codigo)) continue;
                    return c;
                }
            }
        } else {
            ConfiguracaoSerial c = this.getConfiguracaoPortaSelecionada();
            return c;
        }
        return null;
    }

    protected ArrayList getRequisicaoExames(int row, ArrayList exames) {
        ArrayList<Object> requisicaoExames = new ArrayList<Object>();
        String aux = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_CODIGO));
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            aux = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_MULTIGUIA));
        }
        int fil_codigo = Integer.parseInt(aux.substring(0, ParametrosGerais.getDigitosTuboFilial()));
        int req_codigo = Integer.parseInt(aux.substring(ParametrosGerais.getDigitosTuboFilial()));
        int rec_codigo = Integer.parseInt((String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_TUBO)));
        for (int i = 0; i < exames.size(); ++i) {
            Object[] exame = (Object[])exames.get(i);
            aux = (String)exame[this.getColIndice(COL_CODIGO)];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                aux = (String)exame[this.getColIndice(COL_MULTIGUIA)];
            }
            int filial = Integer.parseInt(aux.substring(0, ParametrosGerais.getDigitosTuboFilial()));
            int requisicao = Integer.parseInt(aux.substring(ParametrosGerais.getDigitosTuboFilial()));
            int tubo = Integer.parseInt((String)exame[this.getColIndice(COL_TUBO)]);
            if (fil_codigo != filial || req_codigo != requisicao || rec_codigo != tubo) continue;
            requisicaoExames.add(exame.clone());
        }
        return requisicaoExames;
    }

    public TabelaModelada getTabela() {
        return this.tabelaExames;
    }

    protected void exibirAlterarExamesAgrupados(JCheckBox check) {
        if (!check.isSelected()) {
            this.jPanelFoot.remove(this.panelAgrupados);
        } else {
            this.equipamento.examesProntos = null;
            this.panelAgrupados = new PanelExamesAgrupados(this.equipamento, this.equipamento.getAbaProntos().colunasVisiveis, this.equipamento.getAbaProntos().colunasOcultas, this.equipamento.getAbaProntos().colunas);
            this.panelAgrupados.configTabela();
            this.jPanelFoot.add((Component)this.panelAgrupados, "North");
            if (this.tabelaExames.getSelectedRow() < 0) {
                return;
            }
            this.carregaLinhasExameAgrupados();
            this.tabelaExames.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (PanelAbaAbstrata.this.tabelaExames.getSelectedRow() < 0) {
                        return;
                    }
                    PanelAbaAbstrata.this.carregaLinhasExameAgrupados();
                }
            });
            this.tabelaExames.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (PanelAbaAbstrata.this.tabelaExames.getSelectedRow() < 0) {
                        return;
                    }
                    PanelAbaAbstrata.this.carregaLinhasExameAgrupados();
                }
            });
        }
        this.jPanelFoot.revalidate();
        this.jPanelFoot.repaint();
    }

    public abstract void exibeUltimoEnviado(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    public abstract void exibeUltimoExportado(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    protected void gravaLogExclusaoRequisicao(Object pai, Statement st, String filial, String interfaceamento, String requisicao, String material, String tubo, String exame, String aba) throws Exception {
        requisicao = Integer.toString(Integer.parseInt(requisicao));
        StringBuilder buf = new StringBuilder();
        StringBuilder motivo = new StringBuilder();
        Date d = new Date();
        motivo.append("Requisi\u00e7\u00e3o excluida na tela de interfaceamento na aba ").append(aba).append(" na data ").append(Funcoes.formataData("dd/MM/yyyy", d)).append(" \u00e0s ").append(Funcoes.formataData("HH:mm", d)).append(" pelo usuario: ").append(Variaveis.login);
        motivo.append("\n\nExame(s) exclu\u00eddo(s) : ").append(exame);
        buf.append("select * from interfaceexamerequisicao where fil_codigo = ").append(filial);
        buf.append(" and req_codigo = ").append(requisicao);
        if (!Funcoes.textoVazio(interfaceamento)) {
            buf.append(" and int_codigo = ").append(interfaceamento);
        }
        if (!Funcoes.textoVazio(material)) {
            buf.append(" and mco_codigo = ").append(material);
        }
        if (!Funcoes.textoVazio(exame)) {
            String[] exas = exame.split(" ");
            if (exas.length == 1) {
                buf.append(" and exa_codigo = '").append(exame).append("'");
            } else {
                buf.append(" and exa_codigo in (");
                int i = 0;
                for (String s : exas) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    if (!Funcoes.textoVazio(s)) {
                        buf.append("'").append(s).append("'");
                    }
                    ++i;
                }
                buf.append(")");
            }
        }
        if (!Funcoes.textoVazio(tubo)) {
            buf.append(" and rec_codigo = ").append(tubo);
        }
        ResultSet rs = Conexao.executeQuery(st, buf);
        ArrayList<Registro> regs = new ArrayList<Registro>();
        ArrayList<String> tabelas = new ArrayList<String>();
        while (rs.next()) {
            tabelas.add("interfaceexamerequisicao");
            regs.add(new Registro(rs));
        }
        buf.setLength(0);
        buf.append("select * from interfaceexamerequisicaodesm where fil_codigo = ").append(filial);
        buf.append(" and req_codigo = ").append(requisicao);
        if (!Funcoes.textoVazio(interfaceamento)) {
            buf.append(" and int_codigo = ").append(interfaceamento);
        }
        if (!Funcoes.textoVazio(material)) {
            buf.append(" and mco_codigo = ").append(material);
        }
        if (!Funcoes.textoVazio(exame)) {
            String[] exas = exame.split(" ");
            if (exas.length == 1) {
                buf.append(" and exa_codigo = '").append(exame).append("'");
            } else {
                buf.append(" and exa_codigo in (");
                int i = 0;
                for (String s : exas) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    if (!Funcoes.textoVazio(s)) {
                        buf.append("'").append(s).append("'");
                    }
                    ++i;
                }
                buf.append(")");
            }
        }
        if (!Funcoes.textoVazio(tubo)) {
            buf.append(" and rec_codigo = ").append(tubo);
        }
        rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            tabelas.add("interfaceexamerequisicaodesm");
            regs.add(new Registro(rs));
        }
        if (tabelas.size() > 0) {
            DBUtil.gravaLogXML(st, filial, regs.toArray(new Registro[regs.size()]), tabelas.toArray(new String[tabelas.size()]), "Interfaceamento", requisicao, new String[]{"fil_codigo, int_codigo, exa_codigo, mco_codigo, req_codigo, rec_codigo"}, "E", motivo.toString());
        }
    }

    protected String limparNomePaciente(String nome) {
        nome = StringUtil.removerAcentos(nome == null ? "" : nome);
        StringBuilder retorno = new StringBuilder();
        for (char c : nome.toCharArray()) {
            if (String.valueOf(c).matches("[a-zA-Z0-9 ]")) {
                retorno.append(c);
                continue;
            }
            retorno.append("");
        }
        return retorno.toString();
    }

    protected ArrayList<String> getTubosFilhos(ResultSet rs) throws SQLException {
        ResultSet rsTubosFilhos = rs.getArray("tubosFilhos").getResultSet();
        ArrayList<String> tubosFilhos = new ArrayList<String>();
        if (rsTubosFilhos.next()) {
            do {
                tubosFilhos.add(String.valueOf(rsTubosFilhos.getInt(2)));
            } while (rsTubosFilhos.next());
        }
        return tubosFilhos;
    }

    public abstract void showPopupMenu(MouseEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enviarExameNaoEnviadoParaPendente() {
        if (this.tabelaExames.getSelectedRowCount() == 0) {
            return;
        }
        if (this.equipamento.getAutoImport() != null) {
            this.equipamento.getAutoImport().stop();
        }
        Statement st = null;
        try {
            st = Conexao.getStatement();
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                for (int row : this.tabelaExames.getSelectedRows()) {
                    String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_CODIGO));
                    String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_TUBO));
                    String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_MATCOD));
                    String pac_sexo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_SEXO));
                    String pac_idade = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_IDADE));
                    String pac_nome = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_NOME));
                    String pac_exames = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_EXAME));
                    String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_INTERFACE));
                    ArrayList<String> requisicoes = BDUtil.getReqMultiGuias(fil_codigo, req_codigo.substring(ParametrosGerais.getDigitosTuboFilial()));
                    for (String requisicao : requisicoes) {
                        ExameMaterial[] exa_lista;
                        for (ExameMaterial e : exa_lista = ExamesUtil.anexarCodigoMaterial(pac_exames.split(" ", 0), mco_codigo)) {
                            if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, e.getNomeExame(), e.getCodigoMaterial())) {
                                BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, requisicao, e.getNomeExame(), e.getCodigoMaterial(), rec_codigo, 1);
                            }
                            BDUtil.setExmXmlValores(st, fil_codigo, int_codigo, requisicao, e.getNomeExame(), mco_codigo, rec_codigo, "");
                            BDUtil.setExmSituacao(st, fil_codigo, requisicao, e.getNomeExame(), mco_codigo, 1, "", int_codigo, rec_codigo);
                        }
                    }
                }
            } else {
                for (int row : this.tabelaExames.getSelectedRows()) {
                    ExameMaterial[] exa_lista;
                    String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_CODIGO));
                    String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_TUBO));
                    String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_MATCOD));
                    String pac_sexo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_SEXO));
                    String pac_idade = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_IDADE));
                    String pac_nome = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_NOME));
                    String pac_exames = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_EXAME));
                    String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_INTERFACE));
                    req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                    for (ExameMaterial e : exa_lista = ExamesUtil.anexarCodigoMaterial(pac_exames.split(" ", 0), mco_codigo)) {
                        if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, e.getNomeExame(), e.getCodigoMaterial())) {
                            BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), rec_codigo, 1);
                        }
                        BDUtil.setExmXmlValores(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), mco_codigo, rec_codigo, "");
                        BDUtil.setExmSituacao(st, fil_codigo, req_codigo, e.getNomeExame(), mco_codigo, 1, "", int_codigo, rec_codigo);
                    }
                }
            }
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace(), "PanelAbaAbastrata (1483)");
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace(), "PanelAbaAbastrata (1489)");
            }
        }
        this.reloadExames();
        this.equipamento.getAbaPendentes().reloadExames();
        if (this.equipamento.getAutoImport() != null) {
            this.equipamento.getAutoImport().start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enviarExameParaNaoEnviado() {
        if (this.tabelaExames.getSelectedRowCount() == 0) {
            return;
        }
        if (this.equipamento.getAutoImport() != null) {
            this.equipamento.getAutoImport().stop();
        }
        Statement st = null;
        try {
            st = Conexao.getStatement();
            for (int row : this.tabelaExames.getSelectedRows()) {
                ExameMaterial[] exa_lista;
                String fil_codigo;
                String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_CODIGO));
                String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_TUBO));
                String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_MATCOD));
                String pac_sexo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_SEXO));
                String pac_idade = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_IDADE));
                String pac_nome = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_NOME));
                String pac_exames = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_EXAME));
                String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_INTERFACE));
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_CODIGOTEMP));
                    fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                    ArrayList<String> requisicoes = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
                    ExameMaterial exame = ExamesUtil.anexarCodigoMaterial(pac_exames.split(" ", 0), mco_codigo)[0];
                    for (String req : requisicoes) {
                        if (!BDUtil.existeExame(fil_codigo, int_codigo, req, exame.getNomeExame(), mco_codigo, rec_codigo)) continue;
                        if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exame.getNomeExame(), exame.getCodigoMaterial())) {
                            BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo, 0);
                        }
                        BDUtil.setExmXmlValores(st, fil_codigo, int_codigo, req, exame.getNomeExame(), mco_codigo, rec_codigo, "");
                        BDUtil.setExmSituacao(st, fil_codigo, req, exame.getNomeExame(), mco_codigo, 0, "", int_codigo, rec_codigo);
                    }
                    continue;
                }
                fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                for (ExameMaterial e : exa_lista = ExamesUtil.anexarCodigoMaterial(pac_exames.split(" ", 0), mco_codigo)) {
                    if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, e.getNomeExame(), e.getCodigoMaterial())) {
                        BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), rec_codigo, 0);
                    }
                    BDUtil.setExmXmlValores(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), mco_codigo, rec_codigo, "");
                    BDUtil.setExmSituacao(st, fil_codigo, req_codigo, e.getNomeExame(), mco_codigo, 0, "", int_codigo, rec_codigo);
                }
            }
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace(), "PanelAbaAbastrata (1541)");
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace(), "AbaDefaultNaoEnviados (1547)");
            }
        }
        this.reloadExames();
        this.equipamento.getAbaNaoEnviados().reloadExames();
        if (this.equipamento.getAutoImport() != null) {
            this.equipamento.getAutoImport().start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enviarExameProntoParaPendente() {
        if (this.tabelaExames.getSelectedRowCount() == 0) {
            return;
        }
        if (this.equipamento.getAutoImport() != null) {
            this.equipamento.getAutoImport().stop();
        }
        Statement st = null;
        try {
            st = Conexao.getStatement();
            for (int row : this.tabelaExames.getSelectedRows()) {
                ExameMaterial[] exa_lista;
                String fil_codigo;
                String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_CODIGO));
                String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_TUBO));
                String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_MATCOD));
                String pac_sexo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_SEXO));
                String pac_idade = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_IDADE));
                String pac_nome = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_NOME));
                String pac_exames = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_EXAME));
                String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_INTERFACE));
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_CODIGOTEMP));
                    fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                    ArrayList<String> requisicoes = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
                    ExameMaterial exame = ExamesUtil.anexarCodigoMaterial(pac_exames.split(" ", 0), mco_codigo)[0];
                    for (String req : requisicoes) {
                        if (!BDUtil.existeExame(fil_codigo, int_codigo, req, exame.getNomeExame(), mco_codigo, rec_codigo)) continue;
                        if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exame.getNomeExame(), exame.getCodigoMaterial())) {
                            BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo, 1);
                        }
                        BDUtil.setExmXmlValores(st, fil_codigo, int_codigo, req, exame.getNomeExame(), mco_codigo, rec_codigo, "");
                        BDUtil.setExmSituacao(st, fil_codigo, req, exame.getNomeExame(), mco_codigo, 1, "", int_codigo, rec_codigo);
                        BDUtil.setValorAlterado(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), mco_codigo, rec_codigo, 0);
                    }
                    continue;
                }
                fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                for (ExameMaterial e : exa_lista = ExamesUtil.anexarCodigoMaterial(pac_exames.split(" ", 0), mco_codigo)) {
                    if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, e.getNomeExame(), e.getCodigoMaterial())) {
                        BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), rec_codigo, 1);
                    }
                    BDUtil.setExmXmlValores(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), mco_codigo, rec_codigo, "");
                    BDUtil.setExmSituacao(st, fil_codigo, req_codigo, e.getNomeExame(), mco_codigo, 1, "", int_codigo, rec_codigo);
                    BDUtil.setValorAlterado(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), mco_codigo, rec_codigo, 0);
                }
            }
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace(), "PanelAbaAbastrata (1541)");
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace(), "AbaDefaultNaoEnviados (1547)");
            }
        }
        this.reloadExames();
        this.equipamento.getAbaNaoEnviados().reloadExames();
        if (this.equipamento.getAutoImport() != null) {
            this.equipamento.getAutoImport().start();
        }
    }

    private void carregaLinhasExameAgrupados() {
        Object[] linha = this.tabelaExames.getRow(this.tabelaExames.getSelectedRow());
        String aux = (String)linha[this.getColIndice(COL_CODIGO)];
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            aux = (String)linha[this.getColIndice(COL_MULTIGUIA)];
        }
        String fil_codigo = aux.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = aux.substring(ParametrosGerais.getDigitosTuboFilial());
        this.panelAgrupados.loadExamesAgrupados(fil_codigo, req_codigo);
    }

    public abstract int getTipoAba();

    public class Coluna {
        private String nome_coluna;
        private String nome_campo;

        public Coluna(String nome_coluna, String nome_campo) {
            this.nome_coluna = nome_coluna;
            this.nome_campo = nome_campo;
        }

        public String getNomeColuna() {
            return this.nome_coluna;
        }

        public String getNomeCampo() {
            return this.nome_campo;
        }
    }

    class AlertThread
    extends Thread {
        public AlertThread() {
            this.setPriority(1);
        }

        @Override
        public void run() {
            JTabbedPane pai = (JTabbedPane)PanelAbaAbstrata.this.getParent();
            try {
                while (true) {
                    if (pai == null) {
                        continue;
                    }
                    pai.setBackgroundAt(pai.indexOfComponent(PanelAbaAbstrata.this), PanelAbaAbstrata.this.COR_ALERTA);
                    pai.revalidate();
                    pai.repaint();
                    AlertThread.sleep(500L);
                    pai.setBackgroundAt(pai.indexOfComponent(PanelAbaAbstrata.this), PanelAbaAbstrata.this.COR_NORMAL);
                    pai.revalidate();
                    pai.repaint();
                    AlertThread.sleep(500L);
                }
            }
            catch (InterruptedException ex) {
                pai.setBackgroundAt(pai.indexOfComponent(PanelAbaAbstrata.this), PanelAbaAbstrata.this.COR_NORMAL);
                return;
            }
        }
    }

    protected class ThreadEnvio
    extends Thread {
        int row;
        long acesso;
        FlowController fluxo;
        String exames;

        public ThreadEnvio(int row, long acesso, FlowController fluxo, String exames) {
            this.row = row;
            this.acesso = acesso;
            this.fluxo = fluxo;
            this.exames = exames;
            this.setPriority(1);
        }

        @Override
        public void run() {
            if (Acesso.getAcesso(this.acesso)) {
                try {
                    if (this.fluxo == null) {
                        return;
                    }
                    if (this.fluxo.isRX()) {
                        AbstractInterfaceamento cfr_ignored_0 = PanelAbaAbstrata.this.equipamento;
                        PanelAbaAbstrata.this.equipamento.novaMensagem("Recep\u00e7\u00e3o de dados atual n\u00e3o pode ser interrompida", 1, 5000);
                        return;
                    }
                    if (this.fluxo.isTX()) {
                        AbstractInterfaceamento cfr_ignored_1 = PanelAbaAbstrata.this.equipamento;
                        PanelAbaAbstrata.this.equipamento.novaMensagem("Transmiss\u00e3o de dados j\u00e1 em andamento n\u00e3o pode ser interrompida", 1, 5000);
                        return;
                    }
                    if (this.row >= 0 && PanelAbaAbstrata.this.tabelaExames.getRowCount() > 0) {
                        PanelAbaAbstrata.this.transmiteExames(this.row, this.exames);
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(PanelAbaAbstrata.this.parent, ex.getMessage(), ex.getStackTrace(), "PanelAbaAbstrata: 863");
                }
            } else {
                AbstractInterfaceamento cfr_ignored_2 = PanelAbaAbstrata.this.equipamento;
                PanelAbaAbstrata.this.equipamento.novaMensagem("Voc\u00ea n\u00e3o possui permiss\u00e3o para enviar exames", 1, 5000);
            }
        }
    }
}

