/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.abas;

import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.componentes.PanelBotoes;
import jalis.util.Funcoes;
import jalis.util.TempoUtil;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;

public class AbaExcecoes
extends PanelAbaAbstrata {
    public static final String ERRO_FALTA_MATERIAL_ALTERNATIVO = "Material alternativo n\u00e3o definido para o exame";
    public static final String ERRO_ALTERNATIVO_ERRADO = "Alternativo definido para o exame esta incorreto";
    protected static final String COL_MOMENTO = "Data/Hora";
    protected static final String COL_EXCECAO = "Mensagem";
    protected PanelBotoes button_panel = new PanelBotoes("Linha selecionada");
    protected JButton jButtonExcluir = new BotaoNavegavel("Excluir", 'c');
    protected JButton jButtonExcluirTodos = new BotaoNavegavel("Excluir Todas", 'T');
    JFrame parent;

    public AbaExcecoes(JFrame parent, AbstractInterfaceamento equip) {
        super(parent, equip, "Mensagens", "Mensagens ou advert\u00eancias identificadas durante o processamento de exames (F8)", "interface/aba_excecoes.jpg");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "AbaExcecoes");
        }
    }

    @Override
    protected void loadExames() {
    }

    public void jbInit() {
        this.jPanelHeader.add((Component)this.button_panel, "Center");
        this.button_panel.addButton(this.jButtonExcluir, null, 'c', "Excluir a mensagem selecionada");
        this.button_panel.addButton(this.jButtonExcluirTodos, new Insets(2, 0, 2, 0), 'T', "Excluir todas as mensagens");
        this.addColVisivel(COL_MOMENTO);
        this.addColVisivel(COL_EXCECAO);
        this.tabelaExames.forceSize(this.getColIndice(COL_MOMENTO), 120);
        this.tabelaExames.setDefaultRenderer(Object.class, this.renderer);
        this.tabelaExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                int row;
                if (e.getKeyChar() == '\u007f' && (row = AbaExcecoes.this.tabelaExames.getSelectedRow()) >= 0) {
                    AbaExcecoes.this.excluirExcecao(row);
                }
            }
        });
        this.jButtonExcluir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = AbaExcecoes.this.tabelaExames.getSelectedRow();
                if (row >= 0) {
                    AbaExcecoes.this.excluirExcecao(row);
                }
                AbaExcecoes.this.tabelaExames.grabFocus();
            }
        });
        this.jButtonExcluirTodos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaExcecoes.this.excluirTodas();
                AbaExcecoes.this.tabelaExames.grabFocus();
            }
        });
    }

    public void adicionarExcecao(String exception) {
        StringBuilder momento = new StringBuilder(TempoUtil.getCurrentDateBr()).append(" ").append(TempoUtil.getCurrentTime());
        Object[] linha = new String[]{momento.toString(), exception};
        this.tabelaExames.addRow(linha);
        try {
            this.alertarUsuario();
        }
        catch (IllegalThreadStateException e) {
            e.printStackTrace();
        }
    }

    public void excluirExcecao(int row) {
        this.tabelaExames.deleteRow(row);
    }

    public void excluirTodas() {
        int resposta = Funcoes.showPerguntaSimNao(this.parent, "", "Tem certeza que deseja excluir todas as mensagens?");
        if (resposta == 0) {
            this.tabelaExames.setData(new ArrayList());
        }
    }

    @Override
    public void transmiteExames(int row, String exames) {
    }

    @Override
    public String getAtalhos() {
        return "[DEL]-Excluir";
    }

    @Override
    public void exibeUltimoEnviado(String req_codigo, String pac_nome, String pac_sexo, String req_idade, String req_data, String req_hora, String pac_exames) {
    }

    @Override
    public void exibeUltimoExportado(String req_codigo, String pac_nome, String pac_sexo, String req_idade, String req_data, String req_hora, String pac_exames) {
    }

    @Override
    public void showPopupMenu(MouseEvent e) {
    }

    @Override
    public int getTipoAba() {
        return 3;
    }
}

