/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.abas;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.thread.ThreadInterfaceExportacao;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.SelecionaExame;
import jalis.laboratorio.interfaceamento.componentes.PanelBotoes;
import jalis.laboratorio.interfaceamento.componentes.PanelHistoricos;
import jalis.laboratorio.interfaceamento.componentes.PanelPaciente;
import jalis.laboratorio.interfaceamento.exames.Exame;
import jalis.laboratorio.interfaceamento.resultados.EditarResultado;
import jalis.laboratorio.interfaceamento.resultados.repeticao.AbstractEditarRepeticao;
import jalis.laboratorio.interfaceamento.resultados.repeticao.EditarRepeticaoGrupo;
import jalis.laboratorio.interfaceamento.resultados.repeticao.EditarRepeticaoSimples;
import jalis.laboratorio.interfaceamento.status.StatusExportacao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.DBUtil;
import jalis.util.DialogUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AbaDefaultProntos
extends PanelAbaAbstrata {
    protected JButton jButtonExcluir = new BotaoNavegavel("Excluir");
    protected JButton jButtonExportar = new BotaoNavegavel("Exportar");
    protected JButton jButtonLiberarUm = new BotaoNavegavel("Exportar");
    protected JButton jButtonRepetir = new BotaoNavegavel("Repetir");
    protected JButton jButtonEstornar = new BotaoNavegavel("Estornar");
    protected JButton jButtonResultado = new BotaoNavegavel("Resultado", 't');
    protected PanelBotoes checked_panel = new PanelBotoes("Validados");
    protected PanelHistoricos his_panel = new PanelHistoricos(false, false);
    protected JPanel panelPaciente = new JPanel(new BorderLayout());
    protected PanelPaciente panelPacienteEnviado = new PanelPaciente("\u00daltimo Paciente Enviado");
    protected PanelPaciente panelPacienteExportado = new PanelPaciente("\u00daltimo Paciente Exportado");
    protected StatusExportacao panelExportacao;
    protected ArrayList exames = null;
    protected boolean mostraColunaFlags;
    private boolean loadingExames = false;
    protected boolean exr_codigoapoiado = false;
    private String user_code = null;
    private boolean validado = false;
    protected JCheckBox checkExibirAgrupados = new JCheckBox("Exibir exames agrupados");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbaDefaultProntos(JFrame parent, AbstractInterfaceamento equip) {
        super(parent, equip, "Prontos", "Exames com resultados, em repeti\u00e7\u00e3o ou aguardando valida\u00e7\u00e3o (F7)", "interface/aba_prontos.jpg");
        this.mostraColunaFlags = equip.mostraFlags();
        Statement st = Conexao.getStatement();
        try {
            this.jbInit();
            this.exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
        }
        catch (Exception ex) {
            try {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private void jbInit() throws Exception {
        this.panelPaciente.add((Component)this.panelPacienteEnviado, "North");
        this.panelPaciente.add((Component)this.panelPacienteExportado, "South");
        this.jPanelFoot.add((Component)this.his_panel, "Center");
        this.jPanelFoot.add((Component)this.panelPaciente, "South");
        this.jPanelHeader.add((Component)this.checked_panel, "West");
        this.checked_panel.addButton(this.jButtonExportar, null, 'E', "Exportar para os exames validados");
        this.button_panel.addButton(this.jButtonLiberarUm, null, 'U', "Exportar somente o exame cuja linha est\u00e1 selecionada");
        this.button_panel.addButton(this.jButtonRepetir, null, 'R', "Re-enviar o exame ao equipamento");
        this.button_panel.addButton(this.jButtonEstornar, null, 'N', "Estornar pedido de repeti\u00e7\u00e3o");
        this.button_panel.addButton(this.jButtonResultado, null, 'T', "Requisita ao equipamento os resultados dispon\u00edveis");
        this.button_panel.addButton(this.jButtonExcluir, null, 'C', "Exclui o exame selecionado");
        this.button_panel.add(this.checkExibirAgrupados);
        this.his_panel.setBorder(new TitledBorder(BorderFactory.createBevelBorder(1), "Observa\u00e7\u00f5es"));
        this.initTable();
        this.jButtonExcluir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = AbaDefaultProntos.this.tabelaExames.getSelectedRow();
                if (row >= 0) {
                    AbaDefaultProntos.this.excluirExame(row);
                }
                AbaDefaultProntos.this.tabelaExames.grabFocus();
            }
        });
        this.jButtonExportar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaDefaultProntos.this.jButtonExportar_actionPerformed(e);
                AbaDefaultProntos.this.tabelaExames.grabFocus();
            }
        });
        this.jButtonLiberarUm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaDefaultProntos.this.jButtonLiberarUm_actionPerformed(e);
                AbaDefaultProntos.this.tabelaExames.grabFocus();
            }
        });
        this.jButtonRepetir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Acesso.getAcesso(1001003004L)) {
                    AbaDefaultProntos.this.repetirExame();
                } else {
                    AbstractInterfaceamento cfr_ignored_0 = AbaDefaultProntos.this.equipamento;
                    AbaDefaultProntos.this.equipamento.novaMensagem("Voc\u00ea n\u00e3o possui acesso para repetir exames", 1, 5000);
                }
                AbaDefaultProntos.this.tabelaExames.grabFocus();
            }
        });
        this.jButtonEstornar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaDefaultProntos.this.estornarRepeticao();
                AbaDefaultProntos.this.tabelaExames.grabFocus();
            }
        });
        this.jButtonResultado.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = AbaDefaultProntos.this.tabelaExames.getSelectedRow();
                if (row >= 0) {
                    AbaDefaultProntos.this.requisitarResultado(row);
                }
                AbaDefaultProntos.this.tabelaExames.grabFocus();
            }
        });
        this.panelExportacao = new StatusExportacao(this.equipamento, this.colunasVisiveis, this.colunasOcultas);
        this.equipamento.getStatusFecharInterfaceamento().setStatusExportacao(this.panelExportacao);
        JPanel pnlAux = new JPanel(new BorderLayout());
        pnlAux.add((Component)this.panelEquipamentos, "East");
        pnlAux.add((Component)this.panelExportacao, "Center");
        this.jPanelHeader.add((Component)pnlAux, "East");
        this.checkExibirAgrupados.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaDefaultProntos.this.exibirAlterarExamesAgrupados((JCheckBox)e.getSource());
            }
        });
    }

    protected void initTable() {
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            this.addColVisivel("Multiguia");
        }
        this.addColVisivel("C\u00f3digo");
        this.addColVisivel("Paciente");
        this.addColVisivel("S");
        this.addColVisivel("Ide");
        this.addColVisivel("Mat.");
        this.addColVisivel("Exame");
        this.addColVisivel("Usu\u00e1rio");
        if (this.mostraColunaFlags) {
            this.addColVisivel("F");
        }
        this.addColVisivel("Sit");
        if (this.equipamento.isContadorEnvio()) {
            this.addColVisivel("Contador");
        } else {
            this.addColOculta("Contador");
        }
        this.addColOculta("C\u00f3d. Mat.");
        this.addColOculta("Tubo");
        this.addColOculta("Valores");
        this.addColOculta("Previs\u00e3o");
        this.addColOculta("Rack");
        this.addColOculta("Urgente");
        this.addColOculta("Interface");
        this.addColOculta("Alternativo");
        this.addColOculta("C\u00f3digo Temp.");
        this.addColOculta("Tubos Filhos");
        this.addColOculta("Cod. Apoiado");
        this.addColOculta("Cod. M\u00e9todo");
        this.addColOculta("Exame da Rotina");
        this.addColOculta("Cod. Paciente");
        this.addColOculta("Valor Alterado");
        this.tabelaExames.forceSize(this.getColIndice("C\u00f3digo"), 90);
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            this.tabelaExames.forceSize(this.getColIndice("Multiguia"), 90);
        }
        this.tabelaExames.forceSize(this.getColIndice("S"), 20);
        this.tabelaExames.forceSize(this.getColIndice("Ide"), 35);
        this.tabelaExames.forceSize(this.getColIndice("Mat."), 40);
        this.tabelaExames.forceSize(this.getColIndice("Exame"), 55);
        if (this.mostraColunaFlags) {
            this.tabelaExames.forceSize(this.getColIndice("F"), 16);
        }
        this.tabelaExames.forceSize(this.getColIndice("Usu\u00e1rio"), 60);
        this.tabelaExames.forceSize(this.getColIndice("Sit"), 20);
        if (this.equipamento.isContadorEnvio()) {
            this.tabelaExames.forceSize(this.getColIndice("Contador"), 60);
        }
        this.tabelaExames.setDefaultRenderer(Object.class, this.renderer);
        this.tabelaExames.sortRowsByColumn(0, false, true);
        this.renderer.addColunasCentralizadas(new Integer[]{this.getColIndice("C\u00f3digo"), this.getColIndice("S"), this.getColIndice("Ide"), this.getColIndice("Mat.")});
        this.renderer.setColunaValidacao(this.getColIndice("Sit"));
        if (this.mostraColunaFlags) {
            this.renderer.setColunaFlag(this.getColIndice("F"));
        }
        this.renderer.setColunaDataPrevisao(this.getColIndice("Previs\u00e3o"));
        this.renderer.setColunaUrgente(this.getColIndice("Urgente"));
        this.renderer.setColunaValorAlterado(this.getColIndice("Valor Alterado"));
        this.tabelaExames.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = AbaDefaultProntos.this.tabelaExames.getSelectedRow();
                if (row >= 0 && !e.getValueIsAdjusting()) {
                    AbaDefaultProntos.this.his_panel.loadHistoricos((String)AbaDefaultProntos.this.tabelaExames.getValueAt(row, AbaDefaultProntos.this.getColIndice("Valores")));
                    AbaDefaultProntos.this.validaBotoes(row);
                }
            }
        });
        this.tabelaExames.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AbaDefaultProntos.this.tabelaExames_mouseClicked(e);
            }
        });
        this.tabelaExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                AbaDefaultProntos.this.tabelaExames_keyTyped(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                AbaDefaultProntos.this.tabelaExames_keyPressed(e);
            }
        });
    }

    @Override
    public void transmiteExames(int row, String exames) {
        String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
        String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Tubo"));
        String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3d. Mat."));
        String pac_sexo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("S"));
        String pac_idade = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Ide"));
        String pac_nome = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Paciente"));
        String rackPosition = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Rack"));
        String exa_codigo = Funcoes.textoVazio(exames) ? (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame")) : exames;
        String hora = TempoUtil.getCurrentTime();
        String data = TempoUtil.getCurrentDateBr();
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
        try {
            String resposta = this.equipamento.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackPosition, null, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exa_codigo, "A");
            if (resposta != null) {
                this.equipamento.novaMensagem(resposta, 0, resposta.startsWith("Erro") ? 5000 : 10000);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace());
        }
    }

    public synchronized void carregaExames() {
        this.loadExames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadExames() {
        this.setAmpulheta(true);
        try {
            ArrayList<Object[]> dados_temp = new ArrayList<Object[]>();
            String pronto = SIT_PRONTO;
            StringBuilder query = new StringBuilder();
            query.append("select a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo, a.rec_codigo, ");
            query.append("a.ier_situacao, a.ier_xmlvalores,a.usr_codigo, b.req_anomes, b.req_idade, ");
            query.append("c.pac_nome, c.pac_codigo, c.pac_sexo, d.mco_abreviatura, a.ier_rackpos, ");
            query.append("(b.req_urgente or (coalesce(e.exr_urgente, false))) as req_urgente, ");
            query.append("a.int_codigo, f.met_codigo,");
            if (this.exr_codigoapoiado) {
                query.append("  ( case when (erc.ere_codigoapoiado is not null) then cast(erc.ere_codigoapoiado as varchar) else cast(e.exr_codigoapoiado as varchar) end) as exr_codigoapoiado,  ");
            }
            query.append(" pegaAlternativoExameInterface(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.int_codigo) as emi_alternativo, ");
            query.append(" pegaDataEntregaExame(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.req_codigo) as exr_dataentregaprev ");
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                query.append(", pegaCodigoMultiguiaMae(a.fil_codigo, a.req_codigo) as multiguia ");
            }
            query.append(", (SELECT  ARRAY (select rec_kodigo from interfaceexamerequisicaodesm");
            query.append(" where fil_codigo = a.fil_codigo and req_codigo = a.req_codigo and rec_codigo = a.rec_codigo and exa_codigo = a.exa_codigo and mco_codigo = a.mco_codigo and int_codigo = a.int_codigo)) as tubosFilhos ");
            query.append(" , a.ier_resultadoalterado ");
            query.append("from interfaceexamerequisicao a ");
            query.append("join requisicao b on a.fil_codigo=b.fil_codigo and a.req_codigo=b.req_codigo ");
            query.append("join paciente c on a.fil_codigo=c.fil_codigo and b.pac_codigo=c.pac_codigo ");
            query.append("join examerequisicao e on a.fil_codigo=e.fil_codigo and a.req_codigo=e.req_codigo and a.exa_codigo=e.exa_codigo and a.mco_codigo=e.mco_codigo ");
            if (this.exr_codigoapoiado) {
                query.append(" left join examerequisicaorecipiente erc on erc.fil_codigo = a.fil_codigo and erc.req_codigo = a.req_codigo and erc.rec_kodigo = a.rec_codigo and erc.exa_codigo = a.exa_codigo and erc.mco_codigo = a.mco_codigo ");
            }
            query.append("left join examematinterface f on a.fil_codigo=f.fil_codigo and a.exa_codigo=f.exa_codigo and a.mco_codigo=f.mco_codigo and a.int_codigo=f.int_codigo ");
            query.append("join materialcoleta d on a.fil_codigo=d.fil_codigo and a.mco_codigo=d.mco_codigo ");
            query.append("where ").append(BDUtil.montaSQLEquipamentoFilial());
            query.append("  and (a.ier_situacao = ").append(SIT_PRONTO);
            query.append(" or a.ier_situacao = ").append(SIT_REPETINDO);
            query.append(" or a.ier_situacao = ").append(SIT_COM_REPETICAO);
            query.append(" or a.ier_situacao = ").append(SIT_A_REPETIR);
            query.append(" or a.ier_situacao = ").append(SIT_PRONTO_VALIDADO);
            if (this.equipamento.isPesquisaExamesComExcecao()) {
                query.append(" or a.ier_situacao = 6");
            }
            query.append(") ");
            query.append("and e.exr_situacao not in ( ");
            query.append("'").append("T").append("', ");
            query.append("'").append("A").append("', ");
            query.append("'").append("F").append("', ");
            query.append("'").append("R").append("', ");
            query.append("'").append("N").append("', ");
            query.append("'").append("C").append("', ");
            query.append("'").append("L").append("', ");
            query.append("'").append("E").append("', ");
            query.append("'").append("I").append("' ");
            query.append(") ");
            query.append("and not e.exr_excluido ");
            query.append("and not b.req_excluida ");
            if (Variaveis.equipamentos.get(0).getFiltroColetas() != null && Variaveis.equipamentos.get(0).getFiltroColetas().length > 0) {
                query.append(" and b.col_codigo in ('");
                StringUtil.implode(Variaveis.equipamentos.get(0).getFiltroColetas(), "', '", query);
                query.append("')");
            }
            if (Variaveis.equipamentos.get(0).getFiltroDestinos() != null && Variaveis.equipamentos.get(0).getFiltroDestinos().length > 0) {
                query.append(" and b.des_codigo in ('");
                StringUtil.implode(Variaveis.equipamentos.get(0).getFiltroDestinos(), "', '", query);
                query.append("')");
            }
            if (Variaveis.equipamentos.get(0).getFiltroSituacoesReq() != null && Variaveis.equipamentos.get(0).getFiltroSituacoesReq().length > 0) {
                query.append(" and b.sit_codigo in ('");
                StringUtil.implode(Variaveis.equipamentos.get(0).getFiltroSituacoesReq(), "', '", query);
                query.append("')");
            }
            if (!this.equipamento.configuracao.getNaoUtilizarOrdenacaoPorBanco()) {
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    query.append(" order by a.fil_codigo, multiguia, a.rec_codigo, a.exa_codigo");
                } else {
                    query.append(" order by a.fil_codigo, a.req_codigo, a.rec_codigo, a.exa_codigo");
                }
            }
            Statement st = Conexao.getStatement();
            try (ResultSet rs = null;){
                rs = st.executeQuery(query.toString());
                query.delete(0, query.length());
                query.append("select b.ier_xmlvalores from interfaceexamerequisicaodesm a");
                query.append(" left join interfaceexamerequisicao b on a.fil_codigo = b.fil_codigo and a.int_codigo = b.int_codigo");
                query.append("   and a.exa_kodigo = b.exa_codigo and a.mco_kodigo = a.mco_codigo and a.req_codigo = b.req_codigo");
                query.append("   and a.rec_codigo = b.rec_codigo");
                query.append(" where b.fil_codigo = ? and b.int_codigo = ? and b.exa_codigo = ? and b.mco_codigo = ?");
                query.append("   and b.req_codigo = ? and b.rec_codigo = ?");
                PreparedStatement psFilhos = Conexao.getPreparedStatement(query.toString());
                ResultSet rsFilhos = null;
                while (rs != null && rs.next()) {
                    Object[] linha = new Object[this.getColCount()];
                    String req_codigo = Funcoes.preencheZero(rs.getInt("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
                    req_codigo = req_codigo + Funcoes.preencheZero(rs.getInt("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao());
                    String idade = String.valueOf(rs.getInt("req_idade")) + " " + (rs.getString("req_anomes") == null ? "" : rs.getString("req_anomes").toLowerCase());
                    if (this.panelExportacao.isVerificaExameExportando(req_codigo, rs.getString("int_codigo"), rs.getString("exa_codigo"), rs.getString("mco_codigo"), rs.getString("rec_codigo"))) continue;
                    String nome = this.limparNomePaciente(rs.getString("pac_nome"));
                    if (Funcoes.textoVazio(nome.trim())) {
                        nome = req_codigo + " Nome nao compativel com interfaceamento";
                    }
                    linha[this.getColIndice((String)"C\u00f3digo")] = req_codigo;
                    linha[this.getColIndice((String)"Paciente")] = nome;
                    linha[this.getColIndice((String)"S")] = rs.getString("pac_sexo");
                    linha[this.getColIndice((String)"Ide")] = idade;
                    linha[this.getColIndice((String)"Exame")] = rs.getString("exa_codigo");
                    linha[this.getColIndice((String)"Usu\u00e1rio")] = rs.getString("usr_codigo");
                    linha[this.getColIndice((String)"Sit")] = rs.getString("ier_situacao");
                    linha[this.getColIndice((String)"Mat.")] = rs.getString("mco_abreviatura");
                    linha[this.getColIndice((String)"C\u00f3d. Mat.")] = rs.getString("mco_codigo");
                    linha[this.getColIndice((String)"Tubo")] = rs.getString("rec_codigo");
                    linha[this.getColIndice((String)"Cod. Apoiado")] = "";
                    if (this.exr_codigoapoiado) {
                        linha[this.getColIndice((String)"Cod. Apoiado")] = rs.getString("exr_codigoapoiado");
                    }
                    linha[this.getColIndice((String)"Valor Alterado")] = rs.getInt("ier_resultadoalterado");
                    String xml = rs.getString("ier_xmlvalores");
                    linha[this.getColIndice((String)"Valores")] = xml;
                    linha[this.getColIndice((String)"Previs\u00e3o")] = rs.getTimestamp("exr_dataentregaprev");
                    linha[this.getColIndice((String)"Contador")] = rs.getString("ier_rackpos");
                    linha[this.getColIndice((String)"Rack")] = rs.getString("ier_rackpos");
                    linha[this.getColIndice((String)"Urgente")] = rs.getBoolean("req_urgente");
                    linha[this.getColIndice((String)"Interface")] = rs.getString("int_codigo");
                    linha[this.getColIndice((String)"Alternativo")] = rs.getString("emi_alternativo");
                    linha[this.getColIndice((String)"Cod. M\u00e9todo")] = rs.getString("met_codigo");
                    if (ParametrosGerais.isAgruparGuiasInterface()) {
                        String multiguia = Funcoes.preencheZero(rs.getInt("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
                        multiguia = multiguia + Funcoes.preencheZero(rs.getInt("multiguia"), ParametrosGerais.getDigitosTuboRequisicao());
                        linha[this.getColIndice((String)"Multiguia")] = multiguia;
                        linha[this.getColIndice((String)"C\u00f3digo Temp.")] = req_codigo;
                        if (req_codigo.equalsIgnoreCase(multiguia)) {
                            linha[this.getColIndice((String)"C\u00f3digo")] = "";
                        }
                    }
                    ResultSet rsTubosFilhos = rs.getArray("tubosFilhos").getResultSet();
                    boolean exameDesmembrado = false;
                    ArrayList<String> tubosFilhos = new ArrayList<String>();
                    if (rsTubosFilhos.next()) {
                        do {
                            tubosFilhos.add(String.valueOf(rsTubosFilhos.getInt(2)));
                        } while (rsTubosFilhos.next());
                        exameDesmembrado = true;
                    }
                    if (exameDesmembrado) {
                        linha[this.getColIndice((String)"Tubos Filhos")] = tubosFilhos;
                    }
                    if (xml != null) {
                        Map<String, Object> dados = StringUtil.getMapDeXML(xml);
                        if (this.mostraColunaFlags) {
                            List<String> flags = StringUtil.getListDeXML(StringUtil.converteHtmlParaAcentos((String)dados.get("flag")));
                            if (flags != null && !flags.isEmpty()) {
                                linha[this.getColIndice((String)"F")] = true;
                            } else if (exameDesmembrado) {
                                psFilhos.setInt(1, rs.getInt("fil_codigo"));
                                psFilhos.setInt(2, rs.getInt("int_codigo"));
                                psFilhos.setString(3, rs.getString("exa_codigo"));
                                psFilhos.setInt(4, rs.getInt("mco_codigo"));
                                psFilhos.setLong(5, rs.getLong("req_codigo"));
                                psFilhos.setLong(6, rs.getLong("rec_codigo"));
                                try {
                                    rsFilhos = psFilhos.executeQuery();
                                    while (rsFilhos.next()) {
                                        Map<String, Object> dadosFilho = StringUtil.getMapDeXML(rsFilhos.getString("ier_xmlvalores"));
                                        List<String> flagsFilho = StringUtil.getListDeXML(StringUtil.converteHtmlParaAcentos((String)dadosFilho.get("flag")));
                                        if (flagsFilho == null || flagsFilho.isEmpty()) continue;
                                        linha[this.getColIndice((String)"F")] = true;
                                        break;
                                    }
                                }
                                finally {
                                    if (rsFilhos != null) {
                                        rsFilhos.close();
                                    }
                                }
                            }
                        }
                        for (PanelAbaAbstrata.Coluna c : this.colunas) {
                            int index = this.getColIndice(c.getNomeColuna());
                            String campo = c.getNomeCampo();
                            String valor = this.notNull((String)dados.get(campo));
                            linha[index] = valor;
                        }
                    }
                    linha[this.getColIndice((String)"Cod. Paciente")] = rs.getString("pac_codigo");
                    dados_temp.add(linha);
                }
                this.exames = dados_temp;
                this.tabelaExames.setData(this.exames);
                this.tabelaExames.sortRowsByColumn(this.tabelaExames.getColunaOrdenada(), false, false);
            }
            st.close();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setAmpulheta(false);
    }

    public void validaBotoes(final int row) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (row < AbaDefaultProntos.this.tabelaExames.getRowCount()) {
                    int sit = Integer.parseInt((String)AbaDefaultProntos.this.tabelaExames.getValueAt(row, AbaDefaultProntos.this.getColIndice("Sit")));
                    AbaDefaultProntos.this.jButtonLiberarUm.setEnabled(sit == 7);
                    AbaDefaultProntos.this.jButtonRepetir.setEnabled(sit == 2);
                    AbaDefaultProntos.this.jButtonEstornar.setEnabled(sit == 3);
                    AbaDefaultProntos.this.jButtonResultado.setEnabled(sit < 4);
                }
            }
        });
    }

    public void setBotaoRepeticaoDisponivel(boolean state) {
        this.jButtonRepetir.setVisible(state);
        this.jButtonEstornar.setVisible(state);
    }

    public void setMostraColunaFlags(boolean state) {
        this.mostraColunaFlags = state;
    }

    public void setBotaoResultadoDisponivel(boolean state) {
        this.jButtonResultado.setVisible(state);
    }

    public void addColVisivel(int index, String nome_coluna, String nome_campo) {
        this.colunasVisiveis.add(index, nome_coluna);
        this.colunas.add(new PanelAbaAbstrata.Coluna(this, nome_coluna, nome_campo));
        this.tabelaExames.addColumn(index, nome_coluna, false);
        this.renderer.corrigeIndices(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excluirExame(int row) {
        this.setAmpulheta(true);
        if (Acesso.getAcesso(1001003001L)) {
            try {
                String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
                String pac_nome = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Paciente"));
                String exa_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame"));
                String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3d. Mat."));
                String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Tubo"));
                String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
                StringBuilder msg = new StringBuilder("Tem certeza que deseja excluir o exame selecionado de ");
                msg.append(pac_nome);
                msg.append("?");
                int answer = Funcoes.showPerguntaSimNao(this.parent, "Excluir exame", msg.toString());
                if (answer == 0) {
                    Statement st = Conexao.getStatement();
                    if (ParametrosGerais.isAgruparGuiasInterface()) {
                        req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo Temp."));
                    }
                    String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                    this.gravaLogExclusaoRequisicao(this, st, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exa_codigo, "Prontos");
                    BDUtil.deletarExame(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
                    Conexao.arquivaSQL();
                    st.close();
                    this.equipamento.novaMensagem("Exame exclu\u00eddos com sucesso deste interfaceamento", 0, 10000);
                    System.out.println("------------------------");
                    System.out.println("Excluindo  o exame: " + exa_codigo);
                    this.equipamento.enviarRequisicao(pac_nome, null, null, null, null, null, null, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exa_codigo, "C");
                    this.equipamento.refreshSelected();
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                finally {
                    this.equipamento.refreshSelected();
                }
            }
            this.tabelaExames.grabFocus();
        } else {
            this.equipamento.novaMensagem("Voc\u00ea n\u00e3o possui acesso para excluir exames", 1, 5000);
        }
        this.setAmpulheta(false);
    }

    public void repetirExame() {
        int row = this.tabelaExames.getSelectedRow();
        if (row < 0) {
            return;
        }
        ArrayList requisicaoExames = this.getRequisicaoExames(row, this.exames);
        requisicaoExames = (ArrayList)requisicaoExames.clone();
        String codigoApoiado = null;
        if (requisicaoExames.size() > 1) {
            SelecionaExame tela = new SelecionaExame(this.equipamento, requisicaoExames, this.colunas, this.colunasVisiveis, this.colunasOcultas);
            tela.setVisible(true);
            requisicaoExames = tela.getRequisicaoExames();
        } else {
            Object[] exame = (Object[])requisicaoExames.get(0);
            String aux = (String)exame[this.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                aux = (String)exame[this.getColIndice("Multiguia")];
            }
            String fil_codigo = aux.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String int_codigo = (String)exame[this.getColIndice("Interface")];
            String exa_codigo = (String)exame[this.getColIndice("Exame")];
            String mco_codigo = (String)exame[this.getColIndice("C\u00f3d. Mat.")];
            codigoApoiado = (String)exame[this.getColIndice("Cod. Apoiado")];
            try {
                if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exa_codigo, mco_codigo)) {
                    SelecionaExame tela = new SelecionaExame(this.equipamento, requisicaoExames, this.colunas, this.colunasVisiveis, this.colunasOcultas);
                    tela.setVisible(true);
                    requisicaoExames = tela.getRequisicaoExames();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        String exames = " ";
        ArrayList<Integer> linhas = new ArrayList<Integer>();
        for (int i = 0; i < requisicaoExames.size(); ++i) {
            Object[] linhaRepeticao = (Object[])requisicaoExames.get(i);
            String reqRepetir = (String)linhaRepeticao[this.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                reqRepetir = (String)linhaRepeticao[this.getColIndice("Multiguia")];
            }
            String exaRepetir = (String)linhaRepeticao[this.getColIndice("Exame")];
            String matRepetir = (String)linhaRepeticao[this.getColIndice("C\u00f3d. Mat.")];
            for (int j = 0; j < this.tabelaExames.getRowCount(); ++j) {
                ArrayList desmembrado;
                Object[] linhaProntos = this.tabelaExames.getRow(j);
                String reqPronto = (String)linhaProntos[this.getColIndice("C\u00f3digo")];
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    reqPronto = (String)linhaProntos[this.getColIndice("Multiguia")];
                }
                if (!reqRepetir.equalsIgnoreCase(reqPronto)) continue;
                String exaPronto = (String)linhaProntos[this.getColIndice("Exame")];
                String matPronto = (String)linhaProntos[this.getColIndice("C\u00f3d. Mat.")];
                if (!exaRepetir.equalsIgnoreCase(exaPronto) || !matRepetir.equalsIgnoreCase(matPronto)) continue;
                try {
                    desmembrado = (ArrayList)linhaRepeticao[linhaRepeticao.length - 1];
                }
                catch (Exception e) {
                    desmembrado = null;
                }
                if (desmembrado != null) {
                    for (int k = 0; k < desmembrado.size(); ++k) {
                        Object[] exame = (Object[])desmembrado.get(k);
                        String situacao = (String)exame[exame.length - 1];
                        if (!situacao.equalsIgnoreCase(SelecionaExame.SIT_REPETIR)) continue;
                        exames = exames + exame[1] + " ";
                    }
                    linhas.add(j);
                    continue;
                }
                String sit = (String)linhaRepeticao[this.getColIndice("Sit")];
                if (!sit.equalsIgnoreCase(SelecionaExame.SIT_REPETIR) && (requisicaoExames.size() != 1 || !sit.equalsIgnoreCase(SelecionaExame.SIT_PRONTO))) continue;
                exames = exames + exaPronto + " ";
                linhas.add(j);
            }
        }
        if (exames.trim().length() > 0) {
            try {
                String req_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("C\u00f3digo"));
                String rec_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Tubo"));
                String mco_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("C\u00f3d. Mat."));
                String pac_sexo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("S"));
                String pac_idade = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Ide"));
                String pac_nome = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Paciente"));
                String rack = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Rack"));
                if (Funcoes.textoVazio(codigoApoiado)) {
                    codigoApoiado = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Cod. Apoiado"));
                }
                String hora = TempoUtil.getCurrentTime();
                String data = TempoUtil.getCurrentDateBr();
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    req_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("C\u00f3digo Temp."));
                }
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                HashMap<String, String> maps = new HashMap<String, String>();
                maps.put("codigoApoiado", codigoApoiado);
                String resposta = "";
                resposta = Funcoes.textoVazio(codigoApoiado) ? this.equipamento.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, null, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames.trim(), "A") : this.equipamento.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, null, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames.trim(), "A", maps);
                if (resposta != null) {
                    this.equipamento.novaMensagem(resposta, 0, resposta.startsWith("Erro") ? 5000 : 10000);
                }
                for (Integer i : linhas) {
                    this.reloadLinha(i);
                }
                this.revalidate();
                this.repaint();
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    public void estornarRepeticao() {
        try {
            int row = this.tabelaExames.getSelectedRow();
            Statement st = Conexao.getStatement();
            if (row >= 0) {
                String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
                String exa_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame"));
                String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3d. Mat."));
                String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Tubo"));
                String ier_situacao = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Sit"));
                if (Integer.parseInt(ier_situacao) >= 7) {
                    return;
                }
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo Temp."));
                }
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                BDUtil.setExmSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, 2);
                BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, 2);
                Conexao.arquivaSQL();
                this.reloadLinha(row);
                this.validaBotoes(row);
            }
            st.close();
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
                ErrorLogger.mostraMensagem(this.parent, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.reloadExames();
        }
    }

    void tabelaExames_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            Point p = e.getPoint();
            int row = this.tabelaExames.rowAtPoint(p);
            int column = this.tabelaExames.columnAtPoint(p);
            int col_situacao = this.getColIndice("Sit");
            String sit = (String)this.tabelaExames.getValueAt(row, col_situacao);
            if (column == col_situacao) {
                if (!sit.equals(SIT_REPETINDO) && !sit.equals(SIT_COM_REPETICAO)) {
                    this.setValidado(row, !e.isControlDown());
                } else {
                    this.equipamento.novaMensagem(sit.equals(SIT_REPETINDO) ? "Exames em repeti\u00e7\u00e3o n\u00e3o podem ser validados." : "Exames com resultados de repeti\u00e7\u00e3o devem ser editados antes de serem validados.", 1, 5000);
                }
            } else if (sit.equals(SIT_COM_REPETICAO) || sit.equals(SIT_PRONTO)) {
                this.editarResultado(row, false);
            } else {
                String msg = sit.equals(SIT_REPETINDO) ? "O exame est\u00e1 aguardando resultados da repeti\u00e7\u00e3o e n\u00e3o pode ser editado." : "O exame est\u00e1 validado para exporta\u00e7\u00e3o e n\u00e3o pode ser editado. Desmarque-o e tente novamente.";
                this.equipamento.novaMensagem(msg, 1, 5000);
            }
        }
    }

    public void tabelaExames_keyTyped(KeyEvent e) {
        if (e.isAltDown()) {
            e.consume();
        } else if (e.getKeyChar() == '\u007f') {
            int row = this.tabelaExames.getSelectedRow();
            if (row >= 0 && this.tabelaExames.getRowCount() > 0) {
                this.excluirExame(row);
            }
        } else if (e.getKeyChar() == ' ') {
            int row = this.tabelaExames.getSelectedRow();
            if (row >= 0 && this.tabelaExames.getRowCount() > 0) {
                this.editarResultado(row, false);
            }
            this.tabelaExames.grabFocus();
        } else if (Character.isLetterOrDigit(e.getKeyChar())) {
            this.showLocalizar(e.getKeyChar());
        } else {
            this.tabelaExames.grabFocus();
        }
    }

    void tabelaExames_keyPressed(KeyEvent e) {
        int row = this.tabelaExames.getSelectedRow();
        if (e.getKeyCode() == 121 && this.tabelaExames.getRowCount() > 0 && row >= 0) {
            String sit = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Sit"));
            if (!sit.equals(SIT_REPETINDO) && !sit.equals(SIT_COM_REPETICAO)) {
                if (e.isControlDown()) {
                    String reqCodigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
                    if (ParametrosGerais.isAgruparGuiasInterface()) {
                        reqCodigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo Temp."));
                    }
                    String filCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    reqCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboFilial());
                    String intCodigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
                    String exaCodigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame"));
                    String mcoCodigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3d. Mat."));
                    this.removeConferenciaAutomatica(filCodigo, reqCodigo, exaCodigo, mcoCodigo, intCodigo, "");
                }
                this.setValidado(row, !e.isControlDown());
            } else {
                this.equipamento.novaMensagem(sit.equals(SIT_REPETINDO) ? "Exames em repeti\u00e7\u00e3o n\u00e3o podem ser validados." : "Exames com resultados de repeti\u00e7\u00e3o devem ser editados antes de serem validados.", 1, 5000);
            }
        }
    }

    public void removeConferenciaAutomatica(String filCodigo, String reqCodigo, String exaCodigo, String mcoCodigo, String intCodigo, String logExtra) {
        StringBuilder log = new StringBuilder(logExtra);
        log.append("Data/Hora: ").append(Funcoes.formataData("dd/MM/yyyy HH:mm", Funcoes.getDataHoraAtual()));
        log.append(".\nRemovido valida\u00e7\u00e3o do exame pelo usu\u00e1rio ").append(Variaveis.login).append("\n=================\n");
        ExameUtil.gravaLogConferenciaAutomatica(filCodigo, reqCodigo, exaCodigo, mcoCodigo, intCodigo, log.toString(), false);
    }

    void jButtonExportar_actionPerformed(ActionEvent e) {
        if (Acesso.getAcesso(1001003002L)) {
            if (!Funcoes.permiteConferirGerarPdf(Variaveis.filialPadrao)) {
                return;
            }
            int col_situacao = this.getColIndice("Sit");
            ArrayList<Object[]> examesProntos = new ArrayList<Object[]>();
            int row = 0;
            while (row < this.tabelaExames.getRowCount()) {
                if (((String)this.tabelaExames.getValueAt(row, col_situacao)).equals(SIT_PRONTO_VALIDADO)) {
                    examesProntos.add(this.tabelaExames.getRow(row));
                    this.tabelaExames.deleteRow(row);
                    continue;
                }
                ++row;
            }
            if (examesProntos.size() == 0) {
                this.equipamento.novaMensagem("N\u00e3o h\u00e1 exames validados.", 1, 5000);
                return;
            }
            int resposta = Funcoes.showPerguntaSimNao(this.parent, "Exportar exames", "Exportar exames validados?");
            if (resposta == 0) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.equipamento.novaMensagem(this.exportarValidados(examesProntos), 0, 10000);
                this.setCursor(Cursor.getDefaultCursor());
            } else {
                this.reloadExames();
            }
        } else {
            this.equipamento.novaMensagem("Voc\u00ea n\u00e3o possui permiss\u00e3o para exportar exames.", 1, 5000);
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        System.gc();
        this.setCursor(Cursor.getDefaultCursor());
    }

    void jButtonLiberarUm_actionPerformed(ActionEvent e) {
        if (Acesso.getAcesso(1001003003L)) {
            int resposta;
            if (!Funcoes.permiteConferirGerarPdf(Variaveis.filialPadrao)) {
                return;
            }
            int row = this.tabelaExames.getSelectedRow();
            if (row >= 0 && row < this.tabelaExames.getRowCount() && (resposta = Funcoes.showPerguntaSimNao(this.parent, "Exportar exame \u00fanico", "Exportar o exame selecionado?")) == 0) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.equipamento.novaMensagem(this.liberarUm(row), 0, 10000);
                this.setCursor(Cursor.getDefaultCursor());
                this.reloadExames();
            }
        } else {
            this.equipamento.novaMensagem("Voc\u00ea n\u00e3o possui acesso para liberar exames", 1, 5000);
        }
    }

    public void setValidado(int row, boolean validacao) {
        this.setAmpulheta(true);
        if (row >= 0 && row < this.tabelaExames.getRowCount()) {
            try {
                Statement st = Conexao.getStatement();
                int situacao = validacao ? 7 : 2;
                String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
                String exa_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame"));
                String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3d. Mat."));
                String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Tubo"));
                String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
                String user_code = Variaveis.login;
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo Temp."));
                }
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                BDUtil.setExmSituacaoEAssinatura(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, situacao, user_code);
                if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exa_codigo, mco_codigo)) {
                    BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, situacao);
                }
                Conexao.arquivaSQL();
                this.tabelaExames.setValueAt(String.valueOf(situacao), row, this.getColIndice("Sit"));
                this.tabelaExames.setValueAt(String.valueOf(user_code), row, this.getColIndice("Usu\u00e1rio"));
                this.tabelaExames.stepSelection();
                st.close();
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                try {
                    Conexao.anulaSQL();
                    this.reloadExames();
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                this.equipamento.novaMensagem("Erro ao acessar BD enquanto alterando valida\u00e7\u00e3o do exame. " + e.getMessage(), 1, 5000);
            }
        }
        this.setAmpulheta(false);
    }

    public void editarResultado(int row, boolean exportando) {
        block17: {
            if (Acesso.getAcesso(1001003005L)) {
                try {
                    String fil_codigo;
                    Exame exame;
                    if (this.tabelaExames.getRowCount() <= 0) break block17;
                    String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
                    String pac_nome = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Paciente"));
                    String pac_sexo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("S"));
                    String exa_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame"));
                    String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3d. Mat."));
                    String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Tubo"));
                    String situacao = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Sit"));
                    String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
                    String metCodigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Cod. M\u00e9todo"));
                    boolean permiteSalvar = true;
                    if (situacao.equals(SIT_REPETINDO) || situacao.equals(SIT_A_REPETIR)) {
                        permiteSalvar = Acesso.getAcesso(1001003010L);
                    }
                    if (ParametrosGerais.isAgruparGuiasInterface()) {
                        req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo Temp."));
                    }
                    this.user_code = !Funcoes.textoVazio((exame = new Exame(fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial()), int_codigo, req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial()), exa_codigo, mco_codigo, rec_codigo)).getUsuarioExame()) && this.validado ? exame.getUsuarioExame() : Variaveis.login;
                    Statement st = Conexao.getStatement();
                    if (Acesso.getAcesso(1001003009L) || !situacao.equals(SIT_PRONTO_VALIDADO) && !situacao.equals(SIT_REPETINDO)) {
                        if (situacao.equals(SIT_COM_REPETICAO)) {
                            boolean is_grupo = BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exa_codigo, mco_codigo);
                            AbstractEditarRepeticao dlg = is_grupo ? new EditarRepeticaoGrupo(this.parent, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, pac_nome, this.user_code) : new EditarRepeticaoSimples(this.parent, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, pac_nome, this.user_code);
                            DialogUtil.centerAndShow(dlg, true, false);
                            this.reloadLinha(row);
                            this.validaBotoes(row);
                            if (!dlg.fechouOK()) {
                                return;
                            }
                        }
                        if (this.parent != null) {
                            EditarResultado dlg = this.exportaExameApenasUm(exportando, req_codigo, pac_nome, pac_sexo, exa_codigo, mco_codigo, rec_codigo, int_codigo, permiteSalvar, fil_codigo, this.user_code, st, metCodigo, false);
                            if (dlg == null) {
                                return;
                            }
                            if (dlg.fechouSalvar()) {
                                this.reloadLinha(row);
                                this.validaBotoes(row);
                                this.his_panel.loadHistoricos((String)this.tabelaExames.getValueAt(row, this.getColIndice("Valores")));
                                this.tabelaExames.stepSelection();
                            } else if (dlg.fechouSalvarEExportar()) {
                                String reqCodigoTmp = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
                                String exaCodigoTmp = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame"));
                                if (reqCodigoTmp.equals(req_codigo) && exaCodigoTmp.equals(exaCodigoTmp)) {
                                    this.tabelaExames.deleteRow(row);
                                } else {
                                    this.reloadExames();
                                }
                            }
                            break block17;
                        }
                        Funcoes.mensagem(this, "Imposs\u00edvel editar resultado!", 2);
                        return;
                    }
                    this.equipamento.novaMensagem(situacao.equals(SIT_PRONTO_VALIDADO) ? "Exame j\u00e1 validado! Somente exames n\u00e3o validados podem ser editados." : "O sistema est\u00e1 aguardando o resultado da repeti\u00e7\u00e3o pelo equipamento.", 1, 5000);
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.equipamento.novaMensagem("Voc\u00ea n\u00e3o possui permiss\u00e3o para editar resultados", 1, 5000);
            }
        }
    }

    public void exportaExame(boolean exportando, String req_codigo, String pac_nome, String pac_sexo, String exa_codigo, String mco_codigo, String rec_codigo, String int_codigo, boolean permiteSalvar, String fil_codigo, String usr_codigo, Statement st, String metCodigo, boolean isValidarExportados, Object[] exame, String codigo_paciente) {
        block3: {
            block2: {
                Laboratorio.getInstancia();
                if (Laboratorio.threadInterfaceExportacao == null) break block2;
                Laboratorio.getInstancia();
                if (Laboratorio.threadInterfaceExportacao == null) break block3;
                Laboratorio.getInstancia();
                if (Laboratorio.threadInterfaceExportacao.isAlive()) break block3;
            }
            Laboratorio.getInstancia();
            Laboratorio.threadInterfaceExportacao = new ThreadInterfaceExportacao();
            Laboratorio.getInstancia();
            Laboratorio.threadInterfaceExportacao.setPriority(1);
            Laboratorio.getInstancia();
            Laboratorio.threadInterfaceExportacao.start();
        }
        Laboratorio.getInstancia();
        Laboratorio.threadInterfaceExportacao.addLog(this.parent, fil_codigo, int_codigo, isValidarExportados, req_codigo, exa_codigo, mco_codigo, rec_codigo, pac_nome, pac_sexo, usr_codigo, this.equipamento, permiteSalvar, exportando, metCodigo, exame, codigo_paciente);
    }

    public EditarResultado exportaExameApenasUm(boolean exportando, String req_codigo, String pac_nome, String pac_sexo, String exa_codigo, String mco_codigo, String rec_codigo, String int_codigo, boolean permiteSalvar, String fil_codigo, String usr_codigo, Statement st, String metCodigo, boolean isValidarExportados) {
        GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)this.getRootPane().getGlassPane();
        final EditarResultado dlg = new EditarResultado(this.parent, st, fil_codigo, int_codigo, isValidarExportados, req_codigo, exa_codigo, mco_codigo, rec_codigo, pac_nome, pac_sexo, usr_codigo, this.equipamento, permiteSalvar, exportando, metCodigo, glassPaneMensagem);
        if (!dlg.isMontada()) {
            return null;
        }
        if (!exportando) {
            DialogUtil.centerAndShow(dlg, true, false);
        } else {
            System.gc();
            if (!Funcoes.permiteConferirGerarPdf(fil_codigo)) {
                return dlg;
            }
            Thread threadGeraComandoWeb = new Thread("Thread Gera\u00e7\u00e3o Comando Web"){

                @Override
                public void run() {
                    dlg.acaoSalvarEExportar();
                }
            };
            threadGeraComandoWeb.start();
        }
        return dlg;
    }

    protected String exportarValidados(ArrayList<Object[]> examesProntos) {
        this.jButtonExportar.setEnabled(false);
        this.jButtonLiberarUm.setEnabled(false);
        String retorno = "Exames exportados com sucesso";
        try {
            this.panelExportacao.addExames(examesProntos);
            this.panelExportacao.restart();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
                retorno = "Erro: Os exames n\u00e3o puderam ser exportados. " + ex.getMessage();
                this.reloadExames();
            }
            catch (SQLException ex2) {
                ErrorLogger.mostraMensagem(this, ex2.getMessage(), ex2.getStackTrace());
            }
        }
        this.jButtonExportar.setEnabled(true);
        this.jButtonLiberarUm.setEnabled(true);
        return retorno;
    }

    public String liberarUm(int row) {
        String retorno = "";
        this.setAmpulheta(true);
        try {
            this.setValidado(true);
            this.editarResultado(row, true);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            try {
                retorno = "Erro: O exame n\u00e3o p\u00f4de ser exportado. " + ex.getLocalizedMessage();
                Conexao.anulaSQL();
                this.reloadExames();
            }
            catch (SQLException ex2) {
                ErrorLogger.mostraMensagem(this, ex2.getMessage(), ex2.getStackTrace());
            }
        }
        this.setAmpulheta(false);
        return retorno;
    }

    @Override
    public String getAtalhos() {
        return "[DEL]-Excluir [ESP]-Resultado";
    }

    public ArrayList getExames() {
        return this.exames;
    }

    public void setExames(ArrayList exames) {
        this.exames = exames;
    }

    public void setValidado(boolean validado) {
        this.validado = validado;
    }

    public boolean getValidado() {
        return this.validado;
    }

    @Override
    public void exibeUltimoEnviado(String req_codigo, String pac_nome, String pac_sexo, String req_idade, String req_data, String req_hora, String pac_exames) {
        this.panelPacienteEnviado.showPacInfo(req_codigo, pac_nome);
    }

    @Override
    public void exibeUltimoExportado(String req_codigo, String pac_nome, String pac_sexo, String req_idade, String req_data, String req_hora, String pac_exames) {
        this.panelPacienteExportado.showPacInfo(req_codigo, pac_nome);
    }

    @Override
    public void showPopupMenu(MouseEvent e) {
        this.popupPronto.show(e.getComponent(), e.getX(), e.getY());
    }

    protected ArrayList ordenaExamesMultiGuia(ArrayList lista) throws SQLException {
        ArrayList<Object> nova = new ArrayList<Object>();
        int exameRotina = this.getColIndice("Exame da Rotina");
        int tubo = this.getColIndice("Tubo");
        int exames = this.getColIndice("Exame");
        int material = this.getColIndice("C\u00f3d. Mat.");
        int equip = this.getColIndice("Interface");
        int codigo = this.getColIndice("Multiguia");
        if (this.equipamento.configuracao.getValidaRotinaExames()) {
            Statement st = Conexao.getStatement();
            Calendar c = Calendar.getInstance();
            int diaAtual = c.get(7);
            for (int i = 0; i < lista.size(); ++i) {
                Object[] temp = (Object[])lista.get(i);
                String filial = ((String)temp[codigo]).substring(0, ParametrosGerais.getDigitosTuboFilial());
                temp[exameRotina] = new Boolean(BDUtil.verificaDiaDeRotina(filial, (String)temp[exames], (String)temp[material], diaAtual));
            }
            Object[] temp = null;
            while (!lista.isEmpty()) {
                Object[] prox = (Object[])lista.remove(0);
                String reqa = temp != null ? (String)temp[codigo] : "";
                String reca = temp != null ? (String)temp[tubo] : "";
                String inta = temp != null ? (String)temp[equip] : "";
                String reqb = (String)prox[codigo];
                String recb = (String)prox[tubo];
                String intb = (String)prox[equip];
                String exaa = null;
                if (temp != null) {
                    exaa = (String)temp[exames];
                }
                String exab = (String)prox[exames];
                if (!((Boolean)prox[exameRotina]).booleanValue()) {
                    if (temp != null) {
                        temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
                        nova.add(temp.clone());
                    }
                    prox[this.getColIndice((String)"C\u00f3digo")] = prox[codigo];
                    nova.add(prox.clone());
                    temp = null;
                    continue;
                }
                if (reqa.equalsIgnoreCase(reqb) && reca.equalsIgnoreCase(recb)) {
                    if (this.equipamento.configuracao.getAgruparExamesPorInterface()) {
                        if (inta.equalsIgnoreCase(intb) && exaa.equalsIgnoreCase(exab)) continue;
                        if (temp != null) {
                            temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
                            nova.add(temp.clone());
                        }
                        temp = prox;
                        continue;
                    }
                    if (exaa.equalsIgnoreCase(exab)) continue;
                    if (temp != null) {
                        temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
                        nova.add(temp.clone());
                    }
                    temp = prox;
                    continue;
                }
                if (temp != null) {
                    temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
                    nova.add(temp.clone());
                }
                temp = prox;
            }
            return nova;
        }
        if (lista.size() > 0) {
            Object[] temp = (Object[])lista.remove(0);
            while (!lista.isEmpty()) {
                Object[] prox = (Object[])lista.remove(0);
                String reqa = (String)temp[codigo];
                String fila = reqa.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reca = (String)temp[tubo];
                String inta = (String)temp[equip];
                String reqb = (String)prox[codigo];
                String filb = reqb.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String recb = (String)prox[tubo];
                String intb = (String)prox[equip];
                String exaa = (String)temp[exames];
                String exab = (String)prox[exames];
                if (reqa.equalsIgnoreCase(reqb) && reca.equalsIgnoreCase(recb)) {
                    if (this.equipamento.configuracao.getAgruparExamesPorInterface()) {
                        if (inta.equalsIgnoreCase(intb) && exaa.equalsIgnoreCase(exab)) continue;
                        if (temp != null) {
                            temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
                            nova.add(temp.clone());
                        }
                        temp = prox;
                        continue;
                    }
                    if (exaa.equalsIgnoreCase(exab)) continue;
                    if (temp != null) {
                        temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
                        nova.add(temp.clone());
                    }
                    temp = prox;
                    continue;
                }
                if (temp != null) {
                    temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
                    nova.add(temp.clone());
                }
                temp = prox;
            }
            if (temp != null) {
                temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
                nova.add(temp.clone());
            }
            return nova;
        }
        return nova;
    }

    @Override
    public void reloadExames() {
        if (!this.loadingExames) {
            block8: {
                this.loadingExames = true;
                int selected = -1;
                String reqSel = "";
                String exaSel = "";
                int colCodigo = this.getColIndice("C\u00f3digo");
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    colCodigo = this.getColIndice("C\u00f3digo Temp.");
                }
                int colExame = this.getColIndice("Exame");
                if (this.tabelaExames != null && this.tabelaExames.getRowCount() > 0 && colCodigo >= 0 && colExame >= 0 && (selected = this.tabelaExames.getSelectedRow()) >= 0 && selected < this.tabelaExames.getRowCount()) {
                    reqSel = (String)this.tabelaExames.getValueAt(selected, colCodigo);
                    exaSel = (String)this.tabelaExames.getValueAt(selected, colExame);
                }
                int coluna_ordenada = this.tabelaExames.getColunaOrdenada();
                this.loadExames();
                try {
                    if (selected < 0 || selected >= this.tabelaExames.getRowCount()) break block8;
                    int rowcount = this.tabelaExames.getRowCount();
                    colCodigo = this.getColIndice("C\u00f3digo");
                    if (ParametrosGerais.isAgruparGuiasInterface()) {
                        colCodigo = this.getColIndice("C\u00f3digo Temp.");
                    }
                    String req = (String)this.tabelaExames.getValueAt(selected, colCodigo);
                    String exa = (String)this.tabelaExames.getValueAt(selected, this.getColIndice("Exame"));
                    if (!Funcoes.textoVazio(reqSel) && reqSel.equalsIgnoreCase(req) && exaSel.equalsIgnoreCase(exa)) {
                        this.tabelaExames.selectRow(selected);
                        break block8;
                    }
                    for (int i = 0; i < rowcount && i <= this.tabelaExames.getRowCount(); ++i) {
                        req = (String)this.tabelaExames.getValueAt(i, colCodigo);
                        exa = (String)this.tabelaExames.getValueAt(i, this.getColIndice("Exame"));
                        if (Funcoes.textoVazio(reqSel) || !reqSel.equalsIgnoreCase(req) || !exaSel.equalsIgnoreCase(exa)) continue;
                        this.tabelaExames.selectRow(i);
                        break;
                    }
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "AbaPadrao: 552");
                }
            }
            this.tabelaExames.revalidate();
            this.tabelaExames.grabFocus();
            this.loadingExames = false;
        }
    }

    public int verificaLancados(int sequence) {
        int seq;
        block5: {
            seq = sequence;
            try {
                List<Registro> registros = BDUtil.getListaExamesLancado(sequence);
                if (registros.isEmpty()) break block5;
                seq = registros.get(registros.size() - 1).getInt("ers_codigo");
                boolean atualizar = false;
                for (Registro registro : registros) {
                    String fil_codigo = Funcoes.preencheZero(registro.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
                    String req_codigo = Funcoes.preencheZero(registro.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao());
                    String codigo = String.format("%s%s", fil_codigo, req_codigo);
                    String mco_codigo = registro.getString("mco_codigo");
                    String exa_codigo = registro.getString("exa_codigo");
                    for (int i = 0; i < this.tabelaExames.getRowCount(); ++i) {
                        String reqCodigo = (String)this.tabelaExames.getValueAt(i, this.getColIndice("C\u00f3digo"));
                        if (ParametrosGerais.isAgruparGuiasInterface()) {
                            reqCodigo = (String)this.tabelaExames.getValueAt(i, this.getColIndice("C\u00f3digo Temp."));
                        }
                        String exaCodigo = (String)this.tabelaExames.getValueAt(i, this.getColIndice("Exame"));
                        String mcoCodigo = (String)this.tabelaExames.getValueAt(i, this.getColIndice("C\u00f3d. Mat."));
                        if (!codigo.equals(reqCodigo) || !mco_codigo.equals(mcoCodigo) || !exa_codigo.equals(exaCodigo)) continue;
                        atualizar = true;
                        break;
                    }
                    if (!atualizar) continue;
                    this.reloadExames();
                    break;
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "Erro ao verificar exames lan\u00e7ados em outra esta\u00e7\u00e3o: " + e.getMessage(), e.getStackTrace());
                this.reloadExames();
            }
        }
        return seq;
    }

    public void voltaExamesNaoExportados(List<Object[]> examesNaoExportados) {
        if (!examesNaoExportados.isEmpty()) {
            this.equipamento.refresh(2);
        }
    }

    @Override
    public int getTipoAba() {
        return 2;
    }
}

