/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.abas;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.SelecionaExame;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;

public class AbaDefaultPendentes
extends PanelAbaAbstrata {
    protected JButton jButtonReenviar = new BotaoNavegavel("Re-enviar", 'r');
    protected JButton jButtonExcluir = new BotaoNavegavel("Excluir", 'c');
    protected JButton jButtonResultado = new BotaoNavegavel("Resultado", 't');
    protected ArrayList exames = null;
    private boolean exr_codigoapoiado = false;
    protected JCheckBox checkExibirAgrupados = new JCheckBox("Exibir exames agrupados");

    public AbaDefaultPendentes(JFrame parent, AbstractInterfaceamento equip) {
        super(parent, equip, "Processando", "Exames enviados ao equipamento e aguardando resultado (F6)", "interface/aba_pendentes.jpg");
        try {
            this.jbInit();
            Statement st = Conexao.getStatement();
            this.exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
            boolean debug = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
            if (debug) {
                this.exr_codigoapoiado = false;
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.button_panel.addButton(this.jButtonReenviar, null, 'r', "Re-enviar exame selecionado para o equipamento");
        this.button_panel.addButton(this.jButtonResultado, null, 'T', "Requisita ao equipamento os resultados dispon\u00edveis");
        this.button_panel.addButton(this.jButtonExcluir, null, 'c', "Excluir exame selecionado");
        this.button_panel.add(this.checkExibirAgrupados);
        this.initTable();
        this.jButtonReenviar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = AbaDefaultPendentes.this.tabelaExames.getSelectedRow();
                if (row >= 0) {
                    AbaDefaultPendentes.this.transmiteLinha(row, 1001001002L);
                }
                AbaDefaultPendentes.this.tabelaExames.grabFocus();
            }
        });
        this.jButtonExcluir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = AbaDefaultPendentes.this.tabelaExames.getSelectedRow();
                if (row >= 0) {
                    AbaDefaultPendentes.this.excluirExame(row);
                }
                AbaDefaultPendentes.this.tabelaExames.grabFocus();
            }
        });
        this.jButtonResultado.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaDefaultPendentes.this.acaoBotaoResultado();
            }
        });
        this.jPanelHeader.add((Component)this.panelEquipamentos, "East");
        this.checkExibirAgrupados.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaDefaultPendentes.this.exibirAlterarExamesAgrupados((JCheckBox)e.getSource());
            }
        });
    }

    protected void acaoBotaoResultado() {
        int row = this.tabelaExames.getSelectedRow();
        if (row >= 0) {
            this.requisitarResultado(row);
        }
        this.tabelaExames.grabFocus();
    }

    protected void initTable() {
        this.addColVisivel("C\u00f3digo");
        this.addColVisivel("Paciente");
        this.addColVisivel("S");
        this.addColVisivel("Ide");
        this.addColVisivel("Data");
        this.addColVisivel("Hora");
        this.addColVisivel("Mat.");
        this.addColVisivel("Exame");
        if (this.equipamento.isContadorEnvio()) {
            this.addColVisivel("Contador");
        } else {
            this.addColOculta("Contador");
        }
        this.addColOculta("C\u00f3d. Mat.");
        this.addColOculta("Tubo");
        this.addColOculta("Previs\u00e3o");
        this.addColOculta("Rack");
        this.addColOculta("Urgente");
        this.addColOculta("Interface");
        this.addColOculta("Alternativo");
        this.addColOculta("Sit");
        this.addColOculta("Multiguia");
        this.addColOculta("C\u00f3digo Temp.");
        this.addColOculta("Tubos Filhos");
        this.addColOculta("Cod. Apoiado");
        this.addColOculta("Exame da Rotina");
        this.tabelaExames.forceSize(this.getColIndice("Alternativo"), 80);
        this.tabelaExames.forceSize(this.getColIndice("C\u00f3digo"), 90);
        this.tabelaExames.forceSize(this.getColIndice("S"), 40);
        this.tabelaExames.forceSize(this.getColIndice("Ide"), 65);
        this.tabelaExames.forceSize(this.getColIndice("Data"), 80);
        this.tabelaExames.forceSize(this.getColIndice("Hora"), 50);
        this.tabelaExames.forceSize(this.getColIndice("Mat."), 50);
        this.tabelaExames.forceSize(this.getColIndice("Exame"), 55);
        if (this.equipamento.isContadorEnvio()) {
            this.tabelaExames.forceSize(this.getColIndice("Contador"), 55);
        }
        this.tabelaExames.setDefaultRenderer(Object.class, this.renderer);
        this.tabelaExames.sortRowsByColumn(this.getColIndice("C\u00f3digo"), false, true);
        this.renderer.addColunasCentralizadas(new Integer[]{this.getColIndice("C\u00f3digo"), this.getColIndice("S"), this.getColIndice("Ide"), this.getColIndice("Data"), this.getColIndice("Hora"), this.getColIndice("Mat.")});
        this.renderer.setColunaDataPrevisao(this.getColIndice("Previs\u00e3o"));
        this.renderer.setColunaUrgente(this.getColIndice("Urgente"));
        this.tabelaExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                AbaDefaultPendentes.this.tabelaExames_keyTyped(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                AbaDefaultPendentes.this.tabelaExames_keyPressed(e);
            }
        });
    }

    public void adicionarBotao(JButton botao, char mnemonico, String tooltiptext) {
        this.button_panel.addButton(botao, null, mnemonico, tooltiptext);
    }

    @Override
    public void transmiteExames(int row, String exames) {
        this.transmiteExames(row, "A", exames);
    }

    public void transmiteExames(int row, String acao, String exames) {
        if (row >= 0 && this.tabelaExames.getRowCount() > 0) {
            String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
            String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Tubo"));
            String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3d. Mat."));
            String pac_sexo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("S"));
            String pac_idade = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Ide"));
            String pac_nome = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Paciente"));
            HashMap<String, String> parametro = new HashMap<String, String>();
            String codigoApoiado = "";
            if (this.tabelaExames.getValueAt(row, this.getColIndice("Cod. Apoiado")) != null && !Funcoes.textoVazio(codigoApoiado = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Cod. Apoiado")))) {
                parametro.put("codigoApoiado", codigoApoiado);
            }
            String pac_exames = Funcoes.textoVazio(exames) ? (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame")) : exames;
            String hora = TempoUtil.getCurrentTime();
            String data = TempoUtil.getCurrentDateBr();
            String rackpos = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Rack"));
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
            try {
                String resposta = "";
                resposta = !Funcoes.textoVazio(codigoApoiado) ? this.equipamento.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackpos, null, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao, parametro) : this.equipamento.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackpos, null, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
                if (resposta != null) {
                    this.equipamento.novaMensagem(resposta, 0, resposta.startsWith("Erro") ? 5000 : 10000);
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    @Override
    protected void loadExames() {
        this.setAmpulheta(true);
        try {
            ArrayList<Object[]> dados_temp = new ArrayList<Object[]>();
            String pendente = String.valueOf(1);
            StringBuilder query = new StringBuilder();
            query.append("select a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo, a.rec_codigo, b.req_data, ");
            query.append(" b.req_hora, b.req_anomes, b.req_idade, c.pac_nome, c.pac_sexo, d.mco_abreviatura, ");
            query.append(" a.ier_rackpos, (b.req_urgente or (coalesce(pegaUrgenteExame(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.req_codigo), false))) as req_urgente, ");
            query.append(" a.int_codigo, a.ier_situacao, ");
            query.append(" pegaAlternativoExameInterface(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.int_codigo) as emi_alternativo, ");
            query.append(" pegaDataEntregaExame(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.req_codigo) as exr_dataentregaprev ");
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                query.append(", pegaCodigoMultiguiaMae(a.fil_codigo, a.req_codigo) as multiguia ");
            }
            if (this.exr_codigoapoiado) {
                query.append("  ,( case when (erc.ere_codigoapoiado is not null) then cast(erc.ere_codigoapoiado as varchar) else cast(exr.exr_codigoapoiado as varchar) end) as codigoApoiado  ");
            }
            query.append(", (SELECT  ARRAY (select rec_kodigo from interfaceexamerequisicaodesm");
            query.append(" where fil_codigo = a.fil_codigo and req_codigo = a.req_codigo and rec_codigo = a.rec_codigo and exa_codigo = a.exa_codigo and mco_codigo = a.mco_codigo and int_codigo = a.int_codigo)) as tubosFilhos ");
            query.append(" from interfaceexamerequisicao a ");
            query.append(" left join requisicao b on a.fil_codigo=b.fil_codigo and a.req_codigo=b.req_codigo ");
            query.append(" left join paciente c on a.fil_codigo=c.fil_codigo and b.pac_codigo=c.pac_codigo ");
            query.append(" left join materialcoleta d on a.fil_codigo=d.fil_codigo and a.mco_codigo=d.mco_codigo ");
            if (this.exr_codigoapoiado) {
                query.append(" left join examerequisicao exr on exr.fil_codigo = a.fil_codigo and exr.req_codigo = a.req_codigo and exr.exa_codigo = a.exa_codigo and exr.mco_codigo = a.mco_codigo ");
                query.append(" left join examerequisicaorecipiente erc on erc.fil_codigo = a.fil_codigo and erc.req_codigo = a.req_codigo and erc.rec_kodigo = a.rec_codigo and erc.exa_codigo = a.exa_codigo and erc.mco_codigo = a.mco_codigo ");
            }
            query.append("where ").append(BDUtil.montaSQLEquipamentoFilial());
            query.append(" and a.ier_situacao = ");
            query.append(pendente);
            if (Variaveis.equipamentos.get(0).getFiltroColetas() != null && Variaveis.equipamentos.get(0).getFiltroColetas().length > 0) {
                query.append(" and b.col_codigo in ('");
                StringUtil.implode(Variaveis.equipamentos.get(0).getFiltroColetas(), "', '", query);
                query.append("')");
            }
            if (Variaveis.equipamentos.get(0).getFiltroDestinos() != null && Variaveis.equipamentos.get(0).getFiltroDestinos().length > 0) {
                query.append(" and b.des_codigo in ('");
                StringUtil.implode(Variaveis.equipamentos.get(0).getFiltroDestinos(), "', '", query);
                query.append("')");
            }
            if (Variaveis.equipamentos.get(0).getFiltroSituacoesReq() != null && Variaveis.equipamentos.get(0).getFiltroSituacoesReq().length > 0) {
                query.append(" and b.sit_codigo in ('");
                StringUtil.implode(Variaveis.equipamentos.get(0).getFiltroSituacoesReq(), "', '", query);
                query.append("')");
            }
            if (!this.equipamento.configuracao.getNaoUtilizarOrdenacaoPorBanco()) {
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    query.append(" order by a.fil_codigo, multiguia, a.rec_codigo, a.int_codigo, a.exa_codigo");
                } else {
                    query.append(" order by a.fil_codigo, a.req_codigo, a.rec_codigo, a.int_codigo, a.exa_codigo");
                }
            }
            PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs != null && rs.next()) {
                ArrayList<String> tubosFilhos;
                boolean exameDesmembrado;
                Object[] linha = new Object[this.getColCount()];
                String req_codigo = Funcoes.preencheZero(rs.getInt("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
                req_codigo = req_codigo + Funcoes.preencheZero(rs.getInt("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao());
                String idade = String.valueOf(rs.getInt("req_idade")) + " " + Tipos.tipoIdade(rs.getString("req_anomes"));
                Date ddata = rs.getDate("req_data");
                Time hhora = rs.getTime("req_hora");
                String data = ddata == null ? "" : new SimpleDateFormat("dd/MM/yyyy").format(ddata);
                String hora = hhora == null ? "" : new SimpleDateFormat("HH:mm").format(hhora);
                String nome = this.limparNomePaciente(rs.getString("pac_nome"));
                if (Funcoes.textoVazio(nome.trim())) {
                    nome = req_codigo + " Nome nao compativel com interfaceamento";
                }
                linha[this.getColIndice((String)"C\u00f3digo")] = req_codigo;
                linha[this.getColIndice((String)"Exame")] = rs.getString("exa_codigo");
                linha[this.getColIndice((String)"Paciente")] = nome;
                linha[this.getColIndice((String)"S")] = rs.getString("pac_sexo");
                linha[this.getColIndice((String)"Data")] = data;
                linha[this.getColIndice((String)"Hora")] = hora;
                linha[this.getColIndice((String)"Ide")] = idade;
                linha[this.getColIndice((String)"Mat.")] = rs.getString("mco_abreviatura");
                linha[this.getColIndice((String)"C\u00f3d. Mat.")] = rs.getString("mco_codigo");
                linha[this.getColIndice((String)"Tubo")] = rs.getString("rec_codigo");
                linha[this.getColIndice((String)"Previs\u00e3o")] = rs.getTimestamp("exr_dataentregaprev");
                linha[this.getColIndice((String)"Rack")] = rs.getString("ier_rackpos");
                linha[this.getColIndice((String)"Urgente")] = rs.getBoolean("req_urgente");
                linha[this.getColIndice((String)"Interface")] = rs.getString("int_codigo");
                linha[this.getColIndice((String)"Alternativo")] = rs.getString("emi_alternativo");
                linha[this.getColIndice((String)"Sit")] = rs.getString("ier_situacao");
                linha[this.getColIndice((String)"Cod. Apoiado")] = "";
                if (this.exr_codigoapoiado) {
                    linha[this.getColIndice((String)"Cod. Apoiado")] = rs.getString("codigoApoiado");
                }
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    String multiguia = Funcoes.preencheZero(rs.getInt("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
                    multiguia = multiguia + Funcoes.preencheZero(rs.getInt("multiguia"), ParametrosGerais.getDigitosTuboRequisicao());
                    linha[this.getColIndice((String)"Multiguia")] = multiguia;
                    linha[this.getColIndice((String)"C\u00f3digo Temp.")] = req_codigo;
                }
                boolean bl = exameDesmembrado = (tubosFilhos = this.getTubosFilhos(rs)).size() > 0;
                if (exameDesmembrado) {
                    linha[this.getColIndice((String)"Tubos Filhos")] = tubosFilhos;
                }
                dados_temp.add(linha);
            }
            this.exames = ParametrosGerais.isAgruparGuiasInterface() ? this.ordenaExamesMultiGuia(dados_temp) : dados_temp;
            this.tabelaExames.setData(this.exames);
            this.tabelaExames.sortRowsByColumn(this.tabelaExames.getColunaOrdenada(), false, false);
            this.tabelaExames.grabFocus();
            ps.close();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setAmpulheta(false);
    }

    public void setBotaoResultadoDisponivel(boolean state) {
        this.jButtonResultado.setVisible(state);
    }

    public void setBotaoReenviarDisponivel(boolean state) {
        this.jButtonReenviar.setVisible(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excluirExame(int row) {
        this.setAmpulheta(true);
        if (Acesso.getAcesso(1001002001L)) {
            try {
                String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
                String pac_nome = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Paciente"));
                String exa_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame"));
                String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3d. Mat."));
                String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Tubo"));
                String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo Temp."));
                }
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                StringBuilder msg = new StringBuilder("Tem certeza que deseja excluir o exame selecionado de ");
                msg.append(pac_nome);
                msg.append("?");
                int answer = Funcoes.showPerguntaSimNao(this.parent, "Excluir exame", msg.toString());
                if (answer == 0) {
                    Statement st = Conexao.getStatement();
                    this.gravaLogExclusaoRequisicao(this, st, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exa_codigo, "Pendentes");
                    BDUtil.deletarExame(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
                    Conexao.arquivaSQL();
                    st.close();
                    this.equipamento.refreshSelected();
                    this.equipamento.novaMensagem("Exame exclu\u00eddos com sucesso deste interfaceamento", 0, 10000);
                    this.equipamento.enviarRequisicao(pac_nome, null, null, null, null, null, null, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exa_codigo, "C");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                finally {
                    this.equipamento.refreshSelected();
                }
            }
            this.tabelaExames.grabFocus();
        } else {
            this.equipamento.novaMensagem("Voc\u00ea n\u00e3o possui acesso para excluir exames", 1, 5000);
        }
        this.setAmpulheta(false);
    }

    protected void tabelaExames_keyTyped(KeyEvent e) {
        int row;
        if (e.isAltDown()) {
            e.consume();
        } else if (Character.isLetterOrDigit(e.getKeyChar())) {
            this.showLocalizar(e.getKeyChar());
        } else if (e.getKeyChar() == '\u007f' && (row = this.tabelaExames.getSelectedRow()) >= 0 && this.tabelaExames.getRowCount() > 0) {
            this.excluirExame(row);
        }
    }

    protected void tabelaExames_keyPressed(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            e.consume();
        }
    }

    public ArrayList getExames() {
        return this.exames;
    }

    @Override
    public String getAtalhos() {
        return "[DEL]-Excluir";
    }

    public void reenviarExame() {
        int row = this.tabelaExames.getSelectedRow();
        if (row < 0) {
            return;
        }
        ArrayList requisicaoExames = this.getRequisicaoExames(row, this.exames);
        if ((requisicaoExames = (ArrayList)requisicaoExames.clone()).size() > 1) {
            SelecionaExame tela = new SelecionaExame(this.equipamento, requisicaoExames, this.colunas, this.colunasVisiveis, this.colunasOcultas);
            tela.setVisible(true);
            requisicaoExames = tela.getRequisicaoExames();
        } else {
            Object[] exame = (Object[])requisicaoExames.get(0);
            String aux = (String)exame[this.getColIndice("C\u00f3digo")];
            String fil_codigo = aux.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String int_codigo = (String)exame[this.getColIndice("Interface")];
            String exa_codigo = (String)exame[this.getColIndice("Exame")];
            String mco_codigo = (String)exame[this.getColIndice("C\u00f3d. Mat.")];
            try {
                Statement st = Conexao.getStatement();
                if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exa_codigo, mco_codigo)) {
                    SelecionaExame tela = new SelecionaExame(this.equipamento, requisicaoExames, this.colunas, this.colunasVisiveis, this.colunasOcultas);
                    tela.setVisible(true);
                    requisicaoExames = tela.getRequisicaoExames();
                }
                st.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        block2: for (int i = 0; i < requisicaoExames.size(); ++i) {
            Object[] linhaRepeticao = (Object[])requisicaoExames.get(i);
            String reqRepetir = (String)linhaRepeticao[this.getColIndice("C\u00f3digo")];
            String exaRepetir = (String)linhaRepeticao[this.getColIndice("Exame")];
            for (int j = 0; j < this.tabelaExames.getRowCount(); ++j) {
                String exaPronto;
                Object[] linhaProntos = this.tabelaExames.getRow(j);
                String reqPronto = (String)linhaProntos[this.getColIndice("C\u00f3digo")];
                if (!reqRepetir.equalsIgnoreCase(reqPronto) || !exaRepetir.equalsIgnoreCase(exaPronto = (String)linhaProntos[this.getColIndice("Exame")])) continue;
                ArrayList desmembrado = (ArrayList)linhaRepeticao[linhaRepeticao.length - 1];
                if (desmembrado != null) {
                    String exames = "";
                    for (int k = 0; k < desmembrado.size(); ++k) {
                        Object[] exame = (Object[])desmembrado.get(k);
                        String situacao = (String)exame[exame.length - 1];
                        if (!situacao.equalsIgnoreCase(SelecionaExame.SIT_REPETIR)) continue;
                        exames = exames + exame[1] + " ";
                    }
                    this.transmiteLinha(j, 1001001002L, exames);
                    this.reloadLinha(j);
                    continue block2;
                }
                String sit = (String)linhaRepeticao[this.getColIndice("Sit")];
                if (!sit.equalsIgnoreCase(SelecionaExame.SIT_REPETIR)) continue;
                this.transmiteLinha(j, 1001001002L);
                this.reloadLinha(j);
                continue block2;
            }
        }
    }

    @Override
    public void exibeUltimoEnviado(String req_codigo, String pac_nome, String pac_sexo, String req_idade, String req_data, String req_hora, String pac_exames) {
    }

    @Override
    public void exibeUltimoExportado(String req_codigo, String pac_nome, String pac_sexo, String req_idade, String req_data, String req_hora, String pac_exames) {
    }

    @Override
    public void showPopupMenu(MouseEvent e) {
        this.popupPendente.show(e.getComponent(), e.getX(), e.getY());
    }

    protected ArrayList ordenaExamesMultiGuia(ArrayList lista) throws SQLException {
        ArrayList<Object> nova = new ArrayList<Object>();
        int exameRotina = this.getColIndice("Exame da Rotina");
        int tubo = this.getColIndice("Tubo");
        int exames = this.getColIndice("Exame");
        int material = this.getColIndice("C\u00f3d. Mat.");
        int equip = this.getColIndice("Interface");
        int codigo = this.getColIndice("Multiguia");
        if (this.equipamento.configuracao.getValidaRotinaExames()) {
            Statement st = Conexao.getStatement();
            Calendar c = Calendar.getInstance();
            int diaAtual = c.get(7);
            for (int i = 0; i < lista.size(); ++i) {
                Object[] temp = (Object[])lista.get(i);
                String filial = ((String)temp[codigo]).substring(0, ParametrosGerais.getDigitosTuboFilial());
                temp[exameRotina] = new Boolean(BDUtil.verificaDiaDeRotina(filial, (String)temp[exames], (String)temp[material], diaAtual));
            }
            Object[] temp = null;
            while (!lista.isEmpty()) {
                Object[] prox = (Object[])lista.remove(0);
                String reqa = temp != null ? (String)temp[codigo] : "";
                String reca = temp != null ? (String)temp[tubo] : "";
                String inta = temp != null ? (String)temp[equip] : "";
                String reqb = (String)prox[codigo];
                String recb = (String)prox[tubo];
                String intb = (String)prox[equip];
                String exaa = temp != null ? (String)temp[exames] : "";
                String exab = (String)prox[exames];
                if (!((Boolean)prox[exameRotina]).booleanValue()) {
                    if (temp != null) {
                        temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
                        nova.add(temp.clone());
                    }
                    prox[this.getColIndice((String)"C\u00f3digo")] = prox[codigo];
                    nova.add(prox.clone());
                    temp = null;
                    continue;
                }
                if (reqa.equalsIgnoreCase(reqb) && reca.equalsIgnoreCase(recb)) {
                    if (this.equipamento.configuracao.getAgruparExamesPorInterface()) {
                        if (inta.equalsIgnoreCase(intb) && exaa.equalsIgnoreCase(exab)) continue;
                        if (temp != null) {
                            temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
                            nova.add(temp.clone());
                        }
                        temp = prox;
                        continue;
                    }
                    if (exaa.equalsIgnoreCase(exab)) continue;
                    if (temp != null) {
                        temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
                        nova.add(temp.clone());
                    }
                    temp = prox;
                    continue;
                }
                if (temp != null) {
                    temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
                    nova.add(temp.clone());
                }
                temp = prox;
            }
            return nova;
        }
        if (lista.size() > 0) {
            Object[] temp = (Object[])lista.remove(0);
            while (!lista.isEmpty()) {
                Object[] prox = (Object[])lista.remove(0);
                String reqa = (String)temp[codigo];
                String fila = reqa.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reca = (String)temp[tubo];
                String inta = (String)temp[equip];
                String reqb = (String)prox[codigo];
                String filb = reqb.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String recb = (String)prox[tubo];
                String intb = (String)prox[equip];
                String exaa = (String)temp[exames];
                String exab = (String)prox[exames];
                if (reqa.equalsIgnoreCase(reqb) && reca.equalsIgnoreCase(recb)) {
                    if (this.equipamento.configuracao.getAgruparExamesPorInterface()) {
                        if (inta.equalsIgnoreCase(intb) && exaa.equalsIgnoreCase(exab)) continue;
                        if (temp != null) {
                            temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
                            nova.add(temp.clone());
                        }
                        temp = prox;
                        continue;
                    }
                    if (exaa.equalsIgnoreCase(exab)) continue;
                    if (temp != null) {
                        temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
                        nova.add(temp.clone());
                    }
                    temp = prox;
                    continue;
                }
                if (temp != null) {
                    temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
                    nova.add(temp.clone());
                }
                temp = prox;
            }
            if (temp != null) {
                temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
                nova.add(temp.clone());
            }
            return nova;
        }
        return nova;
    }

    @Override
    public int getTipoAba() {
        return 1;
    }
}

