/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.abas;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.componentes.PanelBotoes;
import jalis.laboratorio.interfaceamento.componentes.PanelPacienteEnviado;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.ExameLote;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;

public class AbaDefaultNaoEnviados
extends PanelAbaAbstrata {
    protected PanelPacienteEnviado enviado_panel;
    protected JButton jButtonExcluir = new BotaoNavegavel("Excluir", 'c');
    protected JButton buttonLote = new BotaoNavegavel("Lote", 'l');
    protected PanelBotoes lote_panel = new PanelBotoes("Lote");
    protected ArrayList exames = null;
    protected JFrame owner;
    protected JCheckBox checkExibirAgrupados = new JCheckBox("Exibir exames agrupados");
    protected boolean exr_codigoapoiado = false;

    public AbaDefaultNaoEnviados(JFrame parent, AbstractInterfaceamento equip) {
        super(parent, equip, "N\u00e3o enviados", "Exames a realizar (F5)", "interface/aba_nao_enviados.jpg");
        this.owner = parent;
        try {
            this.jbInit();
            Statement st = Conexao.getStatement();
            this.exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.enviado_panel = new PanelPacienteEnviado(this.equipamento);
        this.jPanelFoot.add((Component)this.enviado_panel, "Center");
        this.jPanelHeader.add((Component)this.lote_panel, "West");
        this.lote_panel.addButton(this.buttonLote, null, 'l', "Cria lote de envio");
        this.button_panel.addButton(this.jButtonExcluir, null, 'c', "Excluir tubo/requisi\u00e7\u00e3o selecionado");
        this.button_panel.add(this.checkExibirAgrupados);
        this.initTable();
        this.jButtonExcluir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = AbaDefaultNaoEnviados.this.tabelaExames.getSelectedRow();
                if (row >= 0) {
                    AbaDefaultNaoEnviados.this.excluirExame(row);
                }
                AbaDefaultNaoEnviados.this.tabelaExames.grabFocus();
            }
        });
        this.buttonLote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaDefaultNaoEnviados.this.lote();
            }
        });
        this.jPanelHeader.add((Component)this.panelEquipamentos, "East");
        this.checkExibirAgrupados.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaDefaultNaoEnviados.this.exibirAlterarExamesAgrupados((JCheckBox)e.getSource());
            }
        });
    }

    protected void initTable() {
        this.addColVisivel("C\u00f3digo");
        this.addColVisivel("Paciente");
        this.addColVisivel("S");
        this.addColVisivel("Ide");
        this.addColVisivel("Data");
        this.addColVisivel("Hora");
        this.addColVisivel("Mat.");
        this.addColVisivel("Exame");
        if (this.equipamento.isContadorEnvio()) {
            this.addColVisivel("Contador");
        } else {
            this.addColOculta("Contador");
        }
        this.addColOculta("C\u00f3d. Mat.");
        this.addColOculta("Tubo");
        this.addColOculta("Previs\u00e3o");
        this.addColOculta("Rack");
        this.addColOculta("Urgente");
        this.addColOculta("Interface");
        this.addColOculta("Exame da Rotina");
        this.addColOculta("Alternativo");
        this.addColOculta("Multiguia");
        this.addColOculta("C\u00f3digo Temp.");
        this.addColOculta("Tubos Filhos");
        this.addColOculta("Cod. Apoiado");
        this.tabelaExames.forceSize(this.getColIndice("C\u00f3digo"), 90);
        this.tabelaExames.forceSize(this.getColIndice("S"), 40);
        this.tabelaExames.forceSize(this.getColIndice("Ide"), 65);
        this.tabelaExames.forceSize(this.getColIndice("Data"), 80);
        this.tabelaExames.forceSize(this.getColIndice("Hora"), 50);
        this.tabelaExames.forceSize(this.getColIndice("Mat."), 50);
        this.tabelaExames.forceSize(this.getColIndice("Exame"), 150);
        this.tabelaExames.setDefaultRenderer(Object.class, this.renderer);
        this.tabelaExames.sortRowsByColumn(this.getColIndice("C\u00f3digo"), false, true);
        this.renderer.addColunasCentralizadas(new Integer[]{this.getColIndice("C\u00f3digo"), this.getColIndice("S"), this.getColIndice("Ide"), this.getColIndice("Data"), this.getColIndice("Hora"), this.getColIndice("Mat.")});
        this.renderer.setColunaDataPrevisao(this.getColIndice("Previs\u00e3o"));
        this.renderer.setColunaUrgente(this.getColIndice("Urgente"));
        this.renderer.setColunaExameRotina(this.getColIndice("Exame da Rotina"));
        this.tabelaExames.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AbaDefaultNaoEnviados.this.tabelaExames_mouseClicked(e);
            }
        });
        this.tabelaExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                AbaDefaultNaoEnviados.this.tabelaExames_keyTyped(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    e.consume();
                }
            }
        });
    }

    @Override
    public void transmiteExames(int row, String exames) {
        if (row >= 0 && this.tabelaExames.getRowCount() > 0) {
            String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
            String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Tubo"));
            String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3d. Mat."));
            String pac_sexo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("S"));
            String pac_idade = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Ide"));
            String pac_nome = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Paciente"));
            String codigoApoiado = "";
            HashMap<String, String> parametro = new HashMap<String, String>();
            if (this.tabelaExames.getValueAt(row, this.getColIndice("Cod. Apoiado")) != null && !Funcoes.textoVazio(codigoApoiado = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Cod. Apoiado")))) {
                parametro.put("codigoApoiado", codigoApoiado);
            }
            String pac_exames = Funcoes.textoVazio(exames) ? (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame")) : exames;
            String hora = TempoUtil.getCurrentTime();
            String data = TempoUtil.getCurrentDateBr();
            String rackpos = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Rack"));
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
            try {
                String resposta = "";
                resposta = !Funcoes.textoVazio(codigoApoiado) ? this.equipamento.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackpos, null, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, "N", parametro) : this.equipamento.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackpos, null, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, "N");
                if (resposta != null) {
                    this.equipamento.novaMensagem(resposta, 0, resposta.startsWith("Erro") ? 5000 : 10000);
                    if (resposta.indexOf("Erro") >= 0 && this.equipamento.configuracao.getPularLinhaErroAutoenvio()) {
                        String req = fil_codigo + req_codigo;
                        req = req + Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
                        this.equipamento.addLinhaErro(req, pac_exames);
                    }
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace(), "AbaDefaultNaoEnviados (152)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadExames() {
        this.setAmpulheta(true);
        PreparedStatement ps = null;
        try {
            ArrayList dados_temp = new ArrayList();
            String recente = String.valueOf(0);
            StringBuilder query = new StringBuilder();
            query.append("select a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo, a.rec_codigo, b.req_data, ");
            query.append("b.req_hora, b.req_anomes, b.req_idade, c.pac_nome, c.pac_sexo, d.mco_abreviatura, ");
            query.append("a.ier_rackpos, a.int_codigo, ");
            query.append("exr.exr_situacao, coalesce(b.req_excluida, false) as req_excluida, coalesce(exr.exr_excluido, false) as exr_excluido, ");
            query.append(" pegaAlternativoExameInterface(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.int_codigo) as emi_alternativo, ");
            query.append(" pegaDataEntregaExame(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.req_codigo) as exr_dataentregaprev, ");
            query.append("(b.req_urgente or (coalesce(pegaUrgenteExame(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.req_codigo), false))) as req_urgente ");
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                query.append(", pegaCodigoMultiguiaMae(a.fil_codigo, a.req_codigo) as multiguia ");
            }
            if (this.exr_codigoapoiado) {
                query.append("  ,( case when (erc.ere_codigoapoiado is not null) then cast(erc.ere_codigoapoiado as varchar) else cast(exr.exr_codigoapoiado as varchar) end) as codigoApoiado  ");
            }
            query.append(", (SELECT  ARRAY (select rec_kodigo from interfaceexamerequisicaodesm");
            query.append(" where fil_codigo = a.fil_codigo and req_codigo = a.req_codigo and rec_codigo = a.rec_codigo and exa_codigo = a.exa_codigo and mco_codigo = a.mco_codigo and int_codigo = a.int_codigo)) as tubosFilhos ");
            query.append("from interfaceexamerequisicao a ");
            query.append("left join requisicao b on a.fil_codigo=b.fil_codigo and a.req_codigo=b.req_codigo ");
            query.append("left join examerequisicao exr on exr.fil_codigo = a.fil_codigo and exr.req_codigo = b.req_codigo and exr.exa_codigo = a.exa_codigo and exr.mco_codigo = a.mco_codigo ");
            if (this.exr_codigoapoiado) {
                query.append(" left join examerequisicaorecipiente erc on erc.fil_codigo = a.fil_codigo and erc.req_codigo = a.req_codigo and erc.rec_kodigo = a.rec_codigo and erc.exa_codigo = a.exa_codigo and erc.mco_codigo = a.mco_codigo ");
            }
            query.append("left join paciente c on a.fil_codigo=c.fil_codigo and b.pac_codigo=c.pac_codigo ");
            query.append("left join materialcoleta d on a.fil_codigo=d.fil_codigo and a.mco_codigo=d.mco_codigo ");
            query.append("where ").append(BDUtil.montaSQLEquipamentoFilial());
            query.append(" and a.ier_situacao = ");
            query.append(recente);
            if (Variaveis.equipamentos.get(0).getFiltroColetas() != null && Variaveis.equipamentos.get(0).getFiltroColetas().length > 0) {
                query.append(" and b.col_codigo in ('");
                StringUtil.implode(Variaveis.equipamentos.get(0).getFiltroColetas(), "', '", query);
                query.append("')");
            }
            if (Variaveis.equipamentos.get(0).getFiltroDestinos() != null && Variaveis.equipamentos.get(0).getFiltroDestinos().length > 0) {
                query.append(" and b.des_codigo in ('");
                StringUtil.implode(Variaveis.equipamentos.get(0).getFiltroDestinos(), "', '", query);
                query.append("')");
            }
            if (Variaveis.equipamentos.get(0).getFiltroSituacoesReq() != null && Variaveis.equipamentos.get(0).getFiltroSituacoesReq().length > 0) {
                query.append(" and b.sit_codigo in ('");
                StringUtil.implode(Variaveis.equipamentos.get(0).getFiltroSituacoesReq(), "', '", query);
                query.append("')");
            }
            if (!this.equipamento.configuracao.getNaoUtilizarOrdenacaoPorBanco()) {
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    query.append(" order by a.fil_codigo, multiguia, a.rec_codigo, a.int_codigo, a.exa_codigo");
                } else {
                    query.append(" order by a.fil_codigo, a.req_codigo, a.rec_codigo, a.int_codigo, a.exa_codigo");
                }
            }
            ps = Conexao.getPreparedStatement(query.toString());
            try (ResultSet rs = null;){
                rs = ps.executeQuery();
                while (rs != null && rs.next()) {
                    ArrayList<String> tubosFilhos;
                    boolean exameDesmembrado;
                    String situacao = Funcoes.textoVazio(rs.getString("exr_situacao")) ? "" : rs.getString("exr_situacao");
                    if (situacao.equals("T") || situacao.equals("A") || situacao.equals("F") || situacao.equals("R") || situacao.equals("N") || rs.getBoolean("req_excluida") || rs.getBoolean("exr_excluido")) continue;
                    Object[] linha = new Object[this.getColCount()];
                    String req_codigo = Funcoes.preencheZero(rs.getInt("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
                    req_codigo = req_codigo + Funcoes.preencheZero(rs.getInt("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao());
                    String idade = String.valueOf(rs.getInt("req_idade")) + " " + Tipos.tipoIdade(rs.getString("req_anomes"));
                    Date ddata = rs.getDate("req_data");
                    Time hhora = rs.getTime("req_hora");
                    String data = ddata == null ? "" : new SimpleDateFormat("dd/MM/yyyy").format(ddata);
                    String hora = hhora == null ? "" : new SimpleDateFormat("HH:mm").format(hhora);
                    String nome = this.limparNomePaciente(rs.getString("pac_nome"));
                    if (Funcoes.textoVazio(nome.trim())) {
                        nome = req_codigo + " Nome nao compativel com interfaceamento";
                    }
                    linha[this.getColIndice((String)"C\u00f3digo")] = req_codigo;
                    linha[this.getColIndice((String)"Exame")] = rs.getString("exa_codigo");
                    linha[this.getColIndice((String)"Paciente")] = nome;
                    linha[this.getColIndice((String)"S")] = rs.getString("pac_sexo");
                    linha[this.getColIndice((String)"Data")] = data;
                    linha[this.getColIndice((String)"Hora")] = hora;
                    linha[this.getColIndice((String)"Ide")] = idade;
                    linha[this.getColIndice((String)"Mat.")] = rs.getString("mco_abreviatura");
                    linha[this.getColIndice((String)"C\u00f3d. Mat.")] = rs.getString("mco_codigo");
                    linha[this.getColIndice((String)"Tubo")] = rs.getString("rec_codigo");
                    linha[this.getColIndice((String)"Previs\u00e3o")] = rs.getTimestamp("exr_dataentregaprev");
                    linha[this.getColIndice((String)"Rack")] = rs.getString("ier_rackpos");
                    linha[this.getColIndice((String)"Urgente")] = rs.getBoolean("req_urgente");
                    linha[this.getColIndice((String)"Interface")] = rs.getString("int_codigo");
                    linha[this.getColIndice((String)"Alternativo")] = rs.getString("emi_alternativo");
                    linha[this.getColIndice((String)"Cod. Apoiado")] = "";
                    if (this.exr_codigoapoiado) {
                        linha[this.getColIndice((String)"Cod. Apoiado")] = rs.getString("codigoApoiado");
                    }
                    if (ParametrosGerais.isAgruparGuiasInterface()) {
                        String multiguia = Funcoes.preencheZero(rs.getInt("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
                        multiguia = multiguia + Funcoes.preencheZero(rs.getInt("multiguia"), ParametrosGerais.getDigitosTuboRequisicao());
                        linha[this.getColIndice((String)"Multiguia")] = multiguia;
                        linha[this.getColIndice((String)"C\u00f3digo Temp.")] = req_codigo;
                    }
                    boolean bl = exameDesmembrado = (tubosFilhos = this.getTubosFilhos(rs)).size() > 0;
                    if (exameDesmembrado) {
                        linha[this.getColIndice((String)"Tubos Filhos")] = tubosFilhos;
                    }
                    dados_temp.add(linha);
                }
                dados_temp = ParametrosGerais.isAgruparGuiasInterface() ? this.agrupaExamesMultiGuia(dados_temp) : this.agrupaExamesMesmaRequisicao(dados_temp);
                this.tabelaExames.setData(dados_temp);
                this.tabelaExames.sortRowsByColumn(this.tabelaExames.getColunaOrdenada() == -1 ? 0 : this.tabelaExames.getColunaOrdenada(), false, false);
                this.tabelaExames.grabFocus();
                this.exames = dados_temp;
            }
            ps.close();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setAmpulheta(false);
    }

    @Override
    public void exibeUltimoEnviado(String req_codigo, String pac_nome, String pac_sexo, String req_idade, String req_data, String req_hora, String pac_exames) {
        this.enviado_panel.showPacInfo(req_codigo, pac_nome, pac_sexo, req_idade, req_data, req_hora, pac_exames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excluirExame(int row) {
        this.setAmpulheta(true);
        if (Acesso.getAcesso(1001001001L)) {
            try {
                String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
                String pac_nome = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Paciente"));
                String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Tubo"));
                String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3d. Mat."));
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo Temp."));
                }
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                StringBuilder msg = new StringBuilder("Tem certeza que deseja excluir os exames de ");
                msg.append(pac_nome);
                msg.append("?");
                int answer = Funcoes.showPerguntaSimNao(this.parent, "Excluir exames", msg.toString());
                if (answer == 0) {
                    Statement st = Conexao.getStatement();
                    String exames = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame"));
                    if (ParametrosGerais.isAgruparGuiasInterface()) {
                        String[] exas = exames.split(" ");
                        ArrayList<String> requisicoes = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
                        for (String exa : exas) {
                            for (String req : requisicoes) {
                                if (!BDUtil.existeExame(fil_codigo, int_codigo, req_codigo, exa, mco_codigo, rec_codigo)) continue;
                                this.gravaLogExclusaoRequisicao(this, st, fil_codigo, int_codigo, req, mco_codigo, rec_codigo, exa, "N\u00e3o Enviados");
                                BDUtil.deletarExame(st, fil_codigo, int_codigo, req_codigo, exa, mco_codigo, rec_codigo);
                            }
                        }
                    } else {
                        this.gravaLogExclusaoRequisicao(this, st, fil_codigo, int_codigo, req_codigo, null, rec_codigo, exames, "N\u00e3o Enviados");
                        BDUtil.deletarExamesPorRecipienteSituacao(st, fil_codigo, int_codigo, req_codigo, rec_codigo, 0);
                    }
                    Conexao.arquivaSQL();
                    st.close();
                    this.equipamento.refreshSelected();
                    this.equipamento.novaMensagem("Requisi\u00e7\u00e3o/exames exclu\u00eddos com sucesso deste interfaceamento", 0, 10000);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                finally {
                    this.equipamento.refreshSelected();
                }
            }
            this.tabelaExames.grabFocus();
        } else {
            this.equipamento.novaMensagem("Voc\u00ea n\u00e3o possui acesso para excluir exames", 1, 5000);
        }
        this.setAmpulheta(false);
    }

    protected ArrayList agrupaExamesMesmaRequisicao(ArrayList lista) throws SQLException {
        ArrayList<Object> nova = new ArrayList<Object>();
        int exameRotina = this.getColIndice("Exame da Rotina");
        int codigo = this.getColIndice("C\u00f3digo");
        int tubo = this.getColIndice("Tubo");
        int exames = this.getColIndice("Exame");
        int material = this.getColIndice("C\u00f3d. Mat.");
        int equip = this.getColIndice("Interface");
        int tubos = this.getColIndice("Tubos Filhos");
        if (this.equipamento.configuracao.getValidaRotinaExames()) {
            Statement st = Conexao.getStatement();
            Calendar c = Calendar.getInstance();
            int diaAtual = c.get(7);
            for (int i = 0; i < lista.size(); ++i) {
                Object[] temp = (Object[])lista.get(i);
                String filial = ((String)temp[codigo]).substring(0, ParametrosGerais.getDigitosTuboFilial());
                temp[exameRotina] = new Boolean(BDUtil.verificaDiaDeRotina(filial, (String)temp[exames], (String)temp[material], diaAtual));
            }
            Object[] temp = null;
            while (!lista.isEmpty()) {
                Object[] prox = (Object[])lista.remove(0);
                String reqa = temp != null ? (String)temp[codigo] : "";
                String reca = temp != null ? (String)temp[tubo] : "";
                String inta = temp != null ? (String)temp[equip] : "";
                String reqb = (String)prox[codigo];
                String recb = (String)prox[tubo];
                String intb = (String)prox[equip];
                if (!((Boolean)prox[exameRotina]).booleanValue()) {
                    if (temp != null) {
                        nova.add(temp.clone());
                    }
                    nova.add(prox.clone());
                    temp = null;
                    continue;
                }
                if (reqa.equalsIgnoreCase(reqb) && reca.equalsIgnoreCase(recb)) {
                    ArrayList bTubos;
                    ArrayList aTubos;
                    String b;
                    String a;
                    if (this.equipamento.configuracao.getAgruparExamesPorInterface()) {
                        if (inta.equalsIgnoreCase(intb)) {
                            a = (String)temp[exames];
                            b = (String)prox[exames];
                            temp[exames] = a + " " + b;
                            aTubos = (ArrayList)temp[tubos];
                            bTubos = (ArrayList)prox[tubos];
                            if (aTubos == null) {
                                temp[tubos] = bTubos;
                                continue;
                            }
                            if (bTubos == null) continue;
                            for (String t : bTubos) {
                                aTubos.add(t);
                            }
                            temp[tubos] = aTubos;
                            continue;
                        }
                        if (temp != null) {
                            nova.add(temp.clone());
                        }
                        temp = prox;
                        continue;
                    }
                    a = (String)temp[exames];
                    b = (String)prox[exames];
                    temp[exames] = a + " " + b;
                    aTubos = (ArrayList)temp[tubos];
                    bTubos = (ArrayList)prox[tubos];
                    if (aTubos == null) {
                        temp[tubos] = bTubos;
                        continue;
                    }
                    if (bTubos == null) continue;
                    for (String t : bTubos) {
                        aTubos.add(t);
                    }
                    temp[tubos] = aTubos;
                    continue;
                }
                if (temp != null) {
                    nova.add(temp.clone());
                }
                temp = prox;
            }
            return nova;
        }
        if (lista.size() >= 2) {
            Object[] temp = (Object[])lista.remove(0);
            while (!lista.isEmpty()) {
                Object[] prox = (Object[])lista.remove(0);
                String reqa = (String)temp[codigo];
                String reca = (String)temp[tubo];
                String inta = (String)temp[equip];
                String reqb = (String)prox[codigo];
                String recb = (String)prox[tubo];
                String intb = (String)prox[equip];
                if (reqa.equalsIgnoreCase(reqb) && reca.equalsIgnoreCase(recb)) {
                    ArrayList bTubos;
                    ArrayList aTubos;
                    String b;
                    String a;
                    if (this.equipamento.configuracao.getAgruparExamesPorInterface()) {
                        if (inta.equalsIgnoreCase(intb)) {
                            a = (String)temp[exames];
                            b = (String)prox[exames];
                            temp[exames] = a + " " + b;
                            aTubos = (ArrayList)temp[tubos];
                            bTubos = (ArrayList)prox[tubos];
                            if (aTubos == null) {
                                temp[tubos] = bTubos;
                                continue;
                            }
                            if (bTubos == null) continue;
                            for (String t : bTubos) {
                                aTubos.add(t);
                            }
                            temp[tubos] = aTubos;
                            continue;
                        }
                        if (temp != null) {
                            nova.add(temp.clone());
                        }
                        temp = prox;
                        continue;
                    }
                    a = (String)temp[exames];
                    b = (String)prox[exames];
                    temp[exames] = a + " " + b;
                    aTubos = (ArrayList)temp[tubos];
                    bTubos = (ArrayList)prox[tubos];
                    if (aTubos == null) {
                        temp[tubos] = bTubos;
                        continue;
                    }
                    if (bTubos == null) continue;
                    for (String t : bTubos) {
                        aTubos.add(t);
                    }
                    temp[tubos] = aTubos;
                    continue;
                }
                nova.add(temp.clone());
                temp = prox;
            }
            nova.add(temp.clone());
            return nova;
        }
        return lista;
    }

    /*
     * WARNING - void declaration
     */
    protected ArrayList agrupaExamesMultiGuia(ArrayList lista) throws SQLException {
        Object[] temp;
        ArrayList<Object> nova = new ArrayList<Object>();
        int exameRotina = this.getColIndice("Exame da Rotina");
        int tubo = this.getColIndice("Tubo");
        int exames = this.getColIndice("Exame");
        int material = this.getColIndice("C\u00f3d. Mat.");
        int equip = this.getColIndice("Interface");
        int codigo = this.getColIndice("Multiguia");
        int tubos = this.getColIndice("Tubos Filhos");
        if (this.equipamento.configuracao.getNaoUtilizarOrdenacaoPorBanco()) {
            HashMap lis = new HashMap();
            for (int i = 0; i < lista.size(); ++i) {
                Object[] temp2 = (Object[])lista.get(i);
                String key = (String)temp2[codigo] + (String)temp2[tubo] + (String)temp2[material];
                if (!lis.containsKey(key)) {
                    lis.put(key, new ArrayList());
                }
                ((List)lis.get(key)).add(temp2.clone());
            }
            lista.clear();
            for (String key : lis.keySet()) {
                for (Object object : (List)lis.get(key)) {
                    lista.add(object);
                }
            }
        }
        if (this.equipamento.configuracao.getValidaRotinaExames()) {
            Statement st = Conexao.getStatement();
            Calendar c = Calendar.getInstance();
            int diaAtual = c.get(7);
            for (int i = 0; i < lista.size(); ++i) {
                Object[] temp3 = (Object[])lista.get(i);
                String filial = ((String)temp3[codigo]).substring(0, ParametrosGerais.getDigitosTuboFilial());
                temp3[exameRotina] = new Boolean(BDUtil.verificaDiaDeRotina(filial, (String)temp3[exames], (String)temp3[material], diaAtual));
            }
            Object[] temp4 = null;
            while (!lista.isEmpty()) {
                Object[] prox = (Object[])lista.remove(0);
                String reqa = temp4 != null ? (String)temp4[codigo] : "";
                String reca = temp4 != null ? (String)temp4[tubo] : "";
                String inta = temp4 != null ? (String)temp4[equip] : "";
                String reqb = (String)prox[codigo];
                String recb = (String)prox[tubo];
                String intb = (String)prox[equip];
                if (!((Boolean)prox[exameRotina]).booleanValue()) {
                    if (temp4 != null) {
                        temp4[this.getColIndice((String)"C\u00f3digo")] = temp4[codigo];
                        nova.add(temp4.clone());
                    }
                    prox[this.getColIndice((String)"C\u00f3digo")] = prox[codigo];
                    nova.add(prox.clone());
                    temp4 = null;
                    continue;
                }
                if (reqa.equalsIgnoreCase(reqb) && reca.equalsIgnoreCase(recb)) {
                    void var28_67;
                    Object aTubos22;
                    Object exa;
                    String[] tmpExasB;
                    String[] tmpExasA;
                    HashSet<String> exas;
                    String b;
                    String a;
                    if (this.equipamento.configuracao.getAgruparExamesPorInterface()) {
                        if (inta.equalsIgnoreCase(intb)) {
                            void var28_61;
                            a = (String)temp4[exames];
                            b = (String)prox[exames];
                            exas = new HashSet();
                            for (String string : tmpExasA = a.split(" ")) {
                                exas.add(string);
                            }
                            String[] stringArray = tmpExasB = b.split(" ");
                            int n = stringArray.length;
                            boolean bl = false;
                            while (var28_61 < n) {
                                String string = stringArray[var28_61];
                                exas.add(string);
                                ++var28_61;
                            }
                            exa = new StringBuilder();
                            for (String string : exas) {
                                ((StringBuilder)exa).append(string).append(" ");
                            }
                            temp4[exames] = ((StringBuilder)exa).toString();
                            aTubos22 = (ArrayList)temp4[tubos];
                            ArrayList arrayList = (ArrayList)prox[tubos];
                            if (aTubos22 == null) {
                                temp4[tubos] = arrayList;
                                continue;
                            }
                            if (arrayList == null) continue;
                            for (String t : arrayList) {
                                ((ArrayList)aTubos22).add(t);
                            }
                            temp4[tubos] = aTubos22;
                            continue;
                        }
                        if (temp4 != null) {
                            temp4[this.getColIndice((String)"C\u00f3digo")] = temp4[codigo];
                            nova.add(temp4.clone());
                        }
                        temp4 = prox;
                        continue;
                    }
                    a = (String)temp4[exames];
                    b = (String)prox[exames];
                    exas = new HashSet<String>();
                    for (String string : tmpExasA = a.split(" ")) {
                        exas.add(string);
                    }
                    tmpExasB = b.split(" ");
                    exa = tmpExasB;
                    int aTubos22 = ((String[])exa).length;
                    boolean bl = false;
                    while (var28_67 < aTubos22) {
                        String string = exa[var28_67];
                        exas.add(string);
                        ++var28_67;
                    }
                    exa = new StringBuilder();
                    for (String string : exas) {
                        ((StringBuilder)exa).append(string).append(" ");
                    }
                    temp4[exames] = ((StringBuilder)exa).toString();
                    aTubos22 = (ArrayList)temp4[tubos];
                    ArrayList arrayList = (ArrayList)prox[tubos];
                    if (aTubos22 == null) {
                        temp4[tubos] = arrayList;
                        continue;
                    }
                    if (arrayList == null) continue;
                    for (String t : arrayList) {
                        ((ArrayList)aTubos22).add(t);
                    }
                    temp4[tubos] = aTubos22;
                    continue;
                }
                if (temp4 != null) {
                    temp4[this.getColIndice((String)"C\u00f3digo")] = temp4[codigo];
                    nova.add(temp4.clone());
                }
                temp4 = prox;
            }
            return nova;
        }
        if (lista.size() == 1) {
            temp = (Object[])lista.remove(0);
            temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
            nova.add(temp.clone());
            return nova;
        }
        if (lista.size() > 1) {
            temp = (Object[])lista.remove(0);
            while (!lista.isEmpty()) {
                Object[] prox = (Object[])lista.remove(0);
                String reqa = (String)temp[codigo];
                String fila = reqa.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reca = (String)temp[tubo];
                String inta = (String)temp[equip];
                String reqb = (String)prox[codigo];
                String filb = reqb.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String recb = (String)prox[tubo];
                String intb = (String)prox[equip];
                if (reqa.equalsIgnoreCase(reqb) && reca.equalsIgnoreCase(recb)) {
                    ArrayList bTubos;
                    Object aTubos;
                    Object exa;
                    String[] tmpExasB;
                    String[] tmpExasA;
                    HashSet<String> exas;
                    String b;
                    String a;
                    if (this.equipamento.configuracao.getAgruparExamesPorInterface()) {
                        if (inta.equalsIgnoreCase(intb)) {
                            a = (String)temp[exames];
                            b = (String)prox[exames];
                            exas = new HashSet();
                            for (String e : tmpExasA = a.split(" ")) {
                                exas.add(e);
                            }
                            for (String string : tmpExasB = b.split(" ")) {
                                exas.add(string);
                            }
                            exa = new StringBuilder();
                            for (String e8 : exas) {
                                ((StringBuilder)exa).append(e8).append(" ");
                            }
                            temp[exames] = ((StringBuilder)exa).toString();
                            aTubos = (ArrayList)temp[tubos];
                            bTubos = (ArrayList)prox[tubos];
                            if (aTubos == null) {
                                temp[tubos] = bTubos;
                                continue;
                            }
                            if (bTubos == null) continue;
                            for (String string : bTubos) {
                                ((ArrayList)aTubos).add(string);
                            }
                            temp[tubos] = aTubos;
                            continue;
                        }
                        if (temp != null) {
                            temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
                            nova.add(temp.clone());
                        }
                        temp = prox;
                        continue;
                    }
                    a = (String)temp[exames];
                    b = (String)prox[exames];
                    exas = new HashSet<String>();
                    for (String e6 : tmpExasA = a.split(" ")) {
                        exas.add(e6);
                    }
                    tmpExasB = b.split(" ");
                    for (String string : tmpExasB) {
                        exas.add(string);
                    }
                    exa = new StringBuilder();
                    for (String e : exas) {
                        ((StringBuilder)exa).append(e).append(" ");
                    }
                    temp[exames] = ((StringBuilder)exa).toString();
                    aTubos = (ArrayList)temp[tubos];
                    bTubos = (ArrayList)prox[tubos];
                    if (aTubos == null) {
                        temp[tubos] = bTubos;
                        continue;
                    }
                    if (bTubos == null) continue;
                    for (String string : bTubos) {
                        ((ArrayList)aTubos).add(string);
                    }
                    temp[tubos] = aTubos;
                    continue;
                }
                if (temp != null) {
                    temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
                    nova.add(temp.clone());
                }
                temp = prox;
            }
            temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
            nova.add(temp.clone());
            return nova;
        }
        return lista;
    }

    public void tabelaExames_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            boolean desabilitar;
            boolean bl = desabilitar = this.equipamento.configuracao.getDesativarEnvioManualAbaNaoEnviados() && this.equipamento.configuracao.getModoHostQuery();
            if (!desabilitar) {
                int row = this.tabelaExames.getSelectedRow();
                if (row >= 0) {
                    this.transmiteLinha(row, 1001001002L);
                }
                this.tabelaExames.grabFocus();
            }
        }
    }

    public void tabelaExames_keyTyped(KeyEvent e) {
        if (e.isAltDown()) {
            e.consume();
        } else if (e.getKeyChar() == '\u007f') {
            int row = this.tabelaExames.getSelectedRow();
            if (row >= 0 && this.tabelaExames.getRowCount() > 0) {
                this.excluirExame(row);
            }
        } else if (e.getKeyChar() == ' ') {
            boolean desabilitar;
            boolean bl = desabilitar = this.equipamento.configuracao.getDesativarEnvioManualAbaNaoEnviados() && this.equipamento.configuracao.getModoHostQuery();
            if (!desabilitar) {
                int row = this.tabelaExames.getSelectedRow();
                if (row >= 0 && this.tabelaExames.getRowCount() > 0) {
                    this.transmiteLinha(row, 1001001002L);
                }
                this.tabelaExames.grabFocus();
            }
        } else if (Character.isLetterOrDigit(e.getKeyChar())) {
            this.showLocalizar(e.getKeyChar());
        } else {
            this.tabelaExames.grabFocus();
        }
    }

    protected void lote() {
        if (Acesso.getAcesso(1001001003L) && this.exames != null && this.exames.size() > 0) {
            ExameLote tela = new ExameLote(this.owner, this.exames, this.getColIndice("C\u00f3digo"), this.getColIndice("Tubo"), this.getColIndice("Paciente"), this.getColIndice("Exame"), this.getColIndice("Contador"), this.equipamento);
            tela.setVisible(true);
            ArrayList requisicoes = tela.getRequisicoes();
            for (int i = 0; i < requisicoes.size(); ++i) {
                Object[] req = (Object[])requisicoes.get(i);
                String requisicao = req[this.getColIndice("C\u00f3digo")].toString();
                String tubo = req[this.getColIndice("Tubo")].toString();
                for (int j = 0; j < this.tabelaExames.getRowCount(); ++j) {
                    String requisicaoExame = this.tabelaExames.getValueAt(j, this.getColIndice("C\u00f3digo")).toString();
                    String tuboExame = this.tabelaExames.getValueAt(j, this.getColIndice("Tubo")).toString();
                    if (!requisicao.equalsIgnoreCase(requisicaoExame) || !tubo.equalsIgnoreCase(tuboExame)) continue;
                    this.transmiteExames(j);
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public String getAtalhos() {
        return "[DEL]-Excluir [ESP]-Transmite";
    }

    public ArrayList getExames() {
        return this.exames;
    }

    @Override
    public void exibeUltimoExportado(String req_codigo, String pac_nome, String pac_sexo, String req_idade, String req_data, String req_hora, String pac_exames) {
    }

    @Override
    public void showPopupMenu(MouseEvent e) {
        this.popupNaoEnviado.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public int getTipoAba() {
        return 0;
    }
}

