/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento;

import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoFactory;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JFrame;

public class JarInterfaceamento {
    JarFile arquivo;
    String nome_arquivo;
    URL url;
    String nome_interfaceamento;

    public JarInterfaceamento(URL url) {
        try {
            File temp = new File(url.toURI());
            this.arquivo = new JarFile(temp);
            this.nome_arquivo = temp.getName();
            this.url = url;
            this.recuperaNomeInterfaceamento();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    public String getNomeArquivoJar() {
        return this.nome_arquivo;
    }

    private void recuperaNomeInterfaceamento() {
        AbstractInterfaceamentoFactory factory = this.carregaFabrica();
        if (factory != null) {
            this.nome_interfaceamento = factory.getNomeInterfaceamento();
        }
    }

    public String getNomeInterfaceamento() {
        return this.nome_interfaceamento;
    }

    public AbstractInterfaceamento getInstanciaInterfaceamento(JFrame parent) {
        AbstractInterfaceamentoFactory factory = this.carregaFabrica();
        if (factory != null) {
            return factory.getInterfaceamento(parent);
        }
        return null;
    }

    public String toString() {
        return this.getNomeInterfaceamento();
    }

    public AbstractInterfaceamentoFactory carregaFabrica() {
        try {
            Manifest mf = this.arquivo.getManifest();
            if (mf != null) {
                Attributes attribs = mf.getMainAttributes();
                if (attribs != null) {
                    String mainClass = attribs.getValue("Main-Class");
                    if (mainClass != null) {
                        ClassLoader loader = JarInterfaceamento.class.getClassLoader();
                        Funcoes.mensagem(null, "ClassLoader criado", 2);
                        Class<?> cl = loader.loadClass(mainClass);
                        Funcoes.mensagem(null, "Class recuperada", 2);
                        AbstractInterfaceamentoFactory fabrica = (AbstractInterfaceamentoFactory)cl.newInstance();
                        Funcoes.mensagem(null, "AbstractInterfaceamentoFactory instanciado", 2);
                        return fabrica;
                    }
                    throw new Exception("Atributo Main-Class inexistente...");
                }
                throw new Exception("Arquivo Manifesto sem main-attributes...");
            }
            throw new Exception("Arquivo jar sem Manifesto...");
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }
}

