/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoFactory;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.comunicacao.DataChangedListenerInput;
import jalis.laboratorio.interfaceamento.comunicacao.DataChangedListenerOutput;
import jalis.laboratorio.interfaceamento.comunicacao.FlowController;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocket;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketServer;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketServerDouble;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketServerTriplex;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketSingle;
import jalis.laboratorio.interfaceamento.comunicacao.SoftHandShakeListenerInput;
import jalis.laboratorio.interfaceamento.comunicacao.SoftHandShakeListenerOutput;
import jalis.laboratorio.interfaceamento.comunicacao.arquivo.ArquivoException;
import jalis.laboratorio.interfaceamento.comunicacao.log.LogArquivoInterface;
import jalis.laboratorio.interfaceamento.comunicacao.log.LogInterfaceamentoException;
import jalis.laboratorio.interfaceamento.comunicacao.log.LogInterfaceamentoService;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.padroes.socket.InterfaceSocketListener;
import jalis.util.Funcoes;
import jalis.util.JalisPropertiesService;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;

public class InterfaceamentoLoader {
    static SplashMensagem splash = new SplashMensagem();
    private static final LogInterfaceamentoService service = new LogInterfaceamentoService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FrmPadrao carregaInterfaceamentoConfigurado() {
        Object apa_nome = null;
        String apa_classe = null;
        try {
            splash = new SplashMensagem();
            splash.mostrar("Carregando protocolo...");
            Laboratorio.setIconeInterfaceamento(null);
            if (Variaveis.equip != null) {
                AbstractInterfaceamento abstractInterfaceamento = Variaveis.equip;
                return abstractInterfaceamento;
            }
            Variaveis.equipamentos = ConfiguracaoSerial.loadConfiguracoes(ParametrosLocais.getParametro("xml_interfaceamento"));
            AbstractInterfaceamentoFactory aif = null;
            if (Variaveis.equipamentos == null || Variaveis.equipamentos.size() == 0) {
                splash.apagar();
                Funcoes.showErro(null, "N\u00e3o foi poss\u00edvel abrir interfaceamento.\nNenhuma porta serial ou equipamento dispon\u00edvel nesta m\u00e1quina.");
                FrmPadrao frmPadrao = null;
                return frmPadrao;
            }
            apa_classe = Variaveis.equipamentos.get(0).getProtocolo().getClasse();
            aif = (AbstractInterfaceamentoFactory)Class.forName("jalis.laboratorio.interfaceamento.interfaces." + apa_classe + ".InterfaceamentoFactory").newInstance();
            InterfaceamentoLoader.gravarDataUltimoAcesso(apa_classe);
            for (ConfiguracaoSerial c : Variaveis.equipamentos) {
                if (c != null) {
                    c.load(aif.getTipoComunicacao());
                }
                AbstractInterfaceamentoListener ail = (AbstractInterfaceamentoListener)Class.forName("jalis.laboratorio.interfaceamento.interfaces." + apa_classe + ".InterfaceListener").newInstance();
                if (c == null || c.getPortaCOM() == null) {
                    throw new Exception("Erro ao buscar a porta de comunica\u00e7\u00e3o do equipamento");
                }
                if (aif.getTipoComunicacao() == 0) {
                    c.getPortaCOM().addDataChangedListener(ail);
                    c.getPortaCOM().addSoftHandShakeListener(ail);
                } else if (aif.getTipoComunicacao() == 2) {
                    ((PortaSocket)c.getPortaCOM()).addDataChangedListenerInput((InterfaceSocketListener)ail);
                    ((PortaSocket)c.getPortaCOM()).addDataChangedListenerOutput((InterfaceSocketListener)ail);
                    ((PortaSocket)c.getPortaCOM()).addSoftHandShakeListenerInput((InterfaceSocketListener)ail);
                    ((PortaSocket)c.getPortaCOM()).addSoftHandShakeListenerOutput((InterfaceSocketListener)ail);
                } else if (aif.getTipoComunicacao() == 3) {
                    ((PortaSocketServer)c.getPortaCOM()).addDataChangedListener(ail);
                    ((PortaSocketServer)c.getPortaCOM()).addSoftHandShakeListener(ail);
                } else if (aif.getTipoComunicacao() == 8) {
                    ((PortaSocketServerDouble)c.getPortaCOM()).addDataChangedListenerInput((DataChangedListenerInput)((Object)ail));
                    ((PortaSocketServerDouble)c.getPortaCOM()).addDataChangedListenerOutput((DataChangedListenerOutput)((Object)ail));
                    ((PortaSocketServerDouble)c.getPortaCOM()).addSoftHandShakeListenerInput((SoftHandShakeListenerInput)((Object)ail));
                    ((PortaSocketServerDouble)c.getPortaCOM()).addSoftHandShakeListenerOutput((SoftHandShakeListenerOutput)((Object)ail));
                } else if (aif.getTipoComunicacao() == 9) {
                    ((PortaSocketServerTriplex)c.getPortaCOM()).addDataChangedListenerInput((DataChangedListenerInput)((Object)ail));
                    ((PortaSocketServerTriplex)c.getPortaCOM()).addDataChangedListenerOutput((DataChangedListenerOutput)((Object)ail));
                    ((PortaSocketServerTriplex)c.getPortaCOM()).addDataChangedListenerInputTriplex((DataChangedListenerInput)((Object)ail));
                    ((PortaSocketServerTriplex)c.getPortaCOM()).addSoftHandShakeListenerInput((SoftHandShakeListenerInput)((Object)ail));
                    ((PortaSocketServerTriplex)c.getPortaCOM()).addSoftHandShakeListenerOutput((SoftHandShakeListenerOutput)((Object)ail));
                    ((PortaSocketServerTriplex)c.getPortaCOM()).addSoftHandShakeListenerInputTriplex((SoftHandShakeListenerInput)((Object)ail));
                } else if (aif.getTipoComunicacao() == 4) {
                    ((PortaSocketSingle)c.getPortaCOM()).addDataChangedListener(ail);
                    ((PortaSocketSingle)c.getPortaCOM()).addSoftHandShakeListener(ail);
                } else if (aif.getTipoComunicacao() == 5) {
                    ((PortaSocketSingle)c.getPortaCOM()).addDataChangedListener(ail);
                    ((PortaSocketSingle)c.getPortaCOM()).addSoftHandShakeListener(ail);
                }
                ail.setPortaCOM(c.getPortaCOM());
                ail.setFluxo(new FlowController());
                c.setFluxoController(ail.getFluxo());
                c.setInterfaceamentoListener(ail);
            }
            AbstractInterfaceamento equip = aif.getInterfaceamento(Laboratorio.getInstancia());
            for (ConfiguracaoSerial c : Variaveis.equipamentos) {
                c.getInterfacementoListener().addRecebimentoListener(equip);
                equip.addEnvioListener(c.getInterfacementoListener());
                c.getInterfacementoListener().setAbstractInterfaceamentoListener(equip);
            }
            System.gc();
            InterfaceamentoLoader.criarArquivo(equip);
            AbstractInterfaceamento abstractInterfaceamento = equip;
            return abstractInterfaceamento;
        }
        catch (Exception ex) {
            splash.apagar();
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            FrmPadrao frmPadrao = null;
            return frmPadrao;
        }
        finally {
            splash.apagar();
        }
    }

    private static void criarArquivo(AbstractInterfaceamento equip) {
        try {
            int colInterface = equip.getAbaNaoEnviados().getColIndice("Interface");
            Integer[] intCodigo = InterfaceamentoLoader.getCodigoInterface();
            service.criarArquivo(new LogArquivoInterface(InterfaceamentoLoader.getFilial(), intCodigo));
        }
        catch (LogInterfaceamentoException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
    }

    private static Integer[] getCodigoInterface() {
        try {
            return JalisPropertiesService.getCodigoInterfaceamento();
        }
        catch (ArquivoException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    private static Integer getFilial() {
        return Integer.valueOf(Variaveis.filialPadrao);
    }

    private static boolean loadSerialCfg() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void gravarDataUltimoAcesso(String classe) {
        Statement st = Conexao.getStatement();
        try {
            String sql = "update aparelhosinterface set apa_ultimoacesso = now() where apa_classe = " + StringUtil.textoDBEscape(classe);
            st.execute(sql);
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }
}

