/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.InterfaceamentoEnvioListener;
import jalis.laboratorio.interfaceamento.InterfaceamentoRecebimentoListener;
import jalis.laboratorio.interfaceamento.TravaFechamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultNaoEnviados;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultPendentes;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultProntos;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.DataChangedListener;
import jalis.laboratorio.interfaceamento.comunicacao.FCTimeOutListener;
import jalis.laboratorio.interfaceamento.comunicacao.FlowController;
import jalis.laboratorio.interfaceamento.comunicacao.SoftHandShakeListener;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.ResolvedorResultado;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractInterfaceamentoListener
implements DataChangedListener,
SoftHandShakeListener,
InterfaceamentoEnvioListener,
FCTimeOutListener {
    public static final char NUL = '\u0000';
    public static final char SOH = '\u0001';
    public static final char STX = '\u0002';
    public static final char ETX = '\u0003';
    public static final char EOT = '\u0004';
    public static final char ENQ = '\u0005';
    public static final char ACK = '\u0006';
    public static final char LF = '\n';
    public static final char SB = '\u000b';
    public static final char CR = '\r';
    public static final char DLE = '\u0010';
    public static final char DC1 = '\u0011';
    public static final char NAK = '\u0015';
    public static final char SYN = '\u0016';
    public static final char ETB = '\u0017';
    public static final char CAN = '\u0018';
    public static final char EB = '\u001c';
    public static final char EOF = '\u001a';
    public static final char GS = '\u001d';
    public static final char RS = '\u001e';
    public static final char SP = ' ';
    public static final char DEL = '\u007f';
    public static final String LINE = String.valueOf('\r') + String.valueOf('\n');
    public static final char FD = '\u00fd';
    public static final char FS = '\u001c';
    public static final char VT = '\u000b';
    public static final int ABA_NAOENVIADOS = 0;
    public static final int ABA_PENDENTES = 1;
    public static final int ABA_PRONTOS = 2;
    public static final int ABA_EXCECOES = 3;
    public static final String CODIGO_APOIADO = "codigoApoiado";
    protected FlowController fluxo;
    private AbstractPort portaCOM;
    public AbstractInterfaceamento equipamento;
    protected ArrayList<InterfaceamentoRecebimentoListener> recebimento_listeners = new ArrayList();

    public void setAbstractInterfaceamentoListener(AbstractInterfaceamento equipamento) {
        this.equipamento = equipamento;
        if (this.portaCOM != null) {
            this.portaCOM.setEquipamento(equipamento);
        }
    }

    public void setFluxo(FlowController fluxo) {
        this.fluxo = fluxo;
        fluxo.addFCTimeOutListener(this);
    }

    public FlowController getFluxo() {
        return this.fluxo;
    }

    public void setPortaCOM(AbstractPort portaCOM) {
        this.portaCOM = portaCOM;
        if (this.equipamento != null) {
            portaCOM.setEquipamento(this.equipamento);
        }
    }

    public AbstractPort getPortaCOM() {
        return this.portaCOM;
    }

    @Override
    public abstract void dataChanged();

    @Override
    public abstract void handShakeCharReceived(char var1);

    public void addRecebimentoListener(InterfaceamentoRecebimentoListener listener) {
        this.recebimento_listeners.add(listener);
    }

    public void removeAllRecebimentoListener() {
        this.recebimento_listeners.clear();
    }

    public abstract String getMsgEnd();

    public abstract String getMsgStart();

    public abstract String parse(String var1);

    @Override
    public abstract String enviarRequisicao(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, String var13, String var14);

    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao, HashMap<String, String> mapaParametros) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames, acao);
    }

    public void firePacienteEnviado(String req_codigo, String pac_nome, String pac_sexo, String req_idade, String req_data, String req_hora, String pac_exames) {
        for (InterfaceamentoRecebimentoListener i : this.recebimento_listeners) {
            i.pacienteEnviado(req_codigo, pac_nome, pac_sexo, req_idade, req_data, req_hora, pac_exames);
        }
    }

    public void firePacienteExportado(String req_codigo, String pac_nome, String pac_sexo, String req_idade, String req_data, String req_hora, String pac_exames) {
        for (InterfaceamentoRecebimentoListener i : this.recebimento_listeners) {
            i.pacienteExportado(req_codigo, pac_nome, pac_sexo, req_idade, req_data, req_hora, pac_exames);
        }
    }

    public void fireMensagemEnviada(String texto, int tipo, int tempo) {
        for (InterfaceamentoRecebimentoListener i : this.recebimento_listeners) {
            i.mensagemEnviada(texto, tipo, tempo);
        }
    }

    public void fireExcecaoEncontrada(String texto) {
        for (InterfaceamentoRecebimentoListener i : this.recebimento_listeners) {
            i.execaoEncontrada(texto);
        }
    }

    public void fireAtualizarTabela(int aba) {
        for (InterfaceamentoRecebimentoListener i : this.recebimento_listeners) {
            i.atualizarTabela(aba);
        }
    }

    public void fireAtualizarTabela() {
        for (InterfaceamentoRecebimentoListener i : this.recebimento_listeners) {
            i.atualizarTabela();
        }
    }

    public boolean isTX() {
        return this.fluxo == null ? false : this.fluxo.isTX();
    }

    public boolean isRX() {
        return this.fluxo == null ? false : this.fluxo.isRX();
    }

    public boolean isIdle() {
        return this.fluxo == null ? true : this.fluxo.isIdle();
    }

    public void setTX() {
        this.fluxo.setEstado(1);
    }

    public void setRX() {
        this.fluxo.setEstado(2);
    }

    public void setIdle() {
        this.fluxo.setEstado(0);
    }

    public void setPausa() {
        this.fluxo.setPausa();
    }

    public void setPausa(int tempo_milissegundos) {
        this.fluxo.setPausa(tempo_milissegundos);
    }

    public void setTX(int tempo_milissegundos) {
        try {
            if (this.fluxo != null) {
                this.fluxo.setEstado(1, tempo_milissegundos);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setRX(int tempo_milissegundos) {
        this.fluxo.setEstado(2, tempo_milissegundos);
    }

    public void interromperTimer() {
        this.fluxo.interromperTimer();
    }

    public void enviadoIdle() {
        this.setIdle();
    }

    public void enviadoRX(int tempo) {
        this.setRX(tempo);
    }

    public void enviadoTX(int tempo) {
        this.setTX(tempo);
    }

    public String getIntCodigo(String fil_codigo, String req_codigo, String rec_codigo, String exame) throws SQLException {
        ArrayList<String> exames;
        List<String> interfaces = this.getInterfaceEstacao();
        if (interfaces != null && interfaces.size() == 1) {
            return interfaces.get(0);
        }
        String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, exame, 1, true);
        if (int_codigo == null) {
            exames = BDUtil.getIntDesmExamesPai(fil_codigo, req_codigo, rec_codigo, exame);
            for (String s : exames) {
                int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, s, 1, false);
                if (int_codigo == null) continue;
                return int_codigo;
            }
        }
        if (int_codigo == null && (int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, exame, 0, true)) == null) {
            exames = BDUtil.getIntDesmExamesPai(fil_codigo, req_codigo, rec_codigo, exame);
            for (String s : exames) {
                int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, s, 0, false);
                if (int_codigo == null) continue;
                return int_codigo;
            }
        }
        if (int_codigo == null && ParametrosGerais.getTipoExportacaoInterface().equals("P")) {
            int_codigo = BDUtil.getInterfaceExameAlternativo(fil_codigo, req_codigo, rec_codigo, exame);
            if (int_codigo == null) {
                String requisicao;
                ArrayList<String> requisicoes = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
                requisicoes.remove(String.valueOf(Integer.parseInt(req_codigo)));
                Iterator<String> iterator = requisicoes.iterator();
                while (iterator.hasNext() && (int_codigo = BDUtil.getInterfaceExameAlternativo(fil_codigo, requisicao = iterator.next(), rec_codigo, exame)) == null) {
                    String s;
                    if (!ParametrosGerais.isAgruparGuiasInterface()) continue;
                    ArrayList<String> exames2 = BDUtil.getIntDesmExamesPai(fil_codigo, requisicao, rec_codigo, exame);
                    Iterator<String> iterator2 = exames2.iterator();
                    while (iterator2.hasNext() && (int_codigo = BDUtil.getInterfaceExameTuboRequisicao(fil_codigo, requisicao, rec_codigo, s = iterator2.next())) == null) {
                    }
                    if (int_codigo == null) continue;
                    break;
                }
            }
        } else if (int_codigo == null) {
            int_codigo = this.getIntCodigoAlternativo(fil_codigo, req_codigo, rec_codigo, exame);
        }
        if (int_codigo == null && (int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, exame, 2, true)) == null) {
            exames = BDUtil.getIntDesmExamesPai(fil_codigo, req_codigo, rec_codigo, exame);
            for (String s : exames) {
                int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, s, 2, false);
                if (int_codigo == null) continue;
                return int_codigo;
            }
        }
        if (int_codigo == null && (int_codigo = this.getIntCodigoCurva(fil_codigo, req_codigo, rec_codigo, 1)) == null && (int_codigo = this.getIntCodigoCurva(fil_codigo, req_codigo, rec_codigo, 0)) == null) {
            int_codigo = this.getIntCodigoCurva(fil_codigo, req_codigo, rec_codigo, 2);
        }
        return int_codigo;
    }

    private List<String> getInterfaceEstacao() {
        int numEqpEstacao = this.getAba(0).getConfiguracoesPorta().size();
        if (numEqpEstacao == 1) {
            List<String> naoEnviados = this.getInterfaceEstacao(0);
            List<String> pendentes = this.getInterfaceEstacao(1);
            List<String> prontos = this.getInterfaceEstacao(2);
            if (naoEnviados.size() <= 1 && pendentes.size() <= 1 && prontos.size() <= 1) {
                if (naoEnviados.size() == 1 && pendentes.size() == 1 && prontos.size() == 1 && pendentes.get(0).equals(naoEnviados.get(0)) && prontos.get(0).equals(naoEnviados.get(0))) {
                    return naoEnviados;
                }
                if (pendentes.size() == 1 && prontos.size() == 1 && prontos.get(0).equals(pendentes.get(0))) {
                    return pendentes;
                }
                if (prontos.size() == 1) {
                    return prontos;
                }
            }
        }
        return null;
    }

    private List<String> getInterfaceEstacao(int abaSelecionada) {
        ArrayList<String> interfaces = new ArrayList<String>();
        ArrayList exames = this.getExamesAba(abaSelecionada);
        PanelAbaAbstrata aba = this.getAba(abaSelecionada);
        for (int i = 0; i < exames.size(); ++i) {
            Object[] req = (Object[])exames.get(i);
            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
            String codInterface = (String)req[aba.getColIndice("Interface")];
            if (interfaces.contains(codInterface)) continue;
            interfaces.add(codInterface);
        }
        return interfaces;
    }

    private String getIntCodigoAlternativo(String fil_codigo, String req_codigo, String rec_codigo, String emi_alternativo) throws SQLException {
        Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
        PanelAbaAbstrata aba = this.getAba(0);
        if (req != null) {
            String exame = (String)req[aba.getColIndice("Exame")];
            String mco_codigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
            String int_codigo = (String)req[aba.getColIndice("Interface")];
            String[] exames = new String[]{exame};
            if (exame.contains(" ")) {
                exames = exame.split(" ");
            }
            for (String ex : exames) {
                ExameMaterial exameLis = BDUtil.getExamesLIS(fil_codigo, req_codigo, rec_codigo, int_codigo, emi_alternativo);
                if (exameLis == null || !exameLis.getNomeExame().equals(ex) || !exameLis.getCodigoMaterial().equals(mco_codigo)) continue;
                return int_codigo;
            }
        }
        return null;
    }

    public String getIntCodigo(String fil_codigo, String req_codigo, String rec_codigo, String exa_codigo, String mco_codigo) throws SQLException {
        String int_codigo;
        int abaPrimeira = 1;
        int abaSegunda = 0;
        boolean todasInterfaces = ParametrosGerais.getTipoExportacaoInterface().equals("T");
        if (todasInterfaces) {
            abaPrimeira = 0;
            abaSegunda = 1;
        }
        if ((int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, abaPrimeira)) == null && (int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, abaSegunda)) == null) {
            int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, 2);
        }
        if (int_codigo == null && !todasInterfaces) {
            int_codigo = BDUtil.getInterfaceExameTuboRequisicao(fil_codigo, req_codigo, rec_codigo, exa_codigo);
        }
        return int_codigo;
    }

    public ExameMaterial getReqExameLIS(String fil_codigo, String int_codigo, String req_codigo, String rec_codigo, String emi_alternativo) throws SQLException {
        if (int_codigo == null) {
            List<String> interfaces = this.getTodasInterfaces();
            for (String intCodigo : interfaces) {
                ExameMaterial exame = this.getReqExameLis(fil_codigo, intCodigo, req_codigo, rec_codigo, emi_alternativo);
                if (exame == null) continue;
                return exame;
            }
            return null;
        }
        return this.getReqExameLis(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
    }

    private List<String> getTodasInterfaces() {
        List<String> interfaces = this.getInterfaceEstacao(0);
        List<String> pendentes = this.getInterfaceEstacao(1);
        List<String> prontos = this.getInterfaceEstacao(2);
        for (String intCodigo : pendentes) {
            if (interfaces.contains(intCodigo)) continue;
            interfaces.add(intCodigo);
        }
        for (String intCodigo : prontos) {
            if (interfaces.contains(intCodigo)) continue;
            interfaces.add(intCodigo);
        }
        return interfaces;
    }

    private ExameMaterial getReqExameLis(String fil_codigo, String int_codigo, String req_codigo, String rec_codigo, String emi_alternativo) throws SQLException {
        ExameMaterial exame;
        block7: {
            String requisicao;
            Iterator<Object> iterator;
            ArrayList<String> requisicoes;
            exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo, 1);
            if (exame == null && (exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo, 0)) == null) {
                exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo, 2);
            }
            if (exame == null) {
                exame = BDUtil.getReqExameFilhoLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
            }
            if (exame == null && ParametrosGerais.isAgruparGuiasInterface()) {
                String req;
                requisicoes = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
                iterator = requisicoes.iterator();
                while (iterator.hasNext() && (exame = BDUtil.getReqExameFilhoLIS(fil_codigo, int_codigo, req = (String)iterator.next(), rec_codigo, emi_alternativo)) == null) {
                }
            }
            if (!Funcoes.isNumeric(int_codigo)) {
                int_codigo = BDUtil.getInterfaceExameAlternativo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
            }
            if (exame == null && Funcoes.isNumeric(int_codigo)) {
                exame = BDUtil.getExamesLIS(fil_codigo, req_codigo, rec_codigo, int_codigo, emi_alternativo);
            }
            if (exame != null || !Funcoes.isNumeric(int_codigo) || !ParametrosGerais.isAgruparGuiasInterface()) break block7;
            requisicoes = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
            requisicoes.remove(String.valueOf(Integer.parseInt(req_codigo)));
            iterator = requisicoes.iterator();
            while (iterator.hasNext() && (exame = BDUtil.getExamesLIS(fil_codigo, requisicao = (String)iterator.next(), rec_codigo, int_codigo, emi_alternativo)) == null) {
            }
        }
        return exame;
    }

    protected String getIntCodigo(String fil_codigo, String req_codigo, String rec_codigo, String exa_codigo, String mco_codigo, int abaSelecionada) {
        ArrayList exames = this.getExamesAba(abaSelecionada);
        PanelAbaAbstrata aba = this.getAba(abaSelecionada);
        for (int i = 0; i < exames.size(); ++i) {
            Object[] req = (Object[])exames.get(i);
            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                requisicao = (String)req[aba.getColIndice("Multiguia")];
            }
            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
            String tubo = Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboTubo());
            String tuboLocalizar = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            String exame = (String)req[aba.getColIndice("Exame")];
            String material = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
            if (!fil_codigo.equalsIgnoreCase(filial) || !req_codigo.equalsIgnoreCase(requisicao) || !tuboLocalizar.equalsIgnoreCase(tubo) || exame.indexOf(exa_codigo) < 0 || !mco_codigo.equalsIgnoreCase(material)) continue;
            return (String)req[aba.getColIndice("Interface")];
        }
        return null;
    }

    protected String getIntCodigo(String fil_codigo, String req_codigo, String rec_codigo, String exame, int abaSelecionada, boolean alternativo) {
        ArrayList exames = this.getExamesAba(abaSelecionada);
        PanelAbaAbstrata aba = this.getAba(abaSelecionada);
        for (int i = 0; i < exames.size(); ++i) {
            Object[] req = (Object[])exames.get(i);
            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                requisicao = (String)req[aba.getColIndice("Multiguia")];
            }
            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
            String tubo = (String)req[aba.getColIndice("Tubo")];
            tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
            String exa = (String)req[aba.getColIndice("Exame")];
            if (abaSelecionada != 0 && alternativo || exa.trim().indexOf(" ") == -1) {
                String tmp = (String)req[aba.getColIndice("Alternativo")];
                if (exa.trim().indexOf(" ") == -1 && !Funcoes.textoVazio(tmp)) {
                    exa = tmp;
                }
            }
            int col = aba.getColIndice("Cod. Apoiado");
            String codigoAp = "";
            String codigoApoiado = String.format("%s%s%s", fil_codigo, req_codigo, rec_codigo);
            boolean apoiado = false;
            if (col != -1 && !Funcoes.textoVazio(codigoAp = (String)req[col])) {
                apoiado = codigoAp.equals(codigoApoiado);
            }
            if ((Funcoes.textoVazio(fil_codigo) || Funcoes.textoVazio(filial) || Funcoes.textoVazio(req_codigo) || Funcoes.textoVazio(requisicao) || Funcoes.textoVazio(rec_codigo) || Funcoes.textoVazio(tubo) || Funcoes.textoVazio(exame) || Funcoes.textoVazio(exa) || !fil_codigo.equalsIgnoreCase(filial) || !req_codigo.equalsIgnoreCase(requisicao) || !rec_codigo.equalsIgnoreCase(tubo)) && !apoiado || !exame.equalsIgnoreCase(exa)) continue;
            return (String)req[aba.getColIndice("Interface")];
        }
        return null;
    }

    protected String getIntCodigoCurva(String fil_codigo, String req_codigo, String rec_kodigo, int abaSelecionada) {
        ArrayList exames = this.getExamesAba(abaSelecionada);
        PanelAbaAbstrata aba = this.getAba(abaSelecionada);
        for (int i = 0; i < exames.size(); ++i) {
            Object[] req = (Object[])exames.get(i);
            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                requisicao = (String)req[aba.getColIndice("Multiguia")];
            }
            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
            ArrayList tubos = (ArrayList)req[aba.getColIndice("Tubos Filhos")];
            if (tubos == null) continue;
            for (String tubo : tubos) {
                if (Funcoes.textoVazio(tubo)) continue;
                tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
                if (Funcoes.textoVazio(fil_codigo) || Funcoes.textoVazio(filial) || Funcoes.textoVazio(req_codigo) || Funcoes.textoVazio(requisicao) || Funcoes.textoVazio(rec_kodigo) || Funcoes.textoVazio(tubo) || !fil_codigo.equalsIgnoreCase(filial) || !req_codigo.equalsIgnoreCase(requisicao) || !rec_kodigo.equalsIgnoreCase(tubo)) continue;
                return (String)req[aba.getColIndice("Interface")];
            }
        }
        return null;
    }

    protected ExameMaterial getReqExameLIS(String fil_codigo, String int_codigo, String req_codigo, String rec_codigo, String emi_alternativo, int abaSelecionada) {
        ArrayList exames = this.getExamesAba(abaSelecionada);
        PanelAbaAbstrata aba = this.getAba(abaSelecionada);
        for (int i = 0; i < exames.size(); ++i) {
            Object[] req = (Object[])exames.get(i);
            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                requisicao = (String)req[aba.getColIndice("Multiguia")];
            }
            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
            String tubo = (String)req[aba.getColIndice("Tubo")];
            tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
            String alternativo = (String)req[aba.getColIndice("Alternativo")];
            String equip = (String)req[aba.getColIndice("Interface")];
            String exame = (String)req[aba.getColIndice("Exame")];
            int col = aba.getColIndice("Cod. Apoiado");
            String codigoAp = "";
            String codigoApoiado = String.format("%s%s%s", fil_codigo, req_codigo, rec_codigo);
            boolean apoiado = false;
            if (col != -1 && !Funcoes.textoVazio(codigoAp = (String)req[col])) {
                apoiado = codigoAp.equals(codigoApoiado);
            }
            if ((Funcoes.textoVazio(fil_codigo) || Funcoes.textoVazio(filial) || Funcoes.textoVazio(req_codigo) || Funcoes.textoVazio(requisicao) || Funcoes.textoVazio(rec_codigo) || Funcoes.textoVazio(tubo) || Funcoes.textoVazio(emi_alternativo) || Funcoes.textoVazio(alternativo) || Funcoes.textoVazio(int_codigo) || Funcoes.textoVazio(equip) || !fil_codigo.equalsIgnoreCase(filial) || !req_codigo.equalsIgnoreCase(requisicao) || !rec_codigo.equalsIgnoreCase(tubo)) && !apoiado || !emi_alternativo.equalsIgnoreCase(alternativo) || !int_codigo.equalsIgnoreCase(equip) || exame.indexOf(" ") != -1) continue;
            String material = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
            return new ExameMaterial(exame, Integer.parseInt(material));
        }
        return null;
    }

    protected String getRecCodigo(String fil_codigo, String req_codigo, String emi_alternativo) {
        String rec_codigo = this.getRecCodigo(fil_codigo, req_codigo, emi_alternativo, 1);
        if (rec_codigo == null && (rec_codigo = this.getRecCodigo(fil_codigo, req_codigo, emi_alternativo, 0)) == null) {
            req_codigo = this.getRecCodigo(fil_codigo, req_codigo, emi_alternativo, 2);
        }
        return rec_codigo;
    }

    private String getRecCodigo(String fil_codigo, String req_codigo, String emi_alternativo, int abaSelecionada) {
        ArrayList exames = this.getExamesAba(abaSelecionada);
        PanelAbaAbstrata aba = this.getAba(abaSelecionada);
        for (int i = 0; i < exames.size(); ++i) {
            Object[] req = (Object[])exames.get(i);
            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                requisicao = (String)req[aba.getColIndice("Multiguia")];
            }
            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
            String alternativo = (String)req[aba.getColIndice("Alternativo")];
            if (!fil_codigo.equalsIgnoreCase(filial) || !req_codigo.equalsIgnoreCase(requisicao) || !emi_alternativo.equalsIgnoreCase(alternativo)) continue;
            return (String)req[aba.getColIndice("Tubo")];
        }
        return null;
    }

    protected String getRequisicaoRack(String rack, String requisicao) {
        String req = this.getRequisicaoRack(rack, requisicao, 1);
        if (req == null) {
            req = this.getRequisicaoRack(rack, requisicao, 0);
        }
        if (req == null) {
            req = this.getRequisicaoRack(rack, requisicao, 2);
        }
        return req;
    }

    private String getRequisicaoRack(String rack, String requisicao, int abaSelecionada) {
        ArrayList exames = this.getExamesAba(abaSelecionada);
        PanelAbaAbstrata aba = this.getAba(abaSelecionada);
        for (int i = 0; i < exames.size(); ++i) {
            Object[] linha = (Object[])exames.get(i);
            String rackPosition = (String)linha[aba.getColIndice("Rack")];
            String req = (String)linha[aba.getColIndice("C\u00f3digo")];
            if (Funcoes.textoVazio(req)) {
                req = (String)linha[aba.getColIndice("Multiguia")];
            }
            if (Funcoes.textoVazio(rackPosition) || !rackPosition.equalsIgnoreCase(rack) || Funcoes.textoVazio(requisicao) || !req.equalsIgnoreCase(requisicao)) continue;
            String tubo = (String)linha[aba.getColIndice("Tubo")];
            req = req + StringUtil.preencheString(tubo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            return req;
        }
        return null;
    }

    public String getRequisicaoRack(String rack) {
        String req = this.getRequisicaoRack(rack, 1);
        if (req == null) {
            req = this.getRequisicaoRack(rack, 0);
        }
        if (req == null) {
            req = this.getRequisicaoRack(rack, 2);
        }
        return req;
    }

    private String getRequisicaoRack(String rack, int abaSelecionada) {
        ArrayList exames = this.getExamesAba(abaSelecionada);
        PanelAbaAbstrata aba = this.getAba(abaSelecionada);
        for (int i = 0; i < exames.size(); ++i) {
            Object[] linha = (Object[])exames.get(i);
            String rackPosition = (String)linha[aba.getColIndice("Rack")];
            String req = (String)linha[aba.getColIndice("C\u00f3digo")];
            if (Funcoes.textoVazio(rackPosition) || !rackPosition.equalsIgnoreCase(rack)) continue;
            String tubo = (String)linha[aba.getColIndice("Tubo")];
            req = req + StringUtil.preencheString(tubo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            return req;
        }
        return null;
    }

    protected String getIntRack(String rack) {
        String int_codigo = this.getIntRack(rack, 1);
        if (int_codigo == null) {
            int_codigo = this.getIntRack(rack, 0);
        }
        if (int_codigo == null) {
            int_codigo = this.getIntRack(rack, 2);
        }
        return int_codigo;
    }

    private String getIntRack(String rack, int abaSelecionada) {
        ArrayList exames = this.getExamesAba(abaSelecionada);
        PanelAbaAbstrata aba = this.getAba(abaSelecionada);
        for (int i = 0; i < exames.size(); ++i) {
            Object[] req = (Object[])exames.get(i);
            String rackPosition = (String)req[aba.getColIndice("Rack")];
            if (Funcoes.textoVazio(rackPosition) || !rackPosition.equalsIgnoreCase(rack)) continue;
            return (String)req[aba.getColIndice("Interface")];
        }
        return null;
    }

    protected String getExamesRack(String rack) {
        String examesEnviados = this.getExamesRack(rack, 1);
        if (examesEnviados == null || examesEnviados.trim().length() == 0) {
            examesEnviados = this.getExamesRack(rack, 0);
        }
        return examesEnviados;
    }

    private String getExamesRack(String rack, int abaSelecionada) {
        ArrayList exames = this.getExamesAba(abaSelecionada);
        PanelAbaAbstrata aba = this.getAba(abaSelecionada);
        String examesEnviados = "";
        for (int i = 0; i < exames.size(); ++i) {
            Object[] req = (Object[])exames.get(i);
            String rackPosition = (String)req[aba.getColIndice("Rack")];
            if (Funcoes.textoVazio(rackPosition) || !rackPosition.equalsIgnoreCase(rack)) continue;
            examesEnviados = examesEnviados + (String)req[aba.getColIndice("Exame")] + " ";
        }
        return examesEnviados;
    }

    protected ArrayList getExamesAba(int abaSelecionada) {
        ArrayList exames = null;
        PanelAbaAbstrata aba = this.getAba(abaSelecionada);
        switch (abaSelecionada) {
            case 0: {
                exames = ((AbaDefaultNaoEnviados)aba).getExames();
                if (exames != null && exames.size() != 0) break;
                aba.reloadExames();
                exames = ((AbaDefaultNaoEnviados)aba).getExames();
                break;
            }
            case 1: {
                exames = ((AbaDefaultPendentes)aba).getExames();
                if (exames != null && exames.size() != 0) break;
                aba.reloadExames();
                exames = ((AbaDefaultPendentes)aba).getExames();
                break;
            }
            case 2: {
                exames = ((AbaDefaultProntos)aba).getExames();
                if (exames != null && exames.size() != 0) break;
                aba.reloadExames();
                exames = ((AbaDefaultProntos)aba).getExames();
            }
        }
        if (exames == null) {
            return new ArrayList();
        }
        return exames;
    }

    protected PanelAbaAbstrata getAba(int abaSelecionada) {
        switch (abaSelecionada) {
            case 0: {
                return this.equipamento.getAbaNaoEnviados();
            }
            case 1: {
                return this.equipamento.getAbaPendentes();
            }
            case 2: {
                return this.equipamento.getAbaProntos();
            }
        }
        return null;
    }

    protected String parseMessage(String message) {
        return this.equipamento.parseMessage(message);
    }

    public int getAbaSelecionada() {
        PanelAbaAbstrata aba = this.equipamento.getSelectedTab();
        if (aba instanceof AbaDefaultProntos) {
            return 2;
        }
        if (aba instanceof AbaDefaultNaoEnviados) {
            return 0;
        }
        if (aba instanceof AbaDefaultPendentes) {
            return 1;
        }
        return -1;
    }

    public Object[] getRequisicaoAba(String fil_codigo, String req_codigo, String rec_codigo) throws SQLException {
        Object[] requisicao = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
        if (requisicao == null && (requisicao = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0)) == null) {
            requisicao = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
        }
        return requisicao;
    }

    public Object[] getRequisicaoAba(String fil_codigo, String req_codigo, String rec_codigo, int abaSelecionada) {
        return this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, abaSelecionada, false);
    }

    public Object[] getRequisicaoAba(String fil_codigo, String req_codigo, String rec_codigo, int abaSelecionada, boolean isSomenteRepeticao) {
        return this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, abaSelecionada, isSomenteRepeticao, true);
    }

    public Object[] getRequisicaoAba(String fil_codigo, String req_codigo, String rec_codigo, int abaSelecionada, boolean isSomenteRepeticao, boolean isMultiguia) {
        ArrayList exames = this.getExamesAba(abaSelecionada);
        PanelAbaAbstrata aba = this.getAba(abaSelecionada);
        if (Funcoes.textoVazio(fil_codigo) || Funcoes.textoVazio(req_codigo) || Funcoes.textoVazio(rec_codigo)) {
            return null;
        }
        for (int i = 0; i < exames.size(); ++i) {
            Object[] req = (Object[])exames.get(i);
            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                requisicao = (String)req[aba.getColIndice("Multiguia")];
            }
            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
            String tubo = (String)req[aba.getColIndice("Tubo")];
            tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
            int col = aba.getColIndice("Cod. Apoiado");
            String codigoAp = "";
            if (col > -1) {
                codigoAp = (String)req[col];
            }
            String codigoApoiado = String.format("%s%s%s", fil_codigo, req_codigo, rec_codigo);
            boolean apoiado = false;
            if (!Funcoes.textoVazio(codigoAp) && codigoApoiado.equals(codigoAp)) {
                apoiado = true;
            }
            if (fil_codigo.equalsIgnoreCase(filial) && req_codigo.equalsIgnoreCase(requisicao) && rec_codigo.equalsIgnoreCase(tubo) || apoiado) {
                if (isSomenteRepeticao) {
                    boolean isRepetir;
                    String situacao = (String)req[aba.getColIndice("Sit")];
                    boolean bl = isRepetir = Integer.parseInt(situacao) == 3 || Integer.parseInt(situacao) == 5;
                    if (!isRepetir) continue;
                }
                return req;
            }
            ArrayList tubos = (ArrayList)req[aba.getColIndice("Tubos Filhos")];
            if (tubos == null) continue;
            for (String t : tubos) {
                if (Funcoes.textoVazio(t)) continue;
                t = Funcoes.preencheZero(t, ParametrosGerais.getDigitosTuboTubo());
                if (!fil_codigo.equalsIgnoreCase(filial) || !req_codigo.equalsIgnoreCase(requisicao) || !rec_codigo.equalsIgnoreCase(t)) continue;
                if (isSomenteRepeticao) {
                    boolean isRepetir;
                    String situacao = (String)req[aba.getColIndice("Sit")];
                    boolean bl = isRepetir = Integer.parseInt(situacao) == 3 || Integer.parseInt(situacao) == 5;
                    if (!isRepetir) continue;
                }
                return req;
            }
        }
        if (isMultiguia && ParametrosGerais.isAgruparGuiasInterface()) {
            ArrayList<String> guias = null;
            if (Funcoes.isNumeric(fil_codigo) && Funcoes.isNumeric(req_codigo)) {
                try {
                    guias = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                }
                if (guias != null) {
                    for (String guia : guias) {
                        Object[] req;
                        if (Integer.parseInt(guia) == Integer.parseInt(req_codigo) || (req = this.getRequisicaoAba(fil_codigo, Funcoes.preencheZero(guia, ParametrosGerais.getDigitosTuboRequisicao()), rec_codigo, abaSelecionada, isSomenteRepeticao, false)) == null) continue;
                        return req;
                    }
                }
            } else {
                this.fireExcecaoEncontrada("Entrada n\u00e3o esperada, a requisi\u00e7\u00e3o tem ser do tipo numerico." + fil_codigo + " " + req_codigo + " " + rec_codigo);
                return null;
            }
        }
        return null;
    }

    public List<Object[]> getTodasRequisicaoAba(String fil_codigo, String req_codigo, String rec_codigo, int abaSelecionada) {
        ArrayList exames = this.getExamesAba(abaSelecionada);
        PanelAbaAbstrata aba = this.getAba(abaSelecionada);
        ArrayList<Object[]> requisicoesEncontradas = new ArrayList<Object[]>();
        for (int i = 0; i < exames.size(); ++i) {
            Object[] req = (Object[])exames.get(i);
            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                requisicao = (String)req[aba.getColIndice("Multiguia")];
            }
            int col = aba.getColIndice("Cod. Apoiado");
            String codigoAp = "";
            if (col > -1) {
                codigoAp = (String)req[col];
            }
            String codigoApoiado = String.format("%s%s%s", fil_codigo, req_codigo, rec_codigo);
            boolean apoiado = false;
            if (!Funcoes.textoVazio(codigoAp) && codigoApoiado.equals(codigoAp)) {
                apoiado = true;
            }
            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
            String tubo = Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboTubo());
            String tuboLocalizar = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            if ((!fil_codigo.equalsIgnoreCase(filial) || !req_codigo.equalsIgnoreCase(requisicao) || !tuboLocalizar.equalsIgnoreCase(tubo)) && !apoiado) continue;
            requisicoesEncontradas.add(req);
        }
        return requisicoesEncontradas;
    }

    public String arrendondaValor(String resultado, String fil_codigo, String exa_codigo, String mco_codigo, String int_codigo) {
        int casas = -1;
        try {
            casas = BDUtil.getCasasDecimaisResultado(fil_codigo, exa_codigo, mco_codigo, int_codigo);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        if (casas < 0) {
            return resultado;
        }
        BigDecimal b = new BigDecimal(Double.valueOf(resultado)).setScale(casas, RoundingMode.HALF_UP);
        return b.toString();
    }

    public String arrendondaValor(String resultado, String fil_codigo, String exa_codigo, String mco_codigo, String int_codigo, String req_codigo) {
        if (Funcoes.textoVazio(int_codigo)) {
            this.fireExcecaoEncontrada("Erro ao buscar arredondamento do valor do resultado para a filial: " + fil_codigo + ", requisicao: " + req_codigo + ", exame: " + exa_codigo + ", material: " + mco_codigo);
            return new BigDecimal(Double.valueOf(resultado)).setScale(2, RoundingMode.HALF_UP).toString();
        }
        return this.arrendondaValor(resultado, fil_codigo, exa_codigo, mco_codigo, int_codigo);
    }

    public void addTravaFechamento(TravaFechamento trava) {
        this.equipamento.botao_fechar.addTravaFechamento(trava);
    }

    public void removeTravaFechamento(TravaFechamento trava) {
        this.equipamento.botao_fechar.removeTravaFechamento(trava);
    }

    protected void encerrar() {
    }

    public int getExameSituacao(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo) throws SQLException {
        if (int_codigo == null) {
            List<String> interfaces = this.getTodasInterfaces();
            for (String intCodigo : interfaces) {
                int situacao = this.getExameSituacao(fil_codigo, intCodigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
                if (situacao <= -1) continue;
                return situacao;
            }
        } else {
            return this.getExameSituacao(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
        }
        return -1;
    }

    private int getExameSituacao(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo) throws SQLException {
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            ArrayList<String> requisicoes = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
            ExameMaterial[] examesPai = null;
            int situacaoFilho = -1;
            for (String req : requisicoes) {
                if (BDUtil.existeExame(fil_codigo, int_codigo, req, exa_codigo, mco_codigo, rec_codigo)) {
                    return BDUtil.getExmSituacao(fil_codigo, int_codigo, req, exa_codigo, mco_codigo, rec_codigo);
                }
                if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exa_codigo, mco_codigo)) continue;
                for (ExameMaterial exameMaterialPai : examesPai = BDUtil.getDesmExamesPai(fil_codigo, int_codigo, req, rec_codigo, exa_codigo, mco_codigo)) {
                    situacaoFilho = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req, exameMaterialPai.getNomeExame(), exameMaterialPai.getCodigoMaterial(), rec_codigo, exa_codigo, mco_codigo);
                    if (situacaoFilho <= -1) continue;
                    return situacaoFilho;
                }
            }
            if (situacaoFilho == -1) {
                situacaoFilho = BDUtil.getExmSituacao(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
            }
            if (situacaoFilho == -1 && examesPai != null) {
                for (Iterator iterator : examesPai) {
                    situacaoFilho = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, ((ExameMaterial)((Object)iterator)).getNomeExame(), mco_codigo, rec_codigo, exa_codigo, mco_codigo);
                    if (situacaoFilho <= -1) continue;
                    return situacaoFilho;
                }
            }
            return situacaoFilho;
        }
        if (!BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exa_codigo, mco_codigo)) {
            ExameMaterial[] examesPai = BDUtil.getDesmExamesPai(fil_codigo, int_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo);
            int situacaoFilho = -1;
            for (ExameMaterial exameMaterialPai : examesPai) {
                situacaoFilho = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, exameMaterialPai.getNomeExame(), exameMaterialPai.getCodigoMaterial(), rec_codigo, exa_codigo, mco_codigo);
                if (situacaoFilho <= -1) continue;
                return situacaoFilho;
            }
            if (situacaoFilho == -1) {
                situacaoFilho = BDUtil.getExmSituacao(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
            }
            return situacaoFilho;
        }
        return BDUtil.getExmSituacao(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
    }

    public void atualizarSituacaoExame(Statement st, String fil_codigo, String req_codigo, String rec_codigo, String exa_codigo, String mco_codigo, String int_codigo, String rack, int situacao, boolean curva) throws SQLException {
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            ArrayList<String> requisicoes = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
            ExameMaterial exa = ExamesUtil.anexarCodigoMaterial(exa_codigo.split(" ", 0), mco_codigo)[0];
            for (String req : requisicoes) {
                ExameMaterial[] exaMat;
                if (BDUtil.existeDesmembramento(fil_codigo, int_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo) || curva) {
                    this.atualizaSitExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, rack, situacao, req);
                    this.atualizaSituacaoDesmembrado(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, rack, situacao, req);
                    continue;
                }
                if (BDUtil.existeExame(fil_codigo, int_codigo, req, exa.getNomeExame(), mco_codigo, rec_codigo)) {
                    this.atualizaSitExame(st, fil_codigo, req, rec_codigo, exa_codigo, mco_codigo, int_codigo, rack, situacao, req);
                    continue;
                }
                if (!BDUtil.existeDesmembramento(fil_codigo, int_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, true) || (exaMat = BDUtil.getExameMaterialRecipiente(fil_codigo, req_codigo, rec_codigo, int_codigo)) == null || exaMat.length != 1) continue;
                this.atualizaSituacaoDesmembrado(st, fil_codigo, req_codigo, rec_codigo, exaMat[0].getNomeExame(), exaMat[0].getCodigoMaterial(), int_codigo, rack, situacao, req);
            }
        } else {
            this.atualizaSitExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, rack, situacao, req_codigo);
            if (BDUtil.existeDesmembramento(fil_codigo, int_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo)) {
                this.atualizaSituacaoDesmembrado(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, rack, situacao, req_codigo);
            }
        }
    }

    private void atualizaSituacaoDesmembrado(Statement st, String fil_codigo, String req_codigo, String rec_codigo, String exa_codigo, String mco_codigo, String int_codigo, String rack, int situacao, String req) throws SQLException {
        ExameMaterial[] exaPai = BDUtil.getDesmExamesPai(fil_codigo, int_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo);
        String exPai = null;
        String exMcoPai = null;
        for (ExameMaterial e : exaPai) {
            exPai = e.getNomeExame();
            exMcoPai = e.getCodigoMaterial();
            BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), exa_codigo, mco_codigo, rec_codigo, situacao);
        }
        if (!Funcoes.textoVazio(exPai) && !Funcoes.textoVazio(exMcoPai)) {
            if (BDUtil.existeExame(fil_codigo, int_codigo, req, exPai, exMcoPai, rec_codigo)) {
                this.atualizaSitExame(st, fil_codigo, req_codigo, rec_codigo, exPai, exMcoPai, int_codigo, rack, situacao, req_codigo);
            } else if (BDUtil.isExameCurva(fil_codigo, int_codigo, exPai, exMcoPai)) {
                String tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, exPai, exMcoPai);
                BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, exPai, exMcoPai, exa_codigo, mco_codigo, tuboPai, situacao);
                if (tuboPai != null && BDUtil.isGrupoInteiroPendente(fil_codigo, int_codigo, req_codigo, exPai, exMcoPai, tuboPai)) {
                    this.atualizaSitExame(st, fil_codigo, req_codigo, tuboPai, exPai, exMcoPai, int_codigo, rack, situacao, req_codigo);
                }
            }
        }
    }

    public void atualizarSituacaoExame(Statement st, String fil_codigo, String req_codigo, String rec_codigo, String exa_codigo, String mco_codigo, String int_codigo, String rack, int situacao) throws SQLException {
        this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, rack, situacao, false);
    }

    private void atualizaSitExame(Statement st, String fil_codigo, String req_codigo, String rec_codigo, String exa_codigo, String mco_codigo, String int_codigo, String rack, int situacao, String req) throws SQLException {
        if (Funcoes.textoVazio(rack)) {
            BDUtil.setExmSituacao(st, fil_codigo, int_codigo, req, exa_codigo, mco_codigo, rec_codigo, situacao);
        } else {
            BDUtil.setExmSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, situacao, rack);
        }
    }

    public void atualizarSituacaoTubo(Statement st, String fil_codigo, String req_codigo, String rec_codigo, String mco_codigo, String int_codigo, int situacao) throws SQLException {
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            ArrayList<String> requisicoes = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
            for (String req : requisicoes) {
                BDUtil.setExmSituacaoTubo(st, fil_codigo, int_codigo, req, mco_codigo, rec_codigo, situacao);
            }
        } else {
            BDUtil.setExmSituacaoTubo(st, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, situacao);
        }
    }

    public void atualizarSituacaoRackTubo(Statement st, String fil_codigo, String req_codigo, String rec_codigo, String mco_codigo, String int_codigo, int situacao, String ier_rackpost) throws SQLException {
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            ArrayList<String> requisicoes = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
            for (String req : requisicoes) {
                BDUtil.setExmSituacaoRackTubo(st, fil_codigo, int_codigo, req, mco_codigo, rec_codigo, situacao, ier_rackpost);
            }
        } else {
            BDUtil.setExmSituacaoRackTubo(st, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, situacao, ier_rackpost);
        }
    }

    public void atualizarResultadoExame(Statement st, String fil_codigo, String req_codigo, String rec_codigo, String exa_codigo, String mco_codigo, String int_codigo, String resultado) throws Exception {
        this.atualizarResultadoExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, resultado, true);
    }

    public void atualizarResultadoExame(Statement st, String fil_codigo, String req_codigo, String rec_codigo, String exa_codigo, String mco_codigo, String int_codigo, String resultado, boolean validarLiberado) throws Exception {
        ArrayList<Object> requisicoes = new ArrayList<String>();
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            requisicoes = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
        } else {
            requisicoes.add(req_codigo);
        }
        for (String string : requisicoes) {
            this.atualizaExame(st, fil_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, resultado, validarLiberado, string);
        }
    }

    private void atualizaExame(Statement st, String fil_codigo, String rec_codigo, String exa_codigo, String mco_codigo, String int_codigo, String resultado, boolean validarLiberado, String req) throws SQLException, Exception {
        HashMap<String, Object> dados = new HashMap<String, Object>();
        int sit = this.getExameSituacao(st, fil_codigo, int_codigo, req, exa_codigo, mco_codigo, rec_codigo);
        String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
        dados.put(campo, resultado);
        ResolvedorResultado.salvaDados(st, fil_codigo, int_codigo, req, exa_codigo, mco_codigo, rec_codigo, null, null, dados, validarLiberado, this);
    }

    public void atualizarDadosExame(Statement st, String fil_codigo, String req_codigo, String rec_codigo, String exa_codigo, String mco_codigo, String int_codigo, Map<String, Object> dados) throws Exception {
        this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, dados, null);
    }

    public void atualizarDadosExame(Statement st, String fil_codigo, String req_codigo, String rec_codigo, String exa_codigo, String mco_codigo, String int_codigo, Map<String, Object> dados, List<String> flags) throws Exception {
        this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, dados, flags, true);
    }

    public void atualizarDadosExame(Statement st, String fil_codigo, String req_codigo, String rec_codigo, String exa_codigo, String mco_codigo, String int_codigo, Map<String, Object> dados, List<String> flags, boolean validarLiberado) throws Exception {
        String codigoMetodo = String.valueOf(BDUtil.getExameMetodo(fil_codigo, exa_codigo, mco_codigo, int_codigo));
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            ArrayList<String> requisicoes = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
            for (String req : requisicoes) {
                if (BDUtil.existeDesmembramento(fil_codigo, int_codigo, req, rec_codigo, exa_codigo, mco_codigo)) {
                    ExameMaterial[] exaPai;
                    for (ExameMaterial ePai : exaPai = BDUtil.getDesmExamesPai(fil_codigo, int_codigo, req, rec_codigo, exa_codigo, mco_codigo)) {
                        String tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req, rec_codigo, int_codigo, ePai.getNomeExame(), ePai.getCodigoMaterial());
                        ResolvedorResultado.salvaDados(st, fil_codigo, int_codigo, req, exa_codigo, mco_codigo, tuboPai, rec_codigo, null, null, dados, flags, validarLiberado, this);
                    }
                }
                if (!BDUtil.existeExame(fil_codigo, int_codigo, req, exa_codigo, mco_codigo, rec_codigo)) continue;
                ResolvedorResultado.salvaDados(st, fil_codigo, int_codigo, req, exa_codigo, mco_codigo, rec_codigo, null, null, dados, flags, validarLiberado, this);
            }
        } else if (BDUtil.existeDesmembramento(fil_codigo, int_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo)) {
            ExameMaterial[] exaPai;
            for (ExameMaterial ePai : exaPai = BDUtil.getDesmExamesPai(fil_codigo, int_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo)) {
                String tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, ePai.getNomeExame(), ePai.getCodigoMaterial());
                ResolvedorResultado.salvaDados(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, tuboPai, rec_codigo, null, null, dados, flags, validarLiberado, this);
            }
        } else if (BDUtil.existeExame(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo)) {
            ResolvedorResultado.salvaDados(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, null, null, dados, flags, validarLiberado, this);
        }
        Conexao.arquivaSQL();
    }

    public void teste() {
    }

    public ExameMaterial[] getOutrosExames(String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, List<BDExame> exameMesmoMat, ExameMaterial[] exa_lista) throws NumberFormatException, SQLException {
        block5: {
            block4: {
                if (exa_lista.length <= 0 || mco_codigo.equals(exa_lista[0].getCodigoMaterial())) break block4;
                List<Object[]> requisicoes = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
                PanelAbaAbstrata aba = this.getAba(0);
                for (Object[] req : requisicoes) {
                    String mat = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                    String exame = (String)req[aba.getColIndice("Exame")];
                    String tubo = (String)req[aba.getColIndice("Tubo")];
                    for (String ex : exame.split(" ")) {
                        exameMesmoMat.add(new BDExame(req_codigo, ex, mat, tubo));
                    }
                }
                for (BDExame bdExame : exameMesmoMat) {
                    exa_lista = ArraysUtil.concatenar(exa_lista, new ExameMaterial[]{new ExameMaterial(bdExame.getExame(), Integer.parseInt(bdExame.getMaterial()))});
                }
                break block5;
            }
            if (exa_lista.length <= 0) break block5;
            exameMesmoMat.addAll(BDUtil.getDesmExamesFilhos(fil_codigo, int_codigo, req_codigo, exa_lista[0].getCodigoMaterial(), rec_codigo));
            for (BDExame bdExame : exameMesmoMat) {
                exa_lista = ArraysUtil.concatenar(exa_lista, new ExameMaterial[]{new ExameMaterial(bdExame.getExame(), Integer.parseInt(bdExame.getMaterial()))});
            }
        }
        return exa_lista;
    }
}

