/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento;

import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoFactory;
import jalis.laboratorio.interfaceamento.InterfaceamentoConfiguracao;
import jalis.laboratorio.interfaceamento.InterfaceamentoEnvioListener;
import jalis.laboratorio.interfaceamento.InterfaceamentoRecebimentoListener;
import jalis.laboratorio.interfaceamento.LinhaErroAutoEnvio;
import jalis.laboratorio.interfaceamento.abas.AbaExcecoes;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.comunicacao.LogListener;
import jalis.laboratorio.interfaceamento.configuracao.ConfigEquipamento;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.configuracao.TelaAjuda;
import jalis.laboratorio.interfaceamento.status.StatusAutoEnvio;
import jalis.laboratorio.interfaceamento.status.StatusAutoImportador;
import jalis.laboratorio.interfaceamento.status.StatusEstadoComunicacao;
import jalis.laboratorio.interfaceamento.status.StatusFecharInterfaceamento;
import jalis.laboratorio.interfaceamento.status.StatusMensagem;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.Legenda;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public abstract class AbstractInterfaceamento
extends FrmPadrao
implements InterfaceamentoRecebimentoListener {
    public static final ImageIcon imagemInterfaceamentoAberto = ImagemUtils.carregaImagemJalis("interface_14x14.jpg");
    public static final int TEMPO_STATUS_PADRAO = 10000;
    public static final int TEMPO_ALERTA_PADRAO = 5000;
    public static final int RESULTADO_ALTERADO = 1;
    public static final int RESULTADO_NORMAL = 0;
    public static final char NUL = '\u0000';
    public static final char SOH = '\u0001';
    public static final char STX = '\u0002';
    public static final char ETX = '\u0003';
    public static final char EOT = '\u0004';
    public static final char ENQ = '\u0005';
    public static final char ACK = '\u0006';
    public static final char LF = '\n';
    public static final char SB = '\u000b';
    public static final char CR = '\r';
    public static final char DLE = '\u0010';
    public static final char DC1 = '\u0011';
    public static final char NAK = '\u0015';
    public static final char SYN = '\u0016';
    public static final char ETB = '\u0017';
    public static final char CAN = '\u0018';
    public static final char EB = '\u001c';
    public static final char GS = '\u001d';
    public static final char RS = '\u001e';
    public static final char SP = ' ';
    public static final char DEL = '\u007f';
    public static final String LINE = String.valueOf('\r') + String.valueOf('\n');
    public static final char FD = '\u00fd';
    public static final char FS = '\u001c';
    public static final char VT = '\u000b';
    public static final int SIT_NAO_ENVIADO = 0;
    public static final int SIT_PENDENTE = 1;
    public static final int SIT_PRONTO = 2;
    public static final int SIT_REPETINDO = 3;
    public static final int SIT_COM_REPETICAO = 4;
    public static final int SIT_A_REPETIR = 5;
    public static final int SIT_EXCECAO = 6;
    public static final int SIT_PRONTO_VALIDADO = 7;
    public static final int SIT_EXPORTADO = 8;
    public static final int SIT_CANCELADO = 9;
    public static final int SIT_EFETUADO_OUTRO_RECIPIENTE = 10;
    public static final int SIT_EXPORTANDO_WEB = 11;
    public static final int SIT_RECOLETA = 12;
    public static final int SIT_REMOVIDO_MANUAL = 99;
    public static final String ACAO_NOVO = "N";
    public static final String ACAO_ADICIONAR = "A";
    public static final String ACAO_CANCELAR = "C";
    public static final String ACAO_RESULTADO = "R";
    public static final String ACAO_NO_REQUEST = "Q";
    public static final String ACAO_QUERY_RESPONSE = "QR";
    public static final String CODIGO_APOIADO = "codigoApoiado";
    public static final String CODIGO_ETIQUETA = "codigoEtiqueta";
    public static final Color COR_VALORALTERADO = new Color(255, 204, 51);
    public PanelAbaAbstrata examesProntos;
    public PanelAbaAbstrata examesNaoEnviados;
    public PanelAbaAbstrata examesPendentes;
    public AbaExcecoes excecoes;
    protected Icon logo_icon;
    protected JFrame parent;
    protected StatusAutoImportador auto_import;
    protected StatusAutoEnvio auto_envio;
    protected StatusFecharInterfaceamento botao_fechar = new StatusFecharInterfaceamento();
    protected JTabbedPane tabbed_panel = new JTabbedPane();
    protected JPanel panelLegendaStatus = new JPanel(new GridBagLayout());
    protected JPanel panelLegenda = new JPanel(new BorderLayout());
    protected JPanel panelLegendas = new JPanel(new FlowLayout(2));
    protected JPanel panelAtalhos = new JPanel(new FlowLayout(0));
    protected JPanel status_panel = new JPanel(new GridBagLayout());
    protected StatusMensagem status = new StatusMensagem();
    protected JTabbedPane tabbed_log = new JTabbedPane();
    private PopupMenu popupMenu;
    private MenuItem itemLog;
    protected JSplitPane split;
    private static ArrayList<Component> status_bar_components;
    private ArrayList<InterfaceamentoEnvioListener> envio_listeners = new ArrayList();
    public InterfaceamentoConfiguracao configuracao = new InterfaceamentoConfiguracao();
    private ArrayList<LinhaErroAutoEnvio> linhasErro = new ArrayList();
    private Timer timerGravacaoLog = new Timer(600000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractInterfaceamento.this.gravaLog();
        }
    });
    public static String sNUL;
    public static String sSOH;
    public static String sSTX;
    public static String sETX;
    public static String sEOT;
    public static String sENQ;
    public static String sACK;
    public static String sLF;
    public static String sSB;
    public static String sCR;
    public static String sDLE;
    public static String sDC1;
    public static String sNAK;
    public static String sSYN;
    public static String sETB;
    public static String sCAN;
    public static String sEB;
    public static String sSP;
    public static String sDEL;
    public static String sLINE;
    public static String sFD;
    public static String sGS;
    public static String sRS;
    public static String sVT;
    public static String sFS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurar(JFrame parent) {
        try {
            String envioAutomatico;
            this.setLayout(new BorderLayout());
            this.setAbas();
            this.add((Component)this.tabbed_panel, "Center");
            FlowLayout flow = (FlowLayout)this.panelLegendas.getLayout();
            flow.setVgap(0);
            this.panelLegenda.add((Component)this.panelAtalhos, "Center");
            flow = (FlowLayout)this.panelAtalhos.getLayout();
            flow.setVgap(0);
            flow.setHgap(0);
            JPanel panelCorLegenda = new JPanel();
            panelCorLegenda.setPreferredSize(new Dimension(10, 10));
            panelCorLegenda.setBackground(Color.RED);
            this.panelLegendas.add(panelCorLegenda);
            JLabel labelLegenda = new JLabel("Atrasado");
            Font font = new Font(labelLegenda.getFont().getName(), 0, 10);
            labelLegenda.setFont(font);
            this.panelLegendas.add(labelLegenda);
            panelCorLegenda = new JPanel();
            panelCorLegenda.setPreferredSize(new Dimension(10, 10));
            panelCorLegenda.setBackground(Color.BLUE);
            this.panelLegendas.add(panelCorLegenda);
            labelLegenda = new JLabel("No Prazo");
            labelLegenda.setFont(font);
            this.panelLegendas.add(labelLegenda);
            panelCorLegenda = new JPanel();
            panelCorLegenda.setPreferredSize(new Dimension(10, 10));
            panelCorLegenda.setBackground(Color.BLACK);
            this.panelLegendas.add(panelCorLegenda);
            labelLegenda = new JLabel("Entrega Futura");
            labelLegenda.setFont(font);
            this.panelLegendas.add(labelLegenda);
            panelCorLegenda = new JPanel();
            panelCorLegenda.setPreferredSize(new Dimension(10, 10));
            panelCorLegenda.setBackground(ScreenUtil.clarearCor(Color.RED, 200));
            this.panelLegendas.add(panelCorLegenda);
            JLabel labelUrgente = new JLabel("Urgente");
            labelUrgente.setBackground(ScreenUtil.clarearCor(Color.RED, 200));
            labelUrgente.setOpaque(true);
            labelUrgente.setFont(font);
            this.panelLegendas.add(labelUrgente);
            if (this.configuracao.getDestacarExames()) {
                panelCorLegenda = new JPanel();
                panelCorLegenda.setPreferredSize(new Dimension(10, 10));
                panelCorLegenda.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, COR_VALORALTERADO));
                this.panelLegendas.add(panelCorLegenda);
                JLabel labelValoresAlterados = new JLabel("Valores alterados");
                labelValoresAlterados.setOpaque(true);
                labelValoresAlterados.setFont(font);
                this.panelLegendas.add(labelValoresAlterados);
            }
            this.panelLegenda.add((Component)this.panelLegendas, "East");
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.fill = 2;
            c.weightx = 1.0;
            this.panelLegendaStatus.add((Component)this.panelLegenda, c);
            c.gridy = 1;
            this.panelLegendaStatus.add((Component)this.status_panel, c);
            c.gridy = 0;
            c.gridx = 1;
            c.fill = 3;
            c.gridheight = 2;
            c.weightx = 0.0;
            this.panelLegendaStatus.add((Component)this.botao_fechar, c);
            this.add((Component)this.panelLegendaStatus, "South");
            this.inserirAcaoDeTecla("F5", "atalhoF5", new AbstractAction("atalhoF5"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractInterfaceamento.this.tabbed_panel.setSelectedComponent(AbstractInterfaceamento.this.examesNaoEnviados);
                }
            });
            this.inserirAcaoDeTecla("F6", "atalhoF6", new AbstractAction("atalhoF6"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractInterfaceamento.this.tabbed_panel.setSelectedComponent(AbstractInterfaceamento.this.examesPendentes);
                }
            });
            this.inserirAcaoDeTecla("F7", "atalhoF7", new AbstractAction("atalhoF7"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractInterfaceamento.this.tabbed_panel.setSelectedComponent(AbstractInterfaceamento.this.examesProntos);
                }
            });
            this.inserirAcaoDeTecla("F8", "atalhoF8", new AbstractAction("atalhoF8"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        AbstractInterfaceamento.this.tabbed_panel.setSelectedComponent(AbstractInterfaceamento.this.excecoes);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            });
            this.inserirAcaoDeTecla("F11", "atalhoF11", new AbstractAction("atalhoF11"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AbstractInterfaceamento.this.split == null) {
                        AbstractInterfaceamento.this.split = new JSplitPane(0, AbstractInterfaceamento.this.tabbed_panel, AbstractInterfaceamento.this.tabbed_log);
                        AbstractInterfaceamento.this.montaAbasLog();
                        AbstractInterfaceamento.this.remove(AbstractInterfaceamento.this.tabbed_panel);
                        AbstractInterfaceamento.this.add((Component)AbstractInterfaceamento.this.split, "Center");
                    } else {
                        AbstractInterfaceamento.this.removeAbasLog();
                        AbstractInterfaceamento.this.remove(AbstractInterfaceamento.this.split);
                        AbstractInterfaceamento.this.split = null;
                        AbstractInterfaceamento.this.add((Component)AbstractInterfaceamento.this.tabbed_panel, "Center");
                    }
                    AbstractInterfaceamento.this.revalidate();
                }
            });
            this.inserirAcaoDeTecla("F12", "atalhoF12", new AbstractAction("atalhoF12"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TestesInterface.teste(AbstractInterfaceamento.this.getAbaNaoEnviados().getConfiguracoesPorta().get(0).getInterfacementoListener());
                }
            });
            this.inserirAcaoDeTecla("shift F1", "atalhoshiftF1", new AbstractAction("atalhoshiftF1"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        String apa_classe = Variaveis.equipamentos.get(0).getProtocolo().getClasse();
                        AbstractInterfaceamentoFactory aif = (AbstractInterfaceamentoFactory)Class.forName("jalis.laboratorio.interfaceamento.interfaces." + apa_classe + ".InterfaceamentoFactory").newInstance();
                        TelaAjuda tela = new TelaAjuda(Laboratorio.getInstancia());
                        if (!Funcoes.textoVazio(aif.getSerialInfo())) {
                            try {
                                tela.setPage(ConfigEquipamento.class.getResource(aif.getSerialInfo()));
                            }
                            catch (Exception ex) {
                                tela.setText(aif.getSerialInfo());
                            }
                        }
                        tela.setVisible(true);
                    }
                    catch (Exception ex1) {
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex1.getMessage(), ex1.getStackTrace(), "AbstractInterfaceamento: 471");
                    }
                }
            });
            this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, true), "none");
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    if (AbstractInterfaceamento.this.getParent() != null) {
                        AbstractInterfaceamento.this.getParent().removeAll();
                    }
                }
            });
            status_bar_components = new ArrayList();
            this.status_panel.setPreferredSize(new Dimension(0, 15));
            this.auto_import = new StatusAutoImportador(this);
            this.auto_import.start();
            for (ConfiguracaoSerial conf : this.getSelectedTab().getConfiguracoesPorta()) {
                StatusEstadoComunicacao state_comp = new StatusEstadoComunicacao(conf.getFluxoController());
                state_comp.setToolTipText(conf.getDescricao());
                this.addStatusBarComponent(state_comp);
            }
            this.configuracao.setXmlVariaveis(this.getSelectedTab().getConfiguracaoPortaSelecionada().getVariaveisConfiguracao());
            if (this.isAutoEnvio() && !this.configuracao.getModoHostQuery()) {
                this.auto_envio = new StatusAutoEnvio(this);
                this.addStatusBarComponent(this.auto_envio);
            }
            this.addStatusBarComponent(this.auto_import);
            if (this.isAutoEnvio() && !this.configuracao.getModoHostQuery() && ((envioAutomatico = ParametrosLocais.getParametro("envioAutomaticoExameInterfaceamento")) == null || envioAutomatico.equalsIgnoreCase("1") && !this.configuracao.getModoHostQuery())) {
                this.auto_envio.start();
            }
            this.tabbed_panel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    try {
                        AbstractInterfaceamento.this.alteraLegendaAtalhos();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            if (this.configuracao.getLogComunicacao()) {
                this.timerGravacaoLog.start();
                for (ConfiguracaoSerial conf : this.getAbaNaoEnviados().getConfiguracoesPorta()) {
                    LogPortasArquivo log = new LogPortasArquivo(null);
                    conf.getPortaCOM().addLogListener(log);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(parent, ex.getMessage(), ex.getStackTrace(), "AbstractInterfaceamento: construtora");
        }
        finally {
            parent.setCursor(Cursor.getDefaultCursor());
            this.setVisible(true);
        }
    }

    public AbstractInterfaceamento(JFrame parent) {
        try {
            parent.setCursor(Cursor.getPredefinedCursor(3));
            this.parent = parent;
            Variaveis.equip = this;
            Variaveis.equip.configurar(parent);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(parent, ex.getMessage(), ex.getStackTrace(), "AbstractInterfaceamento: construtora");
        }
        finally {
            parent.setCursor(Cursor.getDefaultCursor());
            this.setVisible(true);
        }
    }

    public abstract PanelAbaAbstrata getAbaNaoEnviados();

    public abstract PanelAbaAbstrata getAbaPendentes();

    public abstract PanelAbaAbstrata getAbaProntos();

    protected abstract AbaExcecoes getAbaExcecoes();

    @Override
    public abstract String getName();

    protected void inserirAcaoDeTecla(String key_stroke, String action_name, AbstractAction action) {
        this.getInputMap(0).put(KeyStroke.getKeyStroke(key_stroke), action_name);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(key_stroke), action_name);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(key_stroke), action_name);
        this.getActionMap().put(action_name, action);
    }

    public void enviarProximoExameAutoEnvio() {
        if (this.examesNaoEnviados != null) {
            int colunaExameRotina = this.examesNaoEnviados.getColIndice("Exame da Rotina");
            if (this.configuracao.getValidaRotinaExames() && colunaExameRotina >= 0) {
                int row;
                Boolean b = false;
                for (row = 0; !b.booleanValue() && row < this.examesNaoEnviados.getRowCount(); ++row) {
                    b = (Boolean)this.examesNaoEnviados.getValueAt(row, colunaExameRotina);
                    if (!b.booleanValue()) continue;
                    if (!this.configuracao.getPularLinhaErroAutoenvio()) break;
                    String requisicao = (String)this.examesNaoEnviados.getValueAt(row, this.examesNaoEnviados.getColIndice("C\u00f3digo"));
                    String tubo = (String)this.examesNaoEnviados.getValueAt(row, this.examesNaoEnviados.getColIndice("Tubo"));
                    requisicao = requisicao + Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
                    String exames = (String)this.examesNaoEnviados.getValueAt(row, this.examesNaoEnviados.getColIndice("Exame"));
                    if (!this.linhasErro.contains(new LinhaErroAutoEnvio(requisicao, exames))) break;
                }
                if (b.booleanValue()) {
                    this.examesNaoEnviados.transmiteLinha(row, 1001001002L);
                }
            } else if (this.configuracao.getPularLinhaErroAutoenvio()) {
                int row;
                for (row = 0; row < this.examesNaoEnviados.getRowCount(); ++row) {
                    String requisicao = (String)this.examesNaoEnviados.getValueAt(row, this.examesNaoEnviados.getColIndice("C\u00f3digo"));
                    String tubo = (String)this.examesNaoEnviados.getValueAt(row, this.examesNaoEnviados.getColIndice("Tubo"));
                    requisicao = requisicao + Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
                    String exames = (String)this.examesNaoEnviados.getValueAt(row, this.examesNaoEnviados.getColIndice("Exame"));
                    if (!this.linhasErro.contains(new LinhaErroAutoEnvio(requisicao, exames))) break;
                }
                if (row < this.examesNaoEnviados.getRowCount()) {
                    this.examesNaoEnviados.transmiteLinha(row, 1001001002L);
                }
            } else {
                this.examesNaoEnviados.transmiteLinha(0, 1001001002L);
            }
        }
    }

    public void transmiteRequisicao(String fil_codigo, String req_codigo, String rec_codigo) {
        StringBuilder req = new StringBuilder();
        req.append(Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial()));
        req.append(Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao()));
        req.append(Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo()));
        for (int row = 0; row < this.examesNaoEnviados.getRowCount(); ++row) {
            String requisicao = (String)this.examesNaoEnviados.getValueAt(row, this.examesNaoEnviados.getColIndice("C\u00f3digo"));
            String tubo = (String)this.examesNaoEnviados.getValueAt(row, this.examesNaoEnviados.getColIndice("Tubo"));
            if (!(requisicao = requisicao + Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo())).equalsIgnoreCase(req.toString())) continue;
            this.examesNaoEnviados.transmiteLinha(row, 1001001002L);
            break;
        }
    }

    public void adicionarExcecao(String msg_excecao) {
        if (this.excecoes == null) {
            this.excecoes = this.getAbaExcecoes();
        }
        this.excecoes.adicionarExcecao(msg_excecao);
    }

    public void refreshSelected() {
        if (this.getSelectedTab() != null) {
            this.getSelectedTab().reloadExames();
        }
    }

    public void refresh(int tab_number) {
        if (tab_number < this.getTabCount()) {
            this.getTab(tab_number).reloadExames();
        }
    }

    public void refresh(PanelAbaAbstrata aba) {
        aba.reloadExames();
    }

    public void novaMensagem(String texto, int tipo, int tempo) {
        this.status.novaMensagem(texto, tipo, tempo);
    }

    public void alertarResultado() {
        this.examesProntos.alertarUsuario();
    }

    public void addStatusBarComponent(Component comp) {
        if (!status_bar_components.contains(comp)) {
            status_bar_components.add(0, comp);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.gridy = 0;
            this.status_panel.removeAll();
            c.weightx = 1.0;
            c.gridx = 0;
            this.status_panel.add((Component)this.status, c);
            c.weightx = 0.0;
            for (int i = 0; i < status_bar_components.size(); ++i) {
                c.gridx = i + 1;
                this.status_panel.add(status_bar_components.get(i), c);
            }
        }
    }

    public void setAbas() {
        this.tabbed_panel = new JTabbedPane();
        this.examesNaoEnviados = this.getAbaNaoEnviados();
        this.examesPendentes = this.getAbaPendentes();
        this.examesProntos = this.getAbaProntos();
        this.excecoes = this.getAbaExcecoes();
        this.examesProntos.getTabela().resizeAndRepaint();
        this.tabbed_panel.add("N\u00e3o enviados", this.examesNaoEnviados);
        this.tabbed_panel.add("Processando", this.examesPendentes);
        this.tabbed_panel.add("Prontos", this.examesProntos);
        this.tabbed_panel.add("Mensagens", this.excecoes);
        this.tabbed_panel.revalidate();
        this.tabbed_panel.repaint();
        try {
            this.alteraLegendaAtalhos();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getTabCount() {
        return this.tabbed_panel.getTabCount();
    }

    public PanelAbaAbstrata getTab(int tab_index) {
        return (PanelAbaAbstrata)this.tabbed_panel.getComponentAt(tab_index);
    }

    public PanelAbaAbstrata getSelectedTab() {
        if (this.tabbed_panel.getSelectedComponent() != null) {
            return (PanelAbaAbstrata)this.tabbed_panel.getSelectedComponent();
        }
        return null;
    }

    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao, HashMap<String, String> mapaParametros) {
        ConfiguracaoSerial c = this.getSelectedTab().getConfiguracaoPorta(fil_codigo, int_codigo);
        if (c == null || c.getInterfacementoListener() == null) {
            return "N\u00e3o h\u00e1 uma configura\u00e7\u00e3o v\u00e1lida para enviar a requisi\u00e7\u00e3o para o aparelho";
        }
        return c.getInterfacementoListener().enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames, acao, mapaParametros);
    }

    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        ConfiguracaoSerial c = this.getSelectedTab().getConfiguracaoPorta(fil_codigo, int_codigo);
        if (c == null || c.getInterfacementoListener() == null) {
            return "N\u00e3o h\u00e1 uma configura\u00e7\u00e3o v\u00e1lida para enviar a requisi\u00e7\u00e3o para o aparelho";
        }
        return c.getInterfacementoListener().enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames, acao);
    }

    public void encerrar() {
        for (ConfiguracaoSerial c : this.getSelectedTab().getConfiguracoesPorta()) {
            if (c.getPortaCOM() == null) continue;
            for (LogListener l : c.getPortaCOM().getLogListeners()) {
                if (!(l instanceof LogPortasArquivo)) continue;
                for (int tentativas = 5; !((LogPortasArquivo)l).fecharArquivo() && tentativas > 0; --tentativas) {
                }
            }
            c.getInterfacementoListener().encerrar();
            c.setInterfaceamentoListener(null);
            c.getPortaCOM().clearInputString();
            c.getPortaCOM().flush();
            c.getPortaCOM().close();
            if (c.getFluxoController() == null) continue;
            c.getFluxoController().interromperTimer();
            c.setFluxoController(null);
        }
        if (this.auto_envio != null) {
            this.auto_envio.stop();
            this.auto_envio = null;
        }
        if (this.auto_import != null) {
            this.auto_import.stop();
            this.auto_import = null;
        }
        this.examesNaoEnviados = null;
        this.examesPendentes = null;
        this.examesProntos = null;
        this.excecoes = null;
        if (this.configuracao.getLogComunicacao() && this.timerGravacaoLog != null) {
            this.timerGravacaoLog.stop();
        }
        this.escreverLog("Fechou", new Date());
        this.removeAll();
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void escreverLog(String texto, Date data) {
        if (Variaveis.equip == null || !Variaveis.equip.configuracao.getLogAberturaInterfaceamento()) {
            return;
        }
        String nomeArquivo = System.getProperty("user.home").toString() + "/.interfaceamento.log";
        texto = Funcoes.formataData("dd/MM/yyyy HH:mm:ss", data) + " - " + texto + "\t- " + Variaveis.login;
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(nomeArquivo, true));
            out.write(texto + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1001001000");
    }

    public abstract boolean isAutoEnvio();

    public boolean isAutoImportador() {
        return true;
    }

    public StatusAutoEnvio getStatusAutoEnvio() {
        return this.auto_envio;
    }

    public StatusFecharInterfaceamento getStatusFecharInterfaceamento() {
        return this.botao_fechar;
    }

    public abstract boolean isPesquisaExamesComExcecao();

    public abstract boolean isContadorEnvio();

    public abstract boolean isContadorCelula();

    public boolean mostraFlags() {
        return false;
    }

    public boolean digitarDadosBrutos() {
        return false;
    }

    private void alteraLegendaAtalhos() throws Exception {
        this.panelAtalhos.removeAll();
        JLabel labelAtalhos = new JLabel(((PanelAbaAbstrata)this.tabbed_panel.getSelectedComponent()).getAtalhos());
        Font font = new Font(labelAtalhos.getFont().getName(), 0, 10);
        labelAtalhos.setFont(font);
        this.panelAtalhos.add(labelAtalhos);
        this.panelAtalhos.revalidate();
        this.panelAtalhos.repaint();
    }

    public void addEnvioListener(InterfaceamentoEnvioListener listener) {
        this.envio_listeners.add(listener);
    }

    public void removeAllEnvioListener() {
        this.envio_listeners.clear();
    }

    @Override
    public void atualizarTabela(int aba) {
        this.refresh(aba);
    }

    @Override
    public void atualizarTabela() {
        this.refreshSelected();
    }

    @Override
    public void execaoEncontrada(String excecao) {
        this.adicionarExcecao(excecao);
    }

    @Override
    public void mensagemEnviada(String texto, int tipo, int tempo) {
        this.novaMensagem(texto, tipo, tempo);
    }

    @Override
    public void pacienteEnviado(String req_codigo, String pac_nome, String pac_sexo, String req_idade, String req_data, String req_hora, String pac_exames) {
        if (this.examesNaoEnviados != null) {
            this.examesNaoEnviados.exibeUltimoEnviado(req_codigo, pac_nome, pac_sexo, req_idade, req_data, req_hora, pac_exames);
        }
        if (this.examesProntos != null) {
            this.examesProntos.exibeUltimoEnviado(req_codigo, pac_nome, pac_sexo, req_idade, req_data, req_hora, pac_exames);
        }
    }

    @Override
    public void pacienteExportado(String req_codigo, String pac_nome, String pac_sexo, String req_idade, String req_data, String req_hora, String pac_exames) {
        this.examesProntos.exibeUltimoExportado(req_codigo, pac_nome, pac_sexo, req_idade, req_data, req_hora, pac_exames);
    }

    private void montaAbasLog() {
        for (ConfiguracaoSerial conf : this.getAbaNaoEnviados().getConfiguracoesPorta()) {
            LogAba aba = new LogAba();
            this.tabbed_log.addTab(conf.getDescricao(), aba);
            LogPortas log = new LogPortas(aba);
            conf.getPortaCOM().addLogListener(log);
        }
    }

    private void removeAbasLog() {
        for (ConfiguracaoSerial conf : this.getAbaNaoEnviados().getConfiguracoesPorta()) {
            conf.getPortaCOM().removeLogListeners();
        }
        this.tabbed_log.removeAll();
    }

    public String arruma(String message) {
        String command = message;
        String newCommand = "";
        String c = "";
        if (command != null && command.trim().length() > 0) {
            char[] a = command.toCharArray();
            for (int i = 0; i < a.length; ++i) {
                if (a[i] == '[' && a[i + 1] != '[') {
                    c = c + a[i];
                    ++i;
                    while (a[i] != ']') {
                        c = c + a[i];
                        ++i;
                    }
                    c = c + a[i];
                    newCommand = newCommand + this.parseStringToConstant(c);
                    c = "";
                    continue;
                }
                newCommand = newCommand + a[i];
            }
        }
        return newCommand;
    }

    public String parseStringToConstant(String command) {
        if (command.equalsIgnoreCase(sNUL)) {
            return String.valueOf('\u0000');
        }
        if (command.equalsIgnoreCase(sSOH)) {
            return String.valueOf('\u0001');
        }
        if (command.equalsIgnoreCase(sSTX)) {
            return String.valueOf('\u0002');
        }
        if (command.equalsIgnoreCase(sETX)) {
            return String.valueOf('\u0003');
        }
        if (command.equalsIgnoreCase(sEOT)) {
            return String.valueOf('\u0004');
        }
        if (command.equalsIgnoreCase(sENQ)) {
            return String.valueOf('\u0005');
        }
        if (command.equalsIgnoreCase(sACK)) {
            return String.valueOf('\u0006');
        }
        if (command.equalsIgnoreCase(sLF)) {
            return String.valueOf('\n');
        }
        if (command.equalsIgnoreCase(sSB)) {
            return String.valueOf('\u000b');
        }
        if (command.equalsIgnoreCase(sCR)) {
            return String.valueOf('\r');
        }
        if (command.equalsIgnoreCase(sDLE)) {
            return String.valueOf('\u0010');
        }
        if (command.equalsIgnoreCase(sDC1)) {
            return String.valueOf('\u0011');
        }
        if (command.equalsIgnoreCase(sNAK)) {
            return String.valueOf('\u0015');
        }
        if (command.equalsIgnoreCase(sSYN)) {
            return String.valueOf('\u0016');
        }
        if (command.equalsIgnoreCase(sETB)) {
            return String.valueOf('\u0017');
        }
        if (command.equalsIgnoreCase(sCAN)) {
            return String.valueOf('\u0018');
        }
        if (command.equalsIgnoreCase(sEB)) {
            return String.valueOf('\u001c');
        }
        if (command.equalsIgnoreCase(sSP)) {
            return String.valueOf(' ');
        }
        if (command.equalsIgnoreCase(sDEL)) {
            return String.valueOf('\u007f');
        }
        if (command.equalsIgnoreCase(sLINE)) {
            return String.valueOf(LINE);
        }
        if (command.equalsIgnoreCase(sFD)) {
            return String.valueOf('\u00fd');
        }
        if (command.equalsIgnoreCase(sGS)) {
            return String.valueOf('\u001d');
        }
        if (command.equalsIgnoreCase(sRS)) {
            return String.valueOf('\u001e');
        }
        if (command.equalsIgnoreCase(sVT)) {
            return String.valueOf('\u000b');
        }
        if (command.equalsIgnoreCase(sFS)) {
            return String.valueOf('\u001c');
        }
        return "";
    }

    private void gravaLog() {
        if (this.configuracao.getLogComunicacao()) {
            for (ConfiguracaoSerial conf : this.getAbaNaoEnviados().getConfiguracoesPorta()) {
                ArrayList<LogListener> logs = conf.getPortaCOM().getLogListeners();
                for (LogListener log : logs) {
                    if (!(log instanceof LogPortasArquivo)) continue;
                    LogPortasArquivo logPorta = (LogPortasArquivo)log;
                    String nomeArq = logPorta.nome;
                    for (int tentativas = 5; !logPorta.fecharArquivo() && tentativas > 0; --tentativas) {
                    }
                    logPorta.abrirArquivo(nomeArq);
                }
            }
        }
    }

    public String parseMessage(String message) {
        String newMessage = "";
        if (message != null && message.length() > 0) {
            char[] a = message.toCharArray();
            for (int i = 0; i < a.length; ++i) {
                char c = a[i];
                if (c == '\u0000') {
                    newMessage = newMessage + sNUL;
                    continue;
                }
                if (c == '\u0001') {
                    newMessage = newMessage + sSOH;
                    continue;
                }
                if (c == '\u0002') {
                    newMessage = newMessage + sSTX;
                    continue;
                }
                if (c == '\u0003') {
                    newMessage = newMessage + sETX;
                    continue;
                }
                if (c == '\u0004') {
                    newMessage = newMessage + sEOT;
                    continue;
                }
                if (c == '\u0005') {
                    newMessage = newMessage + sENQ;
                    continue;
                }
                if (c == '\u0006') {
                    newMessage = newMessage + sACK;
                    continue;
                }
                if (c == '\n') {
                    newMessage = newMessage + sLF;
                    newMessage = newMessage + "\n";
                    continue;
                }
                if (c == '\u000b') {
                    newMessage = newMessage + sSB;
                    continue;
                }
                if (c == '\r') {
                    if (i + 1 < a.length && a[i + 1] == '\n') {
                        newMessage = newMessage + sLINE;
                        ++i;
                    } else {
                        newMessage = newMessage + sCR;
                    }
                    newMessage = newMessage + "\n";
                    continue;
                }
                newMessage = c == '\u0010' ? newMessage + sDLE : (c == '\u0011' ? newMessage + sDC1 : (c == '\u0015' ? newMessage + sNAK : (c == '\u0016' ? newMessage + sSYN : (c == '\u0017' ? newMessage + sETB : (c == '\u0018' ? newMessage + sCAN : (c == '\u001c' ? newMessage + sEB : (c == ' ' ? newMessage + sSP : (c == '\u007f' ? newMessage + sDEL : (c == '\u00fd' ? newMessage + sFD : (c == '\u001d' ? newMessage + sGS : (c == '\u001e' ? newMessage + sRS : (c == '\u000b' ? newMessage + sVT : (c == '\u001c' ? newMessage + sFS : newMessage + c)))))))))))));
            }
        }
        return newMessage;
    }

    public StatusAutoImportador getAutoImport() {
        return this.auto_import;
    }

    public StatusAutoEnvio getAutoEnvio() {
        return this.auto_envio;
    }

    public void addLinhaErro(String requisicao, String exames) {
        this.linhasErro.add(new LinhaErroAutoEnvio(requisicao, exames));
    }

    public void finalizarInterfaceamento(boolean mostrarMensagem) {
        this.botao_fechar.doClick(mostrarMensagem);
    }

    static {
        sNUL = "[NUL]";
        sSOH = "[SOH]";
        sSTX = "[STX]";
        sETX = "[ETX]";
        sEOT = "[EOT]";
        sENQ = "[ENQ]";
        sACK = "[ACK]";
        sLF = "[LF]";
        sSB = "[SB]";
        sCR = "[CR]";
        sDLE = "[DLE]";
        sDC1 = "[D1C]";
        sNAK = "[NAK]";
        sSYN = "[SYN]";
        sETB = "[ETB]";
        sCAN = "[CAN]";
        sEB = "[EB]";
        sSP = "[SP]";
        sDEL = "[DEL]";
        sLINE = "[LINE]";
        sFD = "[FD]";
        sGS = "[GS]";
        sRS = "[RS]";
        sVT = "[VT]";
        sFS = "[FS]";
    }

    class LogAba
    extends JPanel
    implements ActionListener {
        private JTextPane textPane;
        private Document doc;
        private JScrollPane scrollText;
        private JPanel panelBotoes;
        private Legenda legenda;
        private JButton buttonLimpar;
        private JButton buttonSalvar;
        private JButton buttonEnviar;
        private final Color corIn;
        private final Color corOut;
        private SimpleAttributeSet attributesTime;
        private SimpleAttributeSet attributesIn;
        private SimpleAttributeSet attributesOut;

        public LogAba() {
            super(new BorderLayout());
            this.textPane = new JTextPane();
            this.doc = this.textPane.getDocument();
            this.scrollText = new JScrollPane(this.textPane);
            this.panelBotoes = new JPanel(new FlowLayout(0));
            this.legenda = new Legenda();
            this.buttonLimpar = new JButton("Limpar");
            this.buttonSalvar = new JButton("Salvar");
            this.buttonEnviar = new JButton("Enviar");
            this.corIn = Color.RED;
            this.corOut = Color.BLACK;
            this.attributesTime = new SimpleAttributeSet();
            this.attributesIn = new SimpleAttributeSet();
            this.attributesOut = new SimpleAttributeSet();
            this.textPane.setEditable(false);
            this.attributesTime.addAttribute(StyleConstants.Foreground, Color.GRAY);
            this.attributesIn.addAttribute(StyleConstants.Foreground, this.corIn);
            this.attributesOut.addAttribute(StyleConstants.Foreground, this.corOut);
            FlowLayout flw = (FlowLayout)this.panelBotoes.getLayout();
            flw.setHgap(2);
            flw.setVgap(1);
            this.legenda.addItem(this.corOut, "Out");
            this.legenda.addItem(this.corIn, "In");
            this.buttonLimpar.setMargin(new Insets(1, 1, 1, 1));
            this.buttonSalvar.setMargin(new Insets(1, 1, 1, 1));
            this.buttonEnviar.setMargin(new Insets(1, 1, 1, 1));
            this.buttonLimpar.addActionListener(this);
            this.buttonSalvar.addActionListener(this);
            this.buttonEnviar.addActionListener(this);
            this.panelBotoes.add(this.buttonLimpar);
            this.panelBotoes.add(this.buttonSalvar);
            this.panelBotoes.add(this.buttonEnviar);
            super.add((Component)this.legenda.getPanel(), "North");
            super.add((Component)this.scrollText, "Center");
            super.add((Component)this.panelBotoes, "South");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.buttonSalvar) {
                this.salvar();
            } else if (e.getSource() == this.buttonLimpar) {
                this.textPane.setText("");
            } else if (e.getSource() == this.buttonEnviar) {
                this.enviar();
            }
        }

        private void salvar() {
            JFileChooser f = ComponenteFactory.novoJFileChooser();
            FileFilter flt = ComponenteFactory.novoFileFilter("(*.txt)", "txt");
            f.setFileFilter(flt);
            if (f.showSaveDialog(this) == 0) {
                String arquivo = f.getSelectedFile().getAbsolutePath();
                if (!arquivo.toUpperCase().endsWith(".TXT")) {
                    arquivo = arquivo + ".txt";
                }
                String texto = this.textPane.getText();
                try {
                    StringUtil.escreverArquivoTexto(arquivo, texto);
                    Funcoes.mensagem(this, "Exporta\u00e7\u00e3o realizada com sucesso!", 5);
                }
                catch (Exception e) {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel exportar os dados.\nMensagem: " + e.getMessage(), 1);
                }
            }
        }

        private void enviar() {
            String texto = this.textPane.getText();
            ErrorLogger.enviarEmail("suporte@lode.com.br", "\n" + texto, "LOG INTERFACEAMENTO");
        }

        private void escreveLinha(String prefixo, String texto, AttributeSet attributeSet) {
            try {
                String time = Funcoes.formataData("HH:mm:ss:SSS", new Date());
                this.doc.insertString(this.doc.getLength(), time + prefixo, this.attributesTime);
                this.doc.insertString(this.doc.getLength(), texto + "\n", attributeSet);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        public void appendOut(String out) {
            this.escreveLinha("<<", out, this.attributesOut);
        }

        public void appendIn(String in) {
            this.escreveLinha(">>", in, this.attributesIn);
        }
    }

    class LogPortasArquivo
    implements LogListener {
        BufferedWriter out = null;
        String nome = "";
        long qtdeCaracters = 0L;
        boolean gravando = false;

        public LogPortasArquivo(String arquivo) {
            this.abrirArquivo(arquivo);
        }

        private void abrirArquivo(String arquivo) {
            if (Funcoes.textoVazio(arquivo)) {
                if (!Funcoes.diretorioExiste(System.getProperty("user.home") + "/logs")) {
                    new File(System.getProperty("user.home") + "/logs").mkdirs();
                }
                Date dt = new Date();
                StringBuilder nome = new StringBuilder();
                nome.append(System.getProperty("user.home"));
                nome.append("/logs/.jalis_");
                nome.append(Funcoes.formataData("ddMMyyyy_HHmmss", dt));
                nome.append(".log");
                this.nome = nome.toString();
            }
            try {
                this.out = new BufferedWriter(new FileWriter(this.nome, true));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void inputLog(String log) {
            if (this.out == null) {
                return;
            }
            this.gravando = true;
            try {
                String msg = AbstractInterfaceamento.this.parseMessage(log);
                this.out.write(String.format("%s RECEBIMENTO: ", Funcoes.formataData("HH:mm:ss:SSS", Calendar.getInstance().getTime())) + msg + "\n-----------------------------------\n");
                this.out.flush();
                this.qtdeCaracters += (long)msg.length();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.gravando = false;
            this.validaTamanho();
        }

        @Override
        public void outputLog(String log) {
            block3: {
                if (this.out == null) {
                    return;
                }
                try {
                    this.gravando = true;
                    String msg = AbstractInterfaceamento.this.parseMessage(log);
                    this.out.write(String.format("%s ENVIO: ", Funcoes.formataData("HH:mm:ss", Calendar.getInstance().getTime())) + msg + "\n-----------------------------------\n");
                    this.qtdeCaracters += (long)msg.length();
                }
                catch (IOException e) {
                    if (e.getMessage().contains("ClosedByInterruptException") || e.getMessage().contains("IOException")) break block3;
                    e.printStackTrace();
                }
            }
            this.gravando = false;
            this.validaTamanho();
        }

        public boolean fecharArquivo() {
            if (this.out == null || this.gravando) {
                return false;
            }
            try {
                this.out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }

        private void validaTamanho() {
            if (this.qtdeCaracters >= 1000000L && this.fecharArquivo()) {
                this.qtdeCaracters = 0L;
                this.abrirArquivo(null);
            }
        }
    }

    class LogPortas
    implements LogListener {
        private LogAba logAba;

        public LogPortas(LogAba logAba) {
            this.logAba = logAba;
        }

        @Override
        public void inputLog(String log) {
            this.logAba.appendIn(AbstractInterfaceamento.this.parseMessage(log));
        }

        @Override
        public void outputLog(String log) {
            this.logAba.appendOut(AbstractInterfaceamento.this.parseMessage(log));
        }
    }
}

