/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.impressao.componente;

import br.com.thread.openpdf.text.pdf.PdfGraphics2D;
import jalis.laboratorio.configurador.Constantes;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.digitacao.componente.ComponenteValor;
import jalis.laboratorio.impressao.componente.ComponenteImpressao;
import jalis.util.StringUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.StyleConstants;
import sun.swing.SwingUtilities2;

public class TextoEstatico
extends JLabel
implements ComponenteImpressao,
ComponenteValor {
    private boolean imprimir;
    private boolean quebrarLinha = false;
    private transient Componente dono;
    private transient Object valor;
    private boolean processarTagsHTML = false;
    private boolean considerarImpressaoPDF = false;
    private static final float AJUSTE_TAMANHO = 0.1f;
    private static final String TAG_HTML = "<html>";

    @Override
    public void setDimensoes(Rectangle rec) {
        if (this.dono != null) {
            this.dono.setDimensoes(rec);
        }
        this.setBounds(rec);
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.setDimensoes(new Rectangle(esquerda, topo, largura, altura));
    }

    @Override
    public Rectangle getDimensoes() {
        if (this.dono != null) {
            return this.dono.getDimensoes();
        }
        return this.getBounds();
    }

    public boolean isProcessarTagsHTML() {
        return this.processarTagsHTML;
    }

    public void setProcessarTagsHTML(boolean removerTagsHTML) {
        this.processarTagsHTML = removerTagsHTML;
    }

    @Override
    public Point getPosicao() {
        return this.getDimensoes().getLocation();
    }

    @Override
    public List<String> getLigacoes() {
        if (this.dono != null) {
            return this.dono.getLigacoes();
        }
        return new ArrayList<String>();
    }

    @Override
    public String getNome() {
        return this.getName();
    }

    @Override
    public void setDono(Componente dono) {
        this.dono = dono;
    }

    @Override
    public Componente getDono() {
        return this.dono;
    }

    @Override
    public Object getValor() {
        if (null != this.valor) {
            if (this.valor.toString().contains("<![CDATA[")) {
                return StringUtil.limpaCdata(this.valor.toString());
            }
            return this.valor;
        }
        return null;
    }

    @Override
    public boolean vazio() {
        return false;
    }

    public void setValor(Object valor) {
        this.valor = null != valor ? (valor.toString().contains("<![CDATA[") ? StringUtil.limpaCdata(valor.toString()) : valor) : null;
    }

    @Override
    public boolean resultadoAnterior() {
        if (this.dono != null) {
            return this.dono.getResultadoAnterior();
        }
        return false;
    }

    public void setImprimir(boolean imprimir) {
        this.imprimir = imprimir;
    }

    @Override
    public boolean imprimir() {
        return this.imprimir;
    }

    @Override
    public void paint(Graphics g) {
        String os = System.getProperty("os.name");
        boolean isWindows = os.toUpperCase().startsWith("WINDOWS");
        String texto = this.getText();
        if (this.considerarImpressaoPDF && texto.contains(TAG_HTML) && g instanceof PdfGraphics2D) {
            this.paintPdf(g);
        } else {
            this.customPaint((Graphics2D)g.create(), isWindows ? 2 : 0);
        }
    }

    public void paintPdf(Graphics g) {
        g = g.create();
        Font fonte = this.getFont();
        String texto = this.getText().replaceAll("\\<.[html]*[b]*[i]*[u]*[sub]*[sup]*\\>", "");
        int widthAux = SwingUtilities2.stringWidth(this, g.getFontMetrics(fonte), texto);
        while (widthAux > this.getWidth()) {
            fonte = fonte.deriveFont(fonte.getSize2D() - 0.05f);
            widthAux = SwingUtilities2.stringWidth(this, g.getFontMetrics(fonte), texto);
        }
        this.setFont(fonte);
        super.paint(g);
    }

    public void customPaint(Graphics2D g, int ajuste) {
        HashMap<TextAttribute, Double> map;
        double auxFator;
        String texto = this.getText();
        texto = texto.replace("&lt;", String.valueOf('\u0134'));
        texto = texto.replace("&gt;", String.valueOf('\u0135'));
        texto = texto.replace("&le;", String.valueOf('\u2264'));
        texto = texto.replace("&ge;", String.valueOf('\u2265'));
        texto = texto.replace("&hellip;", String.valueOf(' '));
        String textoSemHTML = texto.replaceAll("\\<.[html]*[b]*[i]*[u]*[sub]*[sup]*\\>", "");
        textoSemHTML = textoSemHTML.replaceAll(String.valueOf('\u0134'), "<");
        if ((textoSemHTML = textoSemHTML.replaceAll(String.valueOf('\u0135'), ">")).length() == 0) {
            return;
        }
        Font fonte = this.getFont();
        g.setFont(fonte);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHints(hints);
        FontMetrics fm = g.getFontMetrics(fonte);
        double widthAux = fm == null ? (double)this.getWidth() : fm.getStringBounds(textoSemHTML, g).getWidth();
        double d = widthAux = widthAux <= 0.0 ? 0.1 : widthAux;
        while (widthAux > (double)(this.getWidth() - ajuste) && textoSemHTML.trim().length() > 0) {
            fonte = fonte.deriveFont(fonte.getSize2D() - 0.1f);
            FontMetrics recalc = g.getFontMetrics(fonte);
            widthAux = recalc.getStringBounds(textoSemHTML, g).getWidth();
        }
        Graphics auxFrac = g.create();
        if (g.getTransform().getScaleX() > 1.0) {
            ((Graphics2D)auxFrac).scale(0.625, 0.625);
        }
        RenderingHints auxHints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        auxHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        auxHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        ((Graphics2D)auxFrac).setRenderingHints(auxHints);
        Graphics auxNormal = g.create();
        if (g.getTransform().getScaleX() > 1.0) {
            ((Graphics2D)auxNormal).scale(0.625, 0.625);
        }
        auxHints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        auxHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        auxHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        ((Graphics2D)auxNormal).setRenderingHints(auxHints);
        GlyphVector glyphFrac = fonte.createGlyphVector(((Graphics2D)auxFrac).getFontRenderContext(), textoSemHTML);
        GlyphVector glyphNormal = fonte.createGlyphVector(((Graphics2D)auxNormal).getFontRenderContext(), textoSemHTML);
        double widthFrac = glyphFrac.getVisualBounds().getWidth();
        double widthNormal = glyphNormal.getVisualBounds().getWidth();
        int escala = (int)(g.getTransform().getScaleX() > 0.0 ? g.getTransform().getScaleX() % 1.0 * 10.0 : 1.0);
        int n = escala = escala == 0 ? 1 : escala;
        if (ajuste > 0 && g.getDeviceConfiguration().getDevice().getType() == 1 || escala > 1) {
            double d2 = Math.abs(widthNormal - widthFrac);
            double d3 = escala > 1 ? 11.0 : 0.7;
            if (d2 >= d3) {
                widthNormal += escala > 1 ? (double)(ajuste * 2) : (double)ajuste;
            }
        }
        double fator = 1.0;
        double dif = Math.abs(widthNormal - widthFrac);
        double widthFinal = widthNormal;
        while (true) {
            auxFator = fator;
            double difAnt = dif;
            fator = widthNormal > widthFrac ? (fator += (double)new Float("0.0001").floatValue()) : (fator -= (double)new Float("0.0001").floatValue());
            map = new HashMap<TextAttribute, Double>();
            map.put(TextAttribute.WIDTH, fator);
            Font fonteAux = fonte.deriveFont(map);
            glyphFrac = fonteAux.createGlyphVector(((Graphics2D)auxFrac).getFontRenderContext(), textoSemHTML);
            widthFrac = glyphFrac == null || glyphFrac.getVisualBounds() == null ? widthNormal + 1.0 : glyphFrac.getVisualBounds().getWidth();
            dif = Math.abs(widthNormal - widthFrac);
            if (dif >= difAnt) break;
            widthFinal = widthFrac;
        }
        fator = auxFator;
        AttributedString as = new AttributedString(textoSemHTML);
        StringBuilder buf = new StringBuilder(texto);
        if (this.processarTagsHTML && buf.indexOf(TAG_HTML) > -1) {
            ArrayList<AtributosFonteTextoEstatico> aplicar = new ArrayList<AtributosFonteTextoEstatico>();
            int posHtml = -1;
            while ((posHtml = buf.indexOf(TAG_HTML)) > -1) {
                buf.delete(posHtml, posHtml + 6);
                posHtml = buf.indexOf("</html>");
                if (posHtml <= -1) continue;
                buf.delete(posHtml, posHtml + 7);
            }
            boolean abriu = false;
            String tag = "";
            int posicaoAbriu = -1;
            int posicaoAtual = 0;
            for (int i = 0; i < buf.length(); ++i) {
                char c = buf.charAt(i);
                if (String.valueOf(c).equals("<") && !abriu && this.tagHTML(i, buf.toString())) {
                    posicaoAbriu = posicaoAtual;
                    abriu = true;
                    continue;
                }
                if (String.valueOf(c).equals(">") && abriu) {
                    if (Constantes.estilos.containsKey(tag) && Constantes.estilos.get(tag) != null) {
                        AtributosFonteTextoEstatico at = new AtributosFonteTextoEstatico();
                        at.posicaoInicial = posicaoAbriu;
                        at.estilo = Constantes.estilos.get(tag);
                        aplicar.add(at);
                    }
                    posicaoAbriu = -1;
                    abriu = false;
                    tag = "";
                    continue;
                }
                if (abriu) {
                    int pos;
                    if ((tag = tag + String.valueOf(c)).length() > 4) {
                        tag = "";
                        posicaoAbriu = -1;
                        abriu = false;
                        continue;
                    }
                    if (tag.length() == 2 && tag.indexOf("/") > -1 && Constantes.estilos.containsKey(tag.substring(1))) {
                        int pos2 = this.achaPosicaoTagAberta(aplicar, Constantes.estilos.get(tag.substring(1)));
                        if (pos2 <= -1) continue;
                        aplicar.get((int)pos2).posicaoFinal = posicaoAbriu;
                        continue;
                    }
                    if (tag.length() != 4 || tag.indexOf("/") <= -1 || !Constantes.estilos.containsKey(tag.substring(1)) || (pos = this.achaPosicaoTagAberta(aplicar, Constantes.estilos.get(tag.substring(1)))) <= -1) continue;
                    aplicar.get((int)pos).posicaoFinal = posicaoAbriu;
                    continue;
                }
                ++posicaoAtual;
            }
            Atributos atributos = this.carregarAtributos(aplicar);
            if (textoSemHTML.length() > 0) {
                HashMap<TextAttribute, Object> map2 = new HashMap<TextAttribute, Object>();
                map2.put(TextAttribute.SIZE, fonte.getSize());
                map2.put(TextAttribute.WIDTH, fator);
                map2.put(TextAttribute.FAMILY, fonte.getFamily());
                as.addAttributes(map2, 0, textoSemHTML.length());
            }
            for (int i = 0; i < atributos.lista.size(); ++i) {
                HashMap<TextAttribute, Object> map3 = new HashMap<TextAttribute, Object>();
                Atributos.Atributo atributo = atributos.lista.get(i);
                map3.putAll(atributo.mapa);
                if (atributo.posFim - atributo.posIni <= 0) continue;
                as.addAttributes(map3, atributo.posIni, atributo.posFim);
            }
        } else {
            map = new HashMap();
            map.put(TextAttribute.WIDTH, fator);
            Font auxFonte = fonte.deriveFont(map);
            as.addAttribute(TextAttribute.FONT, auxFonte);
        }
        g.setColor(this.getForeground());
        this.calcularPosicaoDoTexto(fonte, as, fator, widthAux, g, textoSemHTML, widthFinal, ajuste, escala);
    }

    private void calcularPosicaoDoTexto(Font fonte, AttributedString as, double fator, double widthAux, Graphics2D g, String textoSemHTML, double widthFinal, int ajuste, int escala) {
        int x;
        int align = this.getHorizontalAlignment();
        int alinhDireita = align == 4 ? this.getWidth() - (int)widthAux : 0;
        int n = x = align == 0 ? (this.getWidth() - (int)widthAux) / 2 : alinhDireita;
        if (x < 0) {
            x = 0;
        }
        FontMetrics met = g.getFontMetrics(fonte);
        AttributedCharacterIterator aa = as.getIterator();
        int qtde = 0;
        if (fator != 1.0) {
            qtde += 10;
        }
        if (widthAux > 0.0) {
            Shape aux = g.getClip();
            boolean ultrapassouX = false;
            if (this.getParent() instanceof JPanel && (double)this.getX() + aux.getBounds2D().getX() + aux.getBounds2D().getWidth() + 2.0 > ((JPanel)this.getParent()).getVisibleRect().getWidth()) {
                ultrapassouX = true;
            }
            Rectangle2D.Double shape = new Rectangle2D.Double(aux.getBounds2D().getX(), aux.getBounds2D().getY(), aux.getBounds2D().getWidth() + (double)(!ultrapassouX ? qtde : 0), aux.getBounds2D().getHeight());
            g.setClip(shape);
            double diff = (met.getStringBounds(textoSemHTML, g).getBounds2D().getHeight() - (double)(met.getAscent() + met.getDescent() + met.getLeading())) / 2.0;
            int y = BigDecimal.valueOf(((double)(this.getHeight() + met.getAscent() - met.getDescent() - met.getLeading()) + diff) / 2.0).setScale(0, RoundingMode.HALF_DOWN).intValue();
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                int widthCalculada = (int)(widthFinal + (double)(ajuste > 0 ? ajuste : 5) + (double)(ajuste > 0 && escala > 1 ? 6 : 0));
                g.fillRect((int)aux.getBounds2D().getX(), (int)aux.getBounds2D().getY(), this.getWidth() > widthCalculada ? this.getWidth() + 1 : widthCalculada, (int)aux.getBounds2D().getHeight());
            }
            g.setColor(this.getForeground());
            this.imprimirTexto(g, textoSemHTML, aa, x, y, fonte);
        }
    }

    private void imprimirTexto(Graphics2D g, String textoSemHTML, AttributedCharacterIterator aa, int x, int y, Font fonte) {
        if (g instanceof PdfGraphics2D && textoSemHTML.matches("[^\\w\\s]+")) {
            ((PdfGraphics2D)g).customDrawSpecialCharacter(aa, (float)x, (float)y);
        } else {
            g.drawString(aa, x, y);
        }
    }

    private Atributos carregarAtributos(ArrayList<AtributosFonteTextoEstatico> aplicar) {
        Atributos atributos = new Atributos();
        for (AtributosFonteTextoEstatico at : aplicar) {
            if (at.estilo == StyleConstants.Italic) {
                atributos.add(at.posicaoInicial, at.posicaoFinal, TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            if (at.estilo == StyleConstants.Bold) {
                atributos.add(at.posicaoInicial, at.posicaoFinal, TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            if (at.estilo == StyleConstants.Underline) {
                atributos.add(at.posicaoInicial, at.posicaoFinal, TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (at.estilo == StyleConstants.Subscript) {
                atributos.add(at.posicaoInicial, at.posicaoFinal, TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
            }
            if (at.estilo != StyleConstants.Superscript) continue;
            atributos.add(at.posicaoInicial, at.posicaoFinal, TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
        }
        return atributos;
    }

    public String getTextoSemHTML() {
        String texto = this.getText();
        texto = texto.replace("&lt;", String.valueOf('\u0134'));
        texto = texto.replace("&gt;", String.valueOf('\u0135'));
        texto = texto.replace("&le;", String.valueOf('\u2264'));
        texto = texto.replace("&ge;", String.valueOf('\u2265'));
        texto = texto.replace("&hellip;", String.valueOf(' '));
        String textoSemHTML = texto.replaceAll("\\<.[html]*[b]*[i]*[u]*[sub]*[sup]*\\>", "");
        textoSemHTML = textoSemHTML.replaceAll(String.valueOf('\u0134'), "<");
        textoSemHTML = textoSemHTML.replaceAll(String.valueOf('\u0135'), ">");
        return textoSemHTML;
    }

    private boolean tagHTML(int posicaoInicial, String texto) {
        int j = posicaoInicial + 1;
        char[] array = texto.toCharArray();
        while (j < array.length) {
            if (array[j] == '/' || array[j] == 'u' || array[j] == 'b' || array[j] == 'i' || array[j] == 's') {
                return true;
            }
            if (j + 3 <= posicaoInicial) continue;
            break;
        }
        return false;
    }

    private int achaPosicaoTagAberta(ArrayList<AtributosFonteTextoEstatico> lista, Object estilo) {
        int retorno = -1;
        for (int i = lista.size() - 1; i >= 0; --i) {
            AtributosFonteTextoEstatico a = lista.get(i);
            if (!a.estilo.equals(estilo) || a.posicaoFinal != -1) continue;
            return i;
        }
        return retorno;
    }

    @Override
    public void pintar(Graphics g) {
        this.paint(g);
    }

    @Override
    public String getValorOriginal() {
        return this.getValor() != null ? this.getValor().toString() : "";
    }

    public boolean getQuebrarLinha() {
        return this.quebrarLinha;
    }

    public void setQuebrarLinha(boolean wordWrap) {
        this.quebrarLinha = wordWrap;
    }

    public boolean isConsiderarImpressaoPDF() {
        return this.considerarImpressaoPDF;
    }

    public void setConsiderarImpressaoPDF(boolean considerarImpressaoPDF) {
        this.considerarImpressaoPDF = considerarImpressaoPDF;
    }

    class AtributosFonteTextoEstatico {
        int posicaoInicial = -1;
        int posicaoFinal = -1;
        Object estilo;

        AtributosFonteTextoEstatico() {
        }
    }

    class Atributos {
        ArrayList<Atributo> lista = new ArrayList();

        Atributos() {
        }

        public void add(int posIni, int posFim, TextAttribute atributo, Object valor) {
            Atributo aux;
            int i;
            if (posFim <= posIni) {
                return;
            }
            HashMap<TextAttribute, Object> mapaNovo = new HashMap<TextAttribute, Object>();
            mapaNovo.put(atributo, valor);
            boolean interceptaFim = false;
            boolean interceptaIni = false;
            boolean interceptaContem = false;
            boolean interceptaContido = false;
            boolean interceptaCoincidente = false;
            for (i = 0; i < this.lista.size(); ++i) {
                aux = this.lista.get(i);
                if (posIni == aux.posIni && posFim == aux.posFim) {
                    interceptaCoincidente = true;
                    break;
                }
                if (posIni < aux.posIni && posFim >= aux.posIni && posFim <= aux.posIni) {
                    interceptaFim = true;
                    break;
                }
                if (posIni >= aux.posIni && posIni < aux.posFim && posFim >= aux.posFim) {
                    interceptaIni = true;
                    break;
                }
                if (posIni >= aux.posIni && posIni < aux.posFim && posFim >= aux.posIni && posFim < aux.posFim) {
                    interceptaContido = true;
                    break;
                }
                if (posIni >= aux.posIni || posFim <= aux.posFim) continue;
                interceptaContem = true;
                break;
            }
            if (interceptaIni || interceptaFim || interceptaContido || interceptaContem || interceptaCoincidente) {
                Atributo at1;
                HashMap<TextAttribute, Object> auxMapa;
                aux = this.lista.get(i);
                this.lista.remove(i);
                if (interceptaCoincidente) {
                    auxMapa = new HashMap<TextAttribute, Object>();
                    auxMapa.put(atributo, valor);
                    auxMapa.putAll(aux.mapa);
                    Atributo at = new Atributo(posIni, posFim, auxMapa);
                    this.lista.add(at);
                }
                if (interceptaIni) {
                    auxMapa = new HashMap();
                    auxMapa.put(atributo, valor);
                    auxMapa.putAll(aux.mapa);
                    at1 = new Atributo(aux.posIni, posIni, mapaNovo);
                    if (at1.posFim > at1.posIni) {
                        this.lista.add(at1);
                    }
                    Atributo at2 = new Atributo(posIni, aux.posFim, auxMapa);
                    this.lista.add(at2);
                    Atributo at3 = new Atributo(aux.posFim, posFim, aux.mapa);
                    this.lista.add(at3);
                } else if (interceptaFim) {
                    auxMapa = new HashMap();
                    auxMapa.putAll(mapaNovo);
                    auxMapa.putAll(aux.mapa);
                    at1 = new Atributo(aux.posIni, posIni, aux.mapa);
                    this.lista.add(at1);
                    Atributo at2 = new Atributo(posIni, aux.posFim + 1, auxMapa);
                    this.lista.add(at2);
                    Atributo at3 = new Atributo(aux.posFim + 1, posFim + 1, mapaNovo);
                    this.lista.add(at3);
                } else if (interceptaContido) {
                    auxMapa = new HashMap();
                    auxMapa.putAll(mapaNovo);
                    auxMapa.putAll(aux.mapa);
                    at1 = new Atributo(aux.posIni, posIni, aux.mapa);
                    if (at1.posFim > at1.posIni) {
                        this.lista.add(at1);
                    }
                    Atributo at2 = new Atributo(posIni, posFim, auxMapa);
                    this.lista.add(at2);
                    Atributo at3 = new Atributo(posFim, aux.posFim, aux.mapa);
                    this.lista.add(at3);
                } else if (interceptaContem) {
                    auxMapa = new HashMap();
                    auxMapa.putAll(mapaNovo);
                    auxMapa.putAll(aux.mapa);
                    at1 = new Atributo(posIni, aux.posIni, mapaNovo);
                    this.lista.add(at1);
                    Atributo at2 = new Atributo(aux.posIni, aux.posFim + 1, auxMapa);
                    this.lista.add(at2);
                    Atributo at3 = new Atributo(aux.posFim + 1, posFim + 1, mapaNovo);
                    this.lista.add(at3);
                }
            } else {
                Atributo at = new Atributo(posIni, posFim, mapaNovo);
                this.lista.add(at);
            }
        }

        class Atributo {
            int posIni = 0;
            int posFim = 0;
            Map<TextAttribute, Object> mapa = new HashMap<TextAttribute, Object>();

            public Atributo(int posIni, int posFim, Map<TextAttribute, Object> mapa) {
                this.posIni = posIni;
                this.posFim = posFim;
                this.mapa = mapa;
            }
        }
    }
}

