/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.impressao.componente;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.configurador.Constantes;
import jalis.laboratorio.configurador.ValoresReferencia;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ReguaReferencial;
import jalis.laboratorio.impressao.componente.ComponenteImpressao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class ReguaReferencialImpressao
extends JComponent
implements ComponenteImpressao {
    private ReguaReferencial dono;
    private Float valor;
    private static final DecimalFormat decfor = new DecimalFormat("0.00");

    @Override
    public Componente getDono() {
        return this.dono;
    }

    @Override
    public void setDono(Componente dono) {
        if (dono instanceof ReguaReferencial) {
            this.dono = (ReguaReferencial)dono;
        }
    }

    public void setValor(String str) {
        if (!Funcoes.textoVazio(str) && str.matches("\\-?\\d+(\\.\\d+)?")) {
            this.valor = new Float(str);
        }
    }

    @Override
    public Rectangle getDimensoes() {
        return this.dono == null ? new Rectangle() : this.dono.getDimensoes();
    }

    @Override
    public void setDimensoes(Rectangle rec) {
        if (this.dono != null) {
            this.dono.setDimensoes(rec);
        }
        this.setBounds(rec);
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.setDimensoes(new Rectangle(esquerda, topo, largura, altura));
    }

    @Override
    public String getNome() {
        return this.dono == null ? "" : this.dono.getNome();
    }

    public List getLigacoes() {
        return new ArrayList();
    }

    @Override
    public Point getPosicao() {
        return this.dono == null ? new Point() : this.dono.getLocation();
    }

    @Override
    public boolean imprimir() {
        return this.dono == null ? false : this.dono.getImprimir();
    }

    @Override
    public void pintar(Graphics g) {
        this.paint(g);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void paint(Graphics g) {
        block17: {
            block18: {
                block22: {
                    block24: {
                        block23: {
                            block19: {
                                block21: {
                                    block20: {
                                        block16: {
                                            g2 = (Graphics2D)g;
                                            width = this.getWidth();
                                            height = this.getHeight();
                                            y = height / 2;
                                            if (this.dono != null) break block16;
                                            g2.setColor(Color.red);
                                            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                                            break block17;
                                        }
                                        valores = this.dono.getValoresDeReferencia();
                                        atributosAlterado = this.dono.getAtributosAlterado();
                                        atributosNormal = this.dono.getAtributosNormal();
                                        atributosReguaMedia = this.dono.getAtributosReguaMedia();
                                        g2.setColor(this.dono.getCorDeFundo());
                                        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                                        if (this.dono.getTipoRegua() != 1) break block18;
                                        if (!atributosReguaMedia.getTipoPreenchimento().equals("Degrad\u00ea")) break block19;
                                        height = height <= 10 ? 15 : height;
                                        imagemGradiente = new BufferedImage(width, height - 10, 1);
                                        g2Gradient = imagemGradiente.createGraphics();
                                        cores = new Color[atributosReguaMedia.getAtributosReguas().size()];
                                        dist = new float[atributosReguaMedia.getAtributosReguas().size()];
                                        parteLargura = 1.0f / (float)atributosReguaMedia.getAtributosReguas().size();
                                        for (i = 0; i < atributosReguaMedia.getAtributosReguas().size(); ++i) {
                                            cores[i] = atributosReguaMedia.getAtributosReguas().get(i).getCor();
                                            dist[i] = (float)(i + 1) * parteLargura;
                                        }
                                        if (cores.length > 0) {
                                            primary = new LinearGradientPaint(0.0f, 0.0f, width, height, dist, cores);
                                            g2Gradient.setPaint(primary);
                                            g2Gradient.fillRect(0, 0, width, height - 10);
                                        }
                                        g2.drawImage((Image)imagemGradiente, 0, 5, null);
                                        minimo = atributosReguaMedia.getMinimo().toString().replace(".", ",");
                                        maximo = atributosReguaMedia.getMaximo().toString().replace(".", ",");
                                        if (valores != null) {
                                            valores.setValores(new String[]{minimo, minimo, maximo, maximo});
                                        } else {
                                            valores = ValoresReferencia.novaInstancia(1, "#####");
                                            valores.setValores(new String[]{minimo, minimo, maximo, maximo});
                                        }
                                        if (valores != null && !valores.zero() && !valores.invalido()) break block20;
                                        g2.drawLine(0, y, width - 1, y);
                                        break block17;
                                    }
                                    vlrs = this.dono.converteValores(valores);
                                    dist2 = vlrs[3] - vlrs[0];
                                    minimo = minimo.replace(",", ".");
                                    maximo = maximo.replace(",", ".");
                                    if (!minimo.matches("\\-?\\d+(\\.\\d+)?") || !maximo.matches("\\-?\\d+(\\.\\d+)?")) break block21;
                                    v0 = resultado = StringUtil.isEmpty(this.dono.getResultadoExpressaoMedia()) != false || this.dono.getResultadoExpressaoMedia().equals("null") != false ? null : new Float(this.dono.getResultadoExpressaoMedia());
                                    if (resultado != null) {
                                        v1 = new Float(minimo);
                                        if (resultado.floatValue() >= v1.floatValue()) {
                                            v2 = new Float(maximo);
                                            if (resultado.floatValue() <= v2.floatValue()) {
                                                pos = (int)((float)width * (resultado.floatValue() - vlrs[0]) / dist2);
                                                pos = pos < 1 ? 0 : (pos > width - 3 ? width - 3 : pos - 1);
                                                g2.setColor(atributosReguaMedia.getCorMedia());
                                                larguraCursor = atributosReguaMedia.getLarguraMedia() <= 0 ? 5 : atributosReguaMedia.getLarguraMedia();
                                                pos = larguraCursor + pos >= width ? width - larguraCursor : pos;
                                                g2.fillRect(pos, 0, larguraCursor, height);
                                                ** GOTO lbl163
                                            }
                                        }
                                    }
                                    break block17;
                                }
                                Funcoes.mensagem(Laboratorio.getInstancia(), "Valores m\u00ednimo e/ou m\u00e1ximo invalidos. Verifique a configura\u00e7\u00e3o da r\u00e9gua m\u00e9dia.", 1);
                                return;
                            }
                            height = height <= 10 ? 15 : height;
                            imagemGradiente = new BufferedImage(width, height - 10, 1);
                            g2Gradient = imagemGradiente.createGraphics();
                            cores = new Color[atributosReguaMedia.getAtributosReguas().size()];
                            for (i = 0; i < atributosReguaMedia.getAtributosReguas().size(); ++i) {
                                cores[i] = atributosReguaMedia.getAtributosReguas().get(i).getCor();
                            }
                            if (cores.length > 0) {
                                g2Gradient.setPaint(ReguaReferencial.paintReguaFixa(g2Gradient, width, height - 8, atributosReguaMedia));
                                g2Gradient.fillRect(0, 0, width, height - 10);
                            }
                            g2.drawImage((Image)imagemGradiente, 0, 5, null);
                            v3 = resultado = StringUtil.isEmpty(this.dono.getResultadoExpressaoMedia()) != false || this.dono.getResultadoExpressaoMedia().equals("null") != false ? null : new Float(this.dono.getResultadoExpressaoMedia());
                            if (resultado == null) break block17;
                            this.valor = Float.valueOf(resultado instanceof Number != false ? new Float(resultado.toString()).floatValue() : 0.0f);
                            this.dono.setResultadoExpressaoMedia(this.valor.toString());
                            minimo = atributosReguaMedia.getMinimo().toString().replace(",", ".");
                            maximo = atributosReguaMedia.getMaximo().toString().replace(",", ".");
                            valormin = 0.0f;
                            valormax = 0.0f;
                            dist2 = ReguaReferencial.getPosicoesReguaFixa(atributosReguaMedia);
                            for (i = 0; i < atributosReguaMedia.getAtributosReguas().size(); ++i) {
                                atrib = atributosReguaMedia.getAtributosReguas().get(i);
                                if (this.valor == null) continue;
                                v4 = new Float(atrib.getValorInicial().replace(",", "."));
                                if (!(this.valor.floatValue() >= v4.floatValue())) continue;
                                v5 = new Float(atrib.getValorFinal().replace(",", "."));
                                if (!(this.valor.floatValue() <= v5.floatValue())) continue;
                                minimo = atrib.getValorInicial().replace(",", ".");
                                maximo = atrib.getValorFinal().replace(",", ".");
                                valormin = dist2[i * 2];
                                valormax = dist2[i * 2 + 1];
                            }
                            if (valormax < 0.0f || valormin < 0.0f || valormin == valormax) break block17;
                            dist3 = new Float(maximo).floatValue() - new Float(minimo).floatValue();
                            min = (int)((float)width * valormin);
                            max = (int)((float)width * valormax);
                            if (!minimo.matches("\\-?\\d+(\\.\\d+)?") || !maximo.matches("\\-?\\d+(\\.\\d+)?")) break block22;
                            if (this.valor == null) break block17;
                            larguraCursor = atributosReguaMedia.getLarguraMedia() <= 0 ? 5 : atributosReguaMedia.getLarguraMedia();
                            pos = (int)((float)max * (this.valor.floatValue() - new Float(minimo).floatValue()) / dist3);
                            if (!this.valor.equals(new Float(maximo))) break block23;
                            pos = max;
                            pos = larguraCursor + pos >= width ? width - larguraCursor : pos;
                            break block24;
                        }
                        v6 = new Float(minimo);
                        if (!(this.valor.floatValue() > v6.floatValue())) ** GOTO lbl-1000
                        v7 = new Float(maximo);
                        if (this.valor.floatValue() < v7.floatValue()) {
                            intervalo2 = atributosReguaMedia.getMaximo().floatValue() - atributosReguaMedia.getMinimo().floatValue();
                            diferencaValorFinal = Float.valueOf(this.valor.floatValue() - atributosReguaMedia.getMinimo().floatValue());
                            posicaoInicial = Float.parseFloat(ReguaReferencialImpressao.decfor.format(diferencaValorFinal.floatValue() / intervalo2).replace(",", "."));
                            pos = pos < 1 ? 0 : (int)(posicaoInicial * (float)width);
                            pos = larguraCursor + pos >= max ? max : pos;
                            pos = larguraCursor + pos >= width ? width - larguraCursor : pos;
                        } else if (this.valor.equals(new Float(minimo))) {
                            pos = min;
                        }
                    }
                    g2.setColor(atributosReguaMedia.getCorMedia());
                    g2.fillRect(pos, 0, larguraCursor, height);
                    break block17;
                }
                Funcoes.mensagem(Laboratorio.getInstancia(), "Valores m\u00ednimo e/ou m\u00e1ximo invalidos. Verifique a configura\u00e7\u00e3o da r\u00e9gua m\u00e9dia.", 1);
                return;
            }
            if (valores == null || valores.zero() || valores.invalido()) {
                g2.setColor(Color.red);
                g2.setStroke(Constantes.SOLIDO);
                g2.drawLine(0, y, width - 1, y);
            } else {
                vlrs = this.dono.converteValores(valores);
                dist = vlrs[3] - vlrs[0];
                min = (int)((float)width * (vlrs[1] - vlrs[0]) / dist);
                max = (int)((float)width * (vlrs[2] - vlrs[0]) / dist);
                atributosAlterado.aplicarAtributos(g2);
                g2.drawLine(0, y, min, y);
                g2.drawLine(max, y, width - 1, y);
                atributosNormal.aplicarAtributos(g2);
                g2.drawLine(min, y, max, y);
                g2.setStroke(Constantes.SOLIDO);
                g2.drawLine(min, 2, min, height - 3);
                g2.drawLine(max, 2, max, height - 3);
                if (this.valor != null) {
                    pos = (int)((float)width * (this.valor.floatValue() - vlrs[0]) / dist);
                    pos = pos < 1 ? 0 : (pos > width - 3 ? width - 3 : pos - 1);
                    y = height / 4;
                    g2.setColor(Color.black);
                    g2.fillRect(pos, y, 3, height - y * 2);
                }
                g2.setColor(atributosAlterado.getCor());
            }
            g2.drawLine(0, 0, 0, height - 1);
            g2.drawLine(width - 1, 0, width - 1, height - 1);
        }
    }
}

