/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.impressao.componente;

import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.impressao.componente.ComponenteImpressao;
import jalis.util.ImagemUtils;
import jalis.util.logger.ErrorLogger;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.commons.codec.binary.Base64;

public class ImagemImpressao
extends JComponent
implements ComponenteImpressao {
    int alinHor;
    int alinVer;
    boolean estender;
    boolean imprimir;
    ImageIcon imagem;
    Componente dono;

    @Override
    public void setDono(Componente dono) {
        this.dono = dono;
    }

    @Override
    public Componente getDono() {
        return this.dono;
    }

    @Override
    public void setDimensoes(Rectangle rec) {
        if (this.dono != null) {
            this.dono.setDimensoes(rec);
        }
        this.setBounds(rec);
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.setDimensoes(new Rectangle(esquerda, topo, largura, altura));
    }

    @Override
    public Rectangle getDimensoes() {
        if (this.dono != null) {
            return this.dono.getDimensoes();
        }
        return this.getBounds();
    }

    @Override
    public Point getPosicao() {
        return this.getDimensoes().getLocation();
    }

    @Override
    public String getNome() {
        return this.getName();
    }

    @Override
    public List<String> getLigacoes() {
        if (this.dono != null) {
            return this.dono.getLigacoes();
        }
        return new ArrayList<String>();
    }

    public void setAlinhamentoHorizontal(int alin) {
        this.alinHor = alin;
    }

    public void setAlinhamentoVertical(int alin) {
        this.alinVer = alin;
    }

    public void setEstender(boolean estender) {
        this.estender = estender;
    }

    public void setImagem(String imagem) {
        if (imagem != null) {
            try {
                this.imagem = imagem.length() == 0 ? null : new ImageIcon(new Base64().decode(imagem));
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImagemImpressao: 139");
            }
        }
    }

    public String getImagem() {
        if (this.existeImagem()) {
            return new Base64().encodeAsString(ImagemUtils.imageToByte(this.imagem.getImage()));
        }
        return "";
    }

    public void setImprimir(boolean imprimir) {
        this.imprimir = imprimir;
    }

    @Override
    public boolean imprimir() {
        return this.imprimir;
    }

    @Override
    public void pintar(Graphics g) {
        if (this.existeImagem()) {
            Graphics2D g2D = (Graphics2D)g;
            if (this.estender) {
                g2D.drawImage(this.imagem.getImage(), 0, 0, this.getWidth(), this.getHeight(), null);
            } else {
                int x;
                int imgW = this.imagem.getIconWidth();
                int imgH = this.imagem.getIconHeight();
                int n = this.alinHor == 2 ? 0 : (x = this.alinHor == 4 ? this.getWidth() - imgW : (this.getWidth() - imgW) / 2);
                int y = this.alinVer == 1 ? 0 : (this.alinVer == 3 ? this.getHeight() - imgH : (this.getHeight() - imgH) / 2);
                g2D.drawImage(this.imagem.getImage(), x, y, this.imagem.getIconWidth(), this.imagem.getIconHeight(), null);
            }
        }
    }

    private boolean existeImagem() {
        return this.imagem != null;
    }

    @Override
    public void paint(Graphics g) {
        this.pintar(g);
    }
}

