/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.impressao.componente;

import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.Grafico;
import jalis.laboratorio.impressao.componente.ComponenteImpressao;
import jalis.util.StringUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class GraficoImpressao
extends JComponent
implements ComponenteImpressao {
    private Grafico dono;
    private int qtde;
    private List<String> valores;
    private List<String> rotulos1;
    private List<String> rotulos2;
    private String condicao = "";
    private String retornoExpressaoEixoX = "";
    private String retornoExpressaoEixoY = "";

    public void setQuantidade(int qtde) {
        this.qtde = qtde;
    }

    public void setValorResultado(String xml) {
        if (xml != null && xml.length() > 0 && this.dono != null) {
            xml = StringUtil.getTagEmMinusculas(StringUtil.getValor(xml, "valorGrafico"));
            this.valores = StringUtil.getListValores(xml, "valor");
            this.rotulos1 = StringUtil.getListValores(xml, "rotulo1");
            this.rotulos2 = StringUtil.getListValores(xml, "rotulo2");
        }
    }

    public void setCondicao(String condicao) {
        if (condicao != null) {
            this.condicao = condicao;
        }
    }

    public String getCondicao() {
        return this.condicao;
    }

    @Override
    public Point getPosicao() {
        return this.dono != null ? this.dono.getLocation() : new Point();
    }

    @Override
    public boolean imprimir() {
        return this.dono != null ? this.dono.getImprimir() : false;
    }

    @Override
    public void pintar(Graphics g) {
        this.paint(g);
    }

    @Override
    public void setDono(Componente dono) {
        if (dono instanceof Grafico) {
            this.dono = (Grafico)dono;
        }
    }

    @Override
    public Rectangle getDimensoes() {
        return this.dono != null ? this.dono.getDimensoes() : new Rectangle();
    }

    @Override
    public Componente getDono() {
        return this.dono;
    }

    @Override
    public List<String> getLigacoes() {
        return this.dono != null ? this.dono.getLigacoes() : new ArrayList();
    }

    @Override
    public String getNome() {
        return this.dono != null ? this.dono.getNome() : "";
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.setDimensoes(new Rectangle(esquerda, topo, largura, altura));
    }

    @Override
    public void setDimensoes(Rectangle rec) {
        if (this.dono != null) {
            this.dono.setDimensoes(rec);
        }
    }

    @Override
    public String getName() {
        return this.getNome();
    }

    @Override
    public void paint(Graphics g) {
        if (this.dono != null) {
            Graphics2D g2 = (Graphics2D)g;
            this.dono.desenharGrafico(g2);
            this.dono.desenharIntervaloLinhas(g2);
            this.dono.desenhaLinhaFixa(g2);
            ArrayList<String> rotulosTemp = new ArrayList<String>(this.rotulos1);
            if (this.rotulos1.size() > 0 && this.rotulos1.get(0).indexOf("<rotuloreferencia>") > -1) {
                rotulosTemp.clear();
                for (String s : this.rotulos1) {
                    rotulosTemp.add(StringUtil.getValor(s, "titulo"));
                }
            }
            this.dono.desenharRotulos(g2, this.qtde, rotulosTemp.toArray(new String[rotulosTemp.size()]), this.rotulos2.toArray(new String[this.rotulos2.size()]));
            Integer pontoFaixa = null;
            if (this.dono.getTipoGrafico() != 3 && !this.dono.getMultiplosCampos() && this.dono.getExpressaoEixoX().trim().length() > 0 && this.retornoExpressaoEixoX.trim().length() > 0) {
                if (this.retornoExpressaoEixoX.matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")) {
                    pontoFaixa = Integer.parseInt(this.retornoExpressaoEixoX);
                }
            } else if (this.dono.getTipoGrafico() == 3 && this.dono.getExpressaoEixoX().trim().length() > 0 && this.dono.getExpressaoEixoY().trim().length() > 0 && this.retornoExpressaoEixoX.trim().length() > 0 && this.retornoExpressaoEixoY.trim().length() > 0) {
                this.dono.desenharValores(g2, this.qtde, null, null, Double.parseDouble(this.retornoExpressaoEixoX), Double.parseDouble(this.retornoExpressaoEixoY));
            }
            if (this.dono.getTipoGrafico() != 3) {
                this.dono.desenharValores(g2, this.qtde, this.valores.toArray(new String[this.valores.size()]), pontoFaixa);
            }
        }
    }

    public void setRetornoExpressaoEixoX(String valor) {
        this.retornoExpressaoEixoX = valor;
    }

    public void setRetornoExpressaoEixoY(String valor) {
        this.retornoExpressaoEixoY = valor;
    }
}

