/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.impressao.componente;

import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.digitacao.Execucao;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.digitacao.componente.ComponenteResultado;
import jalis.laboratorio.digitacao.evento.CampoEvento;
import jalis.laboratorio.digitacao.evento.CampoListener;
import jalis.laboratorio.digitacao.evento.MensagemListener;
import jalis.laboratorio.impressao.componente.ComponenteImpressao;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.logger.ErrorLogger;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class FormaImpressao
extends JComponent
implements ComponenteImpressao,
CampoListener,
ComponenteResultado {
    private Componente dono;
    private int forma = -1;
    private int formaTemp;
    private int espessura = 1;
    private Color corLinha;
    private Color corPreenchimento;
    private boolean imprimir;
    private String condicao = "";
    private TabelaSimbolos tabela;
    private String campoBanco = "";
    private boolean removerVazio = true;
    private int arredondada = 0;

    @Override
    public void setDono(Componente dono) {
        this.dono = dono;
    }

    @Override
    public Componente getDono() {
        return this.dono;
    }

    @Override
    public void setDimensoes(Rectangle rec) {
        if (this.dono != null) {
            this.dono.setDimensoes(rec);
        }
        this.setBounds(rec);
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.setDimensoes(new Rectangle(esquerda, topo, largura, altura));
    }

    @Override
    public Rectangle getDimensoes() {
        if (this.dono != null) {
            return this.dono.getDimensoes();
        }
        return this.getBounds();
    }

    @Override
    public Point getPosicao() {
        return this.getDimensoes().getLocation();
    }

    @Override
    public List<String> getLigacoes() {
        return new ArrayList<String>();
    }

    @Override
    public boolean imprimir() {
        return this.imprimir;
    }

    @Override
    public String getNome() {
        return this.getName();
    }

    public void setImprimir(boolean imprimir) {
        this.imprimir = imprimir;
    }

    public void setForma(int forma) {
        if (forma != -1) {
            try {
                this.formaTemp = this.forma = forma;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "FormaImpress\u00e3o: 134");
            }
        } else {
            this.forma = -1;
            this.formaTemp = -1;
        }
    }

    public int getForma() {
        return this.forma;
    }

    public void setEspessura(int espessura) {
        this.espessura = espessura;
    }

    public int getEspessura() {
        return this.espessura;
    }

    public void setCorLinha(Color cor) {
        this.corLinha = cor;
    }

    public Color getCorLinha() {
        return this.corLinha;
    }

    public void setCorPreenchimento(Color cor) {
        this.corPreenchimento = cor;
    }

    public Color getCorPreenchimento() {
        return this.corPreenchimento;
    }

    public void setCondicao(String condicao) {
        if (condicao != null) {
            this.condicao = condicao;
        }
    }

    public String getCondicao() {
        return this.condicao;
    }

    public void setTabelaSimbolos(TabelaSimbolos tabela) {
        this.tabela = tabela;
    }

    @Override
    public String getCampoDeImportacao() {
        return this.dono != null ? this.dono.getCampoImportacao().campoImportacao : "";
    }

    public String getCampoDoBanco() {
        return this.campoBanco;
    }

    @Override
    public void pintar(Graphics g) {
        this.executar();
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.corPreenchimento.getRGB() == Color.black.getRGB() ? new Color(1, 1, 1) : this.corPreenchimento);
        switch (this.forma) {
            case 0: {
                g2.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.arredondada, this.arredondada);
                break;
            }
            case 1: {
                g2.fillOval(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                break;
            }
            case 4: {
                g2.fillPolygon(new int[]{1, this.getWidth() / 2, this.getWidth() - 1}, new int[]{this.getHeight() - 1, 1, this.getHeight() - 1}, 3);
                break;
            }
            case 5: {
                g2.fillPolygon(new int[]{1, this.getWidth() - 1, 1}, new int[]{1, this.getHeight() / 2, this.getHeight() - 1}, 3);
                break;
            }
            case 6: {
                g2.fillPolygon(new int[]{1, this.getWidth() / 2, this.getWidth() - 1}, new int[]{1, this.getHeight() - 1, 1}, 3);
                break;
            }
            case 7: {
                g2.fillPolygon(new int[]{this.getWidth() - 1, 1, this.getWidth() - 1}, new int[]{1, this.getHeight() / 2, this.getHeight() - 1}, 3);
            }
        }
        g2.setColor(this.corLinha.getRGB() == Color.black.getRGB() ? new Color(1, 1, 1) : this.corLinha);
        g2.setStroke(new BasicStroke(this.espessura));
        switch (this.forma) {
            case 0: {
                g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.arredondada, this.arredondada);
                break;
            }
            case 1: {
                g2.drawOval(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                break;
            }
            case 2: {
                g2.drawLine(0, this.getHeight() / 2, this.getWidth() - 1, this.getHeight() / 2);
                break;
            }
            case 3: {
                g2.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight() - 1);
                break;
            }
            case 4: {
                g2.drawPolygon(new int[]{1, this.getWidth() / 2, this.getWidth() - 1}, new int[]{this.getHeight() - 1, 1, this.getHeight() - 1}, 3);
                break;
            }
            case 5: {
                g2.drawPolygon(new int[]{1, this.getWidth() - 1, 1}, new int[]{1, this.getHeight() / 2, this.getHeight() - 1}, 3);
                break;
            }
            case 6: {
                g2.drawPolygon(new int[]{1, this.getWidth() / 2, this.getWidth() - 1}, new int[]{1, this.getHeight() - 1, 1}, 3);
                break;
            }
            case 7: {
                g2.drawPolygon(new int[]{this.getWidth() - 1, 1, this.getWidth() - 1}, new int[]{1, this.getHeight() / 2, this.getHeight() - 1}, 3);
            }
        }
    }

    public void executar() {
        if (this.tabela != null && this.getCondicao().trim().length() > 0) {
            Execucao exe = new Execucao(this.getCondicao(), this.tabela, 1);
            boolean res = exe.resultadoCondicao();
            if (!res) {
                this.forma = -1;
                this.setImprimir(res);
                this.repaint();
            } else if (this.formaTemp != -1 && this.forma == -1) {
                this.forma = this.formaTemp;
                this.setImprimir(true);
                this.repaint();
            }
        }
    }

    @Override
    public void digitouValor(CampoEvento e) {
        this.executar();
    }

    @Override
    public Object getValor() {
        return this.getForma();
    }

    @Override
    public String getValorOriginal() {
        return null;
    }

    @Override
    public boolean vazio() {
        return this.forma < 0;
    }

    @Override
    public boolean resultadoAnterior() {
        return false;
    }

    @Override
    public String getStringValor() {
        return String.valueOf(this.getForma());
    }

    @Override
    public boolean removerVazio() {
        return this.removerVazio;
    }

    @Override
    public void setRemoverVazio(boolean valor) {
        this.removerVazio = valor;
    }

    @Override
    public boolean salvarParcialmente() {
        return true;
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return 0;
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
    }

    @Override
    public void setValor(Object valor) {
        if (valor != null && valor instanceof Integer) {
            this.setForma((Integer)valor);
        }
    }

    @Override
    public void limpar() {
        this.setForma(0);
    }

    @Override
    public void carregarValorPadrao() {
    }

    @Override
    public void setProcessarPerdaDeFoco(boolean flag) {
    }

    @Override
    public void addCampoListener(CampoListener l) {
    }

    @Override
    public void removeCampoListener(CampoListener l) {
    }

    @Override
    public void addMensagemListener(MensagemListener l) {
    }

    @Override
    public void removeMensagemListener(MensagemListener l) {
    }

    @Override
    public boolean digitavel() {
        return false;
    }

    @Override
    public void setComponentesFoco(List<Component> list) {
    }

    @Override
    public boolean isRelacionavelComCampoDeImportacao() {
        return false;
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCampoDeImportacao() {
        return null;
    }

    public int getArredondada() {
        return this.arredondada;
    }

    public void setArredondada(int arredondada) {
        this.arredondada = arredondada;
    }
}

