/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.impressao.componente;

import jalis.laboratorio.configurador.componente.CodigoQRCode;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.digitacao.Execucao;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.impressao.componente.ComponenteImpressao;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class CodigoQRCodeImpressao
extends JComponent
implements ComponenteImpressao {
    private Componente dono;
    private String expressao;
    private boolean imprimir;
    private TabelaSimbolos tabela;

    @Override
    public void setDono(Componente dono) {
        this.dono = dono;
    }

    @Override
    public Componente getDono() {
        return this.dono;
    }

    @Override
    public void setDimensoes(Rectangle rec) {
        if (this.dono != null) {
            this.dono.setDimensoes(rec);
        }
        this.setBounds(rec);
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.setDimensoes(new Rectangle(esquerda, topo, largura, altura));
    }

    @Override
    public Rectangle getDimensoes() {
        if (this.dono != null) {
            return this.dono.getDimensoes();
        }
        return this.getBounds();
    }

    @Override
    public Point getPosicao() {
        return this.getDimensoes().getLocation();
    }

    @Override
    public List<String> getLigacoes() {
        return new ArrayList<String>();
    }

    @Override
    public boolean imprimir() {
        return this.imprimir;
    }

    public void setExpressao(String expressao) {
        this.expressao = expressao;
    }

    public String getExpressao() {
        return this.expressao;
    }

    @Override
    public String getNome() {
        return this.getName();
    }

    public void setImprimir(boolean imprimir) {
        this.imprimir = imprimir;
    }

    @Override
    public void pintar(Graphics g) {
        CodigoQRCode qrcode = (CodigoQRCode)this.getDono();
        qrcode.paint(g);
    }

    public void setTabelaSimbolos(TabelaSimbolos tabela) {
        this.tabela = tabela;
    }

    public void executar() {
        Execucao exe;
        Object res;
        if (this.tabela != null && (res = (exe = new Execucao(this.getExpressao(), this.tabela, 0)).resultadoExpressao()) != null) {
            String retorno = res.toString();
            CodigoQRCode qrcode = (CodigoQRCode)this.getDono();
            qrcode.setExpressao(retorno);
        }
    }
}

