/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.impressao.componente;

import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.impressao.componente.ComponenteImpressao;
import jalis.util.logger.ErrorLogger;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.commons.codec.binary.Base64;

public class AssinaturaImpressao
extends JComponent
implements ComponenteImpressao {
    private int alinHor;
    private int alinVer;
    private boolean estender;
    private String campoBanco;
    private ImageIcon imagem;
    private Componente dono;

    @Override
    public void setDimensoes(Rectangle rec) {
        if (this.dono != null) {
            this.dono.setDimensoes(rec);
        }
        this.setBounds(rec);
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.setDimensoes(new Rectangle(esquerda, topo, largura, altura));
    }

    @Override
    public Rectangle getDimensoes() {
        if (this.dono != null) {
            return this.dono.getDimensoes();
        }
        return this.getBounds();
    }

    @Override
    public Point getPosicao() {
        return this.getDimensoes().getLocation();
    }

    @Override
    public List<String> getLigacoes() {
        return new ArrayList<String>();
    }

    @Override
    public String getNome() {
        return this.getName();
    }

    public void setAlinhamentoHorizontal(int alin) {
        this.alinHor = alin;
    }

    public void setAlinhamentoVertical(int alin) {
        this.alinVer = alin;
    }

    public void setEstender(boolean estender) {
        this.estender = estender;
    }

    public void setCampoBanco(String campo) {
        this.campoBanco = campo;
    }

    public String getCampoBanco() {
        return this.campoBanco;
    }

    public void setImagem(String img) {
        if (img != null) {
            try {
                this.imagem = img.length() == 0 ? null : new ImageIcon(new Base64().decode(img));
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AssinaturaImpressao: 132");
            }
        }
    }

    public void setAlturaProporcional(int altura) {
        if (this.imagem != null) {
            if (altura < this.imagem.getIconHeight()) {
                this.setSize(new Dimension(altura * this.imagem.getIconWidth() / this.imagem.getIconHeight(), altura));
            } else {
                this.setSize(new Dimension(this.imagem.getIconWidth(), this.imagem.getIconHeight()));
            }
        }
    }

    @Override
    public boolean imprimir() {
        return true;
    }

    @Override
    public void pintar(Graphics g) {
        if (this.imagem != null) {
            if (this.estender) {
                g.drawImage(this.imagem.getImage(), 0, 0, this.getWidth(), this.getHeight(), null);
            } else {
                int x;
                int imgW = this.imagem.getIconWidth();
                int imgH = this.imagem.getIconHeight();
                int n = this.alinHor == 2 ? 0 : (x = this.alinHor == 4 ? this.getWidth() - imgW : (this.getWidth() - imgW) / 2);
                int y = this.alinVer == 1 ? 0 : (this.alinVer == 3 ? this.getHeight() - imgH : (this.getHeight() - imgH) / 2);
                g.drawImage(this.imagem.getImage(), x, y, this.imagem.getIconWidth(), this.imagem.getIconHeight(), null);
            }
        }
    }

    @Override
    public void setDono(Componente dono) {
        this.dono = dono;
    }

    @Override
    public Componente getDono() {
        return this.dono;
    }

    public int getAlinhamentoHorizontal() {
        return this.alinHor;
    }
}

