/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.impressao;

import jalis.comum.ParametrosLocais;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.Historico;
import jalis.laboratorio.digitacao.componente.ComponenteDigitacao;
import jalis.laboratorio.digitacao.componente.HistoricoDigitacao;
import jalis.laboratorio.impressao.CampoAssinaturaLaudo;
import jalis.laboratorio.impressao.componente.AssinaturaImpressao;
import jalis.laboratorio.impressao.componente.ComponenteImpressao;
import jalis.laboratorio.impressao.componente.TextoEstatico;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JTextPane;
import javax.swing.text.StyleConstants;

public class ImpressaoUtil {
    public static int alturaResultado(String resultado) {
        int retornoResultado;
        String xmlExame = StringUtil.getValor(resultado, "exame");
        int retornoImpressao = retornoResultado = StringUtil.getInt(xmlExame, "alturaResultado");
        if (!Funcoes.textoVazio(StringUtil.getValor(xmlExame, "alturaResultadoImpressao"))) {
            retornoImpressao = StringUtil.getInt(xmlExame, "alturaResultadoImpressao");
        }
        return retornoImpressao;
    }

    public static int alturaUtilPagina(String xml) {
        int altura = 0;
        if (xml != null) {
            String tmp = StringUtil.getValor(StringUtil.getValor(StringUtil.getValor(xml, "exame"), "pagina"), "propriedades");
            altura = StringUtil.getInt(StringUtil.getValor(tmp, "dimensoes"), "altura");
            altura -= StringUtil.getInt(tmp, "margemSuperior");
            altura -= StringUtil.getInt(tmp, "margemInferior");
            altura -= StringUtil.getInt(tmp, "alturaCabecalho");
            altura -= StringUtil.getInt(tmp, "alturaRodape");
        }
        return altura;
    }

    public static int distanciaEntreExames(String xml) {
        int distancia = 0;
        if (xml != null) {
            String tmp = StringUtil.getValor(StringUtil.getValor(StringUtil.getValor(xml, "exame"), "pagina"), "propriedades");
            distancia = StringUtil.getInt(tmp, "distanciaExames");
        }
        return distancia;
    }

    public static String[] divideResultado(String resultado, int altura) {
        if (ImpressaoUtil.isResultadoRtf(resultado)) {
            return new String[0];
        }
        int altura1 = 0;
        int altura2 = 0;
        StringBuilder parte1 = new StringBuilder();
        StringBuilder parte2 = new StringBuilder();
        String tmp = StringUtil.getValor(resultado, "exame");
        String versao = StringUtil.getValor(tmp, "versao");
        tmp = StringUtil.getValor(tmp, "resultado");
        for (String comp : StringUtil.getListValores(tmp, "componente")) {
            Rectangle rec = ImpressaoUtil.getRetanguloComponente(comp);
            int yMaisHeight = rec.y + rec.height;
            if (yMaisHeight > altura) {
                comp = ImpressaoUtil.setAltura(comp, yMaisHeight - altura);
                if (yMaisHeight - altura + rec.height > altura2) {
                    altura2 = yMaisHeight - altura + rec.height;
                }
                parte2.append(StringUtil.getTag("componente", comp));
                continue;
            }
            if (yMaisHeight > altura1) {
                altura1 = yMaisHeight;
            }
            parte1.append(StringUtil.getTag("componente", comp));
        }
        StringBuilder um = ImpressaoUtil.montaPagina(altura1, parte1, versao);
        StringBuilder dois = ImpressaoUtil.montaPagina(altura2, parte2, versao);
        return new String[]{um.toString(), dois.toString()};
    }

    private static boolean isResultadoRtf(String resultado) {
        return resultado.contains("jalis.laboratorio.configurador.componente.Rotulo") && resultado.contains("<resultadoRtf>true</resultadoRtf>");
    }

    public static String[] divideResultadoRtf(String resultado, int altura, String[] divisao) {
        if (!ImpressaoUtil.isResultadoRtf(resultado)) {
            return divisao;
        }
        int altura1 = 0;
        int altura2 = 0;
        int alturaAnt = 0;
        int alturaAtt = 0;
        int yTopo = 0;
        String compAnt = "";
        StringBuilder parte1 = new StringBuilder();
        StringBuilder parte2 = new StringBuilder();
        String tmp = StringUtil.getValor(resultado, "exame");
        String versao = StringUtil.getValor(tmp, "versao");
        tmp = StringUtil.getValor(tmp, "resultado");
        for (String comp : StringUtil.getListValores(tmp, "componente")) {
            Rectangle rec = ImpressaoUtil.getRetanguloComponente(comp);
            int yMaisHeight = rec.y + rec.height;
            alturaAtt = Integer.parseInt(StringUtil.getValor(comp, "topo"));
            if (yMaisHeight > altura - 10) {
                if (!ImpressaoUtil.componenteTipoImagemRtf(comp)) {
                    comp = ImpressaoUtil.setAltura(comp, yMaisHeight - altura);
                }
                if (yMaisHeight - altura + rec.height > altura2) {
                    altura2 = yMaisHeight - altura + rec.height;
                }
                if (Funcoes.textoVazio(parte2.toString()) && ImpressaoUtil.componenteTipoImagemRtf(compAnt) && ImpressaoUtil.componenteTipoRotuloRtf(comp)) {
                    comp = ImpressaoUtil.setTopo(comp, Integer.valueOf(StringUtil.getValor(comp, "altura")));
                    parte2.append(StringUtil.getTag("componente", comp));
                } else if (ImpressaoUtil.componenteTipoImagemRtf(comp) || ImpressaoUtil.componenteTipoRotuloRtf(comp)) {
                    if (alturaAtt != alturaAnt) {
                        yTopo += alturaAtt - alturaAnt;
                    }
                    comp = ImpressaoUtil.setTopo(comp, yTopo);
                    parte2.append(StringUtil.getTag("componente", comp));
                } else {
                    parte2.append(StringUtil.getTag("componente", comp));
                }
            } else {
                if (yMaisHeight > altura1) {
                    altura1 = yMaisHeight;
                }
                parte1.append(StringUtil.getTag("componente", comp));
            }
            alturaAnt = alturaAtt;
            compAnt = comp;
        }
        StringBuilder um = ImpressaoUtil.montaPagina(altura1, parte1, versao);
        StringBuilder dois = ImpressaoUtil.montaPagina(altura2 + 35, parte2, versao);
        return new String[]{um.toString(), dois.toString()};
    }

    private static String getComponentePaginaDois(int yTopo, String comp, String compAnt, int alturaAtt, int alturaAnt, String pagina2) {
        if (Funcoes.textoVazio(pagina2) && ImpressaoUtil.componenteTipoImagemRtf(compAnt) && ImpressaoUtil.componenteTipoRotuloRtf(comp)) {
            comp = ImpressaoUtil.setTopo(comp, Integer.valueOf(StringUtil.getValor(comp, "altura")));
            return StringUtil.getTag("componente", comp);
        }
        if (ImpressaoUtil.componenteTipoImagemRtf(comp) || ImpressaoUtil.componenteTipoRotuloRtf(comp)) {
            if (alturaAtt != alturaAnt) {
                yTopo += alturaAtt - alturaAnt;
            }
            comp = ImpressaoUtil.setTopo(comp, yTopo);
            return StringUtil.getTag("componente", comp);
        }
        return StringUtil.getTag("componente", comp);
    }

    private static boolean componenteTipoRotuloRtf(String comp) {
        return StringUtil.getValor(comp, "tipo").equals("jalis.laboratorio.configurador.componente.Rotulo") && Boolean.parseBoolean(StringUtil.getValor(comp, "resultadoRtf"));
    }

    private static boolean componenteTipoImagemRtf(String comp) {
        return StringUtil.getValor(comp, "tipo").equals("jalis.laboratorio.configurador.componente.Imagem");
    }

    private static StringBuilder montaPagina(int altura, StringBuilder parte, String versao) {
        StringBuilder um = new StringBuilder("<exame><versao>");
        um.append(versao);
        um.append("</versao><tipo>resultado</tipo><alturaResultado>");
        um.append(altura);
        um.append("</alturaResultado><resultado>");
        um.append((CharSequence)parte);
        um.append("</resultado></exame>");
        return um;
    }

    public static void pintar(Graphics2D g, List<ComponenteImpressao> itens, Point2D ref) {
        ListIterator<ComponenteImpressao> list = itens.listIterator(itens.size());
        while (list.hasPrevious()) {
            ComponenteImpressao comp = list.previous();
            if (!comp.imprimir()) continue;
            Rectangle rec = comp.getDimensoes();
            double x = ref.getX() + (double)rec.x;
            double y = ref.getY() + (double)rec.y;
            g.setClip((int)x, (int)y, rec.width + 15, rec.height);
            g.translate(x, y);
            comp.pintar(g);
            g.translate(-x, -y);
        }
    }

    private static boolean isAlinhamentoJustificado(JTextPane jtp) {
        return jtp.getParagraphAttributes().containsAttribute(StyleConstants.Alignment, 3);
    }

    private static boolean isSimularFontesDesativado() {
        return Funcoes.objectIsNull(ParametrosLocais.getParametro("simularAumentoFonteImpressao")) || ParametrosLocais.getParametro("simularAumentoFonteImpressao").equals("0");
    }

    private static boolean aplicarEspacamentoEntrePalavras(ComponenteImpressao comp) {
        int palavrasMaiusculas = 0;
        int palavrasNoComp = 0;
        for (String str : ((JTextPane)((Object)comp)).getText().split(" ")) {
            ++palavrasNoComp;
            if (!str.trim().equals(str.trim().toUpperCase())) continue;
            ++palavrasMaiusculas;
        }
        return palavrasMaiusculas > palavrasNoComp / 2 && ImpressaoUtil.isSimularFontesDesativado();
    }

    public static void pintarCabecalho(Graphics2D g, List<ComponenteImpressao> itens, Point2D ref) {
        ListIterator<ComponenteImpressao> list = itens.listIterator(itens.size());
        while (list.hasPrevious()) {
            ComponenteImpressao comp = list.previous();
            if (!comp.imprimir()) continue;
            Rectangle rec = comp.getDimensoes();
            double x = ref.getX() + (double)rec.x;
            double y = ref.getY() + (double)rec.y;
            g.setClip((int)x, (int)y, rec.width + 15, rec.height);
            g.translate(x, y);
            comp.pintar(g);
            g.translate(-x, -y);
        }
    }

    public static List<ComponenteImpressao> getComponentesImpressao(List<Component> comps, boolean considerarImpressaoPDF) {
        ArrayList<ComponenteImpressao> lista = new ArrayList<ComponenteImpressao>();
        for (Component obj : comps) {
            if (obj instanceof ComponenteDigitacao) {
                ComponenteDigitacao dig = (ComponenteDigitacao)((Object)obj);
                Componente comp = dig.getDono();
                boolean vazio = dig.vazio();
                comp.setValorResultado(vazio ? "" : dig.getStringValor());
                comp.setSalvoValor(!vazio);
                obj = comp.getComponenteDigitacao(false);
            }
            if (obj instanceof TextoEstatico && considerarImpressaoPDF) {
                ((TextoEstatico)obj).setConsiderarImpressaoPDF(considerarImpressaoPDF);
            }
            if (!(obj instanceof ComponenteImpressao)) continue;
            lista.add((ComponenteImpressao)((Object)obj));
        }
        return lista;
    }

    public static List<ComponenteImpressao> getComponentesImpressao(String resultado, Map<String, String> assinaturas, boolean considerarImpressaoPDF) {
        ArrayList<ComponenteImpressao> lista = new ArrayList<ComponenteImpressao>();
        try {
            String xml = StringUtil.getValor(StringUtil.getValor(resultado, "exame"), "resultado");
            for (String item : StringUtil.getListValores(xml, "componente")) {
                Componente comp = (Componente)Class.forName(StringUtil.getValor(item, "tipo")).newInstance();
                comp.setAtributos(StringUtil.getValor(item, "atributos"));
                Component c = comp.getComponenteDigitacao(false);
                if (!(c instanceof ComponenteImpressao)) continue;
                if (c instanceof TextoEstatico) {
                    String versaoXML;
                    if ((((TextoEstatico)c).getDono() instanceof Historico || ((TextoEstatico)c).getDono() instanceof HistoricoDigitacao) && ((versaoXML = StringUtil.getValor(resultado, "versao")).equalsIgnoreCase("1.0") || versaoXML.equalsIgnoreCase("2.0"))) {
                        ((TextoEstatico)c).setHorizontalAlignment(2);
                    }
                    ((TextoEstatico)c).setConsiderarImpressaoPDF(considerarImpressaoPDF);
                } else if (c instanceof AssinaturaImpressao && assinaturas != null) {
                    AssinaturaImpressao ass = (AssinaturaImpressao)c;
                    String campoBanco = Funcoes.textoVazio(ass.getCampoBanco()) ? CampoAssinaturaLaudo.USUARIO_CONFERENCIA.getIdParaXML() : ass.getCampoBanco();
                    ass.setImagem(assinaturas.get(campoBanco));
                }
                lista.add((ComponenteImpressao)((Object)c));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImpressaoUtil: 190");
        }
        return lista;
    }

    private static Rectangle getRetanguloComponente(String xml) {
        String atr = StringUtil.getValor(xml, "atributos");
        return new Rectangle(StringUtil.getInt(atr, "esquerda"), StringUtil.getInt(atr, "topo"), StringUtil.getInt(atr, "largura"), StringUtil.getInt(atr, "altura"));
    }

    private static String setAltura(String xml, int altura) {
        StringBuilder bui = new StringBuilder(xml);
        StringUtil.setValor(bui, "altura", String.valueOf(altura));
        return bui.toString();
    }

    private static String setTopo(String xml, int topo) {
        StringBuilder bui = new StringBuilder(xml);
        StringUtil.setValor(bui, "topo", String.valueOf(topo));
        return bui.toString();
    }

    public static int contaPaginasResultado(String resultado) {
        int totalPaginas = 1;
        List<String> componentesLocalizados = StringUtil.getListValores(resultado, "componente");
        for (String componente : componentesLocalizados) {
            int contador = StringUtil.getValor(componente, "contadorPagina").matches("\\d+") ? StringUtil.getInt(componente, "contadorPagina") : 1;
            if (contador <= totalPaginas) continue;
            totalPaginas = contador;
        }
        return totalPaginas;
    }

    public static String removerComponentesOutraPagina(String resultado, int pagina) {
        StringBuilder buiTemp = new StringBuilder();
        List<String> componentesLocalizados = StringUtil.getListValores(resultado, "componente");
        String versao = StringUtil.getValor(resultado, "versao");
        for (String componente : componentesLocalizados) {
            int contador = StringUtil.getValor(componente, "contadorPagina").matches("\\d+") ? StringUtil.getInt(componente, "contadorPagina") : 1;
            if (contador != pagina) continue;
            buiTemp.append("<componente>").append(componente).append("</componente>");
        }
        StringBuilder novoExame = new StringBuilder("<exame><versao>");
        novoExame.append(versao);
        novoExame.append("</versao><tipo>resultado</tipo><alturaResultado>");
        novoExame.append(ImpressaoUtil.calculaAlturaNovoResultadoMultiplasPaginas(buiTemp.toString()));
        novoExame.append("</alturaResultado><resultado>");
        novoExame.append((CharSequence)buiTemp);
        novoExame.append("</resultado></exame>");
        return novoExame.toString();
    }

    public static int calculaAlturaNovoResultadoMultiplasPaginas(String resultado) {
        int altura = 0;
        List<String> componentesLocalizados = StringUtil.getListValores(resultado, "componente");
        for (String componente : componentesLocalizados) {
            int alturaComponente;
            int posicaoY = StringUtil.getValor(componente, "topo").matches("\\d+") ? StringUtil.getInt(componente, "topo") : 0;
            int tmp = posicaoY + (alturaComponente = StringUtil.getValor(componente, "altura").matches("\\d+") ? StringUtil.getInt(componente, "altura") : 0);
            if (tmp <= altura) continue;
            altura = tmp;
        }
        return altura;
    }
}

