/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.impressao;

import br.com.thread.openpdf.text.pdf.PdfWriter;
import br.com.thread.pdfbox.pdmodel.PDDocument;
import br.com.thread.pdfbox.printing.Orientation;
import br.com.thread.pdfbox.printing.PDFPageable;
import jalis.laboratorio.impressao.Documento;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.awt.print.Book;
import java.awt.print.Pageable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterJob;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;

public class Impressao {
    private PrintService servicoImpressao;
    private PdfWriter writer = null;

    public Impressao(String nomeImpressora) {
        this.setImpressora(nomeImpressora);
    }

    public void setImpressora(String nomeImpressora) {
        if (nomeImpressora == null || nomeImpressora.trim().length() == 0 || nomeImpressora.trim().equalsIgnoreCase("Impressora local")) {
            this.servicoImpressao = PrintServiceLookup.lookupDefaultPrintService();
        } else if (nomeImpressora != null) {
            this.localizarImpressora(nomeImpressora);
        }
    }

    public void imprimir(final Documento doc) {
        if (this.servicoImpressao != null) {
            doc.setVariavel("dataImpressao", new Date());
            new Thread(){

                @Override
                public void run() {
                    block2: {
                        try {
                            PrinterJob job = PrinterJob.getPrinterJob();
                            job.setPrintService(Impressao.this.servicoImpressao);
                            job.setJobName("Impressao de requisicao - Jalis - " + Funcoes.formataData("dd_MM_yyyy_HH_mm_ss", new Date()));
                            job.setPrintable(doc, doc.getFormatoPagina());
                            job.setCopies(doc.getCopias());
                            job.print();
                        }
                        catch (Exception e) {
                            if (Funcoes.textoVazio(e.getMessage())) break block2;
                            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Impressao: 89");
                        }
                    }
                }
            }.start();
        }
    }

    public void imprimirAgrupadosThread(final Book bk, final int copias) {
        if (this.servicoImpressao != null) {
            new Thread(){

                @Override
                public void run() {
                    Impressao.this.imprimirAgrupados(bk, copias);
                }
            }.start();
        }
    }

    public void imprimirAgrupados(Book bk, int copias) {
        block2: {
            try {
                PrinterJob job = PrinterJob.getPrinterJob();
                job.setPrintService(this.servicoImpressao);
                job.setJobName("Impressao de requisicao - Jalis - " + Funcoes.formataData("dd_MM_yyyy_HH_mm_ss", new Date()));
                job.setPageable(bk);
                job.setCopies(copias);
                job.print();
            }
            catch (Exception e) {
                if (Funcoes.textoVazio(e.getMessage())) break block2;
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Impressao: 89");
            }
        }
    }

    public void imprimirDocumentThread(final byte[] dados) {
        if (this.servicoImpressao != null) {
            new Thread(){

                @Override
                public void run() {
                    Impressao.this.imprimirDocument(dados);
                }
            }.start();
        }
    }

    public void imprimirDocument(byte[] dados) {
        block15: {
            if (this.servicoImpressao != null) {
                try (PDDocument documento = PDDocument.load((byte[])dados);){
                    PrintService servico = this.servicoImpressao;
                    PrinterJob job = PrinterJob.getPrinterJob();
                    job.setJobName("Impressao de requisicao - Jalis - " + Funcoes.formataData("dd_MM_yyyy_HH_mm_ss", new Date()));
                    job.setPageable((Pageable)new PDFPageable(documento, Orientation.AUTO, false, 288.0f, 0));
                    job.setPrintService(servico);
                    job.print();
                    documento.close();
                }
                catch (Exception e) {
                    if (Funcoes.textoVazio(e.getMessage())) break block15;
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Impressao: 89");
                }
            }
        }
    }

    public void imprimirSemThread(Documento doc) {
        block4: {
            if (this.servicoImpressao != null) {
                doc.setVariavel("dataImpressao", new Date());
                try {
                    PrinterJob job = PrinterJob.getPrinterJob();
                    job.setPrintService(this.servicoImpressao);
                    job.setJobName("Impressao de requisicao - Jalis - " + Funcoes.formataData("dd_MM_yyyy_HH_mm_ss", new Date()));
                    job.setPrintable(doc, doc.getFormatoPagina());
                    job.setCopies(doc.getCopias());
                    job.print();
                }
                catch (PrinterAbortException job) {
                }
                catch (Exception e) {
                    if (Funcoes.textoVazio(e.getMessage())) break block4;
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Impressao: 89");
                }
            }
        }
    }

    private void localizarImpressora(String nomeImpressora) {
        boolean encontrou = false;
        PrintService[] services = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
        for (int i = 0; i < services.length; ++i) {
            if (!services[i].getName().equalsIgnoreCase(nomeImpressora)) continue;
            this.servicoImpressao = services[i];
            encontrou = true;
            break;
        }
        if (!encontrou) {
            ErrorLogger.mostraMensagem(null, "A impressora \"" + nomeImpressora + "\" n\u00e3o foi encontrada.", null);
        }
    }

    public static class Variaveis {
        public static final String NUMERO_PAGINA = "numeroPagina";
        public static final String NUMERO_PAGINA_INMETRO = "numeroPaginaInmetro";
        public static final String NUMERO_PAGINA_NAO_CERTIFICADOS = "numeroPaginaNaoCertificados";
        public static final String QUANTIDADE_PAGINAS = "quantidadePaginas";
        public static final String QUANTIDADE_PAGINAS_INMETRO = "quantidadePaginasInmetro";
        public static final String QUANTIDADE_PAGINAS_NAO_CERTIFICADOS = "quantidadePaginasNaoCertificados";
        public static final String DATA_IMPRESSAO = "dataImpressao";
        public static final String DATA_ATUAL = "dataAtual";
        public static final String REFERENCIAS_METODO = "referenciasMetodologia";
        public static final String DESCRICAO_SETORES = "descricaoSetores";
        public static final String SOA_EXAMES = "SOAExames";
        public static final String COA_EXAMES = "COAExames";
        public static final String CODIGOS_EXAMES = "codigosExames";
        public static final String INMETRO_PAGINA = "inmetroNaPagina";

        public static String[] getVariaveis() {
            ArrayList<String> vars = new ArrayList<String>();
            try {
                Field[] f = Variaveis.class.getDeclaredFields();
                for (int i = 0; i < f.length; ++i) {
                    if (f[i].getType() != String.class) continue;
                    String variavel = (String)f[i].get(null);
                    if (!jalis.comum.Variaveis.tipoFilialPadrao.equals("A") && (variavel.contains(NUMERO_PAGINA_INMETRO) || variavel.contains(QUANTIDADE_PAGINAS_INMETRO) || variavel.contains(NUMERO_PAGINA_NAO_CERTIFICADOS) || variavel.contains(QUANTIDADE_PAGINAS_NAO_CERTIFICADOS))) continue;
                    vars.add(variavel);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Impressao.Variaveis: 44");
            }
            return vars.toArray(new String[vars.size()]);
        }
    }
}

