/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.impressao;

import jalis.comum.ParametrosLocais;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.expressao.Token;
import jalis.laboratorio.configurador.pagina.LinhasCorpo;
import jalis.laboratorio.configurador.pagina.ParametrosAssinatura;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.digitacao.componente.CodigoBarrasDigitacao;
import jalis.laboratorio.digitacao.componente.ComponenteDigitacao;
import jalis.laboratorio.digitacao.componente.ComponenteResultado;
import jalis.laboratorio.digitacao.componente.ComponenteValor;
import jalis.laboratorio.digitacao.componente.DadosDigitacao;
import jalis.laboratorio.digitacao.componente.ExpressaoDigitacao;
import jalis.laboratorio.digitacao.componente.ImagemDigitacao;
import jalis.laboratorio.impressao.CampoAssinaturaLaudo;
import jalis.laboratorio.impressao.ExameMaterialPagina;
import jalis.laboratorio.impressao.ImpressaoUtil;
import jalis.laboratorio.impressao.PreencherAreaLivre;
import jalis.laboratorio.impressao.ResultadoNaPagina;
import jalis.laboratorio.impressao.componente.AssinaturaImpressao;
import jalis.laboratorio.impressao.componente.CodigoQRCodeImpressao;
import jalis.laboratorio.impressao.componente.ComponenteImpressao;
import jalis.laboratorio.impressao.componente.TextoEstatico;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;

public class Documento
implements Printable,
Serializable {
    private final boolean IMPRIMIR_PARA_ARQUIVO = false;
    private final String CAMINHO_ARQUIVO = "/home/junior/exames/";
    private float margemAssinaturaDigital = 0.0f;
    private final int ASSINATURA_SUMARIO = 0;
    private final int ASSINATURA_RODAPE = 1;
    private List<String[]> resultados = new ArrayList<String[]>();
    private ArrayList<ExameMaterialPagina[]> exames = new ArrayList();
    private ArrayList<String[]> referencias = new ArrayList();
    private ArrayList<String[]> setores = new ArrayList();
    private ArrayList<String[]> soas = new ArrayList();
    private ArrayList<String[]> coas = new ArrayList();
    private ArrayList<Boolean[]> inmetros = new ArrayList();
    private List<Map<String, String>[]> assinaturas = new ArrayList<Map<String, String>[]>();
    private List<ResultadoNaPagina[]> resPorPagina = new ArrayList<ResultadoNaPagina[]>();
    private List<ExameMaterialPagina[]> exmPorPagina = new ArrayList<ExameMaterialPagina[]>();
    private List<String[]> refPorPagina = new ArrayList<String[]>();
    private List<String[]> setPorPagina = new ArrayList<String[]>();
    private List<String[]> soaPorPagina = new ArrayList<String[]>();
    private List<String[]> coaPorPagina = new ArrayList<String[]>();
    private List<Boolean> inmetroPorPagina = new ArrayList<Boolean>();
    private List<Map<String, String>[]> assPorPagina = new ArrayList<Map<String, String>[]>();
    private List<Component> cabecalho = new ArrayList<Component>();
    private List<Component> sumario = new ArrayList<Component>();
    private List<Component> rodape = new ArrayList<Component>();
    private List<Component> rodapeExame = new ArrayList<Component>();
    private String xmlRodapeExame = "";
    private String mascaraPdf = "";
    private List<ExpressaoDigitacao> expressoes = new ArrayList<ExpressaoDigitacao>();
    private List<CodigoQRCodeImpressao> codigosQrCode = new ArrayList<CodigoQRCodeImpressao>();
    private Map<String, ComponenteResultado> compResultado = new HashMap<String, ComponenteResultado>();
    private ParametrosAssinatura assinaturaSumario;
    private ParametrosAssinatura assinaturaRodape;
    private TabelaSimbolos tabelaSimbolo = new TabelaSimbolos();
    private int alturaCabecalho;
    private int alturaSumario;
    private int alturaRodape;
    private int alturaRodapeExame;
    private int larguraAreaImpressao;
    private int alturaAreaImpressao;
    private int quantidadePaginas;
    private int quantidadePaginasInmetro;
    private int quantidadePaginasNaoCertificados;
    private boolean exibirSumario;
    private boolean exibirReferenciaSumario;
    private boolean exibirRodapeExame;
    private boolean calculouPaginas;
    private PrintRequestAttributeSet atributos = new HashPrintRequestAttributeSet();
    private int margemEsquerda;
    private int margemDireita;
    private int margemSuperior;
    private int margemInferior;
    private int distanciaExames;
    private String separadorExames = ",";
    private String separadorCOA = ",";
    private String separadorSOA = ",";
    private LinhasCorpo lc = null;
    private boolean criarPdf = false;
    private String arquivoPdf = "";
    private boolean considerarPDF = false;
    private PreencherAreaLivre areaLivre = null;
    private int alturaReferencia;
    private int posicaoReferencia;
    private int alinhamentoReferencia;
    private Font fonteReferencia = null;
    private int copias = 1;
    private boolean sempreReposicionarEntrePaginas = false;
    private PageFormat formatoPagina = new PageFormat();
    private boolean isAssinarDigitalmente = false;
    private int posicaoAssinaturaHorizontal = 0;
    private int posicaoAssinaturaVertical = 0;
    private CampoAssinaturaLaudo campoAssinatura = null;
    private boolean isGerarPDF = false;
    private int posicaoVerticalAbsolutaAssinatura = 0;
    private boolean temCertificadoRT = false;
    private boolean temCertificadoRTSub = false;
    private float qualidadeImagensPDF = 100.0f;

    public void setCabecalhoRodape(String atributos) {
        String xmlTagExame = StringUtil.getValor(atributos, "exame");
        atributos = StringUtil.getValor(xmlTagExame, "pagina");
        this.setMascaraPdf(xmlTagExame);
        this.carregarAtributos(StringUtil.getValor(atributos, "propriedades"));
        this.carregarItens(StringUtil.getValor(atributos, "itens"));
        String tmp = "";
        tmp = StringUtil.getValor(atributos, "parametrosAreaLivre");
        if (!Funcoes.textoVazio(tmp)) {
            this.areaLivre = new PreencherAreaLivre(StringUtil.getBoolean(tmp, "preencher"), StringUtil.getValor(tmp, "tipo"), StringUtil.getValor(tmp, "valor"));
            this.areaLivre.setFonteMensagem(StringUtil.getFonte(StringUtil.getValor(tmp, "fontemensagem")));
        }
    }

    public void setMargemAssinaturaDigital(float margemAssinaturaDigital) {
        this.margemAssinaturaDigital = margemAssinaturaDigital;
    }

    public float getMargemAssinaturaDigital() {
        return this.margemAssinaturaDigital;
    }

    public int getQuantidadeResultados() {
        return this.resultados != null ? this.resultados.size() : 0;
    }

    public void addResultados(ExameMaterialPagina[] exm, String[] res) {
        this.addResultados(exm, res, new HashMap[res.length], new String[res.length], new String[res.length], new String[res.length], new String[res.length], null);
    }

    public void addResultados(ExameMaterialPagina[] exm, String[] res, Map<String, String>[] ass, String[] ref, String[] set) {
        this.addResultados(exm, res, ass, ref, new String[res.length], new String[res.length], set, null);
    }

    public void addResultados(ExameMaterialPagina[] exm, String[] res, String[] set) {
        this.addResultados(exm, res, new HashMap[res.length], new String[res.length], new String[res.length], new String[res.length], set, null);
    }

    public void addResultados(ExameMaterialPagina[] exm, String[] res, Map<String, String>[] ass, String[] ref, String[] soa, String[] coa, String[] set) {
        this.addResultados(exm, res, ass, ref, soa, coa, set, null);
    }

    public void addResultados(ExameMaterialPagina[] exm, String[] res, Map<String, String>[] ass, String[] ref, String[] soa, String[] coa, String[] set, Boolean[] inmetro) {
        if (res != null && ass != null && res.length == ass.length && (exm == null || exm.length == res.length)) {
            if (exm == null) {
                this.exames.add(new ExameMaterialPagina[]{new ExameMaterialPagina("", -1, null)});
            } else {
                this.exames.add(exm);
            }
            this.resultados.add(res);
            if (ass != null) {
                this.assinaturas.add(ass);
            }
            if (ref != null) {
                this.referencias.add(ref);
            }
            if (set != null) {
                this.setores.add(set);
            }
            if (soa != null) {
                this.soas.add(soa);
            }
            if (coa != null) {
                this.coas.add(coa);
            }
            if (inmetro != null) {
                this.inmetros.add(inmetro);
            }
        }
    }

    @Deprecated
    public PrintRequestAttributeSet getAtributosImpressao() {
        return this.atributos;
    }

    public PageFormat getFormatoPagina() {
        return this.formatoPagina;
    }

    public void setCopias(int numeroCopias) {
        this.copias = numeroCopias;
    }

    public int getCopias() {
        return this.copias;
    }

    public void setDadosBanco(Map<String, Object> dados) {
        this.tabelaSimbolo.setDados(dados);
    }

    public void setVariavel(String nome, Object valor) {
        this.tabelaSimbolo.setSimbolo(nome, valor);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Boolean bool;
        int pageIndexInmetro = pageIndex;
        int quantidadePaginasInmetroImpressao = this.quantidadePaginasInmetro;
        int quantidadePaginasNaoCertificadosImpressao = this.quantidadePaginasNaoCertificados;
        if (pageIndex >= this.quantidadePaginasInmetro && this.quantidadePaginasInmetro >= 0) {
            pageIndexInmetro = 0;
            quantidadePaginasInmetroImpressao = 0;
            this.tabelaSimbolo.setSimbolo("quantidadePaginasInmetro", new Integer(quantidadePaginasInmetroImpressao));
            this.tabelaSimbolo.setSimbolo("quantidadePaginasNaoCertificados", new Integer(quantidadePaginasNaoCertificadosImpressao));
        }
        if (pageIndex < this.quantidadePaginasInmetro) {
            quantidadePaginasNaoCertificadosImpressao = 0;
        }
        if (pageIndexInmetro < quantidadePaginasInmetroImpressao) {
            ++pageIndexInmetro;
        }
        if (!this.calculouPaginas) {
            this.prepararImpressao();
            this.tabelaSimbolo.setSimbolo("quantidadePaginas", new Integer(this.quantidadePaginas));
            this.tabelaSimbolo.setSimbolo("quantidadePaginasInmetro", new Integer(quantidadePaginasInmetroImpressao));
            this.tabelaSimbolo.setSimbolo("quantidadePaginasNaoCertificados", new Integer(quantidadePaginasNaoCertificadosImpressao));
            this.tabelaSimbolo.setSimbolo("dataImpressao", new Date());
            this.calculouPaginas = true;
            this.atualizarDados();
        }
        if (pageIndex >= this.quantidadePaginas) {
            return 1;
        }
        Integer pageNow = new Integer(pageIndex + 1);
        Integer paginaNaoCertificada = 0;
        if (pageIndexInmetro == 0) {
            paginaNaoCertificada = pageNow - this.quantidadePaginasInmetro;
        }
        this.tabelaSimbolo.setSimbolo("numeroPagina", pageNow);
        this.tabelaSimbolo.setSimbolo("numeroPaginaInmetro", pageIndexInmetro);
        this.tabelaSimbolo.setSimbolo("numeroPaginaNaoCertificados", paginaNaoCertificada);
        StringBuilder reftmp = new StringBuilder("");
        String[] r = this.refPorPagina.get(pageIndex);
        if (r != null) {
            for (String s : r) {
                if (reftmp.length() > 0) {
                    reftmp.append("\n");
                }
                if (s == null || s.trim().length() <= 0) continue;
                reftmp.append(s);
            }
            this.tabelaSimbolo.setSimbolo("referenciasMetodologia", reftmp.toString());
        }
        StringBuilder settmp = new StringBuilder("");
        String[] ss = this.setPorPagina.get(pageIndex);
        if (r != null) {
            for (String x : ss) {
                if (settmp.length() > 0) {
                    settmp.append(", ");
                }
                if (x == null || x.trim().length() <= 0) continue;
                settmp.append(x);
            }
            this.tabelaSimbolo.setSimbolo("descricaoSetores", settmp.toString());
        }
        StringBuilder coatmp = new StringBuilder("");
        String[] c = this.coaPorPagina.get(pageIndex);
        if (c != null) {
            for (String s : c) {
                if (coatmp.length() > 0) {
                    coatmp.append(this.separadorCOA);
                }
                if (s == null || s.trim().length() <= 0) continue;
                coatmp.append(s);
            }
            this.tabelaSimbolo.setSimbolo("COAExames", coatmp.toString());
        }
        StringBuilder soatmp = new StringBuilder("");
        String[] s = this.coaPorPagina.get(pageIndex);
        if (s != null) {
            for (String string : s) {
                if (soatmp.length() > 0) {
                    soatmp.append(this.separadorSOA);
                }
                if (string == null || string.trim().length() <= 0) continue;
                soatmp.append(string);
            }
            this.tabelaSimbolo.setSimbolo("SOAExames", soatmp.toString());
        }
        if ((bool = this.inmetroPorPagina.get(pageIndex)) == null) {
            bool = false;
        }
        this.tabelaSimbolo.setSimbolo("inmetroNaPagina", bool);
        ExameMaterialPagina[] emp = this.exmPorPagina.get(pageIndex);
        StringBuilder b = new StringBuilder();
        if (emp != null) {
            for (ExameMaterialPagina y : emp) {
                if (b.length() > 0) {
                    b.append(this.separadorExames);
                }
                b.append(y.getCodigo());
            }
            this.tabelaSimbolo.setSimbolo("codigosExames", b.toString());
        }
        this.verificaCondicaoImagem();
        this.executarExpressoes();
        this.executarCodigosQrCode();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (Funcoes.isLinux()) {
            double x = 0.0;
            double y = 0.0;
            String tmp = ParametrosLocais.getParametro("calibragemX");
            if (StringUtil.validaDouble(tmp)) {
                x = Double.parseDouble(tmp);
            }
            if (StringUtil.validaDouble(tmp = ParametrosLocais.getParametro("calibragemY"))) {
                y = Double.parseDouble(tmp);
            }
            graphics2D.translate(x, y);
        }
        this.imprimirLinhas(graphics2D, pageIndex);
        this.imprimirAreaNaoUtilizada(graphics2D, pageIndex);
        this.imprimirCabecalhoRodape(graphics2D, pageIndex);
        this.imprimirCorpoSumario(graphics2D, pageIndex);
        this.imprimirReferencias(graphics2D, pageIndex);
        return 0;
    }

    private void imprimirLinhas(Graphics2D g, int pagina) {
        if (this.lc != null && this.lc.isHabilitar()) {
            int i;
            double alturaMaximaLinha;
            double inicio = this.margemSuperior + this.alturaCabecalho;
            double maximo = alturaMaximaLinha = (double)(this.alturaAreaImpressao - (this.margemSuperior + this.alturaRodape + (this.exibirSumario ? this.alturaSumario : 0)));
            ArrayList<Integer> posicoes = new ArrayList<Integer>();
            ResultadoNaPagina[] res = this.resPorPagina.get(pagina);
            double alturaTotalResultado = inicio;
            for (i = 0; i < res.length; ++i) {
                alturaTotalResultado += (double)(ImpressaoUtil.alturaResultado(res[i].getResultado()) + this.distanciaExames + (this.exibirRodapeExame ? this.alturaRodapeExame : 0));
            }
            if (this.exibirSumario) {
                alturaTotalResultado += (double)this.alturaSumario;
            }
            if (this.lc.getTipoLinhaX().equals("Intervalo") && Funcoes.isNumeric(this.lc.getLinhasX())) {
                i = this.alturaCabecalho + this.margemSuperior;
                while (!(!((double)i <= maximo) || this.lc.isAcompanharResultado() && (double)i > alturaTotalResultado)) {
                    posicoes.add(i);
                    i += Integer.parseInt(this.lc.getLinhasX());
                }
            } else if (this.lc.getTipoLinhaX().equals("Fixo") && !Funcoes.textoVazio(this.lc.getLinhasX())) {
                String[] tmp;
                for (String s : tmp = this.lc.getLinhasX().split(",")) {
                    if (!Funcoes.isNumeric(s.trim()) || Integer.parseInt(s.trim()) <= -1) continue;
                    posicoes.add(Integer.parseInt(s.trim()) + this.alturaCabecalho + this.margemSuperior);
                }
            }
            int maiorPosicaoX = 0;
            String[] stringArray = posicoes.iterator();
            while (stringArray.hasNext()) {
                int y = (Integer)stringArray.next();
                g.setColor(this.lc.getCor());
                g.setClip(this.margemEsquerda, y, this.margemEsquerda + this.larguraAreaImpressao, 2);
                g.drawLine(this.margemEsquerda, y, this.larguraAreaImpressao, y);
                if (y <= maiorPosicaoX) continue;
                maiorPosicaoX = y;
            }
            posicoes.clear();
            if (this.lc.getTipoLinhaY().equals("Intervalo") && Funcoes.isNumeric(this.lc.getLinhasY()) && Integer.parseInt(this.lc.getLinhasY()) > 0) {
                int i2 = this.margemEsquerda;
                while ((double)i2 <= maximo) {
                    posicoes.add(i2);
                    i2 += Integer.parseInt(this.lc.getLinhasY());
                }
            } else if (this.lc.getTipoLinhaY().equals("Fixo") && !Funcoes.textoVazio(this.lc.getLinhasY())) {
                String[] tmp;
                for (String s : tmp = this.lc.getLinhasY().split(",")) {
                    if (!Funcoes.isNumeric(s.trim()) || Integer.parseInt(s.trim()) <= -1) continue;
                    posicoes.add(Integer.parseInt(s.trim()) + this.margemEsquerda);
                }
            }
            inicio = this.margemEsquerda;
            maximo = this.larguraAreaImpressao;
            if (alturaMaximaLinha > (double)maiorPosicaoX && this.lc.getTipoLinhaX().equals("Intervalo")) {
                alturaMaximaLinha = maiorPosicaoX;
            }
            Iterator iterator = posicoes.iterator();
            while (iterator.hasNext()) {
                int x = (Integer)iterator.next();
                g.setColor(this.lc.getCor());
                g.setClip(x, this.margemSuperior + this.alturaCabecalho, 2, this.margemSuperior + this.alturaCabecalho + (int)alturaMaximaLinha);
                g.drawLine(x, this.margemSuperior + this.alturaCabecalho, x, this.lc.isAcompanharResultado() ? (int)alturaTotalResultado : (int)alturaMaximaLinha);
            }
        }
    }

    private void imprimirAreaNaoUtilizada(Graphics2D g, int pagina) {
        int ESPACO_MINIMO = 5;
        if (this.areaLivre == null || !this.areaLivre.preencher) {
            return;
        }
        double x = this.margemEsquerda;
        double y = this.margemSuperior + this.alturaCabecalho;
        ResultadoNaPagina[] res = this.resPorPagina.get(pagina);
        double inicio = y + 5.0;
        for (int i = 0; i < res.length; ++i) {
            inicio += (double)(ImpressaoUtil.alturaResultado(res[i].getResultado()) + this.distanciaExames + (this.exibirRodapeExame ? this.alturaRodapeExame : 0));
        }
        if (this.exibirSumario) {
            inicio += (double)this.alturaSumario;
        }
        if (this.areaLivre.tipo.equals("cor")) {
            g.setColor(this.areaLivre.getCor());
            g.fillRect((int)x, (int)inicio, this.larguraAreaImpressao - this.margemEsquerda, (int)((double)this.alturaAreaImpressao - inicio - (double)this.alturaRodape));
        } else if (this.areaLivre.tipo.equals("texto")) {
            String texto = this.areaLivre.getTexto();
            Font fonte = this.areaLivre.getFonteMensagem();
            if (fonte != null) {
                LineMetrics metrica = fonte.getLineMetrics(texto, g.getFontRenderContext());
                int alturaTotal = (int)((double)(this.alturaAreaImpressao - this.alturaRodape) - inicio);
                g.setFont(fonte);
                int posicaoTexto = (int)inicio;
                while ((float)alturaTotal >= metrica.getHeight() + 2.0f) {
                    g.drawString(texto, (int)x, posicaoTexto);
                    posicaoTexto = (int)((float)posicaoTexto + (metrica.getHeight() + 2.0f));
                    alturaTotal = (int)((float)alturaTotal - (metrica.getHeight() + 2.0f));
                }
            }
        }
    }

    public void prepararImpressao() {
        ArrayList<ResultadoNaPagina> pag = new ArrayList<ResultadoNaPagina>();
        ArrayList<ExameMaterialPagina> exm = new ArrayList<ExameMaterialPagina>();
        ArrayList<Map<String, String>> ass = new ArrayList<Map<String, String>>();
        ArrayList<String> ref = new ArrayList<String>();
        ArrayList<String> set = new ArrayList<String>();
        ArrayList<String> soa = new ArrayList<String>();
        ArrayList<String> coa = new ArrayList<String>();
        ArrayList<Object> inm = new ArrayList<Object>();
        int altura = this.alturaAreaImpressao - this.alturaCabecalho - this.alturaRodape - (this.exibirSumario ? this.alturaSumario : 0);
        this.quantidadePaginas = 0;
        this.quantidadePaginasInmetro = 0;
        this.quantidadePaginasNaoCertificados = 0;
        this.resPorPagina.clear();
        this.assPorPagina.clear();
        this.exmPorPagina.clear();
        this.soaPorPagina.clear();
        this.coaPorPagina.clear();
        this.setPorPagina.clear();
        this.refPorPagina.clear();
        this.inmetroPorPagina.clear();
        Iterator<Map<String, String>[]> assItr = this.assinaturas.iterator();
        Iterator<ExameMaterialPagina[]> exmItr = this.exames.iterator();
        Iterator<String[]> refItr = this.referencias.iterator();
        Iterator<String[]> setItr = this.setores.iterator();
        Iterator<String[]> soaItr = this.soas.iterator();
        Iterator<String[]> coaItr = this.coas.iterator();
        Iterator<Boolean[]> inmetroItr = this.inmetros.iterator();
        Iterator<String[]> itr = this.resultados.iterator();
        while (itr.hasNext() && assItr.hasNext() && exmItr.hasNext() && refItr.hasNext() && soaItr.hasNext() && coaItr.hasNext() && setItr.hasNext()) {
            String[] res = itr.next();
            ExameMaterialPagina[] exms = exmItr.next();
            Map<String, String>[] hash = assItr.next();
            String[] refs = refItr.next();
            String[] sets_ = setItr.next();
            String[] soas_ = soaItr.next();
            String[] coas_ = coaItr.next();
            Object[] inmetro_ = null;
            if (inmetroItr != null && inmetroItr.hasNext()) {
                inmetro_ = inmetroItr.next();
            }
            int alturaLivre = altura;
            pag.clear();
            ass.clear();
            exm.clear();
            ref.clear();
            soa.clear();
            coa.clear();
            set.clear();
            inm.clear();
            ++this.quantidadePaginas;
            if (!Funcoes.objectIsNull(inmetro_) && ArraysUtil.contem(inmetro_, true)) {
                ++this.quantidadePaginasInmetro;
            } else {
                ++this.quantidadePaginasNaoCertificados;
            }
            boolean separouInmetro = false;
            for (int i = 0; i < res.length && i < hash.length; ++i) {
                String versaoXML = StringUtil.getValor(res[i], "versao");
                boolean bl = !this.sempreReposicionarEntrePaginas ? (versaoXML.equals("1.0") || StringUtil.getValor(res[i], "reposicionarComponentes").trim().length() == 0 ? true : StringUtil.getBoolean(res[i], "reposicionarComponentes")) : true;
                String[] resultadoPorPagina = new String[]{res[i]};
                int qtdePaginasResultado = ImpressaoUtil.contaPaginasResultado(res[i]);
                if (qtdePaginasResultado > 1) {
                    resultadoPorPagina = new String[qtdePaginasResultado];
                    for (int p = 1; p <= qtdePaginasResultado; ++p) {
                        resultadoPorPagina[p - 1] = ImpressaoUtil.removerComponentesOutraPagina(res[i], p);
                    }
                }
                for (int j = 0; j < resultadoPorPagina.length; ++j) {
                    String resTmp = resultadoPorPagina[j];
                    ExameMaterialPagina exmTmp = exms[i];
                    String refTmp = refs == null || i > refs.length || refs[i] == null ? "" : refs[i];
                    String soaTmp = soas_ == null || i > soas_.length || soas_[i] == null ? "" : soas_[i];
                    String coaTmp = coas_ == null || i > coas_.length || coas_[i] == null ? "" : coas_[i];
                    String setTmp = sets_ == null || i > sets_.length || sets_[i] == null ? "" : sets_[i];
                    Object inmetroTmp = false;
                    if (inmetro_ != null && inmetro_.length == res.length) {
                        inmetroTmp = inmetro_[i];
                    }
                    int alturaRes = ImpressaoUtil.alturaResultado(resTmp) + (this.exibirRodapeExame ? this.alturaRodapeExame : 0);
                    if (!((Boolean)inmetroTmp).booleanValue() && this.quantidadePaginasInmetro > 0 && !separouInmetro) {
                        separouInmetro = true;
                        if (i > 0) {
                            alturaLivre = 0;
                        }
                    }
                    while (alturaRes > alturaLivre) {
                        if (((Boolean)inmetroTmp).booleanValue()) {
                            ++this.quantidadePaginasInmetro;
                        } else {
                            alturaLivre = altura;
                            ++this.quantidadePaginasNaoCertificados;
                        }
                        ++this.quantidadePaginas;
                        if (pag.size() == 0) {
                            String[] divisao = ImpressaoUtil.divideResultado(resTmp, alturaLivre);
                            divisao = ImpressaoUtil.divideResultadoRtf(resTmp, alturaLivre, divisao);
                            pag.add(new ResultadoNaPagina(divisao[0], exmTmp.getTabelaDados(), j == resultadoPorPagina.length - 1));
                            ass.add(hash[i]);
                            if (!exm.contains(exmTmp)) {
                                exm.add(exmTmp);
                            }
                            if (!ref.contains(refTmp)) {
                                ref.add(refTmp);
                            }
                            if (!soa.contains(soaTmp)) {
                                soa.add(soaTmp);
                            }
                            if (!coa.contains(coaTmp)) {
                                coa.add(coaTmp);
                            }
                            if (!set.contains(setTmp)) {
                                set.add(setTmp);
                            }
                            if (!inm.contains(inmetroTmp)) {
                                inm.add(inmetroTmp);
                            }
                            resTmp = divisao[1];
                            alturaRes = ImpressaoUtil.alturaResultado(resTmp);
                        }
                        ArrayList<ExameMaterialPagina> emp = new ArrayList<ExameMaterialPagina>();
                        for (ExameMaterialPagina e : exm) {
                            emp.add(e);
                        }
                        this.resPorPagina.add(pag.toArray(new ResultadoNaPagina[pag.size()]));
                        this.assPorPagina.add(ass.toArray(new Map[ass.size()]));
                        this.exmPorPagina.add(exm.toArray(new ExameMaterialPagina[exm.size()]));
                        this.refPorPagina.add(ref.toArray(new String[ref.size()]));
                        this.coaPorPagina.add(coa.toArray(new String[coa.size()]));
                        this.soaPorPagina.add(soa.toArray(new String[soa.size()]));
                        this.setPorPagina.add(set.toArray(new String[set.size()]));
                        Boolean inme = false;
                        for (Boolean bl2 : inm) {
                            if (!bl2.booleanValue()) continue;
                            inme = bl2;
                            break;
                        }
                        this.inmetroPorPagina.add(inme);
                        alturaLivre = altura;
                        pag.clear();
                        ass.clear();
                        exm.clear();
                        ref.clear();
                        soa.clear();
                        coa.clear();
                        set.clear();
                        inm.clear();
                    }
                    pag.add(new ResultadoNaPagina(resTmp, exmTmp.getTabelaDados(), j == resultadoPorPagina.length - 1));
                    ass.add(hash[i]);
                    if (!exm.contains(exmTmp)) {
                        exm.add(exmTmp);
                    }
                    if (!ref.contains(refTmp)) {
                        ref.add(refTmp);
                    }
                    if (!coa.contains(coaTmp)) {
                        coa.add(coaTmp);
                    }
                    if (!soa.contains(soaTmp)) {
                        soa.add(soaTmp);
                    }
                    if (!set.contains(setTmp)) {
                        set.add(setTmp);
                    }
                    if (!inm.contains(inmetroTmp)) {
                        inm.add(inmetroTmp);
                    }
                    alturaLivre = versaoXML.equals("1.0") || bl ? alturaLivre - alturaRes - this.distanciaExames : 0;
                }
            }
            this.resPorPagina.add(pag.toArray(new ResultadoNaPagina[pag.size()]));
            this.assPorPagina.add(ass.toArray(new Map[ass.size()]));
            this.exmPorPagina.add(exm.toArray(new ExameMaterialPagina[exm.size()]));
            this.refPorPagina.add(ref.toArray(new String[ref.size()]));
            this.coaPorPagina.add(coa.toArray(new String[coa.size()]));
            this.soaPorPagina.add(soa.toArray(new String[soa.size()]));
            this.setPorPagina.add(set.toArray(new String[set.size()]));
            Boolean inme = false;
            for (Boolean bl : inm) {
                if (!bl.booleanValue()) continue;
                inme = bl;
                break;
            }
            this.inmetroPorPagina.add(inme);
        }
    }

    public List<Component> getComponentesCabecalho() {
        return this.cabecalho;
    }

    public List<Component> getComponentesRodape() {
        return this.rodape;
    }

    public List<Component> getComponentesRodapeExame() {
        return this.rodapeExame;
    }

    public List<Component> getComponentesSumario() {
        return this.sumario;
    }

    public ResultadoNaPagina[] getResultadoNaPagina(int indexPagina) {
        return this.resPorPagina.get(indexPagina);
    }

    public List<String[]> getResultados() {
        return this.resultados;
    }

    public boolean exibirRodapeExame() {
        return this.exibirRodapeExame;
    }

    public boolean exibirSumario() {
        return this.exibirSumario;
    }

    private void imprimirCabecalhoRodape(Graphics2D g, int indice) {
        Point2D.Double ref = new Point2D.Double(this.margemEsquerda, this.margemSuperior);
        ImpressaoUtil.pintarCabecalho(g, ImpressaoUtil.getComponentesImpressao(this.cabecalho, this.considerarPDF), ref);
        ref = new Point2D.Double(this.margemEsquerda, this.margemSuperior + this.alturaAreaImpressao - this.alturaRodape);
        this.imprimirAssinaturas(g, this.assinaturaRodape, new Rectangle2D.Double(((Point2D)ref).getX(), ((Point2D)ref).getY(), this.larguraAreaImpressao, this.alturaRodape), indice, 1);
        ImpressaoUtil.pintarCabecalho(g, ImpressaoUtil.getComponentesImpressao(this.rodape, this.considerarPDF), ref);
    }

    public ParametrosAssinatura getAssinaturaRodape() {
        return this.assinaturaRodape;
    }

    private void imprimirCorpoSumario(Graphics2D g, int indice) {
        if (indice < this.resPorPagina.size()) {
            ResultadoNaPagina[] res = this.resPorPagina.get(indice);
            Map<String, String>[] ass = this.assPorPagina.get(indice);
            String[] ref = this.refPorPagina.get(indice);
            double x = this.margemEsquerda;
            double y = this.margemSuperior + this.alturaCabecalho;
            if (this.exibirSumario) {
                double ySumario = y + (double)(this.distanciaExames * (res.length > 0 ? res.length - 1 : 0));
                for (int i = 0; i < res.length; ++i) {
                    ySumario += (double)(ImpressaoUtil.alturaResultado(res[i].getResultado()) + (this.exibirRodapeExame ? this.alturaRodapeExame : 0));
                }
                this.imprimirAssinaturas(g, this.assinaturaSumario, new Rectangle2D.Double(x, ySumario, this.larguraAreaImpressao, this.alturaSumario), indice, 0);
                ImpressaoUtil.pintar(g, ImpressaoUtil.getComponentesImpressao(this.sumario, this.considerarPDF), new Point2D.Double(x, ySumario));
            }
            for (int i = 0; i < res.length && i < ass.length; ++i) {
                int alturaResultado = ImpressaoUtil.alturaResultado(res[i].getResultado());
                ImpressaoUtil.pintar(g, ImpressaoUtil.getComponentesImpressao(res[i].getResultado(), ass[i], this.considerarPDF), new Point2D.Double(x, y));
                y += (double)alturaResultado;
                if (this.exibirRodapeExame && res[i].isUltimaPaginaExame()) {
                    this.carregarItensParaArrayList(this.xmlRodapeExame, this.rodapeExame, res[i].getTabelaSimbolos());
                    for (Component c : this.rodapeExame) {
                        if (c instanceof ExpressaoDigitacao) {
                            ((ExpressaoDigitacao)c).setTabelaSimbolos(res[i].getTabelaSimbolos());
                            ((ExpressaoDigitacao)c).executar();
                            continue;
                        }
                        if (c instanceof DadosDigitacao) {
                            DadosDigitacao dados = (DadosDigitacao)c;
                            if (res[i] == null || res[i].getTabelaSimbolos() == null || dados.getCampoBanco() == null) continue;
                            dados.setValor(res[i].getTabelaSimbolos().getValor(dados.getCampoBanco()));
                            continue;
                        }
                        if (c instanceof CodigoBarrasDigitacao) {
                            CodigoBarrasDigitacao barra = (CodigoBarrasDigitacao)c;
                            barra.setValor(res[i].getTabelaSimbolos().getValor(barra.getCampoBanco()));
                            continue;
                        }
                        if (!(c instanceof ImagemDigitacao)) continue;
                        ((ImagemDigitacao)c).setTabelaSimbolos(this.tabelaSimbolo);
                        ((ImagemDigitacao)c).executar();
                    }
                    ImpressaoUtil.pintar(g, ImpressaoUtil.getComponentesImpressao(this.rodapeExame, this.considerarPDF), new Point2D.Double(x, y));
                    y += (double)this.alturaRodapeExame;
                }
                y += (double)this.distanciaExames;
            }
        }
    }

    private void imprimirReferencias(Graphics2D g, int indice) {
        if (indice < this.resPorPagina.size()) {
            ResultadoNaPagina[] res = this.resPorPagina.get(indice);
            String[] ref = this.refPorPagina.get(indice);
            double x = this.margemEsquerda;
            double y = this.margemSuperior + this.alturaCabecalho;
            if (this.exibirSumario) {
                double ySumario = y + (double)((this.distanciaExames + (this.exibirRodapeExame ? this.alturaRodapeExame : 0)) * (res.length > 0 ? res.length - 1 : 0));
                for (int i = 0; i < res.length; ++i) {
                    ySumario += (double)ImpressaoUtil.alturaResultado(res[i].getResultado());
                }
                if (this.exibirReferenciaSumario) {
                    int alturaRestante = this.alturaReferencia;
                    float yReferencia = (float)(ySumario + (double)this.posicaoReferencia);
                    ArrayList<ComponenteImpressao> refs = new ArrayList<ComponenteImpressao>();
                    for (int _x = 0; _x < ref.length; ++_x) {
                        String r = ref[_x];
                        String[] linhas = r.split("\n");
                        for (int _y = 0; _y < linhas.length; ++_y) {
                            String linhaOriginal = linhas[_y];
                            String[] quebra = this.quebraLinha(g, linhaOriginal);
                            for (int _z = 0; _z < quebra.length; ++_z) {
                                String linha = quebra[_z];
                                LineMetrics metrica = this.fonteReferencia.getLineMetrics(linha, g.getFontRenderContext());
                                FontMetrics fonteMetrica = g.getFontMetrics(this.fonteReferencia);
                                Rectangle2D recFonte = this.fonteReferencia.getMaxCharBounds(g.getFontRenderContext());
                                if ((alturaRestante = (int)((float)alturaRestante - metrica.getHeight())) <= 0) continue;
                                g.setFont(this.fonteReferencia);
                                yReferencia += metrica.getHeight();
                                int xReferencia = (int)x;
                                int comprimentoLinha = fonteMetrica.stringWidth(linha);
                                if (this.alinhamentoReferencia == 4) {
                                    xReferencia = this.larguraAreaImpressao - comprimentoLinha;
                                } else if (this.alinhamentoReferencia == 0) {
                                    xReferencia = this.margemEsquerda + (this.larguraAreaImpressao - comprimentoLinha) / 2;
                                }
                                TextoEstatico te = new TextoEstatico();
                                te.setText(linha);
                                te.setName("ref_" + String.valueOf(_x) + "_" + String.valueOf(_y) + "_" + String.valueOf(_z));
                                te.setDimensoes((int)x, (int)yReferencia, comprimentoLinha, fonteMetrica.getHeight() + 2);
                                te.setOpaque(false);
                                te.setBackground(g.getBackground());
                                te.setForeground(g.getColor());
                                te.setText(linha);
                                te.setFont(this.fonteReferencia);
                                te.setImprimir(true);
                                te.setHorizontalAlignment(this.alinhamentoReferencia);
                                refs.add(te);
                            }
                        }
                    }
                    ImpressaoUtil.pintar(g, refs, new Point2D.Double(x, 0.0));
                }
            }
        }
    }

    private String[] quebraLinha(Graphics2D g, String linha) {
        FontMetrics metrica;
        if (this.fonteReferencia != null && (metrica = g.getFontMetrics(this.fonteReferencia)).stringWidth(linha) > this.larguraAreaImpressao) {
            String[] espacos = linha.split(" ");
            int total = 0;
            StringBuilder buf = new StringBuilder();
            ArrayList<String> novaLinha = new ArrayList<String>();
            for (String e : espacos) {
                String tmp = e + (buf.length() > 0 ? " " : "");
                if (total + metrica.stringWidth(tmp) <= this.larguraAreaImpressao - this.margemEsquerda - this.margemDireita) {
                    buf.append(buf.length() > 0 ? " " : "").append(e);
                    total += metrica.stringWidth(tmp);
                    continue;
                }
                total = metrica.stringWidth(tmp);
                novaLinha.add(buf.toString());
                buf.setLength(0);
                buf.append(e);
            }
            if (buf.length() > 0) {
                novaLinha.add(buf.toString());
            }
            return novaLinha.toArray(new String[novaLinha.size()]);
        }
        return new String[]{linha};
    }

    private void imprimirAssinaturas(Graphics2D g, ParametrosAssinatura param, Rectangle2D rec, int indice, int local) {
        if (param != null && param.exibir()) {
            ArrayList<String> tmp = new ArrayList<String>();
            ArrayList<ComponenteImpressao> comps = new ArrayList<ComponenteImpressao>();
            ArrayList<ComponenteImpressao> compsEletronica = new ArrayList<ComponenteImpressao>();
            Map<String, String>[] ass = this.assPorPagina.get(indice);
            String str = null;
            boolean ok = true;
            double width = 0.0;
            for (int i = 0; i < ass.length && i < param.getQuantidade() && ok; ++i) {
                CampoAssinaturaLaudo campoAssinatura = param.getCampoBanco();
                if (campoAssinatura == CampoAssinaturaLaudo.RESPONSAVEL_TECNICO_DIGITAL || campoAssinatura == CampoAssinaturaLaudo.RESPONSAVEL_TECNICO_SUBSTITUTO_DIGITAL) {
                    if (this.isGerarPDF && (campoAssinatura == CampoAssinaturaLaudo.RESPONSAVEL_TECNICO_DIGITAL && this.temCertificadoRT || campoAssinatura == CampoAssinaturaLaudo.RESPONSAVEL_TECNICO_SUBSTITUTO_DIGITAL && this.temCertificadoRTSub)) {
                        this.setAssinarDigitalmente(true);
                        this.setTipoAssinaturaDigital(campoAssinatura);
                    } else {
                        campoAssinatura = CampoAssinaturaLaudo.USUARIO_CONFERENCIA;
                    }
                }
                String idParaXML = campoAssinatura.getIdParaXML();
                String[] camposParaXML = new String[]{idParaXML};
                if (idParaXML.indexOf("+") > 0) {
                    camposParaXML = idParaXML.split("\\+");
                }
                for (String campoXML : camposParaXML) {
                    if (ass[i] == null || (str = ass[i].get(campoXML) == null ? "" : ass[i].get(campoXML)).length() <= 0 || str != null && tmp.contains(str)) continue;
                    AssinaturaImpressao comp = new AssinaturaImpressao();
                    comp.setImagem(str);
                    comp.setEstender(true);
                    comp.setAlturaProporcional(param.getAltura());
                    ok = width + (double)comp.getWidth() <= rec.getWidth();
                    if (!ok) continue;
                    comps.add(comp);
                    tmp.add(str);
                    width += (double)comp.getWidth();
                }
                if (!param.isImprimirAssinaturaEletronica() || param.getAssinaturaEletronica() == null) continue;
                campoAssinatura = param.getAssinaturaEletronica();
                String idParaXMLEletronica = campoAssinatura.getIdParaXML();
                String[] camposParaXMLEletronica = new String[]{idParaXMLEletronica};
                if (idParaXMLEletronica.indexOf("+") > 0) {
                    camposParaXMLEletronica = idParaXMLEletronica.split("\\+");
                }
                for (String campoXML : camposParaXMLEletronica) {
                    if (ass[i] == null || (str = ass[i].get(campoXML) == null ? "" : ass[i].get(campoXML)).length() <= 0 || str != null && tmp.contains(str)) continue;
                    AssinaturaImpressao comp = new AssinaturaImpressao();
                    comp.setImagem(str);
                    comp.setEstender(true);
                    comp.setAlturaProporcional(param.getAltura());
                    ok = width + (double)comp.getWidth() <= rec.getWidth();
                    if (!ok) continue;
                    compsEletronica.add(comp);
                    tmp.add(str);
                    width += (double)comp.getWidth();
                }
            }
            double y = 0.0;
            double x = this.isAssinarDigitalmente ? (param.getAlinhamento() == 0 ? 0.0 : (param.getAlinhamento() == 4 ? 0.0 : rec.getWidth() - width)) : (param.getAlinhamento() == 0 ? (rec.getWidth() - width) / 2.0 : (param.getAlinhamento() == 4 ? rec.getWidth() - width : 0.0));
            for (ComponenteImpressao comp : comps) {
                AssinaturaImpressao imp = (AssinaturaImpressao)comp;
                y = local == 1 && param.getTipo() == 0 && param.getPosicao() == 11 && param.getPosicaoAbsoluto() > 0 && (double)param.getPosicaoAbsoluto() < rec.getHeight() ? (y += (double)param.getPosicaoAbsoluto()) : (param.getPosicao() == 1 ? (param.getTipo() == 0 ? 0.0 : (double)(-imp.getHeight())) : rec.getHeight() - (double)imp.getHeight());
                imp.setLocation((int)x, (int)y);
                x += (double)imp.getWidth();
            }
            if (param.isImprimirAssinaturaEletronica() && param.getAssinaturaEletronica() != null) {
                double xEletronica = param.getAlinhamento() == 0 || param.getAlinhamento() == 2 ? 0.0 : rec.getWidth() - width;
                for (ComponenteImpressao comp : compsEletronica) {
                    AssinaturaImpressao imp = (AssinaturaImpressao)comp;
                    y = local == 1 && param.getTipo() == 0 && param.getPosicao() == 11 && param.getPosicaoAbsoluto() > 0 && (double)param.getPosicaoAbsoluto() < rec.getHeight() ? (y += (double)param.getPosicaoAbsoluto()) : (param.getPosicao() == 1 ? (param.getTipo() == 0 ? 0.0 : (double)(-imp.getHeight())) : rec.getHeight() - (double)imp.getHeight());
                    imp.setLocation((int)x, (int)y);
                    x += (double)imp.getWidth();
                }
            }
            this.setPosicaoHorizontalAssinatura(param.getAlinhamento());
            this.setPosicaoVerticalAssinatura(param.getPosicao());
            this.setPosicaoVerticalAbsolutaAssinatura(param.getPosicaoAbsoluto());
            this.setMargemAssinaturaDigital(param.getMargemAssinaturaDigital());
            if (!this.isAssinarDigitalmente) {
                ImpressaoUtil.pintar(g, comps, new Point2D.Double(rec.getX(), rec.getY()));
            } else if (param.isImprimirAssinaturaEletronica()) {
                ImpressaoUtil.pintar(g, compsEletronica, new Point2D.Double(rec.getX(), rec.getY()));
            }
        }
    }

    private void setPosicaoVerticalAbsolutaAssinatura(int posicaoAbsoluto) {
        this.posicaoVerticalAbsolutaAssinatura = posicaoAbsoluto;
    }

    private void setTipoAssinaturaDigital(CampoAssinaturaLaudo campoAssinatura) {
        this.campoAssinatura = campoAssinatura;
    }

    public CampoAssinaturaLaudo getTipoAssinaturaDigital() {
        return this.campoAssinatura;
    }

    public int getAlturaAssinaturaRodape() {
        return this.assinaturaRodape.getAltura();
    }

    public int getAlturaRodape() {
        return this.alturaRodape;
    }

    private void setPosicaoVerticalAssinatura(int posicaoAssinatura) {
        this.posicaoAssinaturaVertical = posicaoAssinatura;
    }

    private void setPosicaoHorizontalAssinatura(int posicaoAssinatura) {
        this.posicaoAssinaturaHorizontal = posicaoAssinatura;
    }

    public int getPosicaoHorizontalAssinatura() {
        return this.posicaoAssinaturaHorizontal;
    }

    public int getPosicaoVerticalAssinatura() {
        return this.posicaoAssinaturaVertical;
    }

    private void executarExpressoes() {
        for (ExpressaoDigitacao exp : this.expressoes) {
            exp.executar();
        }
    }

    private void executarCodigosQrCode() {
        for (CodigoQRCodeImpressao qrcode : this.codigosQrCode) {
            qrcode.executar();
        }
    }

    private void carregarAtributos(String prop) {
        String tmp = StringUtil.getValor(prop, "dimensoes");
        float w = Documento.valorPropriedadeMM(tmp, "largura");
        float h = Documento.valorPropriedadeMM(tmp, "altura");
        float mE = Documento.valorPropriedadeMM(prop, "margemEsquerda");
        float mD = Documento.valorPropriedadeMM(prop, "margemDireita");
        float mS = Documento.valorPropriedadeMM(prop, "margemSuperior");
        float mI = Documento.valorPropriedadeMM(prop, "margemInferior");
        if (w > h) {
            Paper paper = new Paper();
            paper.setSize(ScreenUtil.getPixelsDeMilimetros(w), ScreenUtil.getPixelsDeMilimetros(h));
            paper.setImageableArea(mS, mE, h - mS - mI, w - mE - mD);
            this.formatoPagina = new PageFormat();
            this.formatoPagina.setOrientation(0);
            this.formatoPagina.setPaper(paper);
        } else {
            Paper paper = new Paper();
            paper.setSize(ScreenUtil.getPixelsDeMilimetros(w), ScreenUtil.getPixelsDeMilimetros(h));
            paper.setImageableArea(mS, mE, h - mS - mI, w - mE - mD);
            this.formatoPagina = new PageFormat();
            this.formatoPagina.setOrientation(1);
            this.formatoPagina.setPaper(paper);
        }
        this.assinaturaSumario = ParametrosAssinatura.novaInstancia(StringUtil.getValor(prop, "assinaturaSumario"));
        this.assinaturaRodape = ParametrosAssinatura.novaInstancia(StringUtil.getValor(prop, "assinaturaRodape"));
        this.distanciaExames = StringUtil.getInt(prop, "distanciaExames");
        this.margemEsquerda = StringUtil.getInt(prop, "margemEsquerda");
        this.margemSuperior = StringUtil.getInt(prop, "margemSuperior");
        this.margemDireita = StringUtil.getInt(prop, "margemDireita");
        this.margemInferior = StringUtil.getInt(prop, "margemInferior");
        this.larguraAreaImpressao = StringUtil.getInt(tmp, "largura") - this.margemEsquerda - this.margemDireita;
        this.alturaAreaImpressao = StringUtil.getInt(tmp, "altura") - this.margemSuperior - this.margemInferior;
        this.alturaCabecalho = StringUtil.getInt(prop, "alturaCabecalho");
        this.alturaSumario = StringUtil.getInt(prop, "alturaSumario");
        this.alturaRodape = StringUtil.getInt(prop, "alturaRodape");
        this.alturaRodapeExame = StringUtil.getInt(prop, "alturaRodapeExame");
        this.exibirSumario = StringUtil.getBoolean(prop, "exibirSumario");
        this.exibirReferenciaSumario = StringUtil.getBoolean(StringUtil.getValor(prop, "assinaturaSumario"), "exibirReferencia");
        this.exibirRodapeExame = StringUtil.getBoolean(prop, "exibirRodapeExame");
        if (StringUtil.getValor(prop, "separadorExames").trim().length() > 0) {
            this.separadorExames = StringUtil.getValor(prop, "separadorExames");
        }
        if (StringUtil.getValor(prop, "separadorCOA").trim().length() > 0) {
            this.separadorCOA = StringUtil.getValor(prop, "separadorCOA");
        }
        if (StringUtil.getValor(prop, "separadorSOA").trim().length() > 0) {
            this.separadorSOA = StringUtil.getValor(prop, "separadorSOA");
        }
        if (!Funcoes.textoVazio(tmp = StringUtil.getValor(prop, "parametrosLinhasCorpo"))) {
            this.lc = new LinhasCorpo();
            this.lc.parseXML(tmp);
        }
        tmp = StringUtil.getValor(prop, "referencias");
        this.alturaReferencia = StringUtil.getInt(tmp, "alturaReferenciaSumario");
        this.posicaoReferencia = StringUtil.getInt(tmp, "posicaoReferenciaSumario");
        this.alinhamentoReferencia = StringUtil.getInt(tmp, "alinhamentoReferenciaSumario");
        this.fonteReferencia = StringUtil.getFonte(StringUtil.getValor(tmp, "fonteReferenciaSumario"));
        this.qualidadeImagensPDF = StringUtil.getFloat(prop, "qualidadeImagensLaudo");
    }

    public static float valorPropriedadeMM(String xml, String tag) {
        return (float)StringUtil.getInt(xml, tag) * 0.35277778f;
    }

    private void carregarItens(String itens) {
        this.carregarItensParaArrayList(StringUtil.getValor(itens, "cabecalho"), this.cabecalho, this.tabelaSimbolo);
        this.carregarItensParaArrayList(StringUtil.getValor(itens, "sumario"), this.sumario, this.tabelaSimbolo);
        this.carregarItensParaArrayList(StringUtil.getValor(itens, "rodape"), this.rodape, this.tabelaSimbolo);
        this.xmlRodapeExame = StringUtil.getValor(itens, "rodapeExame");
        this.compResultado.clear();
        ArrayList<Component> tmp = new ArrayList<Component>(this.cabecalho);
        tmp.addAll(this.sumario);
        tmp.addAll(this.rodape);
        for (Component comp : tmp) {
            if (comp instanceof ComponenteDigitacao) {
                ComponenteDigitacao dig = (ComponenteDigitacao)((Object)comp);
                if (dig instanceof ComponenteResultado && !(dig instanceof ImagemDigitacao)) {
                    this.compResultado.put(dig.getNome().toLowerCase(), (ComponenteResultado)dig);
                }
                if (dig instanceof ExpressaoDigitacao) {
                    this.expressoes.add((ExpressaoDigitacao)dig);
                }
            }
            if (comp instanceof ComponenteValor) {
                this.tabelaSimbolo.setSimbolo(((ComponenteValor)((Object)comp)).getNome(), comp);
            }
            if (!(comp instanceof CodigoQRCodeImpressao)) continue;
            CodigoQRCodeImpressao qrCode = (CodigoQRCodeImpressao)comp;
            qrCode.setTabelaSimbolos(this.tabelaSimbolo);
            this.codigosQrCode.add(qrCode);
        }
        for (ExpressaoDigitacao exp : this.expressoes) {
            for (String ident : Token.getIdentificadores(exp.getExpressao())) {
                ComponenteResultado comp = this.compResultado.get(ident.toLowerCase());
                if (comp == null) continue;
                comp.addCampoListener(exp);
            }
        }
    }

    public String getMascaraPdf() {
        return this.mascaraPdf;
    }

    private void setMascaraPdf(String tagExame) {
        this.mascaraPdf = StringUtil.getValor(tagExame, "mascaraPDF");
    }

    private void carregarItensParaArrayList(String xml, List<Component> arrayList, TabelaSimbolos tabela) {
        try {
            arrayList.clear();
            for (String item : StringUtil.getListValores(xml, "componente")) {
                Componente comp = (Componente)Class.forName(StringUtil.getValor(item, "tipo")).newInstance();
                comp.setAtributos(StringUtil.getValor(item, "atributos"));
                Component dig = comp.getComponenteDigitacao(false);
                if (dig instanceof ExpressaoDigitacao) {
                    ((ExpressaoDigitacao)dig).setTabelaSimbolos(tabela);
                }
                arrayList.add(dig);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Documento: 541");
        }
    }

    private void atualizarDados() {
        for (ComponenteResultado comp : this.compResultado.values()) {
            if (comp instanceof DadosDigitacao) {
                DadosDigitacao dados = (DadosDigitacao)comp;
                dados.setValor(this.tabelaSimbolo.getValor(dados.getCampoBanco()));
                continue;
            }
            if (!(comp instanceof CodigoBarrasDigitacao)) continue;
            CodigoBarrasDigitacao barra = (CodigoBarrasDigitacao)comp;
            barra.setValor(this.tabelaSimbolo.getValor(barra.getCampoBanco()));
        }
        for (Component c : this.cabecalho) {
            if (!(c instanceof ImagemDigitacao)) continue;
            ((ImagemDigitacao)c).setTabelaSimbolos(this.tabelaSimbolo);
            ((ImagemDigitacao)c).executar();
        }
        for (Component c : this.sumario) {
            if (!(c instanceof ImagemDigitacao)) continue;
            ((ImagemDigitacao)c).setTabelaSimbolos(this.tabelaSimbolo);
            ((ImagemDigitacao)c).executar();
        }
        for (Component c : this.rodape) {
            if (!(c instanceof ImagemDigitacao)) continue;
            ((ImagemDigitacao)c).setTabelaSimbolos(this.tabelaSimbolo);
            ((ImagemDigitacao)c).executar();
        }
    }

    private void verificaCondicaoImagem() {
        for (Component c : this.cabecalho) {
            if (!(c instanceof ImagemDigitacao)) continue;
            ((ImagemDigitacao)c).setTabelaSimbolos(this.tabelaSimbolo);
            ((ImagemDigitacao)c).executar();
        }
        for (Component c : this.sumario) {
            if (!(c instanceof ImagemDigitacao)) continue;
            ((ImagemDigitacao)c).setTabelaSimbolos(this.tabelaSimbolo);
            ((ImagemDigitacao)c).executar();
        }
        for (Component c : this.rodape) {
            if (!(c instanceof ImagemDigitacao)) continue;
            ((ImagemDigitacao)c).setTabelaSimbolos(this.tabelaSimbolo);
            ((ImagemDigitacao)c).executar();
        }
    }

    public void setCriarPdf(boolean b) {
        this.criarPdf = b;
        if (!b) {
            this.arquivoPdf = "";
        }
    }

    public void setCriarPdf(String arquivoPdf) {
        this.criarPdf = true;
        this.arquivoPdf = arquivoPdf;
    }

    public void setArquivoPdf(String arquivoPdf) {
        this.setCriarPdf(arquivoPdf);
    }

    public boolean isCriarPdf() {
        return this.criarPdf;
    }

    public String getArquivoPdf() {
        return this.arquivoPdf;
    }

    public int getLarguraAreaImpressao() {
        return this.larguraAreaImpressao;
    }

    public int getAlturaAreaImpressao() {
        return this.alturaAreaImpressao;
    }

    public int getQuantidadePaginas() {
        return this.quantidadePaginas;
    }

    public int getMargemEsquerda() {
        return this.margemEsquerda;
    }

    public int getMargemSuperior() {
        return this.margemSuperior;
    }

    public int getMargemDireita() {
        return this.margemDireita;
    }

    public int getMargemInferior() {
        return this.margemInferior;
    }

    public void setSempreReposicionarEntrePaginas(boolean reposicionar) {
        this.sempreReposicionarEntrePaginas = reposicionar;
    }

    public boolean isSempreReposicionarEntrePaginas() {
        return this.sempreReposicionarEntrePaginas;
    }

    public void setConsiderarPDF(boolean considerarPDF) {
        this.considerarPDF = considerarPDF;
    }

    private void setAssinarDigitalmente(boolean isAssinarDigitalmente) {
        this.isAssinarDigitalmente = isAssinarDigitalmente;
    }

    public boolean getAssinarDigitalmente() {
        return this.isAssinarDigitalmente;
    }

    public void setGerarPDF(boolean isGerarPDF) {
        this.isGerarPDF = isGerarPDF;
    }

    public int getPosicaoVerticalAbsolutaAssinatura() {
        return this.posicaoVerticalAbsolutaAssinatura;
    }

    public void setTemCertificadoRT(boolean temCertificadoRT) {
        this.temCertificadoRT = temCertificadoRT;
    }

    public void setTemCertificadoRTSub(boolean temCertificadoRTSub) {
        this.temCertificadoRTSub = temCertificadoRTSub;
    }

    public float getQualidadeImagensPDF() {
        return this.qualidadeImagensPDF;
    }

    public void setQualidadeImagensPDF(float qualidadeImagensPDF) {
        this.qualidadeImagensPDF = qualidadeImagensPDF;
    }
}

