/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.util;

public enum TiposApropriacao {
    Nenhuma(-1, "", null),
    RecebimentoBalcao(0, "Recebimento no Balc\u00e3o", null),
    RecebimentoBalcaoDinheiro(1, "Dinheiro Balc\u00e3o", RecebimentoBalcao),
    RecebimentoBalcaoCheque(2, "Cheque Balc\u00e3o", RecebimentoBalcao),
    RecebimentoBalcaoChequePreDatado(32, "Cheque Pr\u00e9-Datado Balc\u00e3o", RecebimentoBalcao),
    RecebimentoBalcaoCortesia(4, "Cortesia Balc\u00e3o", RecebimentoBalcao),
    RecebimentoBalcaoPromissoria(18, "Promiss\u00f3ria Balc\u00e3o", RecebimentoBalcao),
    RecebimentoBalcaoOutros(5, "Outros Balc\u00e3o", RecebimentoBalcao),
    RecebimentoBalcaoCartaoDebito(30, "Cart\u00e3o de D\u00e9bito Balc\u00e3o", RecebimentoBalcao),
    RecebimentoBalcaoCartaoCredito(31, "Cart\u00e3o de Cr\u00e9dito Balc\u00e3o", RecebimentoBalcao),
    RecebimentoBalcaoRepasse(33, "Repasse Balc\u00e3o", RecebimentoBalcao),
    RecebimentoBalcaoBoleto(40, "Boleto Balc\u00e3o", RecebimentoBalcao),
    RecebimentoBalcaoDebitoAutomatico(41, "D\u00e9bito Autom\u00e1tico Balc\u00e3o", RecebimentoBalcao),
    RecebimentoBalcaoChequeCaucao(42, "Cheque Cau\u00e7\u00e3o Balc\u00e3o", RecebimentoBalcao),
    RecebimentoBalcaoDepositoBancario(43, "Dep\u00f3sito Banc\u00e1rio Balc\u00e3o", RecebimentoBalcao),
    RecebimentoBalcaoPagamentoOnline(44, "Pagamento On-line Balc\u00e3o", RecebimentoBalcao),
    RecebimentoBalcaoDescontoFolha(45, "Desconto em folha Balc\u00e3o", RecebimentoBalcao),
    RecebimentoBalcaoTransferencia(46, "Transfer\u00eancia Banc\u00e1ria", RecebimentoBalcao),
    RecebimentoBalcaoPix(47, "Pix", RecebimentoBalcao),
    FaturamentoConvenioApoio(17, "Faturamento Convenios + Apoios", null, true),
    FaturamentoConvenio(15, "Faturamento Convenios", FaturamentoConvenioApoio, true),
    FaturamentoApoio(16, "Faturamento Apoios", FaturamentoConvenioApoio, true),
    ImpostosDiversos(20, "Impostos Diversos", null),
    ImpostosINSS(21, "Inss", ImpostosDiversos),
    ImpostosIRRF(22, "Irrf", ImpostosDiversos),
    ImpostosPIS(23, "PIS", ImpostosDiversos),
    ImpostosCSLL(24, "Csll", ImpostosDiversos),
    ImpostosCOFINS(25, "Cofins", ImpostosDiversos),
    ImpostosISS(26, "ISS", ImpostosDiversos),
    ImpostosIPI(27, "IPI", ImpostosDiversos),
    ImpostosICMS(28, "Icms", ImpostosDiversos),
    ImpostosISSRetido(34, "ISS Retido", ImpostosDiversos),
    ImpostosINSSRetido(35, "INSS Retido", ImpostosDiversos),
    ImpostosCOFINSRetido(36, "COFINS Retido", ImpostosDiversos),
    ImpostosCSLLRetido(37, "CSLL Retido", ImpostosDiversos),
    ImpostosIRRFRetido(38, "IRRF Retido", ImpostosDiversos),
    ImpostosPISRetido(39, "PIS Retido", ImpostosDiversos),
    EstornoBalcao(6, "Estorno de Balc\u00e3o", null),
    Juros(7, "Juros", null),
    Multas(8, "Multas", null),
    Acrescimos(9, "Acr\u00e9scimos", null),
    Desconto(14, "Desconto", null),
    Taxa(10, "Taxa", null),
    Frete(29, "Frete", null);

    private String nome;
    private int tipo;
    private TiposApropriacao pai;
    private boolean apropriaConvenio = false;

    private TiposApropriacao(int tipo, String nome, TiposApropriacao pai) {
        this(tipo, nome, pai, false);
    }

    private TiposApropriacao(int tipo, String nome, TiposApropriacao pai, boolean apropriaConvenio) {
        this.nome = nome;
        this.tipo = tipo;
        this.pai = pai;
        this.apropriaConvenio = apropriaConvenio;
    }

    public String toString() {
        return this.nome;
    }

    public int getTipo() {
        return this.tipo;
    }

    public TiposApropriacao getPai() {
        return this.pai;
    }

    public boolean getApropriaConvenio() {
        return this.apropriaConvenio;
    }

    public static TiposApropriacao[] getTiposApropriacao() {
        return TiposApropriacao.values();
    }

    public static TiposApropriacao getTipoApropriacao(int tipo) {
        TiposApropriacao[] tipos;
        for (TiposApropriacao t : tipos = TiposApropriacao.getTiposApropriacao()) {
            if (t.getTipo() != tipo) continue;
            return t;
        }
        return null;
    }
}

