/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.util;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.financeiro.util.DialogoFiltroFaturas;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class NotaFiscalFatura
extends AbstractDialogoOKCancelar {
    public static final int FATURA_ATUAL = 1;
    public static final int FATURA_AGRUPAR = 2;
    private static final int COLUNA_CODIGO = 0;
    private static final int COLUNA_VENCIMENTO = 1;
    private static final int COLUNA_TOTAL = 2;
    private JRadioButton radioFaturaAtual = ComponenteFactory.novoJRadioButton("Fatura atual", this);
    private JRadioButton radioOutras = ComponenteFactory.novoJRadioButton("Agrupar faturas", this);
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Data", "Valor"});
    private JTable table = new JTable(this.modelo);
    private TTextField textCodigoFatura = new TTextField(6, 1);
    private JButton buttonBuscaFatura = ComponenteFactory.novoJButton(this, true);
    private JButton buttonOKFatura = ComponenteFactory.novoJButton("OK", this);
    private JLabel labelDataFatura = new JLabel("");
    private JLabel labelValorFatura = new JLabel("");
    private JButton buttonFiltrar = ComponenteFactory.novoJButton("Filtrar", 'i', this);
    private String faturaAtual = "";

    public static NotaFiscalFatura novainstancia(Object owner) {
        if (owner instanceof Frame) {
            return new NotaFiscalFatura((Frame)owner, "Faturas");
        }
        if (owner instanceof Dialog) {
            return new NotaFiscalFatura((Dialog)owner, "Faturas");
        }
        return null;
    }

    public NotaFiscalFatura(Frame owner, String titulo) {
        super(owner, titulo);
        this.montaTela(owner);
    }

    public NotaFiscalFatura(Dialog owner, String titulo) {
        super(owner, titulo);
        this.montaTela(owner);
    }

    private void montaTela(Component owner) {
        this.setSize(new Dimension(335, 300));
        this.setLocationRelativeTo(owner);
        this.radioFaturaAtual.setSelected(true);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        ScreenUtil.setBorda(new Component[]{this.labelDataFatura, this.labelValorFatura}, new TitledBorder(""));
        this.desabilitaOutras();
        this.textCodigoFatura.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() != NotaFiscalFatura.this.buttonBuscaFatura) {
                    NotaFiscalFatura.this.buscaFatura();
                }
            }
        });
        this.textCodigoFatura.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    NotaFiscalFatura.this.pesquisaFatura();
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (NotaFiscalFatura.this.table.getSelectedRow() > -1 && Funcoes.mensagem(NotaFiscalFatura.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    if (NotaFiscalFatura.this.modelo.getValueAt(NotaFiscalFatura.this.table.getSelectedRow(), 0).toString().equals(NotaFiscalFatura.this.faturaAtual)) {
                        Funcoes.mensagem(NotaFiscalFatura.this, "A fatura atual n\u00e3o pode ser removida da nota fiscal", 1);
                    } else {
                        NotaFiscalFatura.this.modelo.removeLine(NotaFiscalFatura.this.table.getSelectedRow());
                    }
                }
            }
        });
        ButtonGroup grupo = new ButtonGroup();
        grupo.add(this.radioFaturaAtual);
        grupo.add(this.radioOutras);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 4;
        panel.add((Component)this.radioFaturaAtual, c);
        c.gridy = 1;
        panel.add((Component)this.radioOutras, c);
        c.gridy = 2;
        c.fill = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        panel.add((Component)new JLabel("Fatura"), c);
        c.gridy = 3;
        this.textCodigoFatura.setPreferredSize(new Dimension(70, 20));
        this.textCodigoFatura.setMinimumSize(new Dimension(70, 20));
        panel.add((Component)this.textCodigoFatura, c);
        c.gridx = 1;
        this.buttonBuscaFatura.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaFatura.setMinimumSize(new Dimension(20, 20));
        panel.add((Component)this.buttonBuscaFatura, c);
        c.gridx = 2;
        this.labelDataFatura.setPreferredSize(new Dimension(100, 20));
        this.labelDataFatura.setMinimumSize(new Dimension(100, 20));
        panel.add((Component)this.labelDataFatura, c);
        c.gridx = 3;
        this.labelValorFatura.setPreferredSize(new Dimension(100, 20));
        this.labelValorFatura.setMinimumSize(new Dimension(100, 20));
        panel.add((Component)this.labelValorFatura, c);
        c.gridx = 4;
        this.buttonOKFatura.setPreferredSize(new Dimension(40, 20));
        this.buttonOKFatura.setMaximumSize(this.buttonOKFatura.getPreferredSize());
        this.buttonOKFatura.setMinimumSize(this.buttonOKFatura.getPreferredSize());
        panel.add((Component)this.buttonOKFatura, c);
        c.gridwidth = 5;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 4;
        panel.add((Component)new JScrollPane(this.table), c);
        this.getPanelBotoesEsquerda().setLayout(new FlowLayout(0, 0, 3));
        this.getPanelBotoesEsquerda().add(this.buttonFiltrar);
    }

    private void desabilitaOutras() {
        this.textCodigoFatura.setEnabled(false);
        this.buttonOKFatura.setEnabled(false);
        this.buttonBuscaFatura.setEnabled(false);
        this.buttonFiltrar.setEnabled(false);
        int pos = this.modelo.localizar(0, this.faturaAtual);
        String codigo = "";
        String data = "";
        String valor = "";
        if (pos > -1) {
            codigo = this.modelo.getValueAt(pos, 0).toString();
            data = this.modelo.getValueAt(pos, 1).toString();
            valor = this.modelo.getValueAt(pos, 2).toString();
        }
        this.modelo.clear();
        if (pos > -1) {
            this.modelo.addLine(new String[]{codigo, data, valor});
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.radioFaturaAtual) {
            this.desabilitaOutras();
        } else if (e.getSource() == this.radioOutras) {
            this.textCodigoFatura.setEnabled(true);
            this.buttonOKFatura.setEnabled(true);
            this.buttonBuscaFatura.setEnabled(true);
            this.buttonFiltrar.setEnabled(true);
            ScreenUtil.requisitarFoco(this.textCodigoFatura);
        } else if (e.getSource() == this.buttonBuscaFatura) {
            this.pesquisaFatura();
        } else if (e.getSource() == this.buttonOKFatura) {
            this.adicionaFatura();
        } else if (e.getSource() == this.buttonFiltrar) {
            this.filtrar();
        } else {
            super.actionPerformed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filtrar() {
        DialogoFiltroFaturas filtro = DialogoFiltroFaturas.novaInstancia(this);
        if (filtro != null) {
            List<Registro> registros;
            filtro.setVisible(true);
            if (filtro.getOk() && (registros = filtro.getFaturasSelecionadas()).size() > 0) {
                Statement st = Conexao.getStatement();
                try {
                    for (Registro r : registros) {
                        if (this.modelo.localizar(0, r.getString("fat_codigo")) >= 0) continue;
                        StringBuilder buf = new StringBuilder();
                        buf.append("select fat_dtemis, fat_totalexames + fat_totalmateriais + fat_adicional + fat_despcobranca + ((fat_totalexames + fat_totalmateriais) * fat_percacrescimo / 100) - ((fat_totalexames + fat_totalmateriais) * fat_percdesconto / 100) as total from fatura ");
                        buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                        buf.append(" and fat_codigo = ").append(r.getString("fat_codigo"));
                        buf.append(" and fat_datacancelamento is null ");
                        ResultSet rs = Conexao.executeQuery(st, buf);
                        if (!rs.next()) continue;
                        this.modelo.addLine(new String[]{r.getString("fat_codigo"), Funcoes.formataData(rs.getDate("fat_dtemis")), Funcoes.formataDecimal(rs.getDouble("total"))});
                    }
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "NotaFiscalFatura: 260");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
                Conexao.fecharStatement(st);
            }
        }
    }

    private void pesquisaFatura() {
        Hashtable resultado = Pesquisas.fatura(this);
        if (resultado != null) {
            this.textCodigoFatura.setText(resultado.get("fat_codigo").toString());
        }
        this.textCodigoFatura.requestFocus();
    }

    private void adicionaFatura() {
        if (!Funcoes.textoVazio(this.textCodigoFatura.getText()) && Funcoes.verificaData(this.labelDataFatura.getText()) && Funcoes.isNumeric(this.labelValorFatura.getText()) && this.modelo.localizar(0, this.textCodigoFatura.getText()) < 0) {
            this.modelo.addLine(new String[]{this.textCodigoFatura.getText(), this.labelDataFatura.getText(), this.labelValorFatura.getText()});
        }
        this.textCodigoFatura.clear();
        this.labelDataFatura.setText("");
        this.labelValorFatura.setText("");
        this.textCodigoFatura.grabFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaFatura() {
        if (Funcoes.isNumeric(this.textCodigoFatura.getText())) {
            Statement st;
            block5: {
                st = Conexao.getStatement();
                try {
                    StringBuilder buf = new StringBuilder();
                    buf.append("select fat_dtemis, fat_totalexames + fat_totalmateriais + fat_adicional + fat_despcobranca + ((fat_totalexames + fat_totalmateriais) * fat_percacrescimo / 100) - ((fat_totalexames + fat_totalmateriais) * fat_percdesconto / 100) as total from fatura ");
                    buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append(" and fat_codigo = ").append(this.textCodigoFatura.getText());
                    buf.append(" and fat_datacancelamento is null ");
                    ResultSet rs = Conexao.executeQuery(st, buf);
                    if (!rs.next()) break block5;
                    this.labelDataFatura.setText(Funcoes.formataData(rs.getDate("fat_dtemis")));
                    this.labelValorFatura.setText(Funcoes.formataDecimal(rs.getDouble("total")));
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "NotaFiscalFatura: 233");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }
    }

    public int getOpcaoSelecionada() {
        if (this.radioFaturaAtual.isSelected()) {
            return 1;
        }
        return 2;
    }

    public String[] getFaturasSelecionadas() {
        if (this.modelo.getRowCount() > 0) {
            ArrayList<String> a = new ArrayList<String>();
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                a.add(this.modelo.getValueAt(i, 0).toString());
            }
            return a.toArray(new String[a.size()]);
        }
        return null;
    }

    public Double getValorFaturas() {
        Double valor = 0.0;
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            valor = valor + Double.parseDouble(Funcoes.limpaDecimal(this.modelo.getValueAt(i, 2).toString()));
        }
        return valor;
    }

    public void setFaturaAtual(String fatura, String data, String valor) {
        this.faturaAtual = fatura;
        this.modelo.addLine(new String[]{fatura, data, valor});
    }
}

